/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;

public abstract class Component {
    public static final int COMPONENT_HEADER = 1;
    public static final int COMPONENT_DIRECTORY = 2;
    public static final int COMPONENT_APPLET = 3;
    public static final int COMPONENT_IMPORT = 4;
    public static final int COMPONENT_CONSTANTPOOL = 5;
    public static final int COMPONENT_CLASS = 6;
    public static final int COMPONENT_METHOD = 7;
    public static final int COMPONENT_STATICFIELD = 8;
    public static final int COMPONENT_REFERENCELOCATION = 9;
    public static final int COMPONENT_EXPORT = 10;
    public static final int COMPONENT_DESCRIPTOR = 11;
    public static final int COMPONENT_DEBUG = 12;
    protected static final int COMPONENT_SIZE = 3;
    protected JCPackage parentPackage;
    protected int tag;
    protected String name = "unknown";

    protected Component(int n, String string) {
        this.tag = n;
        this.name = Msg.getMessage(string);
    }

    protected Component(JCPackage jCPackage) {
        this.parentPackage = jCPackage;
        if (this instanceof HeaderComponent) {
            this.tag = 1;
            this.name = Msg.getMessage("header");
        } else if (this instanceof DirectoryComponent) {
            this.tag = 2;
            this.name = Msg.getMessage("directory");
        } else if (this instanceof AppletComponent) {
            this.tag = 3;
            this.name = Msg.getMessage("applet");
        } else if (this instanceof ImportComponent) {
            this.tag = 4;
            this.name = Msg.getMessage("import");
        } else if (this instanceof ConstantPoolComponent) {
            this.tag = 5;
            this.name = Msg.getMessage("constantpool");
        } else if (this instanceof ClassComponent) {
            this.tag = 6;
            this.name = Msg.getMessage("class");
        } else if (this instanceof MethodComponent) {
            this.tag = 7;
            this.name = Msg.getMessage("method");
        } else if (this instanceof StaticFieldComponent) {
            this.tag = 8;
            this.name = Msg.getMessage("staticfield");
        } else if (this instanceof ReferenceLocationComponent) {
            this.tag = 9;
            this.name = Msg.getMessage("referencelocation");
        } else if (this instanceof ExportComponent) {
            this.tag = 10;
            this.name = Msg.getMessage("export");
        } else if (this instanceof DescriptorComponent) {
            this.tag = 11;
            this.name = Msg.getMessage("descriptor");
        } else if (this instanceof DebugComponent) {
            this.tag = 12;
            this.name = Msg.getMessage("debug");
        }
    }

    public int size() {
        return this.dataSize() + 3;
    }

    protected abstract int dataSize();

    protected byte[] toByteArray() {
        Object[] objectArray;
        int n = this.dataSize();
        if (n > 65535) {
            objectArray = new Object[]{this.name};
            Msg.error("component.0", objectArray);
        }
        objectArray = new byte[]{(byte)this.tag, (byte)(n >> 8), (byte)n};
        return objectArray;
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (object == null || !(object instanceof Component)) {
            return false;
        }
        byte[] byArray2 = this.toByteArray();
        if (byArray2.length != (byArray = ((Component)object).toByteArray()).length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tag: " + this.tag + Msg.eol);
        stringBuffer.append("Size: " + this.dataSize() + Msg.eol);
        return stringBuffer.toString();
    }

    public JCPackage getParentPackage() {
        return this.parentPackage;
    }
}

