/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class AlgorithmParametersTest
extends SimpleTest {
    private byte[] dsaParams = Base64.decode("MIGcAkEAjfKklEkidqo9JXWbsGhpy+rA2Dr7jQz3y7gyTw14guXQdi/FtyEOr8Lprawyq3qsSWk9+/g3JMLsBzbuMcgCkQIVAMdzIYxzfsjumTtPLe0w9I7azpFfAkBP3Z9K7oNeZMXEXYpqvrMUgVdFjq4lnWJoV8Rwe+TERStHTkqSO7sp0lq7EEggVMcuXtarKNsxaJ+qyYv/n1t6");

    private void basicTest(String string, Class clazz, byte[] byArray) throws Exception {
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string, "BC");
        algorithmParameters.init(byArray);
        try {
            algorithmParameters.init(byArray);
            this.fail("encoded re-initialization not detected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object object = algorithmParameters.getParameterSpec(clazz);
        try {
            algorithmParameters.init((AlgorithmParameterSpec)object);
            this.fail("spec re-initialization not detected");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
        try {
            object = algorithmParameters.getParameterSpec(AlgorithmParameterSpec.class);
            this.fail("wrong spec not detected");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
        try {
            object = algorithmParameters.getParameterSpec(null);
            this.fail("null spec not detected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        algorithmParameters = AlgorithmParameters.getInstance(string, "BC");
        algorithmParameters.init(byArray, "ASN.1");
        algorithmParameters = AlgorithmParameters.getInstance(string, "BC");
        algorithmParameters.init(byArray, null);
        algorithmParameters = AlgorithmParameters.getInstance(string, "BC");
        try {
            algorithmParameters.init(byArray, "FRED");
            this.fail("unknown spec not detected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void performTest() throws Exception {
        this.basicTest("DSA", DSAParameterSpec.class, this.dsaParams);
    }

    public String getName() {
        return "AlgorithmParameters";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        AlgorithmParametersTest.runTest(new AlgorithmParametersTest());
    }
}

