/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.Target;
import org.bouncycastle.asn1.x509.TargetInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestResult;
import org.bouncycastle.x509.AttributeCertificateHolder;
import org.bouncycastle.x509.AttributeCertificateIssuer;
import org.bouncycastle.x509.X509Attribute;
import org.bouncycastle.x509.X509AttributeCertStoreSelector;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificateGenerator;

public class AttrCertSelectorTest
extends SimpleTest {
    static final RSAPrivateCrtKeySpec RSA_PRIVATE_KEY_SPEC = new RSAPrivateCrtKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
    static final byte[] holderCert = Base64.decode("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");

    public String getName() {
        return "AttrCertSelector";
    }

    private X509AttributeCertificate createAttrCert() throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(holderCert));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(RSA_PRIVATE_KEY_SPEC);
        X509V2AttributeCertificateGenerator x509V2AttributeCertificateGenerator = new X509V2AttributeCertificateGenerator();
        GeneralName generalName = new GeneralName(1, "DAU123456789@test.com");
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(generalName);
        X509Attribute x509Attribute = new X509Attribute("2.5.24.72", new DERSequence(aSN1EncodableVector));
        x509V2AttributeCertificateGenerator.addAttribute(x509Attribute);
        x509V2AttributeCertificateGenerator.setHolder(new AttributeCertificateHolder(PrincipalUtil.getSubjectX509Principal(x509Certificate)));
        x509V2AttributeCertificateGenerator.setIssuer(new AttributeCertificateIssuer(new X509Principal("cn=test")));
        x509V2AttributeCertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V2AttributeCertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509V2AttributeCertificateGenerator.setSerialNumber(BigInteger.ONE);
        x509V2AttributeCertificateGenerator.setSignatureAlgorithm("SHA1WithRSAEncryption");
        Target target = new Target(0, new GeneralName(2, "www.test.com"));
        Target target2 = new Target(1, new GeneralName(4, "o=Test, ou=Test"));
        Target[] targetArray = new Target[]{target, target2};
        TargetInformation targetInformation = new TargetInformation(targetArray);
        x509V2AttributeCertificateGenerator.addExtension(X509Extensions.TargetInformation.getId(), true, targetInformation);
        return x509V2AttributeCertificateGenerator.generate(privateKey, "BC");
    }

    public void testSelector() throws Exception {
        X509AttributeCertificate x509AttributeCertificate = this.createAttrCert();
        X509AttributeCertStoreSelector x509AttributeCertStoreSelector = new X509AttributeCertStoreSelector();
        x509AttributeCertStoreSelector.setAttributeCert(x509AttributeCertificate);
        boolean bl = x509AttributeCertStoreSelector.match(x509AttributeCertificate);
        if (!bl) {
            this.fail("Selector does not match attribute certificate.");
        }
        x509AttributeCertStoreSelector.setAttributeCert(null);
        bl = x509AttributeCertStoreSelector.match(x509AttributeCertificate);
        if (!bl) {
            this.fail("Selector does not match attribute certificate.");
        }
        x509AttributeCertStoreSelector.setHolder(x509AttributeCertificate.getHolder());
        bl = x509AttributeCertStoreSelector.match(x509AttributeCertificate);
        if (!bl) {
            this.fail("Selector does not match attribute certificate holder.");
        }
        x509AttributeCertStoreSelector.setHolder(null);
        x509AttributeCertStoreSelector.setIssuer(x509AttributeCertificate.getIssuer());
        bl = x509AttributeCertStoreSelector.match(x509AttributeCertificate);
        if (!bl) {
            this.fail("Selector does not match attribute certificate issuer.");
        }
        x509AttributeCertStoreSelector.setIssuer(null);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(holderCert));
        bl = x509AttributeCertificate.getHolder().match(x509Certificate);
        if (!bl) {
            this.fail("Issuer holder does not match signing certificate of attribute certificate.");
        }
        x509AttributeCertStoreSelector.setSerialNumber(x509AttributeCertificate.getSerialNumber());
        bl = x509AttributeCertStoreSelector.match(x509AttributeCertificate);
        if (!bl) {
            this.fail("Selector does not match attribute certificate serial number.");
        }
        x509AttributeCertStoreSelector.setAttributeCertificateValid(new Date());
        bl = x509AttributeCertStoreSelector.match(x509AttributeCertificate);
        if (!bl) {
            this.fail("Selector does not match attribute certificate time.");
        }
        x509AttributeCertStoreSelector.addTargetName(new GeneralName(2, "www.test.com"));
        bl = x509AttributeCertStoreSelector.match(x509AttributeCertificate);
        if (!bl) {
            this.fail("Selector does not match attribute certificate target name.");
        }
        x509AttributeCertStoreSelector.setTargetNames(null);
        x509AttributeCertStoreSelector.addTargetGroup(new GeneralName(4, "o=Test, ou=Test"));
        bl = x509AttributeCertStoreSelector.match(x509AttributeCertificate);
        if (!bl) {
            this.fail("Selector does not match attribute certificate target group.");
        }
        x509AttributeCertStoreSelector.setTargetGroups(null);
    }

    public void performTest() throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        this.testSelector();
    }

    public static void main(String[] stringArray) {
        AttrCertSelectorTest attrCertSelectorTest = new AttrCertSelectorTest();
        TestResult testResult = attrCertSelectorTest.perform();
        System.out.println(testResult);
    }
}

