/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTest;

public class CertStoreTest
extends SimpleTest {
    public void performTest() throws Exception {
        this.basicTest();
        this.orderTest();
    }

    private void basicTest() throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        ArrayList<X509Extension> arrayList = new ArrayList<X509Extension>();
        arrayList.add(x509Certificate);
        arrayList.add(x509Certificate2);
        arrayList.add(x509Certificate3);
        arrayList.add(x509CRL);
        arrayList.add(x509CRL2);
        CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
        X509CertSelector x509CertSelector = new X509CertSelector();
        x509CertSelector.setSubject(x509Certificate.getSubjectX500Principal().getName());
        Collection<? extends Certificate> collection = certStore.getCertificates(x509CertSelector);
        if (collection.size() != 1 || !collection.contains(x509Certificate)) {
            this.fail("rootCert not found by subjectDN");
        }
        x509CertSelector = new X509CertSelector();
        x509CertSelector.setSubject(x509Certificate.getSubjectX500Principal().getEncoded());
        collection = certStore.getCertificates(x509CertSelector);
        if (collection.size() != 1 || !collection.contains(x509Certificate)) {
            this.fail("rootCert not found by encoded subjectDN");
        }
        x509CertSelector = new X509CertSelector();
        x509CertSelector.setSubjectPublicKey(x509Certificate.getPublicKey().getEncoded());
        collection = certStore.getCertificates(x509CertSelector);
        if (collection.size() != 1 || !collection.contains(x509Certificate)) {
            this.fail("rootCert not found by encoded public key");
        }
        x509CertSelector = new X509CertSelector();
        x509CertSelector.setIssuer(x509Certificate.getSubjectX500Principal().getEncoded());
        collection = certStore.getCertificates(x509CertSelector);
        if (collection.size() != 2) {
            this.fail("did not found 2 certs");
        }
        if (!collection.contains(x509Certificate)) {
            this.fail("rootCert not found");
        }
        if (!collection.contains(x509Certificate2)) {
            this.fail("interCert not found");
        }
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        x509CRLSelector.addIssuerName(x509CRL.getIssuerX500Principal().getEncoded());
        Collection<? extends CRL> collection2 = certStore.getCRLs(x509CRLSelector);
        if (collection2.size() != 1 || !collection2.contains(x509CRL)) {
            this.fail("rootCrl not found");
        }
    }

    private void orderTest() throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        ArrayList<X509Extension> arrayList = new ArrayList<X509Extension>();
        arrayList.add(x509Certificate);
        arrayList.add(x509Certificate2);
        arrayList.add(x509Certificate3);
        CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
        Iterator<? extends Certificate> iterator = certStore.getCertificates(null).iterator();
        if (!((Object)iterator.next()).equals(x509Certificate)) {
            this.fail("root ordering wrong");
        }
        if (!((Object)iterator.next()).equals(x509Certificate2)) {
            this.fail("mid ordering wrong");
        }
        if (!((Object)iterator.next()).equals(x509Certificate3)) {
            this.fail("final ordering wrong");
        }
        arrayList = new ArrayList();
        arrayList.add(x509Certificate3);
        arrayList.add(x509Certificate2);
        arrayList.add(x509Certificate);
        collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
        certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
        iterator = certStore.getCertificates(null).iterator();
        if (!((Object)iterator.next()).equals(x509Certificate3)) {
            this.fail("reverse final ordering wrong");
        }
        if (!((Object)iterator.next()).equals(x509Certificate2)) {
            this.fail("reverse mid ordering wrong");
        }
        if (!((Object)iterator.next()).equals(x509Certificate)) {
            this.fail("reverse root ordering wrong");
        }
        X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        arrayList = new ArrayList();
        arrayList.add(x509Certificate3);
        arrayList.add(x509CRL);
        arrayList.add(x509CRL2);
        collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
        certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
        Iterator<? extends CRL> iterator2 = certStore.getCRLs(null).iterator();
        if (!iterator2.next().equals(x509CRL)) {
            this.fail("root crl ordering wrong");
        }
        if (!iterator2.next().equals(x509CRL2)) {
            this.fail("mid crl ordering wrong");
        }
        arrayList = new ArrayList();
        arrayList.add(x509Certificate3);
        arrayList.add(x509CRL2);
        arrayList.add(x509CRL);
        collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
        certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
        iterator2 = certStore.getCRLs(null).iterator();
        if (!iterator2.next().equals(x509CRL2)) {
            this.fail("reverse mid crl ordering wrong");
        }
        if (!iterator2.next().equals(x509CRL)) {
            this.fail("reverse root crl ordering wrong");
        }
    }

    public String getName() {
        return "CertStore";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        CertStoreTest.runTest(new CertStoreTest());
    }
}

