/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class ECEncodingTest
extends SimpleTest {
    private int m = 304;
    private int k1 = 1;
    private int k2 = 2;
    private int k3 = 11;
    private byte[] hexa = new byte[]{-3, 13, 105, 49, 73, -95, 24, -10, 81, -26, -36, -26, -128, 32, -123, 55, 126, 95, -120, 45, 27, 81, 11, 68, 22, 0, 116, -63, 40, -128, 120, 54, 90, 3, -106, -56, -26, -127};
    private byte[] hexb = new byte[]{-67, -37, -105, -27, 85, -91, 10, -112, -114, 67, -80, 28, 121, -114, -91, -38, -90, 120, -113, 30, -94, 121, 78, -4, -11, 113, 102, -72, -63, 64, 57, 96, 30, 85, -126, 115, 64, -66};
    private BigInteger a = new BigInteger(1, this.hexa);
    private BigInteger b = new BigInteger(1, this.hexb);
    private byte[] enc = new byte[]{2, 25, 123, 7, -124, 94, -101, -30, -39, 106, -37, 15, 95, 60, 127, 44, -1, -67, 122, 62, -72, -74, -2, -61, 92, 127, -42, 127, 38, -35, -10, 40, 90, 100, 79, 116, 10, 38, 20};

    public String getName() {
        return "ECEncodingTest";
    }

    private void testPointCompression() throws Exception {
        ECCurve.F2m f2m = new ECCurve.F2m(this.m, this.k1, this.k2, this.k3, this.a, this.b);
        ((ECCurve)f2m).decodePoint(this.enc);
        int[] nArray = new int[]{this.k3, this.k2, this.k1};
    }

    public void performTest() throws Exception {
        byte[] byArray = Hex.decode("3081C8020101302806072A8648CE3D0101021D00D7C134AA264366862A18302575D1D787B09F075797DA89F57EC8C0FF303C041C68A5E62CA9CE6C1C299803A6C1530B514E182AD8B0042A59CAD29F43041C2580F63CCFE44138870713B1A92369E33E2135D266DBB372386C400B0439040D9029AD2C7E5CF4340823B2A87DC68C9E4CE3174C1E6EFDEE12C07D58AA56F772C0726F24C6B89E4ECDAC24354B9E99CAA3F6D3761402CD021D00D7C134AA264366862A18302575D0FB98D116BC4B6DDEBCA3A5A7939F020101");
        this.testParams(byArray, true);
        this.testParams(byArray, false);
        byArray = Hex.decode("3081C8020101302806072A8648CE3D0101021D00D7C134AA264366862A18302575D1D787B09F075797DA89F57EC8C0FF303C041C56E6C7E4F11A7B4B961A4DCB5BD282EB22E42E9BCBE3E7B361F18012041C4BE3E7B361F18012F2353D22975E02D8D05D2C6F3342DD8F57D4C76F0439048D127A0C27E0DE207ED3B7FB98F83C8BD5A2A57C827F4B97874DEB2C1BAEB0C006958CE61BB1FC81F5389E288CB3E86E2ED91FB47B08FCCA021D00D7C134AA264366862A18302575D11A5F7AABFBA3D897FF5CA727AF53020101");
        this.testParams(byArray, true);
        this.testParams(byArray, false);
        byArray = Hex.decode("30820142020101303c06072a8648ce3d0101023100fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff3066043100fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000fffffffc043100b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef046104aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab73617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f023100ffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973020101");
        this.testParams(byArray, true);
        this.testParams(byArray, false);
        this.testPointCompression();
    }

    private void testParams(byte[] byArray, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Certificate[] certificateArray;
        String string = "myPass";
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
        X9ECParameters x9ECParameters = new X9ECParameters((ASN1Sequence)aSN1InputStream.readObject());
        KeyPair keyPair = null;
        boolean bl2 = false;
        while (!bl2) {
            certificateArray = KeyPairGenerator.getInstance("ECDSA");
            certificateArray.initialize(new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed()));
            keyPair = certificateArray.generateKeyPair();
            object3 = (JCEECPublicKey)keyPair.getPublic();
            if (!bl) {
                ((JCEECPublicKey)object3).setPointFormat("UNCOMPRESSED");
            }
            if (((Object)(object2 = (Object)((JCEECPublicKey)object3).getQ().getX().toBigInteger().toByteArray())).length != ((byte[])(object = ((JCEECPublicKey)object3).getQ().getY().toBigInteger().toByteArray())).length) continue;
            bl2 = true;
        }
        certificateArray = new Certificate[]{this.generateSelfSignedSoftECCert(keyPair, bl)};
        object3 = KeyStore.getInstance("BKS");
        ((KeyStore)object3).load(null, string.toCharArray());
        ((KeyStore)object3).setCertificateEntry("ECCert", certificateArray[0]);
        object2 = (JCEECPrivateKey)keyPair.getPrivate();
        ((KeyStore)object3).setKeyEntry("ECPrivKey", (Key)object2, string.toCharArray(), certificateArray);
        object = (JCEECPublicKey)keyPair.getPublic();
        String string2 = new String(Hex.encode(((JCEECPrivateKey)object2).getEncoded()));
        String string3 = new String(Hex.encode(((JCEECPublicKey)object).getEncoded()));
        JCEECPrivateKey jCEECPrivateKey = (JCEECPrivateKey)((KeyStore)object3).getKey("ECPrivKey", string.toCharArray());
        JCEECPublicKey jCEECPublicKey = (JCEECPublicKey)((KeyStore)object3).getCertificate("ECCert").getPublicKey();
        if (!bl) {
            jCEECPrivateKey.setPointFormat("UNCOMPRESSED");
            jCEECPublicKey.setPointFormat("UNCOMPRESSED");
        }
        String string4 = new String(Hex.encode(jCEECPrivateKey.getEncoded()));
        String string5 = new String(Hex.encode(jCEECPublicKey.getEncoded()));
        if (!string2.equals(string4)) {
            this.fail("failed private key comparison");
        }
        if (!string3.equals(string5)) {
            this.fail("failed public key comparison");
        }
    }

    private X509Certificate generateSelfSignedSoftECCert(KeyPair keyPair, boolean bl) throws InvalidKeyException, SignatureException {
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        JCEECPrivateKey jCEECPrivateKey = (JCEECPrivateKey)keyPair.getPrivate();
        JCEECPublicKey jCEECPublicKey = (JCEECPublicKey)keyPair.getPublic();
        if (!bl) {
            jCEECPrivateKey.setPointFormat("UNCOMPRESSED");
            jCEECPublicKey.setPointFormat("UNCOMPRESSED");
        }
        x509V3CertificateGenerator.setSignatureAlgorithm("ECDSAwithSHA1");
        x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
        x509V3CertificateGenerator.setIssuerDN(new X509Principal("CN=Software emul (EC Cert)"));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000000L));
        x509V3CertificateGenerator.setSubjectDN(new X509Principal("CN=Software emul (EC Cert)"));
        x509V3CertificateGenerator.setPublicKey(jCEECPublicKey);
        return x509V3CertificateGenerator.generateX509Certificate(jCEECPrivateKey);
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        ECEncodingTest.runTest(new ECEncodingTest());
    }
}

