/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class PBETest
extends SimpleTest {
    private PKCS12Test[] pkcs12Tests = new PKCS12Test[]{new PKCS12Test("DESede", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC", new SHA1Digest(), 192, 64), new PKCS12Test("DESede", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC", new SHA1Digest(), 128, 64), new PKCS12Test("RC4", "PBEWITHSHAAND128BITRC4", new SHA1Digest(), 128, 0), new PKCS12Test("RC4", "PBEWITHSHAAND40BITRC4", new SHA1Digest(), 40, 0), new PKCS12Test("RC2", "PBEWITHSHAAND128BITRC2-CBC", new SHA1Digest(), 128, 64), new PKCS12Test("RC2", "PBEWITHSHAAND40BITRC2-CBC", new SHA1Digest(), 40, 64), new PKCS12Test("AES", "PBEWithSHA1And128BitAES-CBC-BC", new SHA1Digest(), 128, 128), new PKCS12Test("AES", "PBEWithSHA1And192BitAES-CBC-BC", new SHA1Digest(), 192, 128), new PKCS12Test("AES", "PBEWithSHA1And256BitAES-CBC-BC", new SHA1Digest(), 256, 128), new PKCS12Test("AES", "PBEWithSHA256And128BitAES-CBC-BC", new SHA256Digest(), 128, 128), new PKCS12Test("AES", "PBEWithSHA256And192BitAES-CBC-BC", new SHA256Digest(), 192, 128), new PKCS12Test("AES", "PBEWithSHA256And256BitAES-CBC-BC", new SHA256Digest(), 256, 128), new PKCS12Test("Twofish", "PBEWithSHAAndTwofish-CBC", new SHA1Digest(), 256, 128)};
    private OpenSSLTest[] openSSLTests = new OpenSSLTest[]{new OpenSSLTest("AES", "PBEWITHMD5AND128BITAES-CBC-OPENSSL", 128, 128), new OpenSSLTest("AES", "PBEWITHMD5AND192BITAES-CBC-OPENSSL", 192, 128), new OpenSSLTest("AES", "PBEWITHMD5AND256BITAES-CBC-OPENSSL", 256, 128)};
    static byte[] message = Hex.decode("4869205468657265");
    private byte[] hMac1 = Hex.decode("bcc42174ccb04f425d9a5c8c4a95d6fd7c372911");
    private byte[] hMac2 = Hex.decode("cb1d8bdb6aca9e3fa8980d6eb41ab28a7eb2cfd6");

    private Cipher makePBECipherUsingParam(String string, int n, char[] cArray, byte[] byArray, int n2) throws Exception {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        Cipher cipher = Cipher.getInstance(string, "BC");
        cipher.init(n, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
        return cipher;
    }

    private Cipher makePBECipherWithoutParam(String string, int n, char[] cArray, byte[] byArray, int n2) throws Exception {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n2);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
        Cipher cipher = Cipher.getInstance(string, "BC");
        cipher.init(n, secretKeyFactory.generateSecret(pBEKeySpec));
        return cipher;
    }

    private boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public void testPBEHMac(String string, byte[] byArray) {
        Mac mac;
        SecretKey secretKey;
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            secretKey = secretKeyFactory.generateSecret(new PBEKeySpec("hello".toCharArray()));
            mac = Mac.getInstance(string, "BC");
        }
        catch (Exception exception) {
            this.fail("Failed - exception " + exception.toString(), exception);
            return;
        }
        try {
            mac.init(secretKey, new PBEParameterSpec(new byte[20], 100));
        }
        catch (Exception exception) {
            this.fail("Failed - exception " + exception.toString(), exception);
            return;
        }
        mac.reset();
        mac.update(message, 0, message.length);
        byte[] byArray2 = mac.doFinal();
        if (!this.arrayEquals(byArray2, byArray)) {
            this.fail("Failed - expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray2)));
        }
    }

    public void performTest() throws Exception {
        int n;
        byte[] byArray = Hex.decode("1234567890abcdefabcdef1234567890fedbca098765");
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS7Padding", "BC");
        cipher.init(1, (Key)new SecretKeySpec(Hex.decode("30e69252758e5346"), "DES"), new IvParameterSpec(Hex.decode("7c1c1ab9c454a688")));
        byte[] byArray2 = cipher.doFinal(byArray);
        char[] cArray = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
        Cipher cipher2 = this.makePBECipherUsingParam("PBEWithSHA1AndDES", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048);
        byte[] byArray3 = cipher2.doFinal(byArray2);
        if (!this.arrayEquals(byArray, byArray3)) {
            this.fail("DES failed");
        }
        if (!this.arrayEquals(byArray, byArray3 = (cipher2 = this.makePBECipherWithoutParam("PBEWithSHA1AndDES", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048)).doFinal(byArray2))) {
            this.fail("DES failed without param");
        }
        cipher = Cipher.getInstance("DESede/CBC/PKCS7Padding", "BC");
        cipher.init(1, (Key)new SecretKeySpec(Hex.decode("732f2d33c801732b7206756cbd44f9c1c103ddd97c7cbe8e"), "DES"), new IvParameterSpec(Hex.decode("b07bf522c8d608b8")));
        byArray2 = cipher.doFinal(byArray);
        cipher2 = this.makePBECipherUsingParam("PBEWithSHAAnd3-KeyTripleDES-CBC", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048);
        byArray3 = cipher2.doFinal(byArray2);
        if (!this.arrayEquals(byArray, byArray3)) {
            this.fail("DESede failed");
        }
        cipher = Cipher.getInstance("RC2/CBC/PKCS7Padding", "BC");
        cipher.init(1, (Key)new SecretKeySpec(Hex.decode("732f2d33c8"), "RC2"), new IvParameterSpec(Hex.decode("b07bf522c8d608b8")));
        byArray2 = cipher.doFinal(byArray);
        cipher2 = this.makePBECipherUsingParam("PBEWithSHAAnd40BitRC2-CBC", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048);
        byArray3 = cipher2.doFinal(byArray2);
        if (!this.arrayEquals(byArray, byArray3)) {
            this.fail("RC2 failed");
        }
        cipher = Cipher.getInstance("RC4", "BC");
        cipher.init(1, new SecretKeySpec(Hex.decode("732f2d33c801732b7206756cbd44f9c1"), "RC4"));
        byArray2 = cipher.doFinal(byArray);
        cipher2 = this.makePBECipherUsingParam("PBEWithSHAAnd128BitRC4", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048);
        byArray3 = cipher2.doFinal(byArray2);
        if (!this.arrayEquals(byArray, byArray3)) {
            this.fail("RC4 failed");
        }
        if (!this.arrayEquals(byArray, byArray3 = (cipher2 = this.makePBECipherWithoutParam("PBEWithSHAAnd128BitRC4", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048)).doFinal(byArray2))) {
            this.fail("RC4 failed without param");
        }
        for (n = 0; n != this.pkcs12Tests.length; ++n) {
            this.pkcs12Tests[n].perform();
        }
        for (n = 0; n != this.openSSLTests.length; ++n) {
            this.openSSLTests[n].perform();
        }
        this.testPBEHMac("PBEWithHMacSHA1", this.hMac1);
        this.testPBEHMac("PBEWithHMacRIPEMD160", this.hMac2);
    }

    public String getName() {
        return "PBETest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        PBETest.runTest(new PBETest());
    }

    private class PKCS12Test
    extends SimpleTest {
        char[] password;
        String baseAlgorithm;
        String algorithm;
        Digest digest;
        int keySize;
        int ivSize;

        PKCS12Test(String string, String string2, Digest digest, int n, int n2) {
            this.password = string2.toCharArray();
            this.baseAlgorithm = string;
            this.algorithm = string2;
            this.digest = digest;
            this.keySize = n;
            this.ivSize = n2;
        }

        public String getName() {
            return "PKCS12PBE";
        }

        public void performTest() throws Exception {
            Cipher cipher;
            byte[] byArray = new byte[this.digest.getDigestSize()];
            int n = 100;
            this.digest.doFinal(byArray, 0);
            PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(this.digest);
            pKCS12ParametersGenerator.init(PBEParametersGenerator.PKCS12PasswordToBytes(this.password), byArray, n);
            ParametersWithIV parametersWithIV = (ParametersWithIV)pKCS12ParametersGenerator.generateDerivedParameters(this.keySize, this.ivSize);
            SecretKeySpec secretKeySpec = new SecretKeySpec(((KeyParameter)parametersWithIV.getParameters()).getKey(), this.baseAlgorithm);
            if (this.baseAlgorithm.equals("RC4")) {
                cipher = Cipher.getInstance(this.baseAlgorithm, "BC");
                cipher.init(1, secretKeySpec);
            } else {
                cipher = Cipher.getInstance(this.baseAlgorithm + "/CBC/PKCS7Padding", "BC");
                cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(parametersWithIV.getIV()));
            }
            byte[] byArray2 = cipher.doFinal(byArray);
            cipher = Cipher.getInstance(this.algorithm, "BC");
            PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password, byArray, n);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.algorithm, "BC");
            cipher.init(2, secretKeyFactory.generateSecret(pBEKeySpec));
            byte[] byArray3 = cipher.doFinal(byArray2);
            if (!PBETest.this.arrayEquals(byArray, byArray3)) {
                this.fail("" + this.algorithm + "failed encryption/decryption test");
            }
            AlgorithmParameters algorithmParameters = this.checkParameters(cipher, byArray, n);
            cipher = Cipher.getInstance(this.algorithm, "BC");
            pBEKeySpec = new PBEKeySpec(this.password);
            cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), algorithmParameters);
            this.checkParameters(cipher, byArray, n);
            byArray3 = cipher.doFinal(byArray2);
            if (!PBETest.this.arrayEquals(byArray, byArray3)) {
                this.fail("" + this.algorithm + "failed encryption/decryption test");
            }
            cipher = Cipher.getInstance(this.algorithm, "BC");
            pBEKeySpec = new PBEKeySpec(this.password);
            cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), algorithmParameters.getParameterSpec(PBEParameterSpec.class));
            this.checkParameters(cipher, byArray, n);
            byArray3 = cipher.doFinal(byArray2);
            if (!PBETest.this.arrayEquals(byArray, byArray3)) {
                this.fail("" + this.algorithm + "failed encryption/decryption test");
            }
        }

        private AlgorithmParameters checkParameters(Cipher cipher, byte[] byArray, int n) throws InvalidParameterSpecException {
            AlgorithmParameters algorithmParameters = cipher.getParameters();
            PBEParameterSpec pBEParameterSpec = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
            if (!PBETest.this.arrayEquals(byArray, pBEParameterSpec.getSalt())) {
                this.fail("" + this.algorithm + "failed salt test");
            }
            if (n != pBEParameterSpec.getIterationCount()) {
                this.fail("" + this.algorithm + "failed count test");
            }
            return algorithmParameters;
        }
    }

    private class OpenSSLTest
    extends SimpleTest {
        char[] password;
        String baseAlgorithm;
        String algorithm;
        int keySize;
        int ivSize;

        OpenSSLTest(String string, String string2, int n, int n2) {
            this.password = string2.toCharArray();
            this.baseAlgorithm = string;
            this.algorithm = string2;
            this.keySize = n;
            this.ivSize = n2;
        }

        public String getName() {
            return "OpenSSLPBE";
        }

        public void performTest() throws Exception {
            Cipher cipher;
            byte[] byArray = new byte[16];
            int n = 100;
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = (byte)i;
            }
            OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
            openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(this.password), byArray, n);
            ParametersWithIV parametersWithIV = (ParametersWithIV)openSSLPBEParametersGenerator.generateDerivedParameters(this.keySize, this.ivSize);
            SecretKeySpec secretKeySpec = new SecretKeySpec(((KeyParameter)parametersWithIV.getParameters()).getKey(), this.baseAlgorithm);
            if (this.baseAlgorithm.equals("RC4")) {
                cipher = Cipher.getInstance(this.baseAlgorithm, "BC");
                cipher.init(1, secretKeySpec);
            } else {
                cipher = Cipher.getInstance(this.baseAlgorithm + "/CBC/PKCS7Padding", "BC");
                cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(parametersWithIV.getIV()));
            }
            byte[] byArray2 = cipher.doFinal(byArray);
            cipher = Cipher.getInstance(this.algorithm, "BC");
            PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password, byArray, n);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.algorithm, "BC");
            cipher.init(2, secretKeyFactory.generateSecret(pBEKeySpec));
            byte[] byArray3 = cipher.doFinal(byArray2);
            if (!PBETest.this.arrayEquals(byArray, byArray3)) {
                this.fail("" + this.algorithm + "failed encryption/decryption test");
            }
        }
    }
}

