/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidatorException;
import org.bouncycastle.util.test.SimpleTest;

public class PKIXNameConstraintsTest
extends SimpleTest {
    private static final String testEmail = "test@abc.test.com";
    private static final String[] testEmailIsConstraint = new String[]{"test@abc.test.com", "abc.test.com", ".test.com"};
    private static final String[] testEmailIsNotConstraint = new String[]{".abc.test.com", "www.test.com", "test1@abc.test.com", "bc.test.com"};
    private static final String[] email1 = new String[]{"test@test.com", "test@test.com", "test@test.com", "test@abc.test.com", "test@test.com", "test@test.com", ".test.com", ".test.com", ".test.com", ".test.com", "test.com", "abc.test.com", "abc.test1.com", "test.com", "test.com", ".test.com"};
    private static final String[] email2 = new String[]{"test@test.abc.com", "test@test.com", ".test.com", ".test.com", "test.com", "test1.com", "test@test.com", ".test.com", ".test1.com", "test.com", "test.com", ".test.com", ".test.com", "test1.com", ".test.com", "abc.test.com"};
    private static final String[] emailintersect = new String[]{null, "test@test.com", null, "test@abc.test.com", "test@test.com", null, null, ".test.com", null, null, "test.com", "abc.test.com", null, null, null, "abc.test.com"};
    private static final String[][] emailunion = new String[][]{{"test@test.com", "test@test.abc.com"}, {"test@test.com"}, {"test@test.com", ".test.com"}, {".test.com"}, {"test.com"}, {"test@test.com", "test1.com"}, {".test.com", "test@test.com"}, {".test.com"}, {".test.com", ".test1.com"}, {".test.com", "test.com"}, {"test.com"}, {".test.com"}, {".test.com", "abc.test1.com"}, {"test1.com", "test.com"}, {".test.com", "test.com"}, {".test.com"}};
    private static final String[] dn1 = new String[]{"O=test org, OU=test org unit, CN=John Doe"};
    private static final String[] dn2 = new String[]{"O=test org, OU=test org unit"};
    private static final String[][] dnUnion = new String[][]{{"O=test org, OU=test org unit"}};
    private static final String[] dnIntersection = new String[]{"O=test org, OU=test org unit, CN=John Doe"};
    private static final String testDN = "O=test org, OU=test org unit, CN=John Doe";
    private static final String[] testDNIsConstraint = new String[]{"O=test org, OU=test org unit", "O=test org, OU=test org unit, CN=John Doe"};
    private static final String[] testDNIsNotConstraint = new String[]{"O=test org, OU=test org unit, CN=John Doe2", "O=test org, OU=test org unit2", "OU=test org unit, O=test org, CN=John Doe", "O=test org, OU=test org unit, CN=John Doe, L=USA"};
    private static final String testDNS = "abc.test.com";
    private static final String[] testDNSIsConstraint = new String[]{"test.com", "abc.test.com", "test.com"};
    private static final String[] testDNSIsNotConstraint = new String[]{"wwww.test.com", "ww.test.com", "www.test.com"};
    private static final String[] dns1 = new String[]{"www.test.de", "www.test1.de", "www.test.de"};
    private static final String[] dns2 = new String[]{"test.de", "www.test.de", "www.test.de"};
    private static final String[] dnsintersect = new String[]{"www.test.de", null, null};
    private static final String[][] dnsunion = new String[][]{{"test.de"}, {"www.test1.de", "www.test.de"}, {"www.test.de"}};
    private static final String testURI = "http://karsten:password@abc.test.com:8080";
    private static final String[] testURIIsConstraint = new String[]{"abc.test.com", ".test.com"};
    private static final String[] testURIIsNotConstraint = new String[]{"xyz.test.com", ".abc.test.com"};
    private static final String[] uri1 = new String[]{"www.test.de", ".test.de", "test1.de", ".test.de"};
    private static final String[] uri2 = new String[]{"test.de", "www.test.de", "test1.de", ".test.de"};
    private static final String[] uriintersect = new String[]{null, "www.test.de", "test1.de", ".test.de"};
    private static final String[][] uriunion = new String[][]{{"www.test.de", "test.de"}, {".test.de"}, {"test1.de"}, {".test.de"}};
    private static final byte[] testIP = new byte[]{-64, -88, 1, 2};
    private static final byte[][] testIPIsConstraint = new byte[][]{{-64, -88, 1, 1, -1, -1, -1, 0}, {-64, -88, 1, 1, -1, -1, -1, 4}};
    private static final byte[][] testIPIsNotConstraint = new byte[][]{{-64, -88, 3, 1, -1, -1, -1, 2}, {-64, -88, 1, 1, -1, -1, -1, 3}};
    private static final byte[][] ip1 = new byte[][]{{-64, -88, 1, 1, -1, -1, -2, -1}, {-64, -88, 1, 1, -1, -1, -1, -1}, {-64, -88, 1, 1, -1, -1, -1, 0}};
    private static final byte[][] ip2 = new byte[][]{{-64, -88, 0, 1, -1, -1, -4, 3}, {-64, -88, 1, 1, -1, -1, -1, -1}, {-64, -88, 0, 1, -1, -1, -1, 0}};
    private static final byte[][] ipintersect = new byte[][]{{-64, -88, 0, 1, -1, -1, -2, -1}, {-64, -88, 1, 1, -1, -1, -1, -1}, null};
    private static final byte[][][] ipunion = new byte[][][]{new byte[][]{{-64, -88, 1, 1, -1, -1, -2, -1}, {-64, -88, 0, 1, -1, -1, -4, 3}}, new byte[][]{{-64, -88, 1, 1, -1, -1, -1, -1}}, new byte[][]{{-64, -88, 1, 1, -1, -1, -1, 0}, {-64, -88, 0, 1, -1, -1, -1, 0}}};

    public String getName() {
        return "PKIXNameConstraintsTest";
    }

    public void performTest() throws Exception {
        this.testConstraints(1, testEmail, testEmailIsConstraint, testEmailIsNotConstraint, email1, email2, emailunion, emailintersect);
        this.testConstraints(2, testDNS, testDNSIsConstraint, testDNSIsNotConstraint, dns1, dns2, dnsunion, dnsintersect);
        this.testConstraints(4, testDN, testDNIsConstraint, testDNIsNotConstraint, dn1, dn2, dnUnion, dnIntersection);
        this.testConstraints(6, testURI, testURIIsConstraint, testURIIsNotConstraint, uri1, uri2, uriunion, uriintersect);
        this.testConstraints(7, testIP, testIPIsConstraint, testIPIsNotConstraint, ip1, ip2, ipunion, ipintersect);
    }

    private void testConstraints(int n, String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[][] stringArray5, String[] stringArray6) throws Exception {
        PKIXNameConstraintValidator pKIXNameConstraintValidator;
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, stringArray[n2]))));
            pKIXNameConstraintValidator.checkPermitted(new GeneralName(n, string));
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, stringArray2[n2]))));
            try {
                pKIXNameConstraintValidator.checkPermitted(new GeneralName(n, string));
                this.fail("not permitted name allowed: " + n);
                continue;
            }
            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, stringArray[n2])));
            try {
                pKIXNameConstraintValidator.checkExcluded(new GeneralName(n, string));
                this.fail("excluded name missed: " + n);
                continue;
            }
            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, stringArray2[n2])));
            pKIXNameConstraintValidator.checkExcluded(new GeneralName(n, string));
        }
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, stringArray3[n2])));
            pKIXNameConstraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, stringArray4[n2])));
            PKIXNameConstraintValidator pKIXNameConstraintValidator2 = new PKIXNameConstraintValidator();
            for (int i = 0; i < stringArray5[n2].length; ++i) {
                pKIXNameConstraintValidator2.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, stringArray5[n2][i])));
            }
            if (!pKIXNameConstraintValidator2.equals(pKIXNameConstraintValidator)) {
                this.fail("union wrong: " + n);
            }
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, stringArray3[n2]))));
            pKIXNameConstraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, stringArray4[n2]))));
            pKIXNameConstraintValidator2 = new PKIXNameConstraintValidator();
            if (stringArray6[n2] != null) {
                pKIXNameConstraintValidator2.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, stringArray6[n2]))));
            } else {
                pKIXNameConstraintValidator2.intersectEmptyPermittedSubtree(n);
            }
            if (pKIXNameConstraintValidator2.equals(pKIXNameConstraintValidator)) continue;
            this.fail("intersection wrong: " + n);
        }
    }

    private void testConstraints(int n, byte[] byArray, byte[][] byArray2, byte[][] byArray3, byte[][] byArray4, byte[][] byArray5, byte[][][] byArray6, byte[][] byArray7) throws Exception {
        PKIXNameConstraintValidator pKIXNameConstraintValidator;
        int n2;
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray2[n2])))));
            pKIXNameConstraintValidator.checkPermitted(new GeneralName(n, new DEROctetString(byArray)));
        }
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray3[n2])))));
            try {
                pKIXNameConstraintValidator.checkPermitted(new GeneralName(n, new DEROctetString(byArray)));
                this.fail("not permitted name allowed: " + n);
                continue;
            }
            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray2[n2]))));
            try {
                pKIXNameConstraintValidator.checkExcluded(new GeneralName(n, new DEROctetString(byArray)));
                this.fail("excluded name missed: " + n);
                continue;
            }
            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray3[n2]))));
            pKIXNameConstraintValidator.checkExcluded(new GeneralName(n, new DEROctetString(byArray)));
        }
        for (n2 = 0; n2 < byArray4.length; ++n2) {
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray4[n2]))));
            pKIXNameConstraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray5[n2]))));
            PKIXNameConstraintValidator pKIXNameConstraintValidator2 = new PKIXNameConstraintValidator();
            for (int i = 0; i < byArray6[n2].length; ++i) {
                pKIXNameConstraintValidator2.addExcludedSubtree(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray6[n2][i]))));
            }
            if (!pKIXNameConstraintValidator2.equals(pKIXNameConstraintValidator)) {
                this.fail("union wrong: " + n);
            }
            pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
            pKIXNameConstraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray4[n2])))));
            pKIXNameConstraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray5[n2])))));
            pKIXNameConstraintValidator2 = new PKIXNameConstraintValidator();
            if (byArray7[n2] != null) {
                pKIXNameConstraintValidator2.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(n, new DEROctetString(byArray7[n2])))));
            } else {
                pKIXNameConstraintValidator2.intersectEmptyPermittedSubtree(n);
            }
            if (pKIXNameConstraintValidator2.equals(pKIXNameConstraintValidator)) continue;
            this.fail("intersection wrong: " + n);
        }
    }

    public static void main(String[] stringArray) {
        PKIXNameConstraintsTest.runTest(new PKIXNameConstraintsTest());
    }
}

