/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.BaseBlockCipherTest;
import org.bouncycastle.util.encoders.Hex;

public class SEEDTest
extends BaseBlockCipherTest {
    static String[] cipherTests = new String[]{"128", "28DBC3BC49FFD87DCFA509B11D422BE7", "B41E6BE2EBA84A148E2EED84593C5EC7", "9B9B7BFCD1813CB95D0B3618F40F5122"};

    public SEEDTest() {
        super("SEED");
    }

    public void test(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "SEED");
        Cipher cipher = Cipher.getInstance("SEED/ECB/NoPadding", "BC");
        Cipher cipher2 = Cipher.getInstance("SEED/ECB/NoPadding", "BC");
        try {
            cipher2.init(1, secretKeySpec);
        }
        catch (Exception exception) {
            this.fail("SEED failed initialisation - " + exception.toString(), exception);
        }
        try {
            cipher.init(2, secretKeySpec);
        }
        catch (Exception exception) {
            this.fail("SEED failed initialisation - " + exception.toString(), exception);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher2);
        try {
            for (int i = 0; i != byArray2.length / 2; ++i) {
                cipherOutputStream.write(byArray2[i]);
            }
            cipherOutputStream.write(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            this.fail("SEED failed encryption - " + iOException.toString(), iOException);
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        if (!this.areEqual(byArray4, byArray3)) {
            this.fail("SEED failed encryption - expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray4)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray4 = new byte[byArray2.length];
            for (int i = 0; i != byArray2.length / 2; ++i) {
                byArray4[i] = (byte)dataInputStream.read();
            }
            dataInputStream.readFully(byArray4, byArray2.length / 2, byArray4.length - byArray2.length / 2);
        }
        catch (Exception exception) {
            this.fail("SEED failed encryption - " + exception.toString(), exception);
        }
        if (!this.areEqual(byArray4, byArray2)) {
            this.fail("SEED failed decryption - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray4)));
        }
    }

    public void performTest() throws Exception {
        for (int i = 0; i != cipherTests.length; i += 4) {
            this.test(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
        }
        byte[] byArray = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] byArray2 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] byArray3 = Hex.decode("bf71f77138b5afea05232a8dad54024e812dc8dd7d132559");
        this.wrapTest(1, "SEEDWrap", byArray, byArray2, byArray3);
        String[] stringArray = new String[]{KISAObjectIdentifiers.id_seedCBC.getId()};
        String[] stringArray2 = new String[]{"SEED/CBC/PKCS7Padding"};
        this.oidTest(stringArray, stringArray2, 1);
        String[] stringArray3 = new String[]{KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId()};
        this.wrapOidTest(stringArray3, "SEEDWrap");
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        SEEDTest.runTest(new SEEDTest());
    }
}

