/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.Signature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTest;

public class SigNameTest
extends SimpleTest {
    private void checkName(String string) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (!string.equals(Signature.getInstance(string, "BC").getAlgorithm())) {
            this.fail("name misatch on " + string);
        }
    }

    public void performTest() throws Exception {
        this.checkName("SHA1withRSA");
        this.checkName("SHA224withRSA");
        this.checkName("SHA256withRSA");
        this.checkName("SHA384withRSA");
        this.checkName("SHA512withRSA");
        this.checkName("MD2withRSA");
        this.checkName("MD4withRSA");
        this.checkName("MD5withRSA");
        this.checkName("RIPEMD160withRSA");
        this.checkName("RIPEMD128withRSA");
        this.checkName("RIPEMD256withRSA");
        this.checkName("SHA1withDSA");
        this.checkName("SHA224withDSA");
        this.checkName("SHA256withDSA");
        this.checkName("SHA384withDSA");
        this.checkName("SHA512withDSA");
        this.checkName("NONEwithDSA");
        this.checkName("SHA1withECDSA");
        this.checkName("SHA224withECDSA");
        this.checkName("SHA256withECDSA");
        this.checkName("SHA384withECDSA");
        this.checkName("SHA512withECDSA");
        this.checkName("RIPEMD160withECDSA");
        this.checkName("SHA1withECNR");
        this.checkName("SHA224withECNR");
        this.checkName("SHA256withECNR");
        this.checkName("SHA384withECNR");
        this.checkName("SHA512withECNR");
        this.checkName("SHA1withRSAandMGF1");
        this.checkName("SHA1withRSAandMGF1");
        this.checkName("SHA224withRSAandMGF1");
        this.checkName("SHA256withRSAandMGF1");
        this.checkName("SHA384withRSAandMGF1");
        this.checkName("SHA512withRSAandMGF1");
        this.checkName("GOST3411withGOST3410");
        this.checkName("GOST3411withECGOST3410");
        this.checkName("SHA1withRSA/ISO9796-2");
        this.checkName("MD5withRSA/ISO9796-2");
        this.checkName("RIPEMD160withRSA/ISO9796-2");
    }

    public String getName() {
        return "SigNameTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        SigNameTest.runTest(new SigNameTest());
    }
}

