/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTest;

public class SlotTwoTest
extends SimpleTest {
    byte[] plainData = "abcdefghijklmnopqrstuvwxyz".getBytes();

    public String getName() {
        return "SlotTwo";
    }

    public void performTest() throws Exception {
        Security.removeProvider("BC");
        Security.insertProviderAt(new BouncyCastleProvider(), 2);
        KeyGenerator keyGenerator = KeyGenerator.getInstance("DESede", "BC");
        keyGenerator.init(new SecureRandom());
        SecretKey secretKey = keyGenerator.generateKey();
        this.testDesEde(secretKey, "ECB", "PKCS7Padding");
        this.testDesEde(secretKey, "CBC", "PKCS7Padding");
        this.testDesEde(secretKey, "CTR", "NoPadding");
        this.testDesEde(secretKey, "CTR", "PKCS7Padding");
        this.testDesEde(secretKey, "OFB", "PKCS7Padding");
        this.testDesEde(secretKey, "CFB", "PKCS7Padding");
        Security.removeProvider("BC");
        Security.addProvider(new BouncyCastleProvider());
    }

    private void testDesEde(Key key, String string, String string2) throws Exception {
        Object object;
        Cipher cipher = Cipher.getInstance("DESede/" + string + "/" + string2, "BC");
        Cipher cipher2 = Cipher.getInstance("DESede/" + string + "/" + string2);
        if (!cipher2.getProvider().getName().equals("BC")) {
            this.fail("BC provider not returned for DESede/" + string + "/" + string2 + " got " + cipher2.getProvider().getName());
        }
        cipher.init(1, key);
        byte[] byArray = cipher.doFinal(this.plainData);
        byte[] byArray2 = cipher.getIV();
        if (byArray2 != null) {
            object = new IvParameterSpec(byArray2);
            cipher2.init(2, key, (AlgorithmParameterSpec)object);
        } else {
            cipher2.init(2, key);
        }
        object = cipher2.doFinal(byArray, 0, byArray.length);
        if (!this.areEqual(this.plainData, (byte[])object)) {
            this.fail("decryption test failed.");
        }
    }

    public static void main(String[] stringArray) {
        SlotTwoTest.runTest(new SlotTwoTest());
    }
}

