/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test.nist;

import java.io.FileInputStream;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.i18n.ErrorBundle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.PKIXCertPathReviewer;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class NistCertPathReviewerTest
extends TestCase {
    private static final String TEST_DATA_HOME = "bc.test.data.home";
    private static final String GOOD_CA_CERT = "GoodCACert";
    private static final String GOOD_CA_CRL = "GoodCACRL";
    private static final String TRUST_ANCHOR_ROOT_CRL = "TrustAnchorRootCRL";
    private static final String TRUST_ANCHOR_ROOT_CERTIFICATE = "TrustAnchorRootCertificate";
    private static final char[] PKCS12_PASSWORD = "password".toCharArray();
    private static String NIST_TEST_POLICY_1 = "2.16.840.1.101.3.2.1.48.1";
    private static String NIST_TEST_POLICY_2 = "2.16.840.1.101.3.2.1.48.2";
    private static String NIST_TEST_POLICY_3 = "2.16.840.1.101.3.2.1.48.3";
    private static Map certs = new HashMap();
    private static Map crls = new HashMap();
    private static Set noPolicies = Collections.EMPTY_SET;
    private static Set nistTestPolicy1 = Collections.singleton(NIST_TEST_POLICY_1);
    private static Set nistTestPolicy2 = Collections.singleton(NIST_TEST_POLICY_2);
    private static Set nistTestPolicy3 = Collections.singleton(NIST_TEST_POLICY_3);
    private static Set nistTestPolicy1And2 = new HashSet<String>(Arrays.asList(NIST_TEST_POLICY_1, NIST_TEST_POLICY_2));

    public void testValidSignaturesTest1() throws Exception {
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"ValidCertificatePathTest1EE", GOOD_CA_CERT}, new String[]{GOOD_CA_CRL, TRUST_ANCHOR_ROOT_CRL});
    }

    public void testInvalidCASignatureTest2() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"ValidCertificatePathTest1EE", "BadSignedCACert"}, new String[]{"BadSignedCACRL", TRUST_ANCHOR_ROOT_CRL}, 1, "CertPathReviewer.signatureNotVerified", "The certificate signature is invalid. A java.security.InvalidKeyException occurred.");
    }

    public void testInvalidEESignatureTest3() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "InvalidEESignatureTest3EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL}, 0, "CertPathReviewer.signatureNotVerified", "The certificate signature is invalid. A java.security.InvalidKeyException occurred.");
    }

    public void testValidDSASignaturesTest4() throws Exception {
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"DSACACert", "ValidDSASignaturesTest4EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, "DSACACRL"});
    }

    public void testInvalidDSASignaturesTest6() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"DSACACert", "InvalidDSASignatureTest6EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, "DSACACRL"}, 0, "CertPathReviewer.signatureNotVerified", "The certificate signature is invalid. A java.security.InvalidKeyException occurred.");
    }

    public void testCANotBeforeDateTest1() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"BadnotBeforeDateCACert", "InvalidCAnotBeforeDateTest1EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, "BadnotBeforeDateCACRL"}, 1, "CertPathReviewer.certificateNotYetValid", "Could not validate the certificate. Certificate is not valid until Jan 1, 2047 12:01:00 PM GMT.");
    }

    public void testInvalidEENotBeforeDateTest2() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "InvalidEEnotBeforeDateTest2EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL}, 0, "CertPathReviewer.certificateNotYetValid", "Could not validate the certificate. Certificate is not valid until Jan 1, 2047 12:01:00 PM GMT.");
    }

    public void testValidPre2000UTCNotBeforeDateTest3() throws Exception {
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "Validpre2000UTCnotBeforeDateTest3EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL});
    }

    public void testValidGeneralizedTimeNotBeforeDateTest4() throws Exception {
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "ValidGeneralizedTimenotBeforeDateTest4EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL});
    }

    public void testInvalidCANotAfterDateTest5() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"BadnotAfterDateCACert", "InvalidCAnotAfterDateTest5EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, "BadnotAfterDateCACRL"}, 1, "CertPathReviewer.certificateExpired", "Could not validate the certificate. Certificate expired on Jan 1, 2002 12:01:00 PM GMT.");
    }

    public void testInvalidEENotAfterDateTest6() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "InvalidEEnotAfterDateTest6EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL}, 0, "CertPathReviewer.certificateExpired", "Could not validate the certificate. Certificate expired on Jan 1, 2002 12:01:00 PM GMT.");
    }

    public void testInvalidValidPre2000UTCNotAfterDateTest7() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "Invalidpre2000UTCEEnotAfterDateTest7EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL}, 0, "CertPathReviewer.certificateExpired", "Could not validate the certificate. Certificate expired on Jan 1, 1999 12:01:00 PM GMT.");
    }

    public void testInvalidNegativeSerialNumberTest15() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"NegativeSerialNumberCACert", "InvalidNegativeSerialNumberTest15EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, "NegativeSerialNumberCACRL"}, 0, "CertPathReviewer.certRevoked", "The certificate was revoked at Apr 19, 2001 2:57:20 PM GMT. Reason: Key Compromise.");
    }

    public void testAllCertificatesSamePolicyTest1() throws Exception {
        String[] stringArray = new String[]{GOOD_CA_CERT, "ValidCertificatePathTest1EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, noPolicies);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2, -1, "CertPathReviewer.invalidPolicy", "Path processing failed on policy.");
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1And2);
    }

    public void testAllCertificatesNoPoliciesTest2() throws Exception {
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"NoPoliciesCACert", "AllCertificatesNoPoliciesTest2EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, "NoPoliciesCACRL"});
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{"NoPoliciesCACert", "AllCertificatesNoPoliciesTest2EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, "NoPoliciesCACRL"}, noPolicies, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
    }

    public void testDifferentPoliciesTest3() throws Exception {
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "PoliciesP2subCACert", "DifferentPoliciesTest3EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL, "PoliciesP2subCACRL"});
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "PoliciesP2subCACert", "DifferentPoliciesTest3EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL, "PoliciesP2subCACRL"}, noPolicies, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "PoliciesP2subCACert", "DifferentPoliciesTest3EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL, "PoliciesP2subCACRL"}, nistTestPolicy1And2, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
    }

    public void testDifferentPoliciesTest4() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "GoodsubCACert", "DifferentPoliciesTest4EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL, "GoodsubCACRL"}, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
    }

    public void testDifferentPoliciesTest5() throws Exception {
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, new String[]{GOOD_CA_CERT, "PoliciesP2subCA2Cert", "DifferentPoliciesTest5EE"}, new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL, "PoliciesP2subCA2CRL"}, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
    }

    public void testOverlappingPoliciesTest6() throws Exception {
        String[] stringArray = new String[]{"PoliciesP1234CACert", "PoliciesP1234subCAP123Cert", "PoliciesP1234subsubCAP123P12Cert", "OverlappingPoliciesTest6EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "PoliciesP1234CACRL", "PoliciesP1234subCAP123CRL", "PoliciesP1234subsubCAP123P12CRL"};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2, -1, "CertPathReviewer.invalidPolicy", "Path processing failed on policy.");
    }

    public void testDifferentPoliciesTest7() throws Exception {
        String[] stringArray = new String[]{"PoliciesP123CACert", "PoliciesP123subCAP12Cert", "PoliciesP123subsubCAP12P1Cert", "DifferentPoliciesTest7EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "PoliciesP123CACRL", "PoliciesP123subCAP12CRL", "PoliciesP123subsubCAP12P1CRL"};
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
    }

    public void testDifferentPoliciesTest8() throws Exception {
        String[] stringArray = new String[]{"PoliciesP12CACert", "PoliciesP12subCAP1Cert", "PoliciesP12subsubCAP1P2Cert", "DifferentPoliciesTest8EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "PoliciesP12CACRL", "PoliciesP12subCAP1CRL", "PoliciesP12subsubCAP1P2CRL"};
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
    }

    public void testDifferentPoliciesTest9() throws Exception {
        String[] stringArray = new String[]{"PoliciesP123CACert", "PoliciesP123subCAP12Cert", "PoliciesP123subsubCAP12P2Cert", "PoliciesP123subsubsubCAP12P2P1Cert", "DifferentPoliciesTest9EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "PoliciesP123CACRL", "PoliciesP123subCAP12CRL", "PoliciesP123subsubCAP2P2CRL", "PoliciesP123subsubsubCAP12P2P1CRL"};
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
    }

    public void testAllCertificatesSamePoliciesTest10() throws Exception {
        String[] stringArray = new String[]{"PoliciesP12CACert", "AllCertificatesSamePoliciesTest10EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "PoliciesP12CACRL"};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2);
    }

    public void testAllCertificatesAnyPolicyTest11() throws Exception {
        String[] stringArray = new String[]{"anyPolicyCACert", "AllCertificatesanyPolicyTest11EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "anyPolicyCACRL"};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
    }

    public void testDifferentPoliciesTest12() throws Exception {
        String[] stringArray = new String[]{"PoliciesP3CACert", "DifferentPoliciesTest12EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "PoliciesP3CACRL"};
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, -1, "CertPathReviewer.noValidPolicyTree", "Policy checking failed: no valid policy tree found when one expected.");
    }

    public void testAllCertificatesSamePoliciesTest13() throws Exception {
        String[] stringArray = new String[]{"PoliciesP123CACert", "AllCertificatesSamePoliciesTest13EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "PoliciesP123CACRL"};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy3);
    }

    public void testAnyPolicyTest14() throws Exception {
        String[] stringArray = new String[]{"anyPolicyCACert", "AnyPolicyTest14EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "anyPolicyCACRL"};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2, -1, "CertPathReviewer.invalidPolicy", "Path processing failed on policy.");
    }

    public void testUserNoticeQualifierTest15() throws Exception {
        String[] stringArray = new String[]{"UserNoticeQualifierTest15EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2, -1, "CertPathReviewer.invalidPolicy", "Path processing failed on policy.");
    }

    public void testUserNoticeQualifierTest16() throws Exception {
        String[] stringArray = new String[]{GOOD_CA_CERT, "UserNoticeQualifierTest16EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2, -1, "CertPathReviewer.invalidPolicy", "Path processing failed on policy.");
    }

    public void testUserNoticeQualifierTest17() throws Exception {
        String[] stringArray = new String[]{GOOD_CA_CERT, "UserNoticeQualifierTest17EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, GOOD_CA_CRL};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2, -1, "CertPathReviewer.invalidPolicy", "Path processing failed on policy.");
    }

    public void testUserNoticeQualifierTest18() throws Exception {
        String[] stringArray = new String[]{"PoliciesP12CACert", "UserNoticeQualifierTest18EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL, "PoliciesP12CACRL"};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2);
    }

    public void testUserNoticeQualifierTest19() throws Exception {
        String[] stringArray = new String[]{"UserNoticeQualifierTest19EE"};
        String[] stringArray2 = new String[]{TRUST_ANCHOR_ROOT_CRL};
        this.doAcceptingTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy1);
        this.doErrorTest(TRUST_ANCHOR_ROOT_CERTIFICATE, stringArray, stringArray2, nistTestPolicy2, -1, "CertPathReviewer.invalidPolicy", "Path processing failed on policy.");
    }

    private void doAcceptingTest(String string, String[] stringArray, String[] stringArray2) throws Exception {
        PKIXCertPathReviewer pKIXCertPathReviewer = this.doTest(string, stringArray, stringArray2);
        if (!pKIXCertPathReviewer.isValidCertPath()) {
            NistCertPathReviewerTest.fail((String)"path rejected when should be accepted");
        }
    }

    private void doAcceptingTest(String string, String[] stringArray, String[] stringArray2, Set set) throws Exception {
        PKIXCertPathReviewer pKIXCertPathReviewer = this.doTest(string, stringArray, stringArray2, set);
        if (!pKIXCertPathReviewer.isValidCertPath()) {
            NistCertPathReviewerTest.fail((String)"path rejected when should be accepted");
        }
    }

    private void doErrorTest(String string, String[] stringArray, String[] stringArray2, int n, String string2, String string3) throws Exception {
        PKIXCertPathReviewer pKIXCertPathReviewer = this.doTest(string, stringArray, stringArray2);
        if (pKIXCertPathReviewer.isValidCertPath()) {
            NistCertPathReviewerTest.fail((String)"path accepted when should be rejected");
        } else {
            ErrorBundle errorBundle = (ErrorBundle)pKIXCertPathReviewer.getErrors(n).iterator().next();
            NistCertPathReviewerTest.assertEquals((String)string2, (String)errorBundle.getId());
            NistCertPathReviewerTest.assertEquals((String)string3, (String)errorBundle.getText(Locale.ENGLISH, TimeZone.getTimeZone("GMT")));
        }
    }

    private void doErrorTest(String string, String[] stringArray, String[] stringArray2, Set set, int n, String string2, String string3) throws Exception {
        PKIXCertPathReviewer pKIXCertPathReviewer = this.doTest(string, stringArray, stringArray2, set);
        if (pKIXCertPathReviewer.isValidCertPath()) {
            NistCertPathReviewerTest.fail((String)"path accepted when should be rejected");
        } else {
            ErrorBundle errorBundle = (ErrorBundle)pKIXCertPathReviewer.getErrors(n).iterator().next();
            NistCertPathReviewerTest.assertEquals((String)string2, (String)errorBundle.getId());
            NistCertPathReviewerTest.assertEquals((String)string3, (String)errorBundle.getText(Locale.ENGLISH, TimeZone.getTimeZone("GMT")));
        }
    }

    private PKIXCertPathReviewer doTest(String string, String[] stringArray, String[] stringArray2) throws Exception {
        return this.doTest(string, stringArray, stringArray2, null);
    }

    private PKIXCertPathReviewer doTest(String string, String[] stringArray, String[] stringArray2, Set set) throws Exception {
        Set<TrustAnchor> set2 = Collections.singleton(this.getTrustAnchor(string));
        ArrayList<X509Extension> arrayList = new ArrayList<X509Extension>();
        X509Certificate x509Certificate = this.loadCert(stringArray[stringArray.length - 1]);
        for (int i = 0; i != stringArray.length - 1; ++i) {
            arrayList.add(this.loadCert(stringArray[i]));
        }
        arrayList.add(x509Certificate);
        CertPath certPath = CertificateFactory.getInstance("X.509", "BC").generateCertPath(arrayList);
        for (int i = 0; i != stringArray2.length; ++i) {
            arrayList.add(this.loadCrl(stringArray2[i]));
        }
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
        PKIXParameters pKIXParameters = new PKIXParameters(set2);
        pKIXParameters.addCertStore(certStore);
        pKIXParameters.setRevocationEnabled(true);
        if (set != null) {
            pKIXParameters.setExplicitPolicyRequired(true);
            pKIXParameters.setInitialPolicies(set);
        }
        PKIXCertPathReviewer pKIXCertPathReviewer = new PKIXCertPathReviewer(certPath, pKIXParameters);
        return pKIXCertPathReviewer;
    }

    private X509Certificate loadCert(String string) {
        X509Certificate x509Certificate = (X509Certificate)certs.get(string);
        if (x509Certificate != null) {
            return x509Certificate;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.getPkitsHome() + "/certs/" + string + ".crt");
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            certs.put(string, x509Certificate);
            return x509Certificate;
        }
        catch (Exception exception) {
            throw new IllegalStateException("exception loading certificate " + string + ": " + exception);
        }
    }

    private X509CRL loadCrl(String string) throws Exception {
        X509CRL x509CRL = (X509CRL)certs.get(string);
        if (x509CRL != null) {
            return x509CRL;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.getPkitsHome() + "/crls/" + string + ".crl");
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            x509CRL = (X509CRL)certificateFactory.generateCRL(fileInputStream);
            crls.put(string, x509CRL);
            return x509CRL;
        }
        catch (Exception exception) {
            throw new IllegalStateException("exception loading CRL: " + string);
        }
    }

    private TrustAnchor getTrustAnchor(String string) throws Exception {
        X509Certificate x509Certificate = this.loadCert(string);
        byte[] byArray = x509Certificate.getExtensionValue(X509Extensions.NameConstraints.getId());
        if (byArray != null) {
            ASN1Object aSN1Object = X509ExtensionUtil.fromExtensionValue(byArray);
            return new TrustAnchor(x509Certificate, aSN1Object.getDEREncoded());
        }
        return new TrustAnchor(x509Certificate, null);
    }

    private String getPkitsHome() {
        String string = System.getProperty(TEST_DATA_HOME);
        if (string == null) {
            throw new IllegalStateException("bc.test.data.home property not set");
        }
        return string + "/PKITS";
    }

    public static void main(String[] stringArray) throws Exception {
        TestRunner.run((Test)NistCertPathReviewerTest.suite());
    }

    public void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static Test suite() throws Exception {
        TestSuite testSuite = new TestSuite("NIST CertPath Tests");
        testSuite.addTestSuite(NistCertPathReviewerTest.class);
        return testSuite;
    }
}

