/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionDispatcher;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.io.AbstractChannelInterestRead;
import com.limegroup.gnutella.io.AcceptObserver;
import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.SocketFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Acceptor {
    private static final Log LOG = LogFactory.getLog(Acceptor.class);
    static long INCOMING_EXPIRE_TIME = 1800000L;
    static long WAIT_TIME_AFTER_REQUESTS = 30000L;
    static long TIME_BETWEEN_VALIDATES = 600000L;
    private static final UPnPManager UPNP_MANAGER = !ConnectionSettings.DISABLE_UPNP.getValue() ? UPnPManager.instance() : null;
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private static byte[] _address = new byte[4];
    private static byte[] _externalAddress = new byte[4];
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastIncomingTime = 0L;
    private volatile long _lastConnectBackTime = System.currentTimeMillis();
    private volatile boolean _started;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (!NetworkUtils.isValidAddress(byteAddr)) {
            return;
        }
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean addrChanged = false;
        Class clazz = Acceptor.class;
        synchronized (clazz) {
            if (!Arrays.equals(_address, byteAddr)) {
                _address = byteAddr;
                addrChanged = true;
            }
        }
        if (addrChanged) {
            RouterService.addressChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class clazz = Acceptor.class;
        synchronized (clazz) {
            _externalAddress = byteAddr;
        }
    }

    public void init() {
        int oldPort;
        boolean tryingRandom;
        block19: {
            int tempPort;
            tryingRandom = ConnectionSettings.PORT.isDefault() && !ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() && !ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            Random gen = null;
            if (tryingRandom) {
                gen = new Random();
                tempPort = gen.nextInt(50000) + 2000;
            } else {
                tempPort = ConnectionSettings.PORT.getValue();
            }
            try {
                this.setAddress(UPNP_MANAGER != null ? NetworkUtils.getLocalAddress() : InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            oldPort = tempPort;
            try {
                this.setListeningPort(tempPort);
                this._port = tempPort;
            }
            catch (IOException e) {
                LOG.warn("can't set initial port", e);
                int numToTry = 20;
                for (int i = 0; i < numToTry; ++i) {
                    if (gen == null) {
                        gen = new Random();
                    }
                    tempPort = gen.nextInt(50000);
                    if ((tempPort += 2000) == ConnectionSettings.MULTICAST_PORT.getValue()) {
                        ++numToTry;
                        continue;
                    }
                    try {
                        this.setListeningPort(tempPort);
                        this._port = tempPort;
                        break;
                    }
                    catch (IOException e2) {
                        LOG.warn("can't set port", e2);
                    }
                }
                if (this._socket != null) break block19;
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
        if (this._port != oldPort || tryingRandom) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsHandler.save();
            RouterService.addressChanged();
        }
        if (this._socket != null && UPNP_MANAGER != null) {
            boolean forcedIP;
            UPNP_MANAGER.waitForDevice();
            UPNP_MANAGER.stop();
            boolean natted = UPNP_MANAGER.isNATPresent();
            boolean validPort = NetworkUtils.isValidPort(this._port);
            boolean bl = forcedIP = ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Natted: " + natted + ", validPort: " + validPort + ", forcedIP: " + forcedIP);
            }
            if (natted && validPort && !forcedIP) {
                int mappedPort = UPNP_MANAGER.mapPort(this._port);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("UPNP port mapped: " + mappedPort);
                }
                if (mappedPort != 0) {
                    UPNP_MANAGER.clearMappingsOnShutdown();
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                    ConnectionSettings.FORCED_PORT.setValue(mappedPort);
                    ConnectionSettings.UPNP_IN_USE.setValue(true);
                    if (mappedPort != this._port) {
                        RouterService.addressChanged();
                    }
                    this.resetLastConnectBackTime();
                    UDPService.instance().resetLastConnectBackTime();
                }
            }
        }
    }

    public void start() {
        MulticastService.instance().start();
        UDPService.instance().start();
        RouterService.schedule(new IncomingValidator(), TIME_BETWEEN_VALIDATES, TIME_BETWEEN_VALIDATES);
        this._started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class clazz = Acceptor.class;
        synchronized (clazz) {
            return Arrays.equals(this.getAddress(true), _externalAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getExternalAddress() {
        Class clazz = Acceptor.class;
        synchronized (clazz) {
            return _externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAddress(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            String address = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress ia = InetAddress.getByName(address);
                return ia.getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        Class clazz = Acceptor.class;
        synchronized (clazz) {
            return _address;
        }
    }

    public int getPort(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    public void setListeningPort(int port) throws IOException {
        if (this._socket != null && this._port == port) {
            return;
        }
        if (port == 0) {
            LOG.trace("shutting off service.");
            IOUtils.close(this._socket);
            this._socket = null;
            this._port = 0;
            UDPService.instance().setListeningSocket(null);
            MulticastService.instance().setListeningSocket(null);
            LOG.trace("service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changing port to " + port);
        }
        DatagramSocket udpServiceSocket = UDPService.instance().newListeningSocket(port);
        LOG.trace("UDP Service is ready.");
        MulticastSocket mcastServiceSocket = null;
        try {
            InetAddress mgroup = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            mcastServiceSocket = MulticastService.instance().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), mgroup);
            LOG.trace("multicast service setup");
        }
        catch (IOException e) {
            LOG.warn("can't create multicast socket", e);
            mcastServiceSocket = null;
        }
        ServerSocket newSocket = null;
        try {
            newSocket = SocketFactory.newServerSocket(port, new SocketListener());
        }
        catch (IOException e) {
            LOG.warn("can't create ServerSocket", e);
            udpServiceSocket.close();
            throw e;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("can't create ServerSocket", e);
            udpServiceSocket.close();
            throw new IOException("could not create a listening socket");
        }
        IOUtils.close(this._socket);
        this._socket = newSocket;
        this._port = port;
        LOG.trace("Acceptor ready..");
        UDPService.instance().setListeningSocket(udpServiceSocket);
        if (mcastServiceSocket != null) {
            MulticastService.instance().setListeningSocket(mcastServiceSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("listening UDP/TCP on " + this._port);
        }
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    private boolean setIncoming(boolean status) {
        if (this._acceptedIncoming == status) {
            return false;
        }
        this._acceptedIncoming = status;
        RouterService.getCallback().acceptedIncomingChanged(status);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFirewall(InetAddress address) {
        boolean changed = false;
        if (this.isOutsideConnection(address)) {
            Class clazz = Acceptor.class;
            synchronized (clazz) {
                changed = this.setIncoming(true);
                ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(true);
                this._lastIncomingTime = System.currentTimeMillis();
            }
        }
        if (changed) {
            RouterService.incomingStatusChanged();
        }
    }

    public void accept(Socket client) {
        this.accept(client, null);
    }

    public void accept(Socket client, String allowedProtocol) {
        if (!this._started) {
            IOUtils.close(client);
            return;
        }
        InetAddress address = client.getInetAddress();
        if (address == null) {
            IOUtils.close(client);
            LOG.warn("connection closed while accepting");
        } else if (this.isBannedIP(address.getAddress())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring banned host: " + address);
            }
            HTTPStat.BANNED_REQUESTS.incrementStat();
            IOUtils.close(client);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatching new client connecton: " + address);
            }
            if (!ConnectionSettings.UNSET_FIREWALLED_FROM_CONNECTBACK.getValue()) {
                this.checkFirewall(client.getInetAddress());
            }
            InetAddress localAddress = client.getLocalAddress();
            this.setAddress(localAddress);
            try {
                this._socket.setSoTimeout(8000);
            }
            catch (SocketException se) {
                IOUtils.close(this._socket);
                return;
            }
            if (client instanceof NIOMultiplexor) {
                ((NIOMultiplexor)((Object)client)).setReadObserver(new AsyncConnectionDispatcher(client, allowedProtocol));
            } else {
                ThreadFactory.startThread(new BlockingConnectionDispatcher(client, allowedProtocol), "ConnectionDispatchRunner");
            }
        }
    }

    private boolean isOutsideConnection(InetAddress addr) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        return !RouterService.isConnectedTo(addr) && !NetworkUtils.isLocalAddress(addr);
    }

    public boolean isBannedIP(byte[] addr) {
        return !IPFilter.instance().allow(addr);
    }

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - INCOMING_EXPIRE_TIME - 1L;
    }

    public void shutdown() {
        if (UPNP_MANAGER != null && UPNP_MANAGER.isNATPresent() && UPNP_MANAGER.mappingsExist() && ConnectionSettings.UPNP_IN_USE.getValue()) {
            ConnectionSettings.FORCE_IP_ADDRESS.revertToDefault();
            ConnectionSettings.FORCED_PORT.revertToDefault();
            ConnectionSettings.UPNP_IN_USE.revertToDefault();
        }
    }

    private static class BlockingConnectionDispatcher
    implements Runnable {
        private final Socket client;
        private final String allowedWord;

        public BlockingConnectionDispatcher(Socket socket, String allowedWord) {
            this.client = socket;
            this.allowedWord = allowedWord;
        }

        public void run() {
            try {
                InputStream in = null;
                try {
                    in = this.client.getInputStream();
                }
                catch (IOException e) {
                    HTTPStat.CLOSED_REQUESTS.incrementStat();
                    throw e;
                }
                catch (NullPointerException e) {
                    throw new IOException(e.getMessage());
                }
                ConnectionDispatcher dispatcher = RouterService.getConnectionDispatcher();
                String word = IOUtils.readLargestWord(in, dispatcher.getMaximumWordSize());
                if (this.allowedWord != null && !this.allowedWord.equals(word)) {
                    throw new IOException("wrong word!");
                }
                dispatcher.dispatch(word, this.client, false);
            }
            catch (IOException iox) {
                HTTPStat.CLOSED_REQUESTS.incrementStat();
                IOUtils.close(this.client);
            }
        }
    }

    private static class AsyncConnectionDispatcher
    extends AbstractChannelInterestRead {
        private final Socket client;
        private final String allowedWord;

        AsyncConnectionDispatcher(Socket client, String allowedWord) {
            this.client = client;
            this.allowedWord = allowedWord;
        }

        protected int getBufferSize() {
            return RouterService.getConnectionDispatcher().getMaximumWordSize() + 1;
        }

        public void shutdown() {
            super.shutdown();
            HTTPStat.CLOSED_REQUESTS.incrementStat();
        }

        public void handleRead() throws IOException {
            int read = 0;
            while (this.buffer.hasRemaining() && (read = this.source.read(this.buffer)) > 0) {
            }
            for (int i = 0; i < this.buffer.position(); ++i) {
                if (this.buffer.get(i) != 32) continue;
                String word = new String(this.buffer.array(), 0, i);
                if (this.allowedWord != null && !this.allowedWord.equals(word)) {
                    throw new IOException("wrong word!");
                }
                this.buffer.limit(this.buffer.position()).position(i + 1);
                this.source.interest(false);
                RouterService.getConnectionDispatcher().dispatch(word, this.client, true);
                return;
            }
            if (!this.buffer.hasRemaining() || read == -1) {
                this.close();
            }
        }

        public int read(ByteBuffer dst) {
            return BufferUtils.transfer(this.buffer, dst, false);
        }
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            final long currTime = System.currentTimeMillis();
            ConnectionManager cm = RouterService.getConnectionManager();
            if ((Acceptor.this._acceptedIncoming && currTime - Acceptor.this._lastIncomingTime > INCOMING_EXPIRE_TIME || !Acceptor.this._acceptedIncoming && currTime - Acceptor.this._lastConnectBackTime > INCOMING_EXPIRE_TIME) && cm.sendTCPConnectBackRequests()) {
                Acceptor.this._lastConnectBackTime = System.currentTimeMillis();
                Runnable resetter = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean changed = false;
                        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
                        synchronized (clazz) {
                            if (Acceptor.this._lastIncomingTime < currTime) {
                                changed = Acceptor.this.setIncoming(false);
                            }
                        }
                        if (changed) {
                            RouterService.incomingStatusChanged();
                        }
                    }
                };
                RouterService.schedule(resetter, WAIT_TIME_AFTER_REQUESTS, 0L);
            }
        }
    }

    private class SocketListener
    implements AcceptObserver {
        private SocketListener() {
        }

        public void handleIOException(IOException iox) {
            LOG.warn("IOX while accepting", iox);
        }

        public void shutdown() {
            LOG.debug("shutdown one SocketListener");
        }

        public void handleAccept(Socket client) {
            Acceptor.this.accept(client);
        }
    }
}

