/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionDispatcher {
    private static final Log LOG = LogFactory.getLog(ConnectionDispatcher.class);
    private static final int UNKNOWN = -1;
    private static final int GNUTELLA = 0;
    private static final int LIMEWIRE = 1;
    private static final int GET = 2;
    private static final int HEAD = 3;
    private static final int GIV = 4;
    private static final int CHAT = 5;
    private static final int MAGNET = 6;
    private static final int CONNECT = 7;

    private int parseWord(String word) {
        if (word == null) {
            return -1;
        }
        if (word.equals("GNUTELLA")) {
            return 0;
        }
        if (ConnectionSettings.CONNECT_STRING.isDefault() && word.equals("LIMEWIRE")) {
            return 1;
        }
        if (word.equals("GET")) {
            return 2;
        }
        if (word.equals("HEAD")) {
            return 3;
        }
        if (word.equals("GIV")) {
            return 4;
        }
        if (word.equals("CHAT")) {
            return 5;
        }
        if (word.equals("MAGNET")) {
            return 6;
        }
        if (word.equals("CONNECT") || word.equals("\n\n")) {
            return 7;
        }
        return -1;
    }

    public int getMaximumWordSize() {
        return 8;
    }

    public void dispatch(final String word, final Socket client, boolean newThread) {
        try {
            client.setSoTimeout(0);
        }
        catch (SocketException se) {
            IOUtils.close(client);
            return;
        }
        final int protocol = this.parseWord(word);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dispatching protocol: " + protocol + ", from word: " + word);
        }
        boolean localHost = NetworkUtils.isLocalHost(client);
        if (protocol != 6) {
            if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && localHost) {
                LOG.trace("Killing localhost connection with non-magnet.");
                IOUtils.close(client);
                return;
            }
        } else if (!localHost) {
            LOG.trace("Killing non-local ExternalControl request.");
            IOUtils.close(client);
            return;
        }
        switch (protocol) {
            case 0: {
                HTTPStat.GNUTELLA_REQUESTS.incrementStat();
                RouterService.getConnectionManager().acceptConnection(client);
                return;
            }
            case 1: {
                HTTPStat.GNUTELLA_LIMEWIRE_REQUESTS.incrementStat();
                RouterService.getConnectionManager().acceptConnection(client);
                return;
            }
            case 7: {
                if (ConnectionSettings.UNSET_FIREWALLED_FROM_CONNECTBACK.getValue()) {
                    RouterService.getAcceptor().checkFirewall(client.getInetAddress());
                }
                IOUtils.close(client);
                return;
            }
            case 5: {
                HTTPStat.CHAT_REQUESTS.incrementStat();
                ChatManager.instance().accept(client);
                return;
            }
            case 4: {
                HTTPStat.GIV_REQUESTS.incrementStat();
                RouterService.getDownloadManager().acceptDownload(client);
                return;
            }
            case -1: {
                HTTPStat.UNKNOWN_REQUESTS.incrementStat();
                if (LOG.isErrorEnabled()) {
                    LOG.error("Unknown protocol: " + word);
                }
                IOUtils.close(client);
                return;
            }
        }
        Runnable runner = new Runnable(){

            public void run() {
                switch (protocol) {
                    case 2: {
                        HTTPStat.GET_REQUESTS.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.GET, client, false);
                        break;
                    }
                    case 3: {
                        HTTPStat.HEAD_REQUESTS.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.HEAD, client, false);
                        break;
                    }
                    case 6: {
                        HTTPStat.MAGNET_REQUESTS.incrementStat();
                        ExternalControl.fireMagnet(client);
                        break;
                    }
                    default: {
                        IOUtils.close(client);
                        LOG.error("Parsed to unsupported protocol: " + protocol + ", word: " + word);
                    }
                }
            }
        };
        if (newThread) {
            ThreadFactory.startThread(runner, "IncomingConnection");
        } else {
            runner.run();
        }
    }
}

