/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.connection.ConnectionChecker;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.SystemUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager {
    private volatile long _disconnectTime = -1L;
    private volatile long _connectTime = Long.MAX_VALUE;
    private volatile long _automaticConnectTime = 0L;
    private volatile boolean _automaticallyConnecting;
    private volatile long _lastSuccessfulConnect = 0L;
    private volatile long _lastConnectionCheck = 0L;
    private static volatile int _connectionAttempts;
    private static final Log LOG;
    public static final int PREFERRED_CONNECTIONS_FOR_LEAF = 3;
    public static final int CONNECT_BACK_REDUNDANT_REQUESTS = 3;
    private static final int MINIMUM_IDLE_TIME = 1800000;
    public static final int RESERVED_NON_LIMEWIRE_LEAVES = 2;
    private volatile int _preferredConnections = -1;
    private HostCatcher _catcher;
    private final List _fetchers = new ArrayList();
    private final List _initializingFetchedConnections = new ArrayList();
    private ConnectionFetcher _dedicatedPrefFetcher;
    private volatile boolean _needPref = true;
    private boolean _needPrefInterrupterScheduled = false;
    private volatile List _connections = Collections.EMPTY_LIST;
    private volatile List _initializedConnections = Collections.EMPTY_LIST;
    private volatile List _initializedClientConnections = Collections.EMPTY_LIST;
    private volatile int _shieldedConnections = 0;
    private volatile int _nonLimeWireLeaves = 0;
    private volatile int _nonLimeWirePeers = 0;
    private volatile int _localeMatchingPeers = 0;
    private volatile int _leafTries;
    private volatile int _demotionLimit = 0;
    private volatile float _measuredUpstreamBandwidth = 0.0f;
    private volatile float _measuredDownstreamBandwidth = 0.0f;

    public void initialize() {
        this._catcher = RouterService.getHostCatcher();
        if (SystemUtils.supportsIdleTime()) {
            RouterService.schedule(new Runnable(){

                public void run() {
                    ConnectionManager.this.setPreferredConnections();
                }
            }, 1000L, 1000L);
        }
    }

    public ManagedConnection createConnectionBlocking(String hostname, int portnum) throws IOException {
        ManagedConnection c = new ManagedConnection(hostname, portnum);
        this.initializeExternallyGeneratedConnection(c, null);
        ThreadFactory.startThread(new OutgoingConnector(c, false), "OutgoingConnector");
        return c;
    }

    public void createConnectionAsynchronously(String hostname, int portnum) {
        OutgoingConnector outgoingRunner = new OutgoingConnector(new ManagedConnection(hostname, portnum), true);
        ThreadFactory.startThread(outgoingRunner, "OutgoingConnectionThread");
    }

    void acceptConnection(Socket socket) {
        ManagedConnection connection = new ManagedConnection(socket);
        IncomingGNetObserver listener = null;
        if (connection.isAsynchronous()) {
            listener = new IncomingGNetObserver(connection);
        } else {
            Thread.currentThread().setName("IncomingConnectionThread");
        }
        try {
            this.initializeExternallyGeneratedConnection(connection, listener);
        }
        catch (IOException e) {
            connection.close();
            return;
        }
        if (listener == null) {
            try {
                this.startConnection(connection);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public synchronized void remove(ManagedConnection mc) {
        if (!ConnectionSettings.REMOVE_ENABLED.getValue()) {
            return;
        }
        this.removeInternal(mc);
        this.adjustConnectionFetchers();
    }

    public boolean isSupernode() {
        return this.isActiveSupernode() || this.isSupernodeCapable();
    }

    public boolean isSupernodeCapable() {
        return !NetworkUtils.isPrivate() && UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.getValue() && !this.isShieldedLeaf() && !UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue() && !this.isBehindProxy() && this.minConnectTimePassed();
    }

    private boolean minConnectTimePassed() {
        if (!UltrapeerSettings.NEED_MIN_CONNECT_TIME.getValue()) {
            return true;
        }
        return Math.max(0L, System.currentTimeMillis() - this._connectTime) / 1000L >= (long)UltrapeerSettings.MIN_CONNECT_TIME.getValue();
    }

    public boolean isBehindProxy() {
        return ConnectionSettings.CONNECTION_METHOD.getValue() != 0;
    }

    public boolean isActiveSupernode() {
        return !this.isShieldedLeaf() && (this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0);
    }

    public boolean isShieldedLeaf() {
        return this._shieldedConnections != 0;
    }

    public boolean hasSupernodeClientConnection() {
        return this.getNumInitializedClientConnections() > 0;
    }

    public boolean hasFreeSlots() {
        return this.isSupernode() && (this.hasFreeUltrapeerSlots() || this.hasFreeLeafSlots());
    }

    private boolean hasFreeUltrapeerSlots() {
        return this.getNumFreeNonLeafSlots() > 0;
    }

    private boolean hasFreeLeafSlots() {
        return this.getNumFreeLeafSlots() > 0;
    }

    boolean isConnectedTo(String hostName) {
        List connections = this.getConnections();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (!mc.getAddress().equals(hostName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectingTo(IpPort host) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Object next;
            int i;
            for (i = 0; i < this._fetchers.size(); ++i) {
                next = (ConnectionFetcher)this._fetchers.get(i);
                IpPort them = ((ConnectionFetcher)next).getIpPort();
                if (them == null || !host.getAddress().equals(them.getAddress()) || host.getPort() != them.getPort()) continue;
                return true;
            }
            for (i = 0; i < this._initializingFetchedConnections.size(); ++i) {
                next = (ManagedConnection)this._initializingFetchedConnections.get(i);
                if (!host.getAddress().equals(((Connection)next).getAddress()) || host.getPort() != ((Connection)next).getPort()) continue;
                return true;
            }
            return false;
        }
    }

    public int getNumConnections() {
        return this._connections.size();
    }

    public int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    public int getNumInitializedClientConnections() {
        return this._initializedClientConnections.size();
    }

    public int getNumClientSupernodeConnections() {
        return this._shieldedConnections;
    }

    public synchronized int getNumUltrapeerConnections() {
        return this.ultrapeerToUltrapeerConnections();
    }

    public synchronized int getNumOldConnections() {
        return this.oldConnections();
    }

    public int getNumFreeLeafSlots() {
        if (this.isSupernode()) {
            return UltrapeerSettings.MAX_LEAVES.getValue() - this.getNumInitializedClientConnections();
        }
        return 0;
    }

    public int getNumFreeLimeWireLeafSlots() {
        return Math.max(0, this.getNumFreeLeafSlots() - Math.max(0, 2 - this._nonLimeWireLeaves));
    }

    public int getNumFreeNonLeafSlots() {
        return this._preferredConnections - this.getNumInitializedConnections();
    }

    public int getNumFreeLimeWireNonLeafSlots() {
        return Math.max(0, this.getNumFreeNonLeafSlots() - Math.max(0, (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections) - this._nonLimeWirePeers) - this.getNumLimeWireLocalePrefSlots());
    }

    public boolean isLocaleMatched() {
        return !ConnectionSettings.USE_LOCALE_PREF.getValue() || this._localeMatchingPeers != 0;
    }

    public int getNumLimeWireLocalePrefSlots() {
        return Math.max(0, ConnectionSettings.NUM_LOCALE_PREF.getValue() - this._localeMatchingPeers);
    }

    public boolean isFullyConnected() {
        return this._initializedConnections.size() >= this._preferredConnections;
    }

    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        if (this._disconnectTime != 0L) {
            return false;
        }
        if (this.isConnected()) {
            return false;
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            return this._fetchers.size() != 0 || this._initializingFetchedConnections.size() != 0;
        }
    }

    public void measureBandwidth() {
        float upstream = 0.0f;
        float downstream = 0.0f;
        List connections = this.getInitializedConnections();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            mc.measureBandwidth();
            upstream += mc.getMeasuredUpstreamBandwidth();
            downstream += mc.getMeasuredDownstreamBandwidth();
        }
        this._measuredUpstreamBandwidth = upstream;
        this._measuredDownstreamBandwidth = downstream;
    }

    public float getMeasuredUpstreamBandwidth() {
        return this._measuredUpstreamBandwidth;
    }

    public float getMeasuredDownstreamBandwidth() {
        return this._measuredDownstreamBandwidth;
    }

    private HandshakeStatus allowConnection(ManagedConnection c) {
        if (!c.receivedHeaders()) {
            return HandshakeStatus.NO_HEADERS;
        }
        return this.allowConnection(c.headers(), false);
    }

    public HandshakeStatus allowConnectionAsLeaf(HandshakeResponse hr) {
        return this.allowConnection(hr, true);
    }

    public HandshakeStatus allowConnection(HandshakeResponse hr) {
        return this.allowConnection(hr, !hr.isUltrapeer());
    }

    public boolean allowAnyConnection() {
        if (this.isShieldedLeaf()) {
            return false;
        }
        return this.getNumInitializedConnections() < this._preferredConnections || this.isSupernode() && this.getNumInitializedClientConnections() < UltrapeerSettings.MAX_LEAVES.getValue();
    }

    public HandshakeStatus allowConnection(HandshakeResponse hr, boolean leaf) {
        if (!ConnectionSettings.PREFERENCING_ACTIVE.getValue()) {
            return HandshakeStatus.OK;
        }
        if (!hr.isLeaf() && !hr.isUltrapeer()) {
            return HandshakeStatus.NO_X_ULTRAPEER;
        }
        int limeAttempts = ConnectionSettings.LIME_ATTEMPTS.getValue();
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._preferredConnections <= 0) {
            return HandshakeStatus.DISCONNECTED;
        }
        if (this.isShieldedLeaf() || !this.isSupernode()) {
            if (!hr.isUltrapeer()) {
                return HandshakeStatus.WE_ARE_LEAVES;
            }
            if (!hr.isGoodUltrapeer()) {
                return HandshakeStatus.NOT_GOOD_UP;
            }
            if (_connectionAttempts < limeAttempts && !hr.isLimeWire()) {
                return HandshakeStatus.STARTING_LIMEWIRE;
            }
            if (this._shieldedConnections < this._preferredConnections) {
                if (this.checkLocale(hr.getLocalePref())) {
                    this._needPref = false;
                }
                if (this.isIdle()) {
                    if (hr.isLimeWire()) {
                        return HandshakeStatus.OK;
                    }
                    return HandshakeStatus.IDLE_LIMEWIRE;
                }
                return HandshakeStatus.OK;
            }
            if (this._needPref && this.checkLocale(hr.getLocalePref())) {
                this._needPref = false;
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.TOO_MANY_UPS;
        }
        if (hr.isLeaf() || leaf) {
            if (this.isShieldedLeaf() || !this.isSupernode()) {
                return HandshakeStatus.WE_ARE_LEAVES;
            }
            if (!ConnectionManager.allowUltrapeer2LeafConnection(hr)) {
                return HandshakeStatus.NOT_ALLOWED_LEAF;
            }
            int leaves = this.getNumInitializedClientConnections();
            int nonLimeWireLeaves = this._nonLimeWireLeaves;
            if (!hr.isLimeWire() && leaves < UltrapeerSettings.MAX_LEAVES.getValue() && nonLimeWireLeaves < 2) {
                return HandshakeStatus.OK;
            }
            if (!hr.isGoodLeaf()) {
                return HandshakeStatus.NOT_GOOD_LEAF;
            }
            if (leaves + Math.max(0, 2 - nonLimeWireLeaves) < UltrapeerSettings.MAX_LEAVES.getValue()) {
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.TOO_MANY_LEAF;
        }
        if (hr.isUltrapeer()) {
            int peers = this.getNumInitializedConnections();
            int nonLimeWirePeers = this._nonLimeWirePeers;
            int locale_num = 0;
            if (!ConnectionManager.allowUltrapeer2UltrapeerConnection(hr)) {
                return HandshakeStatus.NOT_ALLOWED_UP;
            }
            if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
                if (this.checkLocale(hr.getLocalePref()) && this._localeMatchingPeers < ConnectionSettings.NUM_LOCALE_PREF.getValue()) {
                    return HandshakeStatus.OK;
                }
                locale_num = this.getNumLimeWireLocalePrefSlots();
            }
            if (!hr.isLimeWire()) {
                double nonLimeRatio = (double)nonLimeWirePeers / (double)this._preferredConnections;
                if (nonLimeRatio < (double)ConnectionSettings.MIN_NON_LIME_PEERS.getValue()) {
                    return HandshakeStatus.OK;
                }
                if (!hr.isGoodUltrapeer()) {
                    return HandshakeStatus.NOT_GOOD_UP;
                }
                if (nonLimeRatio < (double)ConnectionSettings.MAX_NON_LIME_PEERS.getValue()) {
                    return HandshakeStatus.OK;
                }
                return HandshakeStatus.NON_LIME_RATIO;
            }
            int minNonLime = (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections);
            if (!hr.isGoodUltrapeer()) {
                return HandshakeStatus.NOT_GOOD_UP;
            }
            if (peers + Math.max(0, minNonLime - nonLimeWirePeers) + locale_num < this._preferredConnections) {
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.NO_LIME_SLOTS;
        }
        return HandshakeStatus.UNKNOWN;
    }

    private static boolean allowUltrapeer2UltrapeerConnection(HandshakeResponse hr) {
        if (hr.isLimeWire()) {
            return true;
        }
        String userAgent = hr.getUserAgent();
        if (userAgent == null) {
            return false;
        }
        userAgent = userAgent.toLowerCase();
        String[] bad = ConnectionSettings.EVIL_HOSTS.getValue();
        for (int i = 0; i < bad.length; ++i) {
            if (userAgent.indexOf(bad[i]) == -1) continue;
            return false;
        }
        return true;
    }

    private static boolean allowUltrapeer2LeafConnection(HandshakeResponse hr) {
        if (hr.isLimeWire()) {
            return true;
        }
        String userAgent = hr.getUserAgent();
        if (userAgent == null) {
            return false;
        }
        userAgent = userAgent.toLowerCase();
        String[] bad = ConnectionSettings.EVIL_HOSTS.getValue();
        for (int i = 0; i < bad.length; ++i) {
            if (userAgent.indexOf(bad[i]) == -1) continue;
            return false;
        }
        return true;
    }

    private int ultrapeerToUltrapeerConnections() {
        int ret = 0;
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (!mc.isSupernodeSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    private int oldConnections() {
        int ret = 0;
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (mc.isSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    public boolean supernodeNeeded() {
        return (double)this.getNumInitializedClientConnections() >= (double)UltrapeerSettings.MAX_LEAVES.getValue() * 0.9;
    }

    public List getInitializedConnections() {
        return this._initializedConnections;
    }

    public List getInitializedConnectionsMatchLocale(String loc) {
        LinkedList<Connection> matches = new LinkedList<Connection>();
        Iterator itr = this._initializedConnections.iterator();
        while (itr.hasNext()) {
            Connection conn = (Connection)itr.next();
            if (!loc.equals(conn.getLocalePref())) continue;
            matches.add(conn);
        }
        return matches;
    }

    public List getInitializedClientConnections() {
        return this._initializedClientConnections;
    }

    public List getInitializedClientConnectionsMatchLocale(String loc) {
        LinkedList<Connection> matches = new LinkedList<Connection>();
        Iterator itr = this._initializedClientConnections.iterator();
        while (itr.hasNext()) {
            Connection conn = (Connection)itr.next();
            if (!loc.equals(conn.getLocalePref())) continue;
            matches.add(conn);
        }
        return matches;
    }

    public List getConnections() {
        return this._connections;
    }

    public Set getPushProxies() {
        if (this.isShieldedLeaf()) {
            Iterator ultrapeers = this.getInitializedConnections().iterator();
            IpPortSet proxies = new IpPortSet();
            while (ultrapeers.hasNext() && proxies.size() < 4) {
                ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
                if (!currMC.isPushProxy()) continue;
                proxies.add(currMC);
            }
            return proxies;
        }
        return Collections.EMPTY_SET;
    }

    public boolean sendTCPConnectBackRequests() {
        int sent = 0;
        ArrayList peers = new ArrayList(this.getInitializedConnections());
        Collections.shuffle(peers);
        Iterator iter = peers.iterator();
        while (iter.hasNext()) {
            ManagedConnection currMC = (ManagedConnection)iter.next();
            if (currMC.remoteHostSupportsTCPRedirect() >= 0) continue;
            iter.remove();
        }
        if (peers.size() == 1) {
            ManagedConnection myConn = (ManagedConnection)peers.get(0);
            for (int i = 0; i < 3; ++i) {
                TCPConnectBackVendorMessage cb = new TCPConnectBackVendorMessage(RouterService.getPort());
                myConn.send(cb);
                ++sent;
            }
        } else {
            TCPConnectBackVendorMessage cb = new TCPConnectBackVendorMessage(RouterService.getPort());
            Iterator i = peers.iterator();
            while (i.hasNext() && sent < 5) {
                ManagedConnection currMC = (ManagedConnection)i.next();
                currMC.send(cb);
                ++sent;
            }
        }
        return sent > 0;
    }

    public boolean sendUDPConnectBackRequests(GUID cbGuid) {
        int sent = 0;
        UDPConnectBackVendorMessage cb = new UDPConnectBackVendorMessage(RouterService.getPort(), cbGuid);
        ArrayList peers = new ArrayList(this.getInitializedConnections());
        Collections.shuffle(peers);
        Iterator i = peers.iterator();
        while (i.hasNext() && sent < 5) {
            ManagedConnection currMC = (ManagedConnection)i.next();
            if (currMC.remoteHostSupportsUDPConnectBack() < 0) continue;
            currMC.send(cb);
            ++sent;
        }
        return sent > 0;
    }

    public void updateQueryStatus(QueryStatusResponse stat) {
        if (this.isShieldedLeaf()) {
            Iterator ultrapeers = this.getInitializedConnections().iterator();
            while (ultrapeers.hasNext()) {
                ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
                if (currMC.remoteHostSupportsLeafGuidance() < 0) continue;
                currMC.send(stat);
            }
        }
    }

    public Endpoint getConnectedGUESSUltrapeer() {
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iter.next();
            if (!connection.isSupernodeConnection() || !connection.isGUESSUltrapeer()) continue;
            return new Endpoint(connection.getInetAddress().getAddress(), connection.getPort());
        }
        return null;
    }

    public List getConnectedGUESSUltrapeers() {
        ArrayList<ManagedConnection> retList = new ArrayList<ManagedConnection>();
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iter.next();
            if (!connection.isSupernodeConnection() || !connection.isGUESSUltrapeer()) continue;
            retList.add(connection);
        }
        return retList;
    }

    private void connectionInitializing(Connection c) {
        ArrayList<Connection> newConnections = new ArrayList<Connection>(this._connections);
        newConnections.add(c);
        this._connections = Collections.unmodifiableList(newConnections);
    }

    private void connectionInitializingIncoming(ManagedConnection c) {
        this.connectionInitializing(c);
    }

    private boolean connectionInitialized(ManagedConnection c) {
        if (this._connections.contains(c)) {
            if (!this.allowInitializedConnection(c)) {
                this.removeInternal(c);
                return false;
            }
            if (!c.isSupernodeClientConnection()) {
                ArrayList<ManagedConnection> newConnections = new ArrayList<ManagedConnection>(this._initializedConnections);
                newConnections.add(c);
                this._initializedConnections = Collections.unmodifiableList(newConnections);
                if (c.isClientSupernodeConnection()) {
                    this.killPeerConnections();
                    ++this._shieldedConnections;
                }
                if (!c.isLimeWire()) {
                    ++this._nonLimeWirePeers;
                }
                if (this.checkLocale(c.getLocalePref())) {
                    ++this._localeMatchingPeers;
                }
            } else {
                ArrayList<ManagedConnection> newConnections = new ArrayList<ManagedConnection>(this._initializedClientConnections);
                newConnections.add(c);
                this._initializedClientConnections = Collections.unmodifiableList(newConnections);
                if (!c.isLimeWire()) {
                    ++this._nonLimeWireLeaves;
                }
            }
            c.postInit();
            this.sendInitialPingRequest(c);
            return true;
        }
        return false;
    }

    private boolean allowInitializedConnection(ManagedConnection c) {
        if (!(!this.isShieldedLeaf() && this.isSupernode() || c.isClientSupernodeConnection())) {
            return false;
        }
        List connections = this.getConnections();
        int listenPort = c.getListeningPort();
        String addr = c.getAddress();
        for (int i = 0; i < connections.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)connections.get(i);
            if (mc == c || ConnectionSettings.ALLOW_DUPLICATE.getValue() || !addr.equals(mc.getAddress())) continue;
            int mcLP = mc.getListeningPort();
            if (listenPort != -1 && listenPort != 0 && mcLP != -1 && mcLP != 0 && mcLP != listenPort) continue;
            return false;
        }
        return this.allowConnection(c.headers()).isAcceptable();
    }

    private void killPeerConnections() {
        List conns = this._initializedConnections;
        Iterator iter = conns.iterator();
        while (iter.hasNext()) {
            ManagedConnection con = (ManagedConnection)iter.next();
            if (!con.isSupernodeSupernodeConnection()) continue;
            this.removeInternal(con);
        }
    }

    public void sendUpdatedCapabilities() {
        Connection c;
        Iterator iter = this.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            c = (Connection)iter.next();
            c.sendUpdatedCapabilities();
        }
        iter = this.getInitializedClientConnections().iterator();
        while (iter.hasNext()) {
            c = (Connection)iter.next();
            c.sendUpdatedCapabilities();
        }
    }

    public synchronized void disconnect() {
        if (this._disconnectTime == 0L) {
            long averageUptime = this.getCurrentAverageUptime();
            int totalConnections = Math.max(1, ApplicationSettings.TOTAL_CONNECTIONS.getValue() + 1);
            long totalConnectTime = averageUptime * (long)totalConnections;
            ApplicationSettings.TOTAL_CONNECTION_TIME.setValue(totalConnectTime);
            ApplicationSettings.TOTAL_CONNECTIONS.setValue(totalConnections);
            ApplicationSettings.AVERAGE_CONNECTION_TIME.setValue(averageUptime);
        }
        this._disconnectTime = System.currentTimeMillis();
        this._connectTime = Long.MAX_VALUE;
        this._preferredConnections = 0;
        this.adjustConnectionFetchers();
        Iterator iter = this.getConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            this.remove(c);
            if (!c.isSupernodeConnection()) continue;
            this._catcher.add(new Endpoint(c.getInetAddress().getHostAddress(), c.getPort()), true, c.getLocalePref());
        }
    }

    public synchronized long getCurrentAverageUptime() {
        long currentAverage = 0L;
        long now = System.currentTimeMillis();
        long sessionTime = Math.max(0L, now - this._connectTime);
        int totalConnections = ApplicationSettings.TOTAL_CONNECTIONS.getValue();
        if (sessionTime != 0L) {
            ++totalConnections;
        }
        long totalConnectTime = Math.max(0L, ApplicationSettings.TOTAL_CONNECTION_TIME.getValue() + sessionTime);
        currentAverage = totalConnectTime / (long)Math.max(1, totalConnections);
        return currentAverage;
    }

    public synchronized void connect() {
        this._disconnectTime = 0L;
        this._connectTime = System.currentTimeMillis();
        if (this.isConnected() || this._catcher == null) {
            return;
        }
        _connectionAttempts = 0;
        this._lastConnectionCheck = 0L;
        this._lastSuccessfulConnect = 0L;
        this._catcher.expire();
        this.setPreferredConnections();
        this._catcher.sendUDPPings();
    }

    private void sendInitialPingRequest(ManagedConnection connection) {
        if (connection.supportsPongCaching()) {
            return;
        }
        PingRequest pr = this.getNumInitializedConnections() >= this._preferredConnections ? new PingRequest(1) : new PingRequest(4);
        connection.send(pr);
        try {
            connection.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeInternal(ManagedConnection c) {
        ArrayList newConnections;
        int i;
        if (!c.isSupernodeClientConnection()) {
            i = this._initializedConnections.indexOf(c);
            if (i != -1) {
                newConnections = new ArrayList();
                newConnections.addAll(this._initializedConnections);
                newConnections.remove(c);
                this._initializedConnections = Collections.unmodifiableList(newConnections);
                if (c.isClientSupernodeConnection()) {
                    --this._shieldedConnections;
                }
                if (!c.isLimeWire()) {
                    --this._nonLimeWirePeers;
                }
                if (this.checkLocale(c.getLocalePref())) {
                    --this._localeMatchingPeers;
                }
            }
        } else {
            i = this._initializedClientConnections.indexOf(c);
            if (i != -1) {
                newConnections = new ArrayList();
                newConnections.addAll(this._initializedClientConnections);
                newConnections.remove(c);
                this._initializedClientConnections = Collections.unmodifiableList(newConnections);
                if (!c.isLimeWire()) {
                    --this._nonLimeWireLeaves;
                }
            }
        }
        i = this._connections.indexOf(c);
        if (i != -1) {
            newConnections = new ArrayList(this._connections);
            newConnections.remove(c);
            this._connections = Collections.unmodifiableList(newConnections);
        }
        c.close();
        RouterService.getMessageRouter().removeConnection(c);
        RouterService.getCallback().connectionClosed(c);
        QueryUnicaster.instance().purgeQuery(c);
    }

    private synchronized void stabilizeConnections() {
        while (this.getNumInitializedConnections() > this._preferredConnections) {
            ManagedConnection newest = null;
            Iterator i = this._initializedConnections.iterator();
            while (i.hasNext()) {
                ManagedConnection c = (ManagedConnection)i.next();
                if (!c.isLimeWire()) {
                    newest = c;
                    break;
                }
                if (newest != null && c.getConnectionTime() <= newest.getConnectionTime()) continue;
                newest = c;
            }
            if (newest == null) continue;
            this.remove(newest);
        }
        this.adjustConnectionFetchers();
    }

    private void adjustConnectionFetchers() {
        int i;
        int multiple;
        if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
            this.startDedicatedLocaleFetcher();
        }
        int goodConnections = this.getNumInitializedConnections();
        int neededConnections = this._preferredConnections - goodConnections;
        if (!RouterService.acceptedIncomingConnection() && !this.isActiveSupernode()) {
            multiple = 3;
        } else if (!this.isSupernode() || this.getNumUltrapeerConnections() == 0) {
            multiple = 3;
        } else if (neededConnections > 10) {
            multiple = 2;
        } else {
            multiple = 1;
            neededConnections = (int)((float)neededConnections - (5.0f + ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections));
        }
        int need = Math.min(10, multiple * neededConnections) - this._fetchers.size() - this._initializingFetchedConnections.size();
        ArrayList<ConnectionFetcher> fetchers = Collections.EMPTY_LIST;
        if (need > 0) {
            fetchers = new ArrayList<ConnectionFetcher>(need);
            for (need = Math.min(need, Sockets.getNumAllowedSockets()); need > 0; --need) {
                ConnectionFetcher fetcher = new ConnectionFetcher();
                fetchers.add(fetcher);
            }
            this._fetchers.addAll(fetchers);
        }
        int lastFetcherIndex = this._fetchers.size();
        ArrayList<Object> extras = new ArrayList<Object>();
        while (need < 0 && lastFetcherIndex > 0) {
            ConnectionFetcher fetcher = (ConnectionFetcher)this._fetchers.remove(--lastFetcherIndex);
            ++need;
            extras.add(fetcher);
        }
        int lastInitializingConnectionIndex = this._initializingFetchedConnections.size();
        while (need < 0 && lastInitializingConnectionIndex > 0) {
            ManagedConnection connection = (ManagedConnection)this._initializingFetchedConnections.remove(--lastInitializingConnectionIndex);
            ++need;
            extras.add(connection);
        }
        for (i = fetchers.size() - 1; i >= 0; --i) {
            ConnectionFetcher fetcher = (ConnectionFetcher)fetchers.remove(i);
            fetcher.connect();
        }
        for (i = extras.size() - 1; i >= 0; --i) {
            Object next = extras.remove(i);
            if (next instanceof ConnectionFetcher) {
                ((ConnectionFetcher)next).stopConnecting();
                continue;
            }
            this.removeInternal((ManagedConnection)next);
        }
    }

    private void startDedicatedLocaleFetcher() {
        if (RouterService.isShieldedLeaf() && this._needPref && !this._needPrefInterrupterScheduled && this._dedicatedPrefFetcher == null) {
            this._dedicatedPrefFetcher = new ConnectionFetcher(true);
            this._dedicatedPrefFetcher.connect();
            Runnable interrupted = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ConnectionManager connectionManager = ConnectionManager.this;
                    synchronized (connectionManager) {
                        ConnectionManager.this._needPref = false;
                        if (ConnectionManager.this._dedicatedPrefFetcher == null) {
                            return;
                        }
                        ConnectionManager.this._dedicatedPrefFetcher.stopConnecting();
                        ConnectionManager.this._dedicatedPrefFetcher = null;
                    }
                }
            };
            this._needPrefInterrupterScheduled = true;
            RouterService.schedule(interrupted, 15000L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFetchedConnection(ManagedConnection mc, ConnectionFetcher fetcher) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (fetcher.isPrematurelyStopped()) {
                fetcher.finish();
                return;
            }
            this._initializingFetchedConnections.add(mc);
            if (fetcher == this._dedicatedPrefFetcher) {
                this._dedicatedPrefFetcher = null;
            } else {
                this._fetchers.remove(fetcher);
            }
            this.connectionInitializing(mc);
        }
        RouterService.getCallback().connectionInitializing(mc);
        try {
            mc.initialize(fetcher);
        }
        catch (IOException e) {
            this.cleanupBrokenFetchedConnection(mc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupBrokenFetchedConnection(ManagedConnection mc) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this._initializingFetchedConnections.remove(mc);
            this.removeInternal(mc);
            this.adjustConnectionFetchers();
        }
        this.processConnectionHeaders(mc);
    }

    private void processConnectionHeaders(Connection connection) {
        if (!connection.receivedHeaders()) {
            return;
        }
        Properties headers = connection.headers().props();
        if (headers == null) {
            return;
        }
        this.updateHostCache(connection.headers());
        String remoteAddress = headers.getProperty("Listen-IP");
        if (remoteAddress == null) {
            remoteAddress = headers.getProperty("X-My-Address");
        }
        if (remoteAddress != null && !connection.isOutgoing()) {
            int colonIndex = remoteAddress.indexOf(58);
            if (colonIndex == -1) {
                return;
            }
            if (++colonIndex > remoteAddress.length()) {
                return;
            }
            try {
                int port = Integer.parseInt(remoteAddress.substring(colonIndex).trim());
                if (NetworkUtils.isValidPort(port)) {
                    connection.setListeningPort(port);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public boolean allowLeafDemotion() {
        ++this._leafTries;
        if (UltrapeerSettings.FORCE_ULTRAPEER_MODE.getValue() || this.isActiveSupernode()) {
            return false;
        }
        return !SupernodeAssigner.isTooGoodToPassUp() || this._leafTries >= this._demotionLimit;
    }

    public void tryToBecomeAnUltrapeer(int demotionLimit) {
        if (this.isSupernode()) {
            return;
        }
        this._demotionLimit = demotionLimit;
        this._leafTries = 0;
        this.disconnect();
        this.connect();
    }

    private void updateHostCache(HandshakeResponse headers) {
        if (!headers.hasXTryUltrapeers()) {
            return;
        }
        String hostAddresses = headers.getXTryUltrapeers();
        StringTokenizer st = new StringTokenizer(hostAddresses, ",");
        ArrayList<Endpoint> hosts = new ArrayList<Endpoint>(st.countTokens());
        while (st.hasMoreTokens()) {
            String address = st.nextToken().trim();
            try {
                Endpoint e = new Endpoint(address);
                hosts.add(e);
            }
            catch (IllegalArgumentException iae) {}
        }
        this._catcher.add(hosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExternallyGeneratedConnection(ManagedConnection c, GnetConnectObserver observer) throws IOException {
        if (c.isOutgoing()) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializing(c);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(c);
        }
        try {
            c.initialize(observer);
        }
        catch (IOException e) {
            this.cleanupBrokenExternallyGeneratedConnection(c);
            throw e;
        }
        if (observer == null) {
            this.completeInitializeExternallyGeneratedConnection(c);
        }
    }

    private void cleanupBrokenExternallyGeneratedConnection(ManagedConnection c) {
        this.remove(c);
        this.processConnectionHeaders(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeInitializeExternallyGeneratedConnection(ManagedConnection c) throws IOException {
        this.processConnectionHeaders(c);
        if (!c.isOutgoing() && !this.allowConnection(c).isAcceptable()) {
            throw new IOException("No space for connection");
        }
        if (!c.isOutgoing()) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializingIncoming(c);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(c);
        }
        return this.completeConnectionInitialization(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeConnectionInitialization(ManagedConnection mc, boolean fetched) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            boolean connectionOpen;
            if (fetched) {
                this._initializingFetchedConnections.remove(mc);
            }
            if (connectionOpen = this.connectionInitialized(mc)) {
                RouterService.getCallback().connectionInitialized(mc);
                this.setPreferredConnections();
            }
            return connectionOpen;
        }
    }

    public int getPreferredConnectionCount() {
        return this._preferredConnections;
    }

    public boolean isConnectionIdle() {
        return this._preferredConnections == ConnectionSettings.IDLE_CONNECTIONS.getValue();
    }

    private void setPreferredConnections() {
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._disconnectTime != 0L) {
            return;
        }
        int oldPreferred = this._preferredConnections;
        this._preferredConnections = this.isSupernode() ? ConnectionSettings.NUM_CONNECTIONS.getValue() : (this.isIdle() ? ConnectionSettings.IDLE_CONNECTIONS.getValue() : 3);
        if (oldPreferred != this._preferredConnections) {
            this.stabilizeConnections();
        }
    }

    private boolean isIdle() {
        return SystemUtils.getIdleTime() >= 1800000L;
    }

    private void startConnection(ManagedConnection conn) throws IOException {
        if (conn.isGUESSUltrapeer()) {
            QueryUnicaster.instance().addUnicastEndpoint(conn.getInetAddress(), conn.getPort());
        }
        conn.loopForMessages();
    }

    public void noInternetConnection() {
        RouterService.getCallback().disconnected();
        if (this._automaticallyConnecting) {
            return;
        }
        this.disconnect();
        RouterService.schedule(new Runnable(){

            public void run() {
                if (ConnectionManager.this._automaticConnectTime < ConnectionManager.this._disconnectTime) {
                    return;
                }
                if (!RouterService.isConnected()) {
                    ConnectionManager.this.connect();
                }
            }
        }, 10000L, 120000L);
        this._automaticConnectTime = System.currentTimeMillis();
        this._automaticallyConnecting = true;
        this.recoverHosts();
    }

    private synchronized void recoverHosts() {
        if (this._catcher != null && this._catcher.getNumHosts() < 100) {
            this._catcher.recoverHosts();
        }
    }

    private boolean checkLocale(String loc) {
        if (loc == null) {
            loc = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        return ApplicationSettings.LANGUAGE.getValue().equals(loc);
    }

    static {
        LOG = LogFactory.getLog(ConnectionManager.class);
    }

    private class ConnectionFetcher
    implements GnetConnectObserver,
    HostCatcher.EndpointObserver {
        private boolean _pref = false;
        private ManagedConnection connection;
        private Endpoint endpoint;
        private volatile boolean stoppedEarly = false;

        public ConnectionFetcher() {
            this(false);
        }

        public ConnectionFetcher(boolean pref) {
            this._pref = pref;
        }

        IpPort getIpPort() {
            if (this.connection != null) {
                return this.connection;
            }
            if (this.endpoint != null) {
                return this.endpoint;
            }
            return null;
        }

        public void connect() {
            ConnectionManager.this._catcher.getAnEndpoint(this);
        }

        public void stopConnecting() {
            this.stoppedEarly = true;
            ConnectionManager.this._catcher.removeEndpointObserver(this);
        }

        public boolean isPrematurelyStopped() {
            return this.stoppedEarly;
        }

        public void finish() {
        }

        public void handleEndpoint(Endpoint endpoint) {
            Assert.that(endpoint != null);
            if (!IPFilter.instance().allow(endpoint.getAddress()) || ConnectionManager.this.isConnectedTo(endpoint.getAddress()) || ConnectionManager.this.isConnectingTo(endpoint)) {
                ConnectionManager.this._catcher.getAnEndpoint(this);
                return;
            }
            this.endpoint = endpoint;
            this.connection = new ManagedConnection(endpoint.getAddress(), endpoint.getPort());
            this.connection.setLocalePreferencing(this._pref);
            this.doConnectionCheck();
            _connectionAttempts++;
            ConnectionManager.this.initializeFetchedConnection(this.connection, this);
        }

        public void handleConnect() {
            boolean stillOpen = ConnectionManager.this.completeConnectionInitialization(this.connection, true);
            ConnectionManager.this.processConnectionHeaders(this.connection);
            ConnectionManager.this._lastSuccessfulConnect = System.currentTimeMillis();
            ConnectionManager.this._catcher.doneWithConnect(this.endpoint, true);
            if (this._pref) {
                ConnectionManager.this._needPref = false;
            }
            try {
                if (stillOpen) {
                    ConnectionManager.this.startConnection(this.connection);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void shutdown() {
            ConnectionManager.this.cleanupBrokenFetchedConnection(this.connection);
            ConnectionManager.this._catcher.doneWithConnect(this.endpoint, false);
            ConnectionManager.this._catcher.expireHost(this.endpoint);
        }

        public void handleBadHandshake() {
            this.shutdown();
        }

        public void handleNoGnutellaOk(int code, String msg) {
            ConnectionManager.this.cleanupBrokenFetchedConnection(this.connection);
            ConnectionManager.this._lastSuccessfulConnect = System.currentTimeMillis();
            if (code == 577) {
                ConnectionManager.this._catcher.add(this.endpoint, true, this.connection.getLocalePref());
            } else {
                ConnectionManager.this._catcher.doneWithConnect(this.endpoint, true);
                ConnectionManager.this._catcher.putHostOnProbation(this.endpoint);
            }
        }

        private void doConnectionCheck() {
            long curTime = System.currentTimeMillis();
            if (!ConnectionManager.this.isConnected() && _connectionAttempts > 40 && curTime - ConnectionManager.this._lastSuccessfulConnect > 4000L && curTime - ConnectionManager.this._lastConnectionCheck > 3600000L) {
                _connectionAttempts = 0;
                ConnectionManager.this._lastConnectionCheck = curTime;
                LOG.debug("checking for live connection");
                ConnectionChecker.checkForLiveConnection();
            }
        }
    }

    private class IncomingGNetObserver
    implements GnetConnectObserver {
        private ManagedConnection connection;

        IncomingGNetObserver(ManagedConnection connection) {
            this.connection = connection;
        }

        public void handleConnect() {
            try {
                if (ConnectionManager.this.completeInitializeExternallyGeneratedConnection(this.connection)) {
                    // empty if block
                }
                ConnectionManager.this.startConnection(this.connection);
            }
            catch (IOException ignored) {
                LOG.warn("Failed to complete initialization", ignored);
            }
        }

        public void handleBadHandshake() {
            this.shutdown();
        }

        public void handleNoGnutellaOk(int code, String msg) {
            this.shutdown();
        }

        public void shutdown() {
            ConnectionManager.this.cleanupBrokenExternallyGeneratedConnection(this.connection);
        }
    }

    private class OutgoingConnector
    implements Runnable {
        private final ManagedConnection _connection;
        private final boolean _doInitialization;

        public OutgoingConnector(ManagedConnection connection, boolean initialize) {
            this._connection = connection;
            this._doInitialization = initialize;
        }

        public void run() {
            try {
                if (this._doInitialization) {
                    ConnectionManager.this.initializeExternallyGeneratedConnection(this._connection, null);
                }
                ConnectionManager.this.startConnection(this._connection);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

