/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionWatchdog {
    private static final Log LOG = LogFactory.getLog(ConnectionWatchdog.class);
    private static final ConnectionWatchdog INSTANCE = new ConnectionWatchdog();
    private static final int EVALUATE_TIME = 30000;
    private static final int REEVALUATE_TIME = 15000;

    public static ConnectionWatchdog instance() {
        return INSTANCE;
    }

    private ConnectionWatchdog() {
    }

    public void start() {
        this.findDuds();
    }

    private void findDuds() {
        HashMap<ManagedConnection, ConnectionState> snapshot = new HashMap<ManagedConnection, ConnectionState>();
        Iterator iter = this.allConnections();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            if (!c.isKillable()) continue;
            snapshot.put(c, new ConnectionState(c));
        }
        RouterService.schedule(new DudChecker(snapshot, false), 30000L, 0L);
    }

    private void killIfStillDud(List connections) {
        HashMap<ManagedConnection, ConnectionState> snapshot = new HashMap<ManagedConnection, ConnectionState>();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            if (!c.isKillable()) continue;
            snapshot.put(c, new ConnectionState(c));
            RouterService.getMessageRouter().sendPingRequest(new PingRequest(1), c);
        }
        RouterService.schedule(new DudChecker(snapshot, true), 15000L, 0L);
    }

    private Iterator allConnections() {
        List normal = RouterService.getConnectionManager().getInitializedConnections();
        List leaves = RouterService.getConnectionManager().getInitializedClientConnections();
        ArrayList buf = new ArrayList(normal.size() + leaves.size());
        buf.addAll(normal);
        buf.addAll(leaves);
        return buf.iterator();
    }

    private class DudChecker
    implements Runnable {
        private Map snapshots;
        private boolean kill;

        DudChecker(Map snapshots, boolean kill) {
            this.snapshots = snapshots;
            this.kill = kill;
        }

        public void run() {
            List potentials = this.kill ? Collections.EMPTY_LIST : new ArrayList();
            Iterator iter = ConnectionWatchdog.this.allConnections();
            while (iter.hasNext()) {
                ConnectionState oldState;
                ConnectionState currentState;
                Object state;
                ManagedConnection c = (ManagedConnection)iter.next();
                if (!c.isKillable() || (state = this.snapshots.get(c)) == null || !(currentState = new ConnectionState(c)).notProgressedSince(oldState = (ConnectionState)state)) continue;
                if (this.kill) {
                    if (!ConnectionSettings.WATCHDOG_ACTIVE.getValue()) continue;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Killing connection: " + c);
                    }
                    RouterService.removeConnection(c);
                    continue;
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Potential dud: " + c);
                }
                potentials.add(c);
            }
            if (potentials.isEmpty()) {
                ConnectionWatchdog.this.findDuds();
            } else {
                ConnectionWatchdog.this.killIfStillDud(potentials);
            }
        }
    }

    private static class ConnectionState {
        final long sentDropped;
        final long sent;
        final long received;

        ConnectionState(ManagedConnection c) {
            this.sentDropped = c.getNumSentMessagesDropped();
            this.sent = c.getNumMessagesSent();
            this.received = c.getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState old) {
            long numSent = this.sent - old.sent;
            long numSentDropped = this.sentDropped - old.sentDropped;
            long numReceived = this.received - old.received;
            if (numSent == numSentDropped && numSent != 0L) {
                return true;
            }
            return numReceived == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

