/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorCallback;

public final class ErrorService {
    private static ErrorCallback _errorCallback = new ShellErrorCallback();

    private ErrorService() {
    }

    public static void setErrorCallback(ErrorCallback callback) {
        _errorCallback = callback;
    }

    public static ErrorCallback getErrorCallback() {
        return _errorCallback;
    }

    public static void error(Throwable problem) {
        _errorCallback.error(problem);
    }

    public static void error(Throwable problem, String detail) {
        _errorCallback.error(problem, detail);
    }

    private static class ShellErrorCallback
    implements ErrorCallback {
        private ShellErrorCallback() {
        }

        public void error(Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t.getMessage());
        }

        public void error(Throwable t, String msg) {
            t.printStackTrace();
            System.out.println(msg);
            throw new RuntimeException(t.getMessage());
        }
    }
}

