/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.CoWList;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FileDesc
implements FileDetails {
    private final int _index;
    private final String _path;
    private final String _name;
    private final long _size;
    private long _modTime;
    private final Set URNS;
    private final File FILE;
    private final URN SHA1_URN;
    private License _license;
    private final List _limeXMLDocs = new CoWList(CoWList.ARRAY_LIST);
    private int _hits;
    private int _attemptedUploads;
    private int _completedUploads;

    public FileDesc(File file, Set urns, int index) {
        if (file == null) {
            throw new NullPointerException("cannot create a FileDesc with a null File");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index (" + index + ") not permitted in FileDesc");
        }
        if (urns == null) {
            throw new NullPointerException("cannot create a FileDesc with a null URN Set");
        }
        this.FILE = file;
        this._index = index;
        this._name = I18NConvert.instance().compose(this.FILE.getName());
        this._path = this.FILE.getAbsolutePath();
        this._size = this.FILE.length();
        this._modTime = this.FILE.lastModified();
        this.URNS = Collections.unmodifiableSet(urns);
        this.SHA1_URN = this.extractSHA1();
        if (this.SHA1_URN == null) {
            throw new IllegalArgumentException("no SHA1 URN");
        }
        this._hits = 0;
    }

    public boolean hasUrns() {
        return !this.URNS.isEmpty();
    }

    public int getIndex() {
        return this._index;
    }

    public long getFileSize() {
        return this._size;
    }

    public String getFileName() {
        return this._name;
    }

    public long lastModified() {
        return this._modTime;
    }

    private URN extractSHA1() {
        Iterator iter = this.URNS.iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            if (!urn.isSHA1()) continue;
            return urn;
        }
        return null;
    }

    public File getFile() {
        return this.FILE;
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public Set getUrns() {
        return this.URNS;
    }

    public String getPath() {
        return this.FILE.getAbsolutePath();
    }

    public void addLimeXMLDocument(LimeXMLDocument doc) {
        this._limeXMLDocs.add(doc);
        doc.setIdentifier(this.FILE);
        if (doc.isLicenseAvailable()) {
            this._license = doc.getLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceLimeXMLDocument(LimeXMLDocument oldDoc, LimeXMLDocument newDoc) {
        List list = this._limeXMLDocs;
        synchronized (list) {
            int index = this._limeXMLDocs.indexOf(oldDoc);
            if (index == -1) {
                return false;
            }
            this._limeXMLDocs.set(index, newDoc);
        }
        newDoc.setIdentifier(this.FILE);
        if (newDoc.isLicenseAvailable()) {
            this._license = newDoc.getLicense();
        } else if (this._license != null && oldDoc.isLicenseAvailable()) {
            this._license = null;
        }
        return true;
    }

    public boolean removeLimeXMLDocument(LimeXMLDocument toRemove) {
        if (!this._limeXMLDocs.remove(toRemove)) {
            return false;
        }
        if (this._license != null && toRemove.isLicenseAvailable()) {
            this._license = null;
        }
        return true;
    }

    public List getLimeXMLDocuments() {
        return this._limeXMLDocs;
    }

    public LimeXMLDocument getXMLDocument() {
        List docs = this.getLimeXMLDocuments();
        return docs.isEmpty() ? null : (LimeXMLDocument)docs.get(0);
    }

    public LimeXMLDocument getXMLDocument(String schemaURI) {
        Iterator it = this.getLimeXMLDocuments().iterator();
        while (it.hasNext()) {
            LimeXMLDocument doc = (LimeXMLDocument)it.next();
            if (!doc.getSchemaURI().equalsIgnoreCase(schemaURI)) continue;
            return doc;
        }
        return null;
    }

    public boolean isLicensed() {
        return this._license != null;
    }

    public License getLicense() {
        return this._license;
    }

    public boolean containsUrn(URN urn) {
        return this.URNS.contains(urn);
    }

    public HashTree getHashTree() {
        return TigerTreeCache.instance().getHashTree(this);
    }

    public int incrementHitCount() {
        return ++this._hits;
    }

    public int getHitCount() {
        return this._hits;
    }

    public int incrementAttemptedUploads() {
        return ++this._attemptedUploads;
    }

    public int getAttemptedUploads() {
        return this._attemptedUploads;
    }

    public int incrementCompletedUploads() {
        return ++this._completedUploads;
    }

    public int getCompletedUploads() {
        return this._completedUploads;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.FILE));
    }

    public String toString() {
        return "FileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this._index + "\r\n" + "path:     " + this._path + "\r\n" + "size:     " + this._size + "\r\n" + "modTime:  " + this._modTime + "\r\n" + "File:     " + this.FILE + "\r\n" + "urns:     " + this.URNS + "\r\n" + "docs:     " + this._limeXMLDocs;
    }

    public InetSocketAddress getSocketAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByAddress(RouterService.getAcceptor().getAddress(true)), RouterService.getAcceptor().getPort(true));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public boolean isFirewalled() {
        return !RouterService.acceptedIncomingConnection();
    }

    public boolean isVerified() {
        return RouterService.getContentManager().isVerified(this.SHA1_URN);
    }
}

