/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.RouterService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class GuidMapFactory {
    private static long EXPIRE_POLL_TIME = 120000L;
    private static List toExpire = new LinkedList();
    private static boolean scheduled = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$GuidMapFactory;

    private GuidMapFactory() {
    }

    public static GuidMap getMap() {
        return new GuidMapImpl();
    }

    public static synchronized void removeMap(GuidMap expiree) {
        toExpire.remove(expiree);
    }

    private static synchronized void addMapToExpire(GuidMapImpl expiree) {
        if (!scheduled) {
            RouterService.schedule(new GuidExpirer(), 0L, EXPIRE_POLL_TIME);
            scheduled = true;
        }
        toExpire.add(expiree);
    }

    private static class GuidMapImpl
    implements GuidMap {
        private static long TIMED_GUID_LIFETIME = 600000L;
        private Map map;

        private GuidMapImpl() {
        }

        public String toString() {
            return "impl, map: " + this.map;
        }

        Map getMap() {
            return this.map;
        }

        public void addMapping(byte[] origGUID, byte[] newGUID) {
            this.addMapping(origGUID, newGUID, TIMED_GUID_LIFETIME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMapping(byte[] origGUID, byte[] newGUID, long lifetime) {
            boolean created = false;
            GuidMapImpl guidMapImpl = this;
            synchronized (guidMapImpl) {
                if (this.map == null) {
                    this.map = new HashMap();
                    created = true;
                }
                GUID.TimedGUID tGuid = new GUID.TimedGUID(new GUID(newGUID), lifetime);
                this.map.put(tGuid, new GUID(origGUID));
            }
            if (created) {
                GuidMapFactory.addMapToExpire(this);
            }
        }

        public synchronized byte[] getOriginalGUID(byte[] newGUID) {
            GUID.TimedGUID wrapper;
            GUID orig;
            if (this.map != null && (orig = (GUID)this.map.get(wrapper = new GUID.TimedGUID(new GUID(newGUID), 0L))) != null) {
                return orig.bytes();
            }
            return null;
        }

        public synchronized GUID getNewGUID(GUID origGUID) {
            if (this.map != null) {
                Iterator i = this.map.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry next = i.next();
                    GUID val = (GUID)next.getValue();
                    if (!val.equals(origGUID)) continue;
                    GUID.TimedGUID key = (GUID.TimedGUID)next.getKey();
                    return key.getGUID();
                }
            }
            return null;
        }
    }

    private static class GuidExpirer
    implements Runnable {
        private GuidExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz = class$com$limegroup$gnutella$GuidMapFactory == null ? (class$com$limegroup$gnutella$GuidMapFactory = GuidMapFactory.class$("com.limegroup.gnutella.GuidMapFactory")) : class$com$limegroup$gnutella$GuidMapFactory;
            synchronized (clazz) {
                Iterator i = toExpire.iterator();
                while (i.hasNext()) {
                    GuidMapImpl next;
                    GuidMapImpl guidMapImpl = next = (GuidMapImpl)i.next();
                    synchronized (guidMapImpl) {
                        Map currMap = next.getMap();
                        Iterator j = currMap.keySet().iterator();
                        while (j.hasNext()) {
                            GUID.TimedGUID g = (GUID.TimedGUID)j.next();
                            if (!g.shouldExpire()) continue;
                            j.remove();
                        }
                    }
                }
            }
        }
    }
}

