/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UniqueHostPinger;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.bootstrap.UDPHostCache;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.BucketQueue;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FixedsizePriorityQueue;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCatcher {
    private static final Log LOG = LogFactory.getLog(HostCatcher.class);
    static final int CACHE_SIZE = 20;
    static final int GOOD_SIZE = 1000;
    static final int NORMAL_SIZE = 400;
    static final int PERMANENT_SIZE = 400;
    public static final int CACHE_PRIORITY = 2;
    public static final int GOOD_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 0;
    private final BucketQueue ENDPOINT_QUEUE = new BucketQueue(new int[]{400, 1000, 20});
    private final Set ENDPOINT_SET = new HashSet();
    private final Set FREE_ULTRAPEER_SLOTS_SET = new HashSet();
    private final Set FREE_LEAF_SLOTS_SET = new HashSet();
    private final Map LOCALE_SET_MAP = new HashMap();
    private static final int LOCALE_SET_SIZE = 100;
    private FixedsizePriorityQueue permanentHosts = new FixedsizePriorityQueue(ExtendedEndpoint.priorityComparator(), 400);
    private Set permanentHostsSet = new HashSet();
    private BootstrapServerManager gWebCache = BootstrapServerManager.instance();
    private UniqueHostPinger pinger;
    private UDPHostCache udpHostCache;
    private int _failures;
    private final Set EXPIRED_HOSTS = new HashSet();
    private final Set PROBATION_HOSTS = new HashSet();
    private static long PROBATION_RECOVERY_WAIT_TIME = 60000L;
    private static long PROBATION_RECOVERY_TIME = 60000L;
    public static final int PROBATION_HOSTS_SIZE = 500;
    public static final int EXPIRED_HOSTS_SIZE = 500;
    public final Bootstrapper FETCHER = new Bootstrapper();
    private List _catchersWaiting = new LinkedList();
    private long lastAllowedPongRankTime = 0L;
    private final long PONG_RANKING_EXPIRE_TIME = 20000L;
    private static final int MAX_CONNECTIONS = 5;
    private boolean dirty = false;
    static boolean DEBUG = false;

    public HostCatcher() {
        this.pinger = new UniqueHostPinger();
        this.udpHostCache = new UDPHostCache(this.pinger);
    }

    public void initialize() {
        LOG.trace("START scheduling");
        this.scheduleServices();
    }

    protected void scheduleServices() {
        Runnable updater = new Runnable(){

            public void run() {
                if (RouterService.acceptedIncomingConnection() && RouterService.isSupernode()) {
                    byte[] addr = RouterService.getAddress();
                    int port = RouterService.getPort();
                    if (NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port) && !NetworkUtils.isPrivateAddress(addr)) {
                        Endpoint e = new Endpoint(addr, port);
                        HostCatcher.this.gWebCache.sendUpdatesAsync(e);
                    }
                }
            }
        };
        RouterService.schedule(updater, BootstrapServerManager.UPDATE_DELAY_MSEC, BootstrapServerManager.UPDATE_DELAY_MSEC);
        Runnable probationRestorer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList toAdd;
                LOG.trace("restoring hosts on probation");
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    toAdd = new ArrayList(HostCatcher.this.PROBATION_HOSTS);
                    HostCatcher.this.PROBATION_HOSTS.clear();
                }
                Iterator i = toAdd.iterator();
                while (i.hasNext()) {
                    HostCatcher.this.add((Endpoint)i.next(), false);
                }
            }
        };
        RouterService.schedule(probationRestorer, PROBATION_RECOVERY_WAIT_TIME, PROBATION_RECOVERY_TIME);
        RouterService.schedule(this.FETCHER, 0L, 2000L);
        LOG.trace("STOP scheduling");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUDPPings() {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.rank(new HashSet(this.ENDPOINT_SET));
        }
    }

    private void rank(Collection hosts) {
        if (this.needsPongRanking()) {
            this.pinger.rank(hosts, new Cancellable(){

                public boolean isCancelled() {
                    return !HostCatcher.this.needsPongRanking();
                }
            });
        }
    }

    private boolean needsPongRanking() {
        if (RouterService.isFullyConnected()) {
            return false;
        }
        int have = RouterService.getConnectionManager().getInitializedConnections().size();
        if (have >= 5) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now > this.lastAllowedPongRankTime) {
            return false;
        }
        int size = RouterService.isSupernode() ? this.FREE_ULTRAPEER_SLOTS_SET.size() : this.FREE_LEAF_SLOTS_SET.size();
        int preferred = RouterService.getConnectionManager().getPreferredConnectionCount();
        return size < preferred - have;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(File hostFile) throws FileNotFoundException, IOException {
        LOG.trace("entered HostCatcher.read(File)");
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(hostFile));
            while (true) {
                String line = in.readLine();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("read line: " + line);
                }
                if (line == null) break;
                try {
                    this.gWebCache.addBootstrapServer(new BootstrapServer(line));
                }
                catch (ParseException ignore) {
                    try {
                        this.add(ExtendedEndpoint.read(line), 0);
                    }
                    catch (ParseException pe) {}
                }
            }
            Object var6_7 = null;
            this.gWebCache.bootstrapServersAdded();
            this.udpHostCache.hostCachesAdded();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.gWebCache.bootstrapServersAdded();
            this.udpHostCache.hostCachesAdded();
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {}
        LOG.trace("left HostCatcher.read(File)");
    }

    synchronized void write() throws IOException {
        this.write(this.getHostsFile());
    }

    synchronized void write(File hostFile) throws IOException {
        this.repOk();
        if (this.dirty || this.gWebCache.isDirty() || this.udpHostCache.isWriteDirty()) {
            FileWriter out = new FileWriter(hostFile);
            this.gWebCache.write(out);
            this.udpHostCache.write(out);
            Iterator iter = this.permanentHosts.iterator();
            while (iter.hasNext()) {
                ExtendedEndpoint e = (ExtendedEndpoint)iter.next();
                e.write(out);
            }
            out.close();
        }
    }

    public boolean add(PingReply pr) {
        ExtendedEndpoint ep;
        IpPort ipp;
        ExtendedEndpoint endpoint = pr.getDailyUptime() != -1 ? new ExtendedEndpoint(pr.getAddress(), pr.getPort(), pr.getDailyUptime()) : new ExtendedEndpoint(pr.getAddress(), pr.getPort());
        if (!pr.getClientLocale().equals("")) {
            endpoint.setClientLocale(pr.getClientLocale());
        }
        if (pr.isUDPHostCache()) {
            endpoint.setHostname(pr.getUDPCacheAddress());
            endpoint.setUDPHostCache(true);
        }
        if (!this.isValidHost(endpoint)) {
            return false;
        }
        if (pr.supportsUnicast()) {
            QueryUnicaster.instance().addUnicastEndpoint(pr.getInetAddress(), pr.getPort());
        }
        this.rank(pr.getPackedIPPorts());
        Iterator i = pr.getPackedIPPorts().iterator();
        while (i.hasNext()) {
            ipp = (IpPort)i.next();
            ep = new ExtendedEndpoint(ipp.getAddress(), ipp.getPort());
            if (!this.isValidHost(ep)) continue;
            this.add(ep, 1);
        }
        i = pr.getPackedUDPHostCaches().iterator();
        while (i.hasNext()) {
            ipp = (IpPort)i.next();
            ep = new ExtendedEndpoint(ipp.getAddress(), ipp.getPort());
            ep.setUDPHostCache(true);
            this.addUDPHostCache(ep);
        }
        if (endpoint.isUDPHostCache()) {
            return this.addUDPHostCache(endpoint);
        }
        if (pr.isUltrapeer()) {
            if (pr.hasFreeLeafSlots()) {
                this.addToFixedSizeSet(endpoint, this.FREE_LEAF_SLOTS_SET);
                if (!pr.hasFreeUltrapeerSlots()) {
                    return true;
                }
            }
            if (pr.hasFreeUltrapeerSlots() || ApplicationSettings.LANGUAGE.getValue().equals(pr.getClientLocale()) && pr.getNumFreeLocaleSlots() > 0) {
                this.addToFixedSizeSet(endpoint, this.FREE_ULTRAPEER_SLOTS_SET);
                return true;
            }
            return this.add(endpoint, 1);
        }
        return this.add(endpoint, 0);
    }

    private boolean addUDPHostCache(ExtendedEndpoint host) {
        return this.udpHostCache.add(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFixedSizeSet(ExtendedEndpoint host, Set hosts) {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (hosts.add(host) && hosts.size() > 200) {
                hosts.remove(hosts.iterator().next());
            }
            this.addPermanent(host);
        }
        this.endpointAdded();
    }

    private synchronized void addToLocaleMap(ExtendedEndpoint endpoint) {
        String loc = endpoint.getClientLocale();
        if (this.LOCALE_SET_MAP.containsKey(loc)) {
            Set s = (Set)this.LOCALE_SET_MAP.get(loc);
            if (s.add(endpoint) && s.size() > 100) {
                s.remove(s.iterator().next());
            }
        } else {
            HashSet<ExtendedEndpoint> s = new HashSet<ExtendedEndpoint>();
            s.add(endpoint);
            this.LOCALE_SET_MAP.put(loc, s);
        }
    }

    public void add(Collection endpoints) {
        this.rank(endpoints);
        Iterator i = endpoints.iterator();
        while (i.hasNext()) {
            this.add((Endpoint)i.next(), true);
        }
    }

    public boolean add(Endpoint e, boolean forceHighPriority) {
        if (!this.isValidHost(e)) {
            return false;
        }
        if (forceHighPriority) {
            return this.add(e, 1);
        }
        return this.add(e, 0);
    }

    public boolean add(Endpoint e, boolean forceHighPriority, String locale) {
        if (!this.isValidHost(e)) {
            return false;
        }
        if (forceHighPriority) {
            return this.add(new ExtendedEndpoint(e.getAddress(), e.getPort(), locale), 1);
        }
        return this.add(new ExtendedEndpoint(e.getAddress(), e.getPort(), locale), 0);
    }

    public boolean add(Endpoint host, int priority) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("adding host " + host);
        }
        if (host instanceof ExtendedEndpoint) {
            return this.add((ExtendedEndpoint)host, priority);
        }
        return this.add(new ExtendedEndpoint(host.getAddress(), host.getPort()), priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(ExtendedEndpoint e, int priority) {
        this.repOk();
        if (e.isUDPHostCache()) {
            return this.addUDPHostCache(e);
        }
        boolean ret = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.addPermanent(e);
            if (!this.ENDPOINT_SET.contains(e)) {
                ret = true;
                this.ENDPOINT_SET.add(e);
                Object ejected = this.ENDPOINT_QUEUE.insert(e, priority);
                if (ejected != null) {
                    this.ENDPOINT_SET.remove(ejected);
                }
            }
        }
        this.endpointAdded();
        this.repOk();
        return ret;
    }

    private synchronized boolean addPermanent(ExtendedEndpoint e) {
        if (NetworkUtils.isPrivateAddress(e.getInetAddress())) {
            return false;
        }
        if (this.permanentHostsSet.contains(e)) {
            return false;
        }
        this.addToLocaleMap(e);
        Object removed = this.permanentHosts.insert(e);
        if (removed != e) {
            this.permanentHostsSet.add(e);
            if (removed != null) {
                this.permanentHostsSet.remove(removed);
            }
            this.dirty = true;
            return true;
        }
        return false;
    }

    private synchronized boolean removePermanent(ExtendedEndpoint e) {
        boolean removed2;
        boolean removed1 = this.permanentHosts.remove(e);
        Assert.that(removed1 == (removed2 = this.permanentHostsSet.remove(e)), "Queue " + removed1 + " but set " + removed2);
        if (removed1) {
            this.dirty = true;
        }
        return removed1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidHost(Endpoint host) {
        byte[] addr;
        if (host.isUDPHostCache()) {
            return true;
        }
        try {
            addr = host.getHostBytes();
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        if (NetworkUtils.isPrivateAddress(addr)) {
            return false;
        }
        if (NetworkUtils.isMe(addr, host.getPort())) {
            return false;
        }
        if (RouterService.getAcceptor().isBannedIP(addr)) {
            return false;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this.EXPIRED_HOSTS.contains(host)) {
                return false;
            }
            if (this.PROBATION_HOSTS.contains(host)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endpointAdded() {
        EndpointObserver observer;
        ExtendedEndpoint p;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this._catchersWaiting.isEmpty()) {
                return;
            }
            p = this.getAnEndpointInternal();
            if (p == null) {
                return;
            }
            observer = (EndpointObserver)this._catchersWaiting.remove(0);
        }
        observer.handleEndpoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAnEndpoint(EndpointObserver observer) {
        ExtendedEndpoint p;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            p = this.getAnEndpointInternal();
            if (p == null) {
                this._catchersWaiting.add(observer);
            }
        }
        if (p != null) {
            observer.handleEndpoint(p);
        }
    }

    public synchronized void removeEndpointObserver(EndpointObserver observer) {
        this._catchersWaiting.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getAnEndpoint() throws InterruptedException {
        BlockingObserver observer = new BlockingObserver();
        this.getAnEndpoint(observer);
        try {
            BlockingObserver blockingObserver = observer;
            synchronized (blockingObserver) {
                if (observer.getEndpoint() == null) {
                    observer.wait();
                }
                return observer.getEndpoint();
            }
        }
        catch (InterruptedException ie) {
            HostCatcher hostCatcher = this;
            synchronized (hostCatcher) {
                this._catchersWaiting.remove(observer);
                throw ie;
            }
        }
    }

    public synchronized void doneWithConnect(Endpoint e, boolean success) {
        if (!(e instanceof ExtendedEndpoint)) {
            return;
        }
        ExtendedEndpoint ee = (ExtendedEndpoint)e;
        this.removePermanent(ee);
        if (success) {
            ee.recordConnectionSuccess();
        } else {
            ++this._failures;
            ee.recordConnectionFailure();
        }
        this.addPermanent(ee);
    }

    protected ExtendedEndpoint getAnEndpointInternal() {
        if (RouterService.isSupernode() && !this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (RouterService.isShieldedLeaf() && !this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_LEAF_SLOTS_SET);
        }
        if (!this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (!this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            Iterator iter = this.FREE_LEAF_SLOTS_SET.iterator();
            ExtendedEndpoint ee = (ExtendedEndpoint)iter.next();
            iter.remove();
            return ee;
        }
        if (!this.ENDPOINT_QUEUE.isEmpty()) {
            ExtendedEndpoint e = (ExtendedEndpoint)this.ENDPOINT_QUEUE.extractMax();
            boolean ok = this.ENDPOINT_SET.remove(e);
            Assert.that(ok, "Rep. invariant for HostCatcher broken.");
            return e;
        }
        return null;
    }

    private ExtendedEndpoint preferenceWithLocale(Set base) {
        String loc = ApplicationSettings.LANGUAGE.getValue();
        if (!RouterService.getConnectionManager().isLocaleMatched() && this.LOCALE_SET_MAP.containsKey(loc)) {
            Set locales = (Set)this.LOCALE_SET_MAP.get(loc);
            Iterator i = base.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (!locales.contains(next)) continue;
                i.remove();
                locales.remove(next);
                return (ExtendedEndpoint)next;
            }
        }
        Iterator iter = base.iterator();
        ExtendedEndpoint ee = (ExtendedEndpoint)iter.next();
        iter.remove();
        return ee;
    }

    public synchronized int getNumHosts() {
        return this.ENDPOINT_QUEUE.size() + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    public synchronized int getNumUltrapeerHosts() {
        return this.ENDPOINT_QUEUE.size(1) + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    Iterator getPermanentHosts() {
        return this.permanentHosts.iterator();
    }

    public synchronized Collection getUltrapeersWithFreeUltrapeerSlots(int num) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue(), num);
    }

    public synchronized Collection getUltrapeersWithFreeUltrapeerSlots(String locale, int num) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, locale, num);
    }

    public synchronized Collection getUltrapeersWithFreeLeafSlots(int num) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue(), num);
    }

    public synchronized Collection getUltrapeersWithFreeLeafSlots(String locale, int num) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, locale, num);
    }

    private Collection getPreferencedCollection(Set base, String loc, int num) {
        Iterator i;
        if (loc == null || loc.equals("")) {
            loc = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        HashSet hosts = new HashSet(num);
        Set locales = (Set)this.LOCALE_SET_MAP.get(loc);
        if (locales != null) {
            i = locales.iterator();
            while (i.hasNext() && hosts.size() < num) {
                Object next = i.next();
                if (!base.contains(next)) continue;
                hosts.add(next);
            }
        }
        i = base.iterator();
        while (i.hasNext() && hosts.size() < num) {
            hosts.add(i.next());
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            long now = System.currentTimeMillis();
            long fetched = ConnectionSettings.LAST_GWEBCACHE_FETCH_TIME.getValue();
            if (fetched + 604800000L <= now) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Fetching more bootstrap servers. Last fetch time: " + fetched);
                }
                this.gWebCache.fetchBootstrapServersAsync();
            }
            this.lastAllowedPongRankTime = now + 20000L;
        }
        this.recoverHosts();
        RouterService.schedule(new Runnable(){

            public void run() {
                HostCatcher.this.pinger.resetData();
            }
        }, 20000L, 0L);
    }

    public synchronized void clear() {
        this.FREE_LEAF_SLOTS_SET.clear();
        this.FREE_ULTRAPEER_SLOTS_SET.clear();
        this.ENDPOINT_QUEUE.clear();
        this.ENDPOINT_SET.clear();
    }

    public UDPPinger getPinger() {
        return this.pinger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repOk() {
        if (!DEBUG) {
            return;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            Object e;
            Iterator iter = this.ENDPOINT_SET.iterator();
            block3: while (iter.hasNext()) {
                e = iter.next();
                Iterator iter2 = this.ENDPOINT_QUEUE.iterator();
                while (iter2.hasNext()) {
                    if (!e.equals(iter2.next())) continue;
                    continue block3;
                }
                Assert.that(false, "Couldn't find " + e + " in queue");
            }
            iter = this.ENDPOINT_QUEUE.iterator();
            while (iter.hasNext()) {
                e = iter.next();
                Assert.that(e instanceof ExtendedEndpoint);
                Assert.that(this.ENDPOINT_SET.contains(e));
            }
            iter = this.permanentHosts.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                Assert.that(o instanceof ExtendedEndpoint);
                Assert.that(this.permanentHostsSet.contains(o));
            }
            iter = this.permanentHostsSet.iterator();
            while (iter.hasNext()) {
                e = iter.next();
                Assert.that(e instanceof ExtendedEndpoint);
                Assert.that(this.permanentHosts.contains(e), "Couldn't find " + e + " from " + this.permanentHostsSet + " in " + this.permanentHosts);
            }
        }
    }

    private void readHostsFile() {
        LOG.trace("Reading Hosts File");
        try {
            this.read(this.getHostsFile());
        }
        catch (IOException e) {
            LOG.debug(this.getHostsFile(), e);
        }
    }

    private File getHostsFile() {
        return new File(CommonUtils.getUserSettingsDir(), "gnutella.net");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverHosts() {
        LOG.debug("recovering hosts file");
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.PROBATION_HOSTS.clear();
            this.EXPIRED_HOSTS.clear();
            this._failures = 0;
            this.FETCHER.resetFetchTime();
            this.gWebCache.resetData();
            this.udpHostCache.resetData();
            this.pinger.resetData();
        }
        this.readHostsFile();
    }

    public synchronized void putHostOnProbation(Endpoint host) {
        this.PROBATION_HOSTS.add(host);
        if (this.PROBATION_HOSTS.size() > 500) {
            this.PROBATION_HOSTS.remove(this.PROBATION_HOSTS.iterator().next());
        }
    }

    public synchronized void expireHost(Endpoint host) {
        this.EXPIRED_HOSTS.add(host);
        if (this.EXPIRED_HOSTS.size() > 500) {
            this.EXPIRED_HOSTS.remove(this.EXPIRED_HOSTS.iterator().next());
        }
    }

    private static class BlockingObserver
    implements EndpointObserver {
        private Endpoint endpoint;

        private BlockingObserver() {
        }

        public synchronized void handleEndpoint(Endpoint p) {
            this.endpoint = p;
            this.notify();
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }
    }

    public static interface EndpointObserver {
        public void handleEndpoint(Endpoint var1);
    }

    private class Bootstrapper
    implements Runnable {
        private long nextAllowedMulticastTime = 0L;
        private long nextAllowedFetchTime = 0L;
        private int delay = 20000;
        private static final int POST_UDP_DELAY = 30000;
        private static final int POST_MULTICAST_DELAY = 60000;

        private Bootstrapper() {
        }

        public synchronized void run() {
            if (ConnectionSettings.DO_NOT_BOOTSTRAP.getValue()) {
                return;
            }
            if (HostCatcher.this._catchersWaiting.isEmpty()) {
                return;
            }
            long now = System.currentTimeMillis();
            if (HostCatcher.this.udpHostCache.getSize() == 0 && now < this.nextAllowedFetchTime && now < this.nextAllowedMulticastTime) {
                return;
            }
            if (!this.needsHosts(now)) {
                return;
            }
            this.getHosts(now);
        }

        void resetFetchTime() {
            this.nextAllowedFetchTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean needsHosts(long now) {
            HostCatcher hostCatcher = HostCatcher.this;
            synchronized (hostCatcher) {
                return HostCatcher.this.getNumHosts() == 0 || !RouterService.isConnected() && HostCatcher.this._failures > 100;
            }
        }

        synchronized void getHosts(long now) {
            if (this.multicastFetch(now)) {
                return;
            }
            if (this.udpHostCacheFetch(now)) {
                return;
            }
            if (this.gwebCacheFetch(now)) {
                return;
            }
        }

        private boolean multicastFetch(long now) {
            if (this.nextAllowedMulticastTime < now && !ConnectionSettings.DO_NOT_MULTICAST_BOOTSTRAP.getValue()) {
                LOG.trace("Fetching via multicast");
                PingRequest pr = PingRequest.createMulticastPing();
                MulticastService.instance().send(pr);
                this.nextAllowedMulticastTime = now + 60000L;
                return true;
            }
            return false;
        }

        private boolean udpHostCacheFetch(long now) {
            if (HostCatcher.this.udpHostCache.fetchHosts()) {
                LOG.trace("Fetching via UDP");
                this.nextAllowedFetchTime = now + 30000L;
                return true;
            }
            return false;
        }

        private boolean gwebCacheFetch(long now) {
            if (now < this.nextAllowedFetchTime) {
                return false;
            }
            int ret = HostCatcher.this.gWebCache.fetchEndpointsAsync();
            switch (ret) {
                case 1: {
                    this.delay *= 5;
                    this.nextAllowedFetchTime = now + (long)this.delay;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Fetching hosts.  Next allowed time: " + this.nextAllowedFetchTime);
                    }
                    return true;
                }
                case 2: {
                    LOG.debug("Tried to fetch, but was already fetching.");
                    return true;
                }
                case 0: {
                    LOG.debug("Didn't fetch, gWebCache's turned off.");
                    return false;
                }
                case 3: {
                    LOG.debug("We've received a bunch of endpoints already, didn't fetch.");
                    MessageService.showError("GWEBCACHE_FETCHED_TOO_MANY");
                    return false;
                }
                case 4: {
                    LOG.debug("Already contacted each gWebCache, didn't fetch.");
                    MessageService.showError("GWEBCACHE_NO_CACHES_LEFT");
                    return false;
                }
            }
            throw new IllegalArgumentException("invalid value: " + ret);
        }
    }
}

