/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class PushEndpoint
implements HTTPHeaderValue,
IpPort {
    public static final int HEADER_SIZE = 17;
    public static final int PROXY_SIZE = 6;
    public static final int PLAIN = 0;
    private static final int SIZE_MASK = 7;
    private static final int FWT_VERSION_MASK = 24;
    private static final int FEATURES_MASK = 224;
    private static final Map GUID_PROXY_MAP = Collections.synchronizedMap(new WeakHashMap());
    private final byte[] _clientGUID;
    private GUID _guid;
    private final int _features;
    private final int _fwtVersion;
    private Set _proxies;
    private final IpPort _externalAddr;

    public PushEndpoint(byte[] guid, Set proxies, int features, int version) {
        this(guid, proxies, features, version, null);
    }

    public PushEndpoint(byte[] guid, Set proxies, int features, int version, IpPort addr) {
        this._features = features & 0xE0 | version << 3;
        this._fwtVersion = version;
        this._clientGUID = guid;
        this._guid = new GUID(this._clientGUID);
        this._proxies = proxies != null ? (proxies instanceof IpPortSet ? Collections.unmodifiableSet(proxies) : Collections.unmodifiableSet(new IpPortSet((Collection)proxies))) : Collections.EMPTY_SET;
        this._externalAddr = addr;
    }

    public PushEndpoint(byte[] guid, Set proxies) {
        this(guid, proxies, 0, 0);
    }

    public PushEndpoint(byte[] guid) {
        this(guid, Collections.EMPTY_SET);
    }

    public PushEndpoint(String httpString) throws IOException {
        if (httpString.length() < 32 || httpString.indexOf(";") > 32) {
            throw new IOException("http string does not contain valid guid");
        }
        String guidS = httpString.substring(0, 32);
        httpString = httpString.substring(32);
        try {
            this._clientGUID = GUID.fromHexString(guidS);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
        this._guid = new GUID(this._clientGUID);
        StringTokenizer tok = new StringTokenizer(httpString, ";");
        IpPortSet proxies = new IpPortSet();
        int fwtVersion = 0;
        IpPort addr = null;
        while (tok.hasMoreTokens() && proxies.size() < 4) {
            String current = tok.nextToken().trim();
            if (current.startsWith("fwt")) {
                fwtVersion = (int)HTTPUtils.parseFeatureToken(current);
                continue;
            }
            try {
                proxies.add(PushEndpoint.parseIpPort(current));
            }
            catch (IOException ohWell) {
                if (addr != null) continue;
                try {
                    addr = PushEndpoint.parsePortIp(current);
                }
                catch (IOException notBad) {}
            }
        }
        this._proxies = Collections.unmodifiableSet(proxies);
        this._externalAddr = addr;
        this._fwtVersion = fwtVersion;
        this._features = proxies.size() | this._fwtVersion << 3;
    }

    public byte[] toBytes() {
        Set proxies = this.getProxies();
        int payloadSize = PushEndpoint.getSizeBytes(proxies);
        IpPort addr = this.getValidExternalAddress();
        int FWTVersion = this.supportsFWTVersion();
        if (addr != null && FWTVersion > 0) {
            payloadSize += 6;
        }
        byte[] ret = new byte[payloadSize];
        this.toBytes(ret, 0, proxies, addr, FWTVersion);
        return ret;
    }

    public void toBytes(byte[] where, int offset) {
        this.toBytes(where, offset, this.getProxies(), this.getValidExternalAddress(), this.supportsFWTVersion());
    }

    private void toBytes(byte[] where, int offset, Set proxies, IpPort address, int FWTVersion) {
        int neededSpace = PushEndpoint.getSizeBytes(proxies);
        if (address != null) {
            if (FWTVersion > 0) {
                neededSpace += 6;
            }
        } else {
            FWTVersion = 0;
        }
        if (where.length - offset < neededSpace) {
            throw new IllegalArgumentException("target array too small");
        }
        where[offset] = (byte)(Math.min(4, proxies.size()) | this.getFeatures() | FWTVersion << 3);
        System.arraycopy(this._clientGUID, 0, where, ++offset, 16);
        offset += 16;
        if (address != null && FWTVersion > 0) {
            byte[] addr = address.getInetAddress().getAddress();
            int port = address.getPort();
            System.arraycopy(addr, 0, where, offset, 4);
            ByteOrder.short2leb((short)port, where, offset += 4);
            offset += 2;
        }
        Iterator iter = proxies.iterator();
        for (int i = 0; iter.hasNext() && i < 4; ++i) {
            IpPort ppi = (IpPort)iter.next();
            byte[] addr = ppi.getInetAddress().getAddress();
            short port = (short)ppi.getPort();
            System.arraycopy(addr, 0, where, offset, 4);
            ByteOrder.short2leb(port, where, offset += 4);
            offset += 2;
        }
    }

    protected IpPort getValidExternalAddress() {
        IpPort ret = this.getIpPort();
        if (!NetworkUtils.isValidExternalIpPort(ret)) {
            return null;
        }
        Assert.that(!ret.getAddress().equals("1.1.1.1"), "bogus ip address leaked");
        return ret;
    }

    public static PushEndpoint fromBytes(DataInputStream dais) throws BadPacketException, IOException {
        byte[] guid = new byte[16];
        IpPortSet proxies = new IpPortSet();
        IPPortCombo addr = null;
        int header = dais.read() & 0xFF;
        int number = header & 7;
        int features = header & 0xE0;
        int version = (header & 0x18) >> 3;
        dais.readFully(guid);
        if (version > 0) {
            byte[] host = new byte[6];
            dais.readFully(host);
            addr = IPPortCombo.getCombo(host);
            if (addr.getAddress().equals("1.1.1.1")) {
                addr = null;
                version = 0;
            }
        }
        byte[] tmp = new byte[6];
        for (int i = 0; i < number; ++i) {
            dais.readFully(tmp);
            proxies.add(IPPortCombo.getCombo(tmp));
        }
        PushEndpoint pe = new PushEndpoint(guid, proxies, features, version, addr);
        pe.updateProxies(true);
        return pe;
    }

    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProxies() {
        PushEndpoint pushEndpoint = this;
        synchronized (pushEndpoint) {
            if (this._proxies != null) {
                return this._proxies;
            }
        }
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        if (current == null) {
            return Collections.EMPTY_SET;
        }
        return current.getProxies();
    }

    public static int getSizeBytes(Set proxies) {
        return 17 + Math.min(proxies.size(), 4) * 6;
    }

    public int supportsFWTVersion() {
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        int currentVersion = current == null ? this._fwtVersion : current.getFWTVersion();
        return currentVersion;
    }

    public static void setFWTVersionSupported(byte[] guid, int version) {
        GUID g = new GUID(guid);
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(g);
        if (current != null) {
            current.setFWTVersion(version);
        }
    }

    public int hashCode() {
        return this._guid.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PushEndpoint)) {
            return false;
        }
        PushEndpoint o = (PushEndpoint)other;
        return this._guid.equals(o._guid);
    }

    public String toString() {
        String ret = "PE [FEATURES:" + this.getFeatures() + ", FWT Version:" + this.supportsFWTVersion() + ", GUID:" + this._guid + ", address: " + this.getAddress() + ":" + this.getPort() + ", proxies:{ ";
        Iterator iter = this.getProxies().iterator();
        while (iter.hasNext()) {
            IpPort ppi = (IpPort)iter.next();
            ret = ret + ppi.getInetAddress() + ":" + ppi.getPort() + " ";
        }
        ret = ret + "}]";
        return ret;
    }

    public String httpStringValue() {
        StringBuffer httpString = new StringBuffer(this._guid.toHexString()).append(";");
        int fwtVersion = this.supportsFWTVersion();
        if (fwtVersion != 0) {
            httpString.append("fwt").append("/").append(fwtVersion).append(";");
            IpPort address = this.getValidExternalAddress();
            if (address != null) {
                String addr = this.getAddress();
                int port = this.getPort();
                if (!addr.equals("1.1.1.1") && NetworkUtils.isValidPort(port)) {
                    httpString.append(port).append(":").append(addr).append(";");
                }
            }
        }
        Iterator iter = this.getProxies().iterator();
        for (int proxiesWritten = 0; iter.hasNext() && proxiesWritten < 4; ++proxiesWritten) {
            IpPort cur = (IpPort)iter.next();
            httpString.append(NetworkUtils.ip2string(cur.getInetAddress().getAddress()));
            httpString.append(":").append(cur.getPort()).append(";");
        }
        httpString.deleteCharAt(httpString.length() - 1);
        return httpString.toString();
    }

    public int getFeatures() {
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        int currentFeatures = current == null ? this._features : current.getFeatures();
        return currentFeatures & 0xE0;
    }

    public static void setFeatures(byte[] guid, int features) {
        GUID g = new GUID(guid);
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(g);
        if (current != null) {
            current.setFeatures(features);
        }
    }

    public static void setAddr(byte[] guid, IpPort addr) {
        GUID g = new GUID(guid);
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(g);
        if (current != null) {
            current.setIpPort(addr);
        }
    }

    private IpPort getIpPort() {
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        return current == null || current.getIpPort() == null ? this._externalAddr : current.getIpPort();
    }

    public String getAddress() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getAddress() : "1.1.1.1";
    }

    public InetAddress getInetAddress() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getInetAddress() : null;
    }

    public int getPort() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getPort() : 6346;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateProxies(boolean good) {
        GuidSetWrapper existing;
        GUID guidRef = null;
        Map map = GUID_PROXY_MAP;
        synchronized (map) {
            existing = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
            if (existing != null) {
                guidRef = existing.getGuid();
            }
            if (existing == null || guidRef == null) {
                existing = new GuidSetWrapper(this._guid, this._features, this._fwtVersion);
                if (good) {
                    existing.updateProxies(this._proxies, true);
                } else {
                    existing.updateProxies(Collections.EMPTY_SET, true);
                }
                GUID_PROXY_MAP.put(this._guid, existing);
                this._proxies = null;
                return;
            }
        }
        existing.updateProxies(this._proxies, good);
        this._guid = guidRef;
        this._proxies = null;
    }

    public PushEndpoint createClone() {
        return new PushEndpoint(this._guid.bytes(), this.getProxies(), this.getFeatures(), this.supportsFWTVersion(), this.getIpPort());
    }

    public static void overwriteProxies(byte[] guid, String httpString) throws IOException {
        HashSet<IpPort> newSet = new HashSet<IpPort>();
        StringTokenizer tok = new StringTokenizer(httpString, ",");
        while (tok.hasMoreTokens()) {
            String proxy = tok.nextToken().trim();
            try {
                newSet.add(PushEndpoint.parseIpPort(proxy));
            }
            catch (IOException ohWell) {}
        }
        PushEndpoint.overwriteProxies(guid, newSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overwriteProxies(byte[] guid, Set newSet) {
        GUID g = new GUID(guid);
        Map map = GUID_PROXY_MAP;
        synchronized (map) {
            GuidSetWrapper wrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(g);
            if (wrapper == null) {
                wrapper = new GuidSetWrapper(g);
                GUID_PROXY_MAP.put(g, wrapper);
            }
            wrapper.overwriteProxies(newSet);
        }
    }

    private static IpPort parseIpPort(String http) throws IOException {
        int separator = http.indexOf(":");
        if (separator == -1 || separator != http.lastIndexOf(":") || separator == http.length()) {
            throw new IOException();
        }
        String host = http.substring(0, separator);
        if (!NetworkUtils.isValidAddress(host) || NetworkUtils.isPrivateAddress(host)) {
            throw new IOException();
        }
        String portS = http.substring(separator + 1);
        try {
            int port = Integer.parseInt(portS);
            if (!NetworkUtils.isValidPort(port)) {
                throw new IOException();
            }
            IpPortImpl ppc = new IpPortImpl(host, port);
            return ppc;
        }
        catch (NumberFormatException notBad) {
            throw new IOException(notBad.getMessage());
        }
    }

    private static IpPort parsePortIp(String http) throws IOException {
        int separator = http.indexOf(":");
        if (separator == -1 || separator != http.lastIndexOf(":") || separator == http.length()) {
            throw new IOException();
        }
        String portS = http.substring(0, separator);
        int port = 0;
        try {
            port = Integer.parseInt(portS);
            if (!NetworkUtils.isValidPort(port)) {
                throw new IOException();
            }
        }
        catch (NumberFormatException failed) {
            throw new IOException(failed.getMessage());
        }
        String host = http.substring(separator + 1);
        if (!NetworkUtils.isValidAddress(host) || NetworkUtils.isPrivateAddress(host)) {
            throw new IOException();
        }
        return new IpPortImpl(host, port);
    }

    static {
        RouterService.schedule(new WeakCleaner(), 30000L, 30000L);
    }

    private static final class WeakCleaner
    implements Runnable {
        private WeakCleaner() {
        }

        public void run() {
            GUID_PROXY_MAP.size();
        }
    }

    private static class GuidSetWrapper {
        private final WeakReference _guidRef;
        private Set _proxies;
        private int _features;
        private int _fwtVersion;
        private IpPort _externalAddr;

        GuidSetWrapper(GUID guid) {
            this(guid, 0, 0);
        }

        GuidSetWrapper(GUID guid, int features, int version) {
            this._guidRef = new WeakReference<GUID>(guid);
            this._features = features;
            this._fwtVersion = version;
        }

        synchronized void updateProxies(Set s, boolean add) {
            IpPortSet existing = new IpPortSet();
            if (s == null) {
                s = this._proxies;
            }
            if (this._proxies != null) {
                existing.addAll(this._proxies);
            }
            if (add) {
                existing.addAll(s);
            } else {
                existing.removeAll(s);
            }
            this.overwriteProxies(existing);
        }

        synchronized void overwriteProxies(Set s) {
            this._proxies = Collections.unmodifiableSet(s);
        }

        synchronized Set getProxies() {
            return this._proxies != null ? this._proxies : Collections.EMPTY_SET;
        }

        synchronized int getFeatures() {
            return this._features;
        }

        synchronized int getFWTVersion() {
            return this._fwtVersion;
        }

        synchronized void setFeatures(int features) {
            this._features = features;
        }

        synchronized void setFWTVersion(int version) {
            this._fwtVersion = version;
        }

        synchronized void setIpPort(IpPort addr) {
            this._externalAddr = addr;
        }

        synchronized IpPort getIpPort() {
            return this._externalAddr;
        }

        GUID getGuid() {
            return (GUID)this._guidRef.get();
        }
    }
}

