/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PushManager {
    private static final Log LOG = LogFactory.getLog(PushManager.class);
    private static final int CONNECT_TIMEOUT = 10000;

    public void acceptPushUpload(String host, int port, String guid, boolean forceAllow, boolean isFWTransfer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Accepting Push Upload from ip:" + host + " port:" + port + " FW:" + isFWTransfer);
        }
        if (host == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        FileManager fm = RouterService.getFileManager();
        if (fm.getNumFiles() < 1 && fm.getNumIncompleteFiles() < 1) {
            return;
        }
        PushData data = new PushData(host, port, guid, forceAllow);
        if (isFWTransfer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding push observer FW-FW to host: " + host + ":" + port);
            }
            UDPConnection socket = new UDPConnection();
            socket.connect(new InetSocketAddress(host, port), 20000, new PushObserver(data, true));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding push observer to host: " + host + ":" + port);
            }
            try {
                Sockets.connect(host, port, 10000, new PushObserver(data, false));
            }
            catch (IOException iox) {
                UploadStat.PUSH_FAILED.incrementStat();
            }
        }
    }

    private static class Pusher
    implements Runnable {
        PushData data;
        private Socket socket;
        private boolean fwTransfer;

        Pusher(PushData data, Socket socket, boolean fwt) {
            this.data = data;
            this.socket = socket;
            this.fwTransfer = fwt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                try {
                    OutputStream ostream = this.socket.getOutputStream();
                    String giv = "GIV 0:" + this.data.getGuid() + "/file\n\n";
                    ostream.write(giv.getBytes());
                    ostream.flush();
                    this.socket.setSoTimeout(30000);
                    String word = IOUtils.readWord(this.socket.getInputStream(), 4);
                    if (this.fwTransfer) {
                        UploadStat.FW_FW_SUCCESS.incrementStat();
                    }
                    if (word.equals("GET")) {
                        UploadStat.PUSHED_GET.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.GET, this.socket, this.data.isForceAllow());
                        break block10;
                    }
                    if (word.equals("HEAD")) {
                        UploadStat.PUSHED_HEAD.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.HEAD, this.socket, this.data.isForceAllow());
                        break block10;
                    }
                    UploadStat.PUSHED_UNKNOWN.incrementStat();
                    throw new IOException();
                }
                catch (IOException ioe) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed push connect/transfer to " + this.data.getHost() + ":" + this.data.getPort() + ", fwt: " + this.fwTransfer);
                    }
                    if (this.fwTransfer) {
                        UploadStat.FW_FW_FAILURE.incrementStat();
                    }
                    UploadStat.PUSH_FAILED.incrementStat();
                }
                finally {
                    IOUtils.close(this.socket);
                }
            }
        }
    }

    private static class PushObserver
    implements ConnectObserver {
        private final PushData data;
        private final boolean fwt;

        PushObserver(PushData data, boolean fwt) {
            this.data = data;
            this.fwt = fwt;
        }

        public void handleIOException(IOException iox) {
        }

        public void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Push (fwt: " + this.fwt + ") connect to: " + this.data.getHost() + ":" + this.data.getPort() + " failed");
            }
            if (this.fwt) {
                UploadStat.FW_FW_FAILURE.incrementStat();
            } else {
                UploadStat.PUSH_FAILED.incrementStat();
            }
        }

        public void handleConnect(Socket socket) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Push (fwt: " + this.fwt + ") connect to: " + this.data.getHost() + ":" + this.data.getPort() + " succeeded");
            }
            ThreadFactory.startThread(new Pusher(this.data, socket, this.fwt), "PushUploadThread");
        }
    }

    private static class PushData {
        private final String host;
        private final int port;
        private final String guid;
        private final boolean forceAllow;

        PushData(String host, int port, String guid, boolean forceAllow) {
            this.host = host;
            this.port = port;
            this.guid = guid;
            this.forceAllow = forceAllow;
        }

        public boolean isForceAllow() {
            return this.forceAllow;
        }

        public String getGuid() {
            return this.guid;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

