/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ConnectionDispatcher;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Pinger;
import com.limegroup.gnutella.PushManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.StandardMessageRouter;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.browser.HTTPAcceptor;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.SecureMessageVerifier;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.spam.RatingTable;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.udpconnect.UDPMultiplexor;
import com.limegroup.gnutella.udpconnect.UDPSelectorProvider;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.SimpleTimer;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.xml.MetaFileManager;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RouterService {
    private static final Log LOG = LogFactory.getLog(RouterService.class);
    private static FileManager fileManager = new MetaFileManager();
    private static final SimpleTimer timer = new SimpleTimer(true);
    private static final Acceptor acceptor = new Acceptor();
    private static final ConnectionDispatcher dispatcher = new ConnectionDispatcher();
    private static HTTPAcceptor httpAcceptor;
    private static ConnectionManager manager;
    private static HostCatcher catcher;
    private static DownloadManager downloader;
    private static UploadManager uploadManager;
    private static PushManager pushManager;
    private static PromotionManager promotionManager;
    private static ResponseVerifier VERIFIER;
    private static final Statistics STATISTICS;
    private static final UDPService UDPSERVICE;
    private static final SearchResultHandler RESULT_HANDLER;
    private static AltLocManager altManager;
    private static SecureMessageVerifier secureMessageVerifier;
    private static ContentManager contentManager;
    private static boolean isShuttingDown;
    private static ActivityCallback callback;
    private static MessageRouter router;
    private static UDPMultiplexor UDP_MULTIPLEXOR;
    private static final List SHUTDOWN_ITEMS;
    private static volatile int _state;
    private static long _lastQueryTime;
    private static boolean _fullPower;
    private static final byte[] MYGUID;

    public RouterService(ActivityCallback callback) {
        this(callback, new StandardMessageRouter());
    }

    public RouterService(ActivityCallback ac, MessageRouter mr, FileManager fm) {
        this(ac, mr);
        fileManager = fm;
    }

    public RouterService(ActivityCallback callback, MessageRouter router) {
        RouterService.callback = callback;
        fileManager.registerFileManagerEventListener(callback);
        RouterService.router = router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncGuiInit() {
        Class clazz = RouterService.class;
        synchronized (clazz) {
            if (_state > 0) {
                return;
            }
            _state = 1;
        }
        ThreadFactory.startThread(new Initializer(), "async gui initializer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preGuiInit() {
        Class clazz = RouterService.class;
        synchronized (clazz) {
            if (_state > 0) {
                return;
            }
            _state = 1;
        }
        new Initializer().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class clazz = RouterService.class;
        synchronized (clazz) {
            int outgoing;
            LOG.trace("START RouterService");
            if (RouterService.isStarted()) {
                return;
            }
            RouterService.preGuiInit();
            _state = 2;
            LOG.trace("START SimppManager.instance");
            callback.componentLoading("SIMPP_MANAGER");
            SimppManager.instance();
            LOG.trace("STOP SimppManager.instance");
            LOG.trace("START SimppSettingsManager.instance");
            SimppSettingsManager.instance();
            LOG.trace("STOP SimppSettingsManager.instance");
            LOG.trace("START ContentManager");
            contentManager.initialize();
            LOG.trace("STOP ContentManager");
            LOG.trace("START MessageRouter");
            callback.componentLoading("MESSAGE_ROUTER");
            router.initialize();
            LOG.trace("STOPMessageRouter");
            LOG.trace("START Acceptor");
            callback.componentLoading("ACCEPTOR");
            acceptor.start();
            LOG.trace("STOP Acceptor");
            LOG.trace("START ConnectionManager");
            callback.componentLoading("CONNECTION_MANAGER");
            manager.initialize();
            LOG.trace("STOP ConnectionManager");
            LOG.trace("START DownloadManager");
            downloader.initialize();
            LOG.trace("STOP DownloadManager");
            LOG.trace("START SupernodeAssigner");
            SupernodeAssigner sa = new SupernodeAssigner(uploadManager, downloader, manager);
            sa.start();
            LOG.trace("STOP SupernodeAssigner");
            LOG.trace("START HostCatcher.initialize");
            callback.componentLoading("HOST_CATCHER");
            catcher.initialize();
            LOG.trace("STOP HostCatcher.initialize");
            if (ConnectionSettings.CONNECT_ON_STARTUP.getValue() && (outgoing = ConnectionSettings.NUM_CONNECTIONS.getValue()) > 0) {
                LOG.trace("START connect");
                RouterService.connect();
                LOG.trace("STOP connect");
            }
            LOG.trace("START FileManager");
            callback.componentLoading("FILE_MANAGER");
            fileManager.start();
            LOG.trace("STOP FileManager");
            LOG.trace("START DownloadManager.postGuiInit");
            callback.componentLoading("DOWNLOAD_MANAGER_POST_GUI");
            downloader.postGuiInit();
            LOG.trace("STOP DownloadManager.postGuiInit");
            LOG.trace("START UpdateManager.instance");
            callback.componentLoading("UPDATE_MANAGER");
            UpdateManager.instance();
            UpdateHandler.instance();
            LOG.trace("STOP UpdateManager.instance");
            LOG.trace("START QueryUnicaster");
            callback.componentLoading("QUERY_UNICASTER");
            QueryUnicaster.instance().start();
            LOG.trace("STOP QueryUnicaster");
            LOG.trace("START HTTPAcceptor");
            callback.componentLoading("HTTPACCEPTOR");
            httpAcceptor = new HTTPAcceptor();
            httpAcceptor.start();
            LOG.trace("STOP HTTPAcceptor");
            LOG.trace("START Pinger");
            callback.componentLoading("PINGER");
            Pinger.instance().start();
            LOG.trace("STOP Pinger");
            LOG.trace("START ConnectionWatchdog");
            callback.componentLoading("CONNECTION_WATCHDOG");
            ConnectionWatchdog.instance().start();
            LOG.trace("STOP ConnectionWatchdog");
            LOG.trace("START SavedFileManager");
            callback.componentLoading("SAVED_FILE_MANAGER");
            SavedFileManager.instance();
            LOG.trace("STOP SavedFileManager");
            LOG.trace("START loading spam data");
            RatingTable.instance();
            LOG.trace("START loading spam data");
            LOG.trace("START loading StaticMessages");
            StaticMessages.initialize();
            LOG.trace("END loading StaticMessages");
            if (ApplicationSettings.AUTOMATIC_MANUAL_GC.getValue()) {
                this.startManualGCThread();
            }
            LOG.trace("STOP RouterService.");
        }
    }

    private void startManualGCThread() {
        ManagedThread t = new ManagedThread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOG.trace("Running GC");
                    System.gc();
                    LOG.trace("GC finished, running finalizers");
                    System.runFinalization();
                    LOG.trace("Finalizers finished.");
                }
            }
        }, "ManualGC");
        t.setDaemon(true);
        t.start();
        LOG.trace("Started manual GC thread.");
    }

    public static boolean isStarted() {
        return _state >= 2;
    }

    public static ActivityCallback getCallback() {
        return callback;
    }

    public static void setFullPower(boolean newValue) {
        if (_fullPower != newValue) {
            _fullPower = newValue;
            NormalUploadState.setThrottleSwitching(!newValue);
            HTTPDownloader.setThrottleSwitching(!newValue);
        }
    }

    public static MessageRouter getMessageRouter() {
        return router;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public static DownloadManager getDownloadManager() {
        return downloader;
    }

    public static AltLocManager getAltlocManager() {
        return altManager;
    }

    public static ContentManager getContentManager() {
        return contentManager;
    }

    public static UDPService getUdpService() {
        return UDPSERVICE;
    }

    public static ConnectionManager getConnectionManager() {
        return manager;
    }

    public static UploadManager getUploadManager() {
        return uploadManager;
    }

    public static PushManager getPushManager() {
        return pushManager;
    }

    public static Acceptor getAcceptor() {
        return acceptor;
    }

    public static ConnectionDispatcher getConnectionDispatcher() {
        return dispatcher;
    }

    public static HTTPAcceptor getHTTPAcceptor() {
        return httpAcceptor;
    }

    public static HostCatcher getHostCatcher() {
        return catcher;
    }

    public static SearchResultHandler getSearchResultHandler() {
        return RESULT_HANDLER;
    }

    public static PromotionManager getPromotionManager() {
        return promotionManager;
    }

    public static SecureMessageVerifier getSecureMessageVerifier() {
        return secureMessageVerifier;
    }

    public static UDPMultiplexor getUDPMultiplexor() {
        return UDP_MULTIPLEXOR;
    }

    public static byte[] getMyGUID() {
        return MYGUID;
    }

    public static void schedule(Runnable task, long delay, long period) {
        timer.schedule(task, delay, period);
    }

    public static ManagedConnection connectToHostBlocking(String hostname, int portnum) throws IOException {
        return manager.createConnectionBlocking(hostname, portnum);
    }

    public static void connectToHostAsynchronously(String hostname, int portnum) {
        byte[] cIP = null;
        try {
            InetAddress addr = InetAddress.getByName(hostname);
            cIP = addr.getAddress();
        }
        catch (UnknownHostException e) {
            return;
        }
        if (cIP[0] == 127 && portnum == acceptor.getPort(true) && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        byte[] managerIP = acceptor.getAddress(true);
        if (Arrays.equals(cIP, managerIP) && portnum == acceptor.getPort(true)) {
            return;
        }
        if (!acceptor.isBannedIP(cIP)) {
            manager.createConnectionAsynchronously(hostname, portnum);
        }
    }

    public static boolean isConnectedTo(InetAddress addr) {
        String host = addr.getHostAddress();
        return manager.isConnectedTo(host) || UDP_MULTIPLEXOR.isConnectedTo(addr) || uploadManager.isConnectedTo(addr);
    }

    public static void connect() {
        RouterService.adjustSpamFilters();
        manager.connect();
    }

    public static void disconnect() {
        manager.disconnect();
    }

    public static void removeConnection(ManagedConnection c) {
        manager.remove(c);
    }

    public static void clearHostCatcher() {
        catcher.clear();
    }

    public static int getRealNumHosts() {
        return catcher.getNumHosts();
    }

    public static int getNumDownloads() {
        return downloader.downloadsInProgress();
    }

    public static int getNumActiveDownloads() {
        return downloader.getNumActiveDownloads();
    }

    public static int getNumWaitingDownloads() {
        return downloader.getNumWaitingDownloads();
    }

    public static int getNumIndividualDownloaders() {
        return downloader.getNumIndividualDownloaders();
    }

    public static int getNumUploads() {
        return uploadManager.uploadsInProgress();
    }

    public static int getNumQueuedUploads() {
        return uploadManager.getNumQueuedUploads();
    }

    public static long getCurrentUptime() {
        return STATISTICS.getUptime();
    }

    public static boolean addShutdownItem(Thread t) {
        if (RouterService.isShuttingDown() || RouterService.isShutdown()) {
            return false;
        }
        SHUTDOWN_ITEMS.add(t);
        return true;
    }

    private static void runShutdownItems() {
        Thread t;
        if (!RouterService.isShuttingDown()) {
            return;
        }
        Iterator i = SHUTDOWN_ITEMS.iterator();
        while (i.hasNext()) {
            t = (Thread)i.next();
            t.start();
        }
        i = SHUTDOWN_ITEMS.iterator();
        while (i.hasNext()) {
            t = (Thread)i.next();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static boolean isShuttingDown() {
        return _state >= 3;
    }

    private static boolean isShutdown() {
        return _state >= 4;
    }

    public static synchronized void shutdown() {
        try {
            if (!RouterService.isStarted()) {
                return;
            }
            _state = 3;
            RouterService.getAcceptor().shutdown();
            manager.disconnect();
            Statistics.instance().shutdown();
            ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(RouterService.acceptedIncomingConnection());
            try {
                catcher.write();
            }
            catch (IOException e) {
                // empty catch block
            }
            SettingsHandler.save();
            RatingTable.instance().ageAndSave();
            RouterService.cleanupPreviewFiles();
            downloader.writeSnapshot();
            fileManager.stop();
            TigerTreeCache.instance().persistCache();
            LicenseFactory.persistCache();
            contentManager.shutdown();
            RouterService.runShutdownItems();
            _state = 4;
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    public static void shutdown(String toExecute) {
        RouterService.shutdown();
        if (toExecute != null) {
            try {
                Runtime.getRuntime().exec(toExecute);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void cleanupPreviewFiles() {
        File incompleteDir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        if (incompleteDir == null) {
            return;
        }
        File[] files = incompleteDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (!name.startsWith("Preview-")) continue;
            files[i].delete();
        }
    }

    public static void adjustSpamFilters() {
        IPFilter.refreshIPFilter();
        Iterator iter = manager.getConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            c.setPersonalFilter(SpamFilter.newPersonalFilter());
            c.setRouteFilter(SpamFilter.newRouteFilter());
        }
        UDPReplyHandler.setPersonalFilter(SpamFilter.newPersonalFilter());
    }

    public static void setListeningPort(int port) throws IOException {
        acceptor.setListeningPort(port);
    }

    public static boolean acceptedIncomingConnection() {
        return acceptor.acceptedIncoming();
    }

    public static int getActiveConnectionMessages() {
        int count = 0;
        Iterator iter = manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            count += c.getNumMessagesSent();
            count += c.getNumMessagesReceived();
        }
        return count;
    }

    public static int countConnectionsWithNMessages(int messageThreshold) {
        int count = 0;
        Iterator iter = manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            int msgs = c.getNumMessagesSent();
            if ((msgs += c.getNumMessagesReceived()) <= messageThreshold) continue;
            ++count;
        }
        return count;
    }

    public static void dumpConnections() {
        System.out.println("UltraPeer connections");
        RouterService.dumpConnections(manager.getInitializedConnections());
        System.out.println("Leaf connections");
        RouterService.dumpConnections(manager.getInitializedClientConnections());
    }

    private static void dumpConnections(Collection connections) {
        Iterator iterator = connections.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString());
        }
    }

    public static byte[] newQueryGUID() {
        if (RouterService.isOOBCapable() && OutOfBandThroughputStat.isOOBEffectiveForMe()) {
            return GUID.makeAddressEncodedGuid(RouterService.getAddress(), RouterService.getPort());
        }
        return GUID.makeGuid();
    }

    public static void query(byte[] guid, String query, MediaType type) {
        RouterService.query(guid, query, "", type);
    }

    public static void query(byte[] guid, String query) {
        RouterService.query(guid, query, null);
    }

    public static void query(byte[] guid, String query, String richQuery, MediaType type) {
        try {
            QueryRequest qr = null;
            if (RouterService.isIpPortValid() && new GUID(guid).addressesMatch(RouterService.getAddress(), RouterService.getPort())) {
                qr = QueryRequest.createOutOfBandQuery(guid, query, richQuery, type);
                OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
            } else {
                qr = QueryRequest.createQuery(guid, query, richQuery, type);
            }
            RouterService.recordAndSendQuery(qr, type);
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    public static void queryWhatIsNew(byte[] guid, MediaType type) {
        try {
            QueryRequest qr = null;
            if (GUID.addressesMatch(guid, RouterService.getAddress(), RouterService.getPort())) {
                qr = QueryRequest.createWhatIsNewOOBQuery(guid, (byte)2, type);
                OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
            } else {
                qr = QueryRequest.createWhatIsNewQuery(guid, (byte)2, type);
            }
            if (FilterSettings.FILTER_WHATS_NEW_ADULT.getValue()) {
                MutableGUIDFilter.instance().addGUID(guid);
            }
            RouterService.recordAndSendQuery(qr, type);
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    private static void recordAndSendQuery(QueryRequest qr, MediaType type) {
        _lastQueryTime = System.currentTimeMillis();
        VERIFIER.record(qr, type);
        RESULT_HANDLER.addQuery(qr);
        router.sendDynamicQuery(qr);
    }

    public static long getLastQueryTime() {
        return _lastQueryTime;
    }

    public static void stopQuery(GUID guid) {
        QueryUnicaster.instance().purgeQuery(guid);
        RESULT_HANDLER.removeQuery(guid);
        router.queryKilled(guid);
        if (RouterService.isSupernode()) {
            QueryDispatcher.instance().addToRemove(guid);
        }
        MutableGUIDFilter.instance().removeGUID(guid.bytes());
    }

    public static boolean matchesType(byte[] guid, Response response) {
        return VERIFIER.matchesType(guid, response);
    }

    public static boolean matchesQuery(byte[] guid, Response response) {
        return VERIFIER.matchesQuery(guid, response);
    }

    public static boolean isMandragoreWorm(byte[] guid, Response response) {
        return VERIFIER.isMandragoreWorm(guid, response);
    }

    public static Collection getPreferencedHosts(boolean isUltrapeer, String locale, int num) {
        IpPortSet hosts = new IpPortSet();
        if (isUltrapeer) {
            hosts.addAll(catcher.getUltrapeersWithFreeUltrapeerSlots(locale, num));
        } else {
            hosts.addAll(catcher.getUltrapeersWithFreeLeafSlots(locale, num));
        }
        if (hosts.size() < num) {
            List conns = manager.getInitializedConnectionsMatchLocale(locale);
            Iterator i = conns.iterator();
            while (i.hasNext() && hosts.size() < num) {
                hosts.add(i.next());
            }
            if (hosts.size() < num) {
                conns = manager.getInitializedConnections();
                i = conns.iterator();
                while (i.hasNext() && hosts.size() < num) {
                    hosts.add(i.next());
                }
            }
        }
        return hosts;
    }

    public static int getNumConnections() {
        return manager.getNumConnections();
    }

    public static int getNumInitializedConnections() {
        return manager.getNumInitializedConnections();
    }

    public static int getNumUltrapeerToLeafConnections() {
        return manager.getNumInitializedClientConnections();
    }

    public static int getNumLeafToUltrapeerConnections() {
        return manager.getNumClientSupernodeConnections();
    }

    public static int getNumUltrapeerToUltrapeerConnections() {
        return manager.getNumUltrapeerConnections();
    }

    public static int getNumOldConnections() {
        return manager.getNumOldConnections();
    }

    public static boolean isFullyConnected() {
        return manager.isFullyConnected();
    }

    public static boolean isConnected() {
        return manager.isConnected();
    }

    public static boolean isConnecting() {
        return manager.isConnecting();
    }

    public static boolean isFetchingEndpoints() {
        return BootstrapServerManager.instance().isEndpointFetchInProgress();
    }

    public static int getNumSharedFiles() {
        return fileManager.getNumFiles();
    }

    public static int getNumPendingShared() {
        return fileManager.getNumPendingFiles();
    }

    public static int getSharedFileSize() {
        return fileManager.getSize();
    }

    public static FileDesc[] getIncompleteFileDescriptors() {
        return fileManager.getIncompleteFileDescriptors();
    }

    public static FileDesc[] getSharedFileDescriptors(File directory) {
        return fileManager.getSharedFileDescriptors(directory);
    }

    public static Downloader download(RemoteFileDesc[] files, List alts, GUID queryGUID, boolean overwrite, File saveDir, String fileName) throws SaveLocationException {
        return downloader.download(files, alts, queryGUID, overwrite, saveDir, fileName);
    }

    public static Downloader download(RemoteFileDesc[] files, List alts, GUID queryGUID, boolean overwrite) throws SaveLocationException {
        return RouterService.download(files, alts, queryGUID, overwrite, null, null);
    }

    public static Downloader download(RemoteFileDesc[] files, GUID queryGUID, boolean overwrite, File saveDir, String fileName) throws SaveLocationException {
        return RouterService.download(files, Collections.EMPTY_LIST, queryGUID, overwrite, saveDir, fileName);
    }

    public static Downloader download(RemoteFileDesc[] files, boolean overwrite, GUID queryGUID) throws SaveLocationException {
        return RouterService.download(files, queryGUID, overwrite, null, null);
    }

    public static Downloader download(MagnetOptions magnet, boolean overwrite) throws SaveLocationException {
        if (!magnet.isDownloadable()) {
            throw new IllegalArgumentException("invalid magnet: not have enough information for downloading");
        }
        return downloader.download(magnet, overwrite, null, magnet.getDisplayName());
    }

    public static Downloader download(MagnetOptions magnet, boolean overwrite, File saveDir, String fileName) throws SaveLocationException {
        return downloader.download(magnet, overwrite, saveDir, fileName);
    }

    public static Downloader download(File incompleteFile) throws CantResumeException, SaveLocationException {
        return downloader.download(incompleteFile);
    }

    public static Chatter createChat(String host, int port) {
        Chatter chatter = ChatManager.instance().request(host, port);
        return chatter;
    }

    public static BrowseHostHandler doAsynchronousBrowseHost(final String host, final int port, GUID guid, GUID serventID, final Set proxies, final boolean canDoFWTransfer) {
        final BrowseHostHandler handler = new BrowseHostHandler(callback, guid, serventID);
        ThreadFactory.startThread(new Runnable(){

            public void run() {
                handler.browseHost(host, port, proxies, canDoFWTransfer);
            }
        }, "BrowseHoster");
        return handler;
    }

    public static boolean isSupernode() {
        return manager.isSupernode();
    }

    public static boolean isShieldedLeaf() {
        return manager.isShieldedLeaf();
    }

    public static int getNumFreeLeafSlots() {
        return manager.getNumFreeLeafSlots();
    }

    public static int getNumFreeNonLeafSlots() {
        return manager.getNumFreeNonLeafSlots();
    }

    public static int getNumFreeLimeWireLeafSlots() {
        return manager.getNumFreeLimeWireLeafSlots();
    }

    public static int getNumFreeLimeWireNonLeafSlots() {
        return manager.getNumFreeLimeWireNonLeafSlots();
    }

    public static void setIsShuttingDown(boolean flag) {
        isShuttingDown = flag;
    }

    public static boolean getIsShuttingDown() {
        return isShuttingDown;
    }

    public static boolean addressChanged() {
        if (callback != null) {
            callback.addressStateChanged();
        }
        byte[] addr = RouterService.getAddress();
        int port = RouterService.getPort();
        if (!NetworkUtils.isValidAddress(addr)) {
            return false;
        }
        if (NetworkUtils.isPrivateAddress(addr)) {
            return false;
        }
        if (!NetworkUtils.isValidPort(port)) {
            return false;
        }
        if (acceptor != null) {
            acceptor.resetLastConnectBackTime();
        }
        if (UDPSERVICE != null) {
            UDPSERVICE.resetLastConnectBackTime();
        }
        if (manager != null) {
            ManagedConnection c;
            Properties props = new Properties();
            props.put("Listen-IP", NetworkUtils.ip2string(addr) + ":" + port);
            HeaderUpdateVendorMessage huvm = new HeaderUpdateVendorMessage(props);
            Iterator iter = manager.getInitializedConnections().iterator();
            while (iter.hasNext()) {
                c = (ManagedConnection)iter.next();
                if (c.remoteHostSupportsHeaderUpdate() < 1) continue;
                c.send(huvm);
            }
            iter = manager.getInitializedClientConnections().iterator();
            while (iter.hasNext()) {
                c = (ManagedConnection)iter.next();
                if (c.remoteHostSupportsHeaderUpdate() < 1) continue;
                c.send(huvm);
            }
        }
        return true;
    }

    public static boolean incomingStatusChanged() {
        if (callback != null) {
            callback.addressStateChanged();
        }
        byte[] addr = RouterService.getAddress();
        int port = RouterService.getPort();
        if (!NetworkUtils.isValidAddress(addr)) {
            return false;
        }
        if (NetworkUtils.isPrivateAddress(addr)) {
            return false;
        }
        return NetworkUtils.isValidPort(port);
    }

    public static byte[] getExternalAddress() {
        return acceptor.getExternalAddress();
    }

    public static byte[] getAddress() {
        return acceptor.getAddress(true);
    }

    public static byte[] getNonForcedAddress() {
        return acceptor.getAddress(false);
    }

    public static int getPort() {
        return acceptor.getPort(true);
    }

    public static int getNonForcedPort() {
        return acceptor.getPort(false);
    }

    public static boolean isGUESSCapable() {
        return UDPSERVICE.isGUESSCapable();
    }

    public static boolean isOOBCapable() {
        return RouterService.isGUESSCapable() && OutOfBandThroughputStat.isSuccessRateGood() && !NetworkUtils.isPrivate() && SearchSettings.OOB_ENABLED.getValue() && acceptor.isAddressExternal() && RouterService.isIpPortValid();
    }

    public static GUID getUDPConnectBackGUID() {
        return UDPSERVICE.getConnectBackGUID();
    }

    public static boolean isIpPortValid() {
        return NetworkUtils.isValidAddress(RouterService.getAddress()) && NetworkUtils.isValidPort(RouterService.getPort());
    }

    public static boolean canReceiveSolicited() {
        return UDPSERVICE.canReceiveSolicited();
    }

    public static boolean canReceiveUnsolicited() {
        return UDPSERVICE.canReceiveUnsolicited();
    }

    public static boolean canDoFWT() {
        return UDPSERVICE.canDoFWT();
    }

    public static long getContentResponsesSize() {
        return contentManager.getCacheSize();
    }

    public static long getCreationCacheSize() {
        return CreationTimeCache.instance().getSize();
    }

    public static long getVerifyingFileByteCacheSize() {
        return VerifyingFile.getSizeOfByteCache();
    }

    public static long getVerifyingFileVerifyingCacheSize() {
        return VerifyingFile.getSizeOfVerifyingCache();
    }

    public static int getVerifyingFileQueueSize() {
        return VerifyingFile.getNumPendingItems();
    }

    public static long getByteBufferCacheSize() {
        return NIODispatcher.instance().getBufferCache().getHeapCacheSize();
    }

    public static int getNumberOfWaitingSockets() {
        return Sockets.getNumWaitingSockets();
    }

    public static int getNumberOfPendingTimeouts() {
        return NIODispatcher.instance().getNumPendingTimeouts();
    }

    static {
        manager = new ConnectionManager();
        catcher = new HostCatcher();
        downloader = new DownloadManager();
        uploadManager = new UploadManager();
        pushManager = new PushManager();
        promotionManager = new PromotionManager();
        VERIFIER = new ResponseVerifier();
        STATISTICS = Statistics.instance();
        UDPSERVICE = UDPService.instance();
        RESULT_HANDLER = new SearchResultHandler();
        altManager = AltLocManager.instance();
        secureMessageVerifier = new SecureMessageVerifier();
        contentManager = new ContentManager();
        UDPSelectorProvider provider = UDPSelectorProvider.instance();
        UDP_MULTIPLEXOR = (UDPMultiplexor)provider.openSelector();
        SocketChannel socketChannel = provider.openSocketChannel();
        try {
            socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        NIODispatcher.instance().registerSelector(UDP_MULTIPLEXOR, socketChannel.getClass());
        SHUTDOWN_ITEMS = Collections.synchronizedList(new LinkedList());
        _lastQueryTime = 0L;
        _fullPower = true;
        byte[] myguid = null;
        try {
            myguid = GUID.fromHexString(ApplicationSettings.CLIENT_ID.getValue());
        }
        catch (IllegalArgumentException iae) {
            myguid = GUID.makeGuid();
            ApplicationSettings.CLIENT_ID.setValue(new GUID(myguid).toHexString());
        }
        MYGUID = myguid;
    }

    private static class Initializer
    implements Runnable {
        private Initializer() {
        }

        public void run() {
            RouterService.getAcceptor().init();
        }
    }
}

