/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SavedFileManager
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SavedFileManager.class);
    private static SavedFileManager INSTANCE = new SavedFileManager();
    private static final ProcessingQueue QUEUE = new ProcessingQueue("SavedFileLoader");
    private Set _urns = new HashSet();
    private Set _names = new TreeSet(Comparators.caseInsensitiveStringComparator());

    public static SavedFileManager instance() {
        return INSTANCE;
    }

    private SavedFileManager() {
        RouterService.schedule(this, 10000L, 180000L);
    }

    public synchronized void addSavedFile(File f, Set urns) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding: " + f + " with: " + urns);
        }
        this._names.add(f.getName());
        Iterator i = urns.iterator();
        while (i.hasNext()) {
            this._urns.add(i.next());
        }
    }

    public synchronized boolean isSaved(URN urn, String name) {
        return urn != null && this._urns.contains(urn) || this._names.contains(name);
    }

    public void run() {
        QUEUE.add(new Runnable(){

            public void run() {
                SavedFileManager.this.load();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        LOG.trace("Loading Saved Files");
        HashSet urns = new HashSet();
        TreeSet names = new TreeSet(Comparators.caseInsensitiveStringComparator());
        UrnCallback callback = new UrnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void urnsCalculated(File f, Set urns) {
                SavedFileManager savedFileManager = SavedFileManager.this;
                synchronized (savedFileManager) {
                    SavedFileManager.this._urns.addAll(urns);
                }
            }

            public boolean isOwner(Object o) {
                return o == SavedFileManager.this;
            }
        };
        Set saveDirs = SharingSettings.getAllSaveDirectories();
        Iterator i = saveDirs.iterator();
        while (i.hasNext()) {
            this.loadDirectory((File)i.next(), urns, names, callback);
        }
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            this._urns.addAll(urns);
            this._names.addAll(names);
        }
    }

    private void loadDirectory(File directory, Set tempUrns, Set tempNames, UrnCallback callback) {
        File[] savedFiles = directory.listFiles();
        if (savedFiles == null) {
            return;
        }
        for (int i = 0; i < savedFiles.length; ++i) {
            File file = savedFiles[i];
            if (!file.isFile() || !file.exists()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading: " + file);
            }
            tempNames.add(file.getName());
            Set urns = UrnCache.instance().getUrns(file);
            if (urns.isEmpty()) {
                UrnCache.instance().calculateAndCacheUrns(file, callback);
                continue;
            }
            tempUrns.addAll(urns);
        }
    }
}

