/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.FeatureSearchData;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.ReceivedMessageStat;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class StandardMessageRouter
extends MessageRouter {
    protected void respondToPingRequest(PingRequest ping, ReplyHandler handler) {
        byte ttl;
        byte hops = ping.getHops();
        if (hops + (ttl = ping.getTTL()) > 2 && !_manager.allowAnyConnection()) {
            return;
        }
        if (NetworkUtils.isValidAddress(RouterService.getAddress()) && NetworkUtils.isValidPort(RouterService.getPort())) {
            if (hops == 1 && ttl == 1) {
                this.handleCrawlerPing(ping, handler);
                return;
            }
            if (ping.isHeartbeat()) {
                this.sendPingReply(PingReply.create(ping.getGUID(), (byte)1), handler);
                return;
            }
            int newTTL = hops + 1;
            if (hops + ttl <= 2) {
                newTTL = 1;
            }
            if (RouterService.getConnectionManager().hasFreeSlots() || Statistics.instance().calculateDailyUptime() > 1800) {
                PingReply pr = PingReply.create(ping.getGUID(), (byte)newTTL);
                this.sendPingReply(pr, handler);
            }
        }
        List pongs = PongCacher.instance().getBestPongs(ping.getLocale());
        Iterator iter = pongs.iterator();
        byte[] guid = ping.getGUID();
        InetAddress pingerIP = handler.getInetAddress();
        while (iter.hasNext()) {
            PingReply pr = (PingReply)iter.next();
            if (pr.getInetAddress().equals(pingerIP)) continue;
            this.sendPingReply(pr.mutateGUID(guid), handler);
        }
    }

    protected void respondToUDPPingRequest(PingRequest request, InetSocketAddress addr, ReplyHandler handler) {
        if (!RouterService.isIpPortValid()) {
            return;
        }
        IPPortCombo ipport = null;
        if (request.requestsIP()) {
            try {
                ipport = new IPPortCombo(addr.getAddress().getHostAddress(), addr.getPort());
            }
            catch (IOException tooBad) {
                // empty catch block
            }
        }
        byte[] data = request.getSupportsCachedPongData();
        Collection hosts = Collections.EMPTY_LIST;
        if (data != null) {
            boolean isUltrapeer = data.length >= 1 && (data[0] & 1) == 1;
            hosts = RouterService.getPreferencedHosts(isUltrapeer, request.getLocale(), ConnectionSettings.NUM_RETURN_PONGS.getValue());
        }
        PingReply reply = ipport != null ? PingReply.create(request.getGUID(), (byte)1, ipport, hosts) : PingReply.create(request.getGUID(), (byte)1, hosts);
        this.sendPingReply(reply, handler);
    }

    private void handleCrawlerPing(PingRequest m, ReplyHandler handler) {
        List leafConnections = _manager.getInitializedClientConnections();
        Iterator iterator = leafConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iterator.next();
            PingReply pr = PingReply.createExternal(m.getGUID(), (byte)2, connection.getPort(), connection.getInetAddress().getAddress(), false);
            pr.hop();
            this.sendPingReply(pr, handler);
        }
    }

    protected boolean respondToQueryRequest(QueryRequest queryRequest, byte[] clientGUID, ReplyHandler handler) {
        if (!FeatureSearchData.supportsFeature(queryRequest.getFeatureSelector())) {
            return false;
        }
        if (queryRequest.isWhatIsNewRequest()) {
            ReceivedMessageStat.WHAT_IS_NEW_QUERY_MESSAGES.incrementStat();
        }
        if (!RouterService.getUploadManager().isServiceable()) {
            return false;
        }
        if (!NetworkUtils.isValidPort(RouterService.getPort()) || !NetworkUtils.isValidAddress(RouterService.getAddress())) {
            return false;
        }
        Response[] responses = RouterService.getFileManager().query(queryRequest);
        if (RouterService.isShieldedLeaf() && queryRequest.isTCP()) {
            if (responses != null && responses.length > 0) {
                RoutedQueryStat.LEAF_HIT.incrementStat();
            } else {
                RoutedQueryStat.LEAF_FALSE_POSITIVE.incrementStat();
            }
        }
        return this.sendResponses(responses, queryRequest, handler);
    }

    public boolean sendResponses(Response[] responses, QueryRequest query, ReplyHandler handler) {
        if (responses == null || responses.length < 1) {
            return false;
        }
        if (query.desiresOutOfBandReplies() && !this.isConnectedTo(query, handler) && RouterService.canReceiveSolicited() && RouterService.getUploadManager().isServiceable() && NetworkUtils.isValidAddressAndPort(query.getReplyAddress(), query.getReplyPort())) {
            if (this.bufferResponsesForLaterDelivery(query, responses)) {
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByName(query.getReplyAddress());
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
                int port = query.getReplyPort();
                if (addr != null) {
                    int resultCount = responses.length > 255 ? 255 : responses.length;
                    ReplyNumberVendorMessage vm = new ReplyNumberVendorMessage(new GUID(query.getGUID()), resultCount);
                    UDPService.instance().send(vm, addr, port);
                    return true;
                }
            } else {
                return false;
            }
        }
        Iterator iterator = this.responsesToQueryReplies(responses, query);
        try {
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                this.sendQueryReply(queryReply);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    private final boolean isConnectedTo(QueryRequest query, ReplyHandler handler) {
        return query.matchesReplyAddress(handler.getInetAddress().getAddress());
    }

    protected List createQueryReply(byte[] guid, byte ttl, long speed, Response[] res, byte[] clientGUID, boolean busy, boolean uploaded, boolean measuredSpeed, boolean isFromMcast, boolean isFWTransfer) {
        Set proxies;
        String xmlCollectionString;
        ArrayList<QueryReply> queryReplies = new ArrayList<QueryReply>();
        QueryReply queryReply = null;
        int port = -1;
        byte[] ip = null;
        if (isFromMcast) {
            ip = RouterService.getNonForcedAddress();
            port = RouterService.getNonForcedPort();
            if (!NetworkUtils.isValidPort(port) || !NetworkUtils.isValidAddress(ip)) {
                isFromMcast = false;
            }
        }
        if (!isFromMcast) {
            if (isFWTransfer) {
                port = UDPService.instance().getStableUDPPort();
                ip = RouterService.getExternalAddress();
                if (!NetworkUtils.isValidAddress(ip) || !NetworkUtils.isValidPort(port)) {
                    isFWTransfer = false;
                }
            }
            if (!isFWTransfer) {
                ip = RouterService.getAddress();
                port = RouterService.getPort();
                if (!NetworkUtils.isValidAddress(ip) || !NetworkUtils.isValidPort(port)) {
                    return Collections.EMPTY_LIST;
                }
            }
        }
        if ((xmlCollectionString = LimeXMLDocumentHelper.getAggregateString(res)) == null) {
            xmlCollectionString = "";
        }
        byte[] xmlBytes = null;
        try {
            xmlBytes = xmlCollectionString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            ErrorService.error(ueex, "encountered UnsupportedEncodingException in creation of QueryReply : xmlCollectionString : " + xmlCollectionString);
        }
        boolean notIncoming = !RouterService.acceptedIncomingConnection();
        Set set = proxies = notIncoming ? _manager.getPushProxies() : null;
        if (xmlBytes.length > 32768) {
            LinkedList splitResps = new LinkedList();
            this.splitAndAddResponses(splitResps, res);
            while (!splitResps.isEmpty()) {
                Response[] currResps = (Response[])splitResps.remove(0);
                String currXML = LimeXMLDocumentHelper.getAggregateString(currResps);
                byte[] currXMLBytes = null;
                try {
                    currXMLBytes = currXML.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ueex) {
                    ErrorService.error(ueex, "encountered UnsupportedEncodingException : currXML " + currXML);
                    currXMLBytes = "".getBytes();
                }
                if (currXMLBytes.length > 32768 && currResps.length > 1) {
                    this.splitAndAddResponses(splitResps, currResps);
                    continue;
                }
                byte[] xmlCompressed = null;
                xmlCompressed = currXML != null && !currXML.equals("") ? LimeXMLUtils.compress(currXMLBytes) : DataUtils.EMPTY_BYTE_ARRAY;
                queryReply = new QueryReply(guid, ttl, port, ip, speed, currResps, this._clientGUID, xmlCompressed, notIncoming, busy, uploaded, measuredSpeed, ChatSettings.CHAT_ENABLED.getValue(), isFromMcast, isFWTransfer, proxies);
                queryReplies.add(queryReply);
            }
        } else {
            byte[] xmlCompressed = null;
            xmlCompressed = xmlCollectionString != null && !xmlCollectionString.equals("") ? LimeXMLUtils.compress(xmlBytes) : DataUtils.EMPTY_BYTE_ARRAY;
            queryReply = new QueryReply(guid, ttl, port, ip, speed, res, this._clientGUID, xmlCompressed, notIncoming, busy, uploaded, measuredSpeed, ChatSettings.CHAT_ENABLED.getValue(), isFromMcast, isFWTransfer, proxies);
            queryReplies.add(queryReply);
        }
        return queryReplies;
    }

    private Response[][] splitResponses(Response[] in) {
        int i;
        int middle = in.length / 2;
        Response[][] retResps = new Response[][]{new Response[middle], new Response[in.length - middle]};
        for (i = 0; i < middle; ++i) {
            retResps[0][i] = in[i];
        }
        for (i = 0; i < in.length - middle; ++i) {
            retResps[1][i] = in[i + middle];
        }
        return retResps;
    }

    private void splitAndAddResponses(List addTo, Response[] toSplit) {
        Response[][] splits = this.splitResponses(toSplit);
        addTo.add(splits[0]);
        addTo.add(splits[1]);
    }
}

