/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPPinger {
    private static final Log LOG = LogFactory.getLog(UDPPinger.class);
    protected static final ProcessingQueue QUEUE = new ProcessingQueue("UDPHostRanker");
    public static int LISTEN_EXPIRE_TIME = 20000;
    private static final long SEND_INTERVAL = 500L;
    private static final int MAX_SENDS = 15;
    private static int _sentAmount;
    private static long _lastSentTime;

    public void rank(Collection hosts) {
        this.rank(hosts, null, null, null);
    }

    public void rank(Collection hosts, Message message) {
        this.rank(hosts, null, null, message);
    }

    public void rank(Collection hosts, Cancellable canceller) {
        this.rank(hosts, null, canceller, null);
    }

    public void rank(Collection hosts, MessageListener listener) {
        this.rank(hosts, listener, null, null);
    }

    public void rank(Collection hosts, MessageListener listener, Cancellable canceller) {
        this.rank(hosts, listener, canceller, null);
    }

    public void rank(Collection hosts, MessageListener listener, Cancellable canceller, Message message) {
        if (hosts == null) {
            throw new NullPointerException("null hosts not allowed");
        }
        if (canceller == null) {
            canceller = new Cancellable(){

                public boolean isCancelled() {
                    return false;
                }
            };
        }
        QUEUE.add(new SenderBundle(hosts, listener, canceller, message));
    }

    private boolean waitForListening(Cancellable canceller) {
        int waits;
        for (waits = 0; !UDPService.instance().isListening() && waits < 10 && !canceller.isCancelled(); ++waits) {
            try {
                Thread.sleep(600L);
                continue;
            }
            catch (InterruptedException e) {
                ErrorService.error(e);
            }
        }
        return waits < 10;
    }

    protected void send(Collection hosts, final MessageListener listener, Cancellable canceller, Message message) {
        if (!this.waitForListening(canceller)) {
            return;
        }
        if (message == null) {
            message = PingRequest.createUDPPing();
        }
        final byte[] messageGUID = message.getGUID();
        if (listener != null) {
            RouterService.getMessageRouter().registerMessageListener(messageGUID, listener);
        }
        Iterator iter = hosts.iterator();
        while (iter.hasNext() && !canceller.isCancelled()) {
            this.sendSingleMessage((IpPort)iter.next(), message);
        }
        if (listener != null) {
            Runnable udpMessagePurger = new Runnable(){

                public void run() {
                    RouterService.getMessageRouter().unregisterMessageListener(messageGUID, listener);
                }
            };
            RouterService.schedule(udpMessagePurger, LISTEN_EXPIRE_TIME, 0L);
        }
    }

    protected void sendSingleMessage(IpPort host, Message message) {
        long now = System.currentTimeMillis();
        if (now > _lastSentTime + 500L) {
            _sentAmount = 0;
        } else if (_sentAmount == 15) {
            try {
                Thread.sleep(500L);
                now = System.currentTimeMillis();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            _sentAmount = 0;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending to " + host + ": " + message.getClass() + " " + message);
        }
        UDPService.instance().send(message, host);
        ++_sentAmount;
        _lastSentTime = now;
    }

    private class SenderBundle
    implements Runnable {
        private final Collection hosts;
        private final MessageListener listener;
        private final Cancellable canceller;
        private final Message message;

        public SenderBundle(Collection hosts, MessageListener listener, Cancellable canceller, Message message) {
            this.hosts = hosts;
            this.listener = listener;
            this.canceller = canceller;
            this.message = message;
        }

        public void run() {
            UDPPinger.this.send(this.hosts, this.listener, this.canceller, this.message);
        }
    }
}

