/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.ReadWriteObserver;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.BufferByteArrayOutputStream;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPService
implements ReadWriteObserver {
    private static final Log LOG = LogFactory.getLog(UDPService.class);
    private static final UDPService INSTANCE = new UDPService();
    private DatagramChannel _channel;
    private final List OUTGOING_MSGS;
    private final ByteBuffer BUFFER;
    private final int BUFFER_SIZE = 2048;
    private volatile boolean _acceptedSolicitedIncoming = false;
    private volatile boolean _acceptedUnsolicitedIncoming = false;
    private long _lastUnsolicitedIncomingTime = 0L;
    private volatile long _lastReceivedAny = 0L;
    private long _lastConnectBackTime = System.currentTimeMillis();
    private boolean _portStable = true;
    private int _lastReportedPort;
    private int _numReceivedIPPongs;
    private final GUID CONNECT_BACK_GUID = new GUID(GUID.makeGuid());
    private final GUID SOLICITED_PING_GUID = new GUID(GUID.makeGuid());
    private boolean _started = false;
    private static final long PING_PERIOD = 85000L;
    private static final byte[] IN_HEADER_BUF = new byte[23];

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - Acceptor.INCOMING_EXPIRE_TIME;
    }

    public static UDPService instance() {
        return INSTANCE;
    }

    protected UDPService() {
        this.OUTGOING_MSGS = new LinkedList();
        byte[] backing = new byte[2048];
        this.BUFFER = ByteBuffer.wrap(backing);
        this.scheduleServices();
    }

    protected void scheduleServices() {
        RouterService.schedule(new IncomingValidator(), Acceptor.TIME_BETWEEN_VALIDATES, Acceptor.TIME_BETWEEN_VALIDATES);
        RouterService.schedule(new PeriodicPinger(), 0L, 85000L);
    }

    public GUID getConnectBackGUID() {
        return this.CONNECT_BACK_GUID;
    }

    public GUID getSolicitedGUID() {
        return this.SOLICITED_PING_GUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        DatagramChannel channel;
        UDPService uDPService = this;
        synchronized (uDPService) {
            this._started = true;
            channel = this._channel;
        }
        if (channel != null) {
            NIODispatcher.instance().registerReadWrite(channel, this);
        }
    }

    DatagramSocket newListeningSocket(int port) throws IOException {
        try {
            DatagramChannel channel = DatagramChannel.open();
            channel.configureBlocking(false);
            DatagramSocket s = channel.socket();
            s.setReceiveBufferSize(65536);
            s.setSendBufferSize(65536);
            s.bind(new InetSocketAddress(port));
            return s;
        }
        catch (SecurityException se) {
            throw new IOException("security exception on port: " + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListeningSocket(DatagramSocket datagramSocket) {
        if (this._channel != null) {
            try {
                this._channel.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (datagramSocket != null) {
            boolean wasStarted;
            UDPService uDPService = this;
            synchronized (uDPService) {
                this._channel = datagramSocket.getChannel();
                if (this._channel == null) {
                    throw new IllegalArgumentException("No channel!");
                }
                wasStarted = this._started;
                this._lastReportedPort = this._channel.socket().getLocalPort();
                this._portStable = true;
            }
            if (wasStarted) {
                this.start();
            }
        }
    }

    public void shutdown() {
        this.setListeningSocket(null);
    }

    public void handleRead() throws IOException {
        while (true) {
            SocketAddress from;
            this.BUFFER.clear();
            try {
                from = this._channel.receive(this.BUFFER);
            }
            catch (IOException iox) {
                break;
            }
            catch (Error error) {
                break;
            }
            if (from == null) break;
            if (!(from instanceof InetSocketAddress)) {
                Assert.silent(false, "non-inet SocketAddress: " + from);
                continue;
            }
            InetSocketAddress addr = (InetSocketAddress)from;
            if (!NetworkUtils.isValidAddress(addr.getAddress()) || !NetworkUtils.isValidPort(addr.getPort())) continue;
            byte[] data = this.BUFFER.array();
            int length = this.BUFFER.position();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(data, 0, length);
                Message message = MessageFactory.read((InputStream)in, 2, IN_HEADER_BUF);
                if (message == null) continue;
                this.processMessage(message, addr);
            }
            catch (IOException ignored) {
            }
            catch (BadPacketException ignored) {}
        }
    }

    public void handleIOException(IOException iox) {
        if (!(iox instanceof ClosedChannelException)) {
            ErrorService.error(iox, "UDP Error.");
        } else {
            LOG.trace("Swallowing a UDPService ClosedChannelException", iox);
        }
    }

    protected void processMessage(Message message, InetSocketAddress addr) {
        this.updateState(message, addr);
        MessageDispatcher.instance().dispatchUDP(message, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(Message message, InetSocketAddress addr) {
        this._lastReceivedAny = System.currentTimeMillis();
        if (!this.isGUESSCapable()) {
            if (message instanceof PingRequest) {
                GUID guid = new GUID(message.getGUID());
                if (this.isValidForIncoming(this.CONNECT_BACK_GUID, guid, addr)) {
                    this._acceptedUnsolicitedIncoming = true;
                }
                this._lastUnsolicitedIncomingTime = this._lastReceivedAny;
            } else if (message instanceof PingReply) {
                GUID guid = new GUID(message.getGUID());
                if (!this.isValidForIncoming(this.SOLICITED_PING_GUID, guid, addr)) {
                    return;
                }
                this._acceptedSolicitedIncoming = true;
                PingReply r = (PingReply)message;
                if (r.getMyPort() != 0) {
                    UDPService uDPService = this;
                    synchronized (uDPService) {
                        ++this._numReceivedIPPongs;
                        if (this._numReceivedIPPongs == 1) {
                            this._lastReportedPort = r.getMyPort();
                        } else if (this._lastReportedPort != r.getMyPort()) {
                            this._portStable = false;
                            this._lastReportedPort = r.getMyPort();
                        }
                    }
                }
            }
        }
        if (message instanceof ReplyNumberVendorMessage) {
            this._lastUnsolicitedIncomingTime = this._lastReceivedAny;
        }
    }

    private boolean isValidForIncoming(GUID match, GUID guidReceived, InetSocketAddress addr) {
        if (!match.equals(guidReceived)) {
            return false;
        }
        String host = addr.getAddress().getHostAddress();
        return !RouterService.getConnectionManager().isConnectedTo(host) && !NetworkUtils.isPrivateAddress(addr.getAddress());
    }

    public void send(Message msg, InetSocketAddress host) {
        this.send(msg, host.getAddress(), host.getPort());
    }

    public void send(Message msg, IpPort host) {
        this.send(msg, host.getInetAddress(), host.getPort());
    }

    public void send(Message msg, InetAddress ip, int port) throws IllegalArgumentException {
        if (msg == null) {
            throw new IllegalArgumentException("Null Message");
        }
        if (ip == null) {
            throw new IllegalArgumentException("Null InetAddress");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("Invalid Port: " + port);
        }
        if (this._channel == null || this._channel.socket().isClosed()) {
            return;
        }
        int length = msg.getTotalLength();
        ByteBuffer buffer = NIODispatcher.instance().getBufferCache().getHeap(length);
        if (buffer.remaining() != length) {
            throw new IllegalStateException("retrieved a buffer with wrong remaining! wanted: " + length + ", had: " + buffer.remaining() + ", position: " + buffer.position() + ", limit: " + buffer.limit());
        }
        BufferByteArrayOutputStream baos = new BufferByteArrayOutputStream(buffer);
        try {
            msg.writeQuickly(baos);
        }
        catch (IOException e) {
            ErrorService.error(e);
            return;
        }
        buffer.flip();
        this.send(buffer, ip, port, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer buffer, InetAddress ip, int port, boolean custom) {
        List list = this.OUTGOING_MSGS;
        synchronized (list) {
            this.OUTGOING_MSGS.add(new SendBundle(buffer, ip, port, custom));
            if (this._channel != null) {
                NIODispatcher.instance().interestWrite(this._channel, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleWrite() throws IOException {
        List list = this.OUTGOING_MSGS;
        synchronized (list) {
            while (true) {
                Object var6_6;
                if (this.OUTGOING_MSGS.isEmpty()) {
                    NIODispatcher.instance().interestWrite(this._channel, false);
                    return false;
                }
                boolean releaseBuffer = true;
                SendBundle bundle = (SendBundle)this.OUTGOING_MSGS.remove(0);
                try {
                    try {
                        if (this._channel.send(bundle.buffer, bundle.addr) == 0) {
                            this.OUTGOING_MSGS.add(0, bundle);
                            return true;
                        }
                        if (bundle.custom) {
                            bundle.buffer.rewind();
                            releaseBuffer = false;
                        }
                    }
                    catch (IOException ignored) {
                        LOG.warn("Ignoring exception on socket", ignored);
                        var6_6 = null;
                        if (!releaseBuffer) continue;
                        NIODispatcher.instance().getBufferCache().release(bundle.buffer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    if (!releaseBuffer) throw throwable;
                    NIODispatcher.instance().getBufferCache().release(bundle.buffer);
                    throw throwable;
                }
                var6_6 = null;
                if (!releaseBuffer) continue;
                NIODispatcher.instance().getBufferCache().release(bundle.buffer);
            }
        }
    }

    public boolean isGUESSCapable() {
        return this.canReceiveUnsolicited() && this.canReceiveSolicited();
    }

    public boolean canReceiveUnsolicited() {
        return this._acceptedUnsolicitedIncoming;
    }

    public boolean canReceiveSolicited() {
        return this._acceptedSolicitedIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDoFWT() {
        if (!this.canReceiveSolicited()) {
            return false;
        }
        if (!RouterService.isConnected()) {
            return !ConnectionSettings.LAST_FWT_STATE.getValue();
        }
        boolean ret = true;
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (this._numReceivedIPPongs < 1) {
                return !ConnectionSettings.LAST_FWT_STATE.getValue();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("stable " + this._portStable + " last reported port " + this._lastReportedPort + " our external port " + RouterService.getPort() + " our non-forced port " + RouterService.getAcceptor().getPort(false) + " number of received IP pongs " + this._numReceivedIPPongs + " valid external addr " + NetworkUtils.isValidAddress(RouterService.getExternalAddress()));
            }
            boolean bl = ret = NetworkUtils.isValidAddress(RouterService.getExternalAddress()) && this._portStable;
            if (this._numReceivedIPPongs == 1) {
                ret = ret && (this._lastReportedPort == RouterService.getAcceptor().getPort(false) || this._lastReportedPort == RouterService.getPort());
            }
        }
        ConnectionSettings.LAST_FWT_STATE.setValue(!ret);
        return ret;
    }

    public boolean portStable() {
        return this._portStable;
    }

    public int receivedIpPong() {
        return this._numReceivedIPPongs;
    }

    public int lastReportedPort() {
        return this._lastReportedPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStableUDPPort() {
        int localPort = RouterService.getAcceptor().getPort(false);
        int forcedPort = RouterService.getPort();
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (this._portStable && this._numReceivedIPPongs > 1) {
                return this._lastReportedPort;
            }
            if (this._numReceivedIPPongs == 1 && (localPort == this._lastReportedPort || forcedPort == this._lastReportedPort)) {
                return this._lastReportedPort;
            }
        }
        return forcedPort;
    }

    public void setReceiveSolicited(boolean value) {
        this._acceptedSolicitedIncoming = value;
    }

    public long getLastReceivedTime() {
        return this._lastReceivedAny;
    }

    public boolean isListening() {
        if (this._channel == null) {
            return false;
        }
        return this._channel.socket().getLocalPort() != -1;
    }

    public String toString() {
        return "UDPService::channel: " + this._channel;
    }

    private class PeriodicPinger
    implements Runnable {
        private PeriodicPinger() {
        }

        public void run() {
            GUESSEndpoint ep = QueryUnicaster.instance().getUnicastEndpoint();
            if (ep == null) {
                return;
            }
            if (!UDPService.this.canReceiveSolicited() && !UDPService.this.canReceiveUnsolicited()) {
                return;
            }
            PingRequest pr = new PingRequest(UDPService.this.getSolicitedGUID().bytes(), 1, 0);
            pr.addIPRequest();
            UDPService.this.send(pr, ep.getAddress(), ep.getPort());
        }
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            final long currTime = System.currentTimeMillis();
            final MessageRouter mr = RouterService.getMessageRouter();
            ConnectionManager cm = RouterService.getConnectionManager();
            if (mr == null || cm == null) {
                return;
            }
            if (UDPService.this._acceptedUnsolicitedIncoming && currTime - UDPService.this._lastUnsolicitedIncomingTime > Acceptor.INCOMING_EXPIRE_TIME || !UDPService.this._acceptedUnsolicitedIncoming && currTime - UDPService.this._lastConnectBackTime > Acceptor.INCOMING_EXPIRE_TIME) {
                final GUID cbGuid = new GUID(GUID.makeGuid());
                final MLImpl ml = new MLImpl();
                mr.registerMessageListener(cbGuid.bytes(), ml);
                if (cm.sendUDPConnectBackRequests(cbGuid)) {
                    UDPService.this._lastConnectBackTime = System.currentTimeMillis();
                    Runnable checkThread = new Runnable(){

                        public void run() {
                            if (UDPService.this._acceptedUnsolicitedIncoming && UDPService.this._lastUnsolicitedIncomingTime < currTime || !UDPService.this._acceptedUnsolicitedIncoming) {
                                UDPService.this._acceptedUnsolicitedIncoming = ml._gotIncoming;
                            }
                            mr.unregisterMessageListener(cbGuid.bytes(), ml);
                        }
                    };
                    RouterService.schedule(checkThread, Acceptor.WAIT_TIME_AFTER_REQUESTS, 0L);
                } else {
                    mr.unregisterMessageListener(cbGuid.bytes(), ml);
                }
            }
        }
    }

    private static class MLImpl
    implements MessageListener {
        public boolean _gotIncoming = false;

        private MLImpl() {
        }

        public void processMessage(Message m, ReplyHandler handler) {
            if (m instanceof PingRequest) {
                this._gotIncoming = true;
            }
        }

        public void registered(byte[] guid) {
        }

        public void unregistered(byte[] guid) {
        }
    }

    private static class SendBundle {
        private final ByteBuffer buffer;
        private final SocketAddress addr;
        private final boolean custom;

        SendBundle(ByteBuffer b, InetAddress addr, int port, boolean custom) {
            this.buffer = b;
            this.addr = new InetSocketAddress(addr, port);
            this.custom = custom;
        }
    }
}

