/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadManager
implements BandwidthTracker {
    private static final Log LOG = LogFactory.getLog(UploadManager.class);
    private final int BYPASS_QUEUE = -1;
    private final int REJECTED = 0;
    private final int QUEUED = 1;
    private final int ACCEPTED = 2;
    private final int BANNED = 3;
    public static final int MIN_POLL_TIME = 45000;
    public static final int MAX_POLL_TIME = 120000;
    private List _activeUploadList = new LinkedList();
    private List _queuedUploads = new ArrayList();
    private volatile boolean _hadSuccesfulUpload = false;
    private int _forcedUploads;
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    private Buffer speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile float lastMeasuredBandwidth;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    public static final int BROWSE_HOST_FILE_INDEX = -1;
    public static final int UPDATE_FILE_INDEX = -2;
    public static final int BAD_URN_QUERY_INDEX = -3;
    public static final int MALFORMED_REQUEST_INDEX = -4;
    public static final int PUSH_PROXY_FILE_INDEX = -5;
    public static final int FILE_VIEW_FILE_INDEX = -6;
    public static final int RESOURCE_INDEX = -7;
    public static final int BROWSER_CONTROL_INDEX = -8;
    public static final String BROWSER_CONTROL_STR = "/browser-control";
    public static final String SERVICE_ID = "service_id";
    public static final String FV_REQ_BEGIN = "/gnutella/file-view";
    public static final String RESOURCE_GET = "/gnutella/res/";
    private final Map REQUESTS = new FixedsizeForgetfulHashMap(250);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void acceptUpload(HTTPRequestMethod method, Socket socket, boolean forceAllow) {
        LOG.trace("accepting upload");
        HTTPUploader uploader = null;
        long startTime = -1L;
        try {
            try {
                int queued = -1;
                String oldFileName = "";
                HTTPRequestMethod currentMethod = method;
                StalledUploadWatchdog watchdog = new StalledUploadWatchdog();
                BufferedInputStream iStream = null;
                boolean startedNewFile = false;
                while (true) {
                    if (uploader != null) {
                        this.assertAsComplete(uploader.getState());
                    }
                    if (iStream == null) {
                        iStream = new BufferedInputStream(socket.getInputStream());
                    }
                    LOG.trace("parsing http line.");
                    HttpRequestLine line = this.parseHttpRequest(socket, iStream);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("line = " + line);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(uploader + " successfully parsed request");
                    }
                    String fileName = line._fileName;
                    startedNewFile = uploader == null || currentMethod != uploader.getMethod() || !oldFileName.equalsIgnoreCase(fileName);
                    if (startedNewFile) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(uploader + " starting new file " + line._fileName + " index " + line._index);
                        }
                        if (uploader != null) {
                            if (queued != 1) {
                                queued = -1;
                            } else {
                                uploader.setState(5);
                            }
                            this.cleanupFinishedUploader(uploader, startTime);
                        }
                        uploader = new HTTPUploader(currentMethod, fileName, socket, line._index, line.getParameters(), watchdog, line.hadPassword());
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(uploader + " continuing old file");
                        }
                        uploader.reinitialize(currentMethod, line.getParameters());
                    }
                    this.assertAsConnecting(uploader.getState());
                    this.setInitialUploadingState(uploader);
                    try {
                        uploader.readHeader(iStream);
                        this.setUploaderStateOffHeaders(uploader);
                    }
                    catch (ProblemReadingHeaderException prhe) {
                        uploader.setState(11);
                    }
                    catch (FreeloaderUploadingException fue) {
                        uploader.setState(1);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(uploader + " HTTPUploader created and read all headers");
                    }
                    if (queued != 2 && (queued = this.processNewRequest(uploader, socket, forceAllow)) == 2) {
                        startTime = System.currentTimeMillis();
                    }
                    if (startedNewFile) {
                        this.addToGUI(uploader);
                    }
                    this.doSingleUpload(uploader);
                    this.assertAsFinished(uploader.getState());
                    oldFileName = fileName;
                    if (!line.isHTTP11()) {
                        Object var18_19 = null;
                        if (uploader != null && uploader.getState() != 4) {
                            uploader.setState(5);
                        }
                        UploadManager uploadManager = this;
                        // MONITORENTER : uploadManager
                        boolean found = false;
                        Iterator iter = this._queuedUploads.iterator();
                        while (iter.hasNext()) {
                            KeyValue kv = (KeyValue)iter.next();
                            if (kv.getKey() != socket) continue;
                            iter.remove();
                            found = true;
                            break;
                        }
                        if (found) {
                            uploader.setState(5);
                        }
                        // MONITOREXIT : uploadManager
                        if (uploader != null) {
                            uploader.stop();
                            this.cleanupFinishedUploader(uploader, startTime);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(uploader + " closing socket");
                        }
                        IOUtils.close(socket);
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(uploader + " waiting for next request with socket ");
                    }
                    int oldTimeout = socket.getSoTimeout();
                    if (queued != 1) {
                        socket.setSoTimeout(SharingSettings.PERSISTENT_HTTP_CONNECTION_TIMEOUT.getValue());
                    } else {
                        socket.setSoTimeout(120000);
                    }
                    String word = IOUtils.readWord(iStream, 4);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(uploader + " next request arrived ");
                    }
                    socket.setSoTimeout(oldTimeout);
                    if (word.equals("GET")) {
                        currentMethod = HTTPRequestMethod.GET;
                        UploadStat.SUBSEQUENT_GET.incrementStat();
                        continue;
                    }
                    if (!word.equals("HEAD")) break;
                    currentMethod = HTTPRequestMethod.HEAD;
                    UploadStat.SUBSEQUENT_HEAD.incrementStat();
                }
                UploadStat.SUBSEQUENT_UNKNOWN.incrementStat();
                Object var18_20 = null;
                if (uploader != null && uploader.getState() != 4) {
                    uploader.setState(5);
                }
                UploadManager uploadManager = this;
                // MONITORENTER : uploadManager
                boolean found = false;
                Iterator iter = this._queuedUploads.iterator();
                while (iter.hasNext()) {
                    KeyValue kv = (KeyValue)iter.next();
                    if (kv.getKey() != socket) continue;
                    iter.remove();
                    found = true;
                    break;
                }
                if (found) {
                    uploader.setState(5);
                }
                // MONITOREXIT : uploadManager
                if (uploader != null) {
                    uploader.stop();
                    this.cleanupFinishedUploader(uploader, startTime);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(uploader + " closing socket");
                }
                IOUtils.close(socket);
                return;
            }
            catch (IOException ioe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(uploader + " IOE thrown, closing socket", ioe);
                }
                Object var18_21 = null;
                if (uploader != null && uploader.getState() != 4) {
                    uploader.setState(5);
                }
                UploadManager uploadManager = this;
                // MONITORENTER : uploadManager
                boolean found = false;
                Iterator iter = this._queuedUploads.iterator();
                while (iter.hasNext()) {
                    KeyValue kv = (KeyValue)iter.next();
                    if (kv.getKey() != socket) continue;
                    iter.remove();
                    found = true;
                    break;
                }
                if (found) {
                    uploader.setState(5);
                }
                // MONITOREXIT : uploadManager
                if (uploader != null) {
                    uploader.stop();
                    this.cleanupFinishedUploader(uploader, startTime);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(uploader + " closing socket");
                }
                IOUtils.close(socket);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            if (uploader != null && uploader.getState() != 4) {
                uploader.setState(5);
            }
            UploadManager uploadManager = this;
            // MONITORENTER : uploadManager
            boolean found = false;
            Iterator iter = this._queuedUploads.iterator();
            while (iter.hasNext()) {
                KeyValue kv = (KeyValue)iter.next();
                if (kv.getKey() != socket) continue;
                iter.remove();
                found = true;
                break;
            }
            if (found) {
                uploader.setState(5);
            }
            // MONITOREXIT : uploadManager
            if (uploader != null) {
                uploader.stop();
                this.cleanupFinishedUploader(uploader, startTime);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(uploader + " closing socket");
            }
            IOUtils.close(socket);
            throw throwable;
        }
    }

    private boolean shouldShowInGUI(HTTPUploader uploader) {
        return uploader.getIndex() != -1 && uploader.getIndex() != -5 && uploader.getIndex() != -2 && uploader.getIndex() != -4 && uploader.getIndex() != -3 && uploader.getIndex() != -6 && uploader.getIndex() != -7 && uploader.getIndex() != -8 && uploader.getMethod() != HTTPRequestMethod.HEAD && !uploader.isForcedShare();
    }

    private boolean shouldBypassQueue(HTTPUploader uploader) {
        return uploader.getState() != 0 || uploader.getMethod() == HTTPRequestMethod.HEAD || uploader.isForcedShare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFinishedUploader(HTTPUploader uploader, long startTime) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(uploader + " cleaning up finished.");
        }
        int state = uploader.getState();
        int lastState = uploader.getLastTransferState();
        this.assertAsFinished(state);
        long finishTime = System.currentTimeMillis();
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            if (startTime > 0L) {
                this.reportUploadSpeed(finishTime - startTime, uploader.getTotalAmountUploaded());
            }
            this.removeFromList(uploader);
        }
        uploader.closeFileStreams();
        switch (state) {
            case 4: {
                UploadStat.COMPLETED.incrementStat();
                if (lastState != 3 && lastState != 15) break;
                UploadStat.COMPLETED_FILE.incrementStat();
                break;
            }
            case 5: {
                UploadStat.INTERRUPTED.incrementStat();
            }
        }
        if (this.shouldShowInGUI(uploader)) {
            FileDesc fd = uploader.getFileDesc();
            if (fd != null && state == 4 && (lastState == 3 || lastState == 15)) {
                fd.incrementCompletedUploads();
                RouterService.getCallback().handleSharedFileUpdate(fd.getFile());
            }
            RouterService.getCallback().removeUpload(uploader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialUploadingState(HTTPUploader uploader) {
        switch (uploader.getIndex()) {
            case -1: {
                uploader.setState(8);
                return;
            }
            case -8: {
                uploader.setState(16);
                return;
            }
            case -5: {
                uploader.setState(12);
                return;
            }
            case -2: {
                uploader.setState(10);
                return;
            }
            case -3: {
                uploader.setState(7);
                return;
            }
            case -4: {
                uploader.setState(11);
                return;
            }
        }
        FileManager fm = RouterService.getFileManager();
        FileDesc fd = null;
        int index = uploader.getIndex();
        FileManager fileManager = fm;
        synchronized (fileManager) {
            if (fm.isValidIndex(index)) {
                fd = fm.get(index);
            }
        }
        if (fd == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(uploader + " fd is null");
            }
            uploader.setState(7);
            return;
        }
        if (!uploader.getFileName().equals(fd.getFileName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(uploader + " wrong file name");
            }
            uploader.setState(7);
            return;
        }
        try {
            uploader.setFileDesc(fd);
        }
        catch (IOException ioe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(uploader + " could not create file stream " + ioe);
            }
            uploader.setState(7);
            return;
        }
        this.assertAsConnecting(uploader.getState());
    }

    private void setUploaderStateOffHeaders(HTTPUploader uploader) {
        FileDesc fd = uploader.getFileDesc();
        if (uploader.getState() == 0) {
            URN urn = uploader.getRequestedURN();
            if (fd != null && urn != null && !fd.containsUrn(urn)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(uploader + " wrong content urn");
                }
                uploader.setState(7);
                return;
            }
            if (uploader.isTHEXRequest()) {
                if (uploader.getFileDesc().getHashTree() != null) {
                    uploader.setState(15);
                } else {
                    uploader.setState(7);
                }
                return;
            }
            if (fd instanceof IncompleteFileDesc) {
                if (!UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                    uploader.setState(7);
                    return;
                }
                if (uploader.isTHEXRequest()) {
                    uploader.setState(7);
                    return;
                }
                IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
                int upStart = uploader.getUploadBegin();
                int upEnd = uploader.getUploadEnd() - 1;
                if (uploader.containedRangeRequest()) {
                    Interval request = ifd.getAvailableSubRange(upStart, upEnd);
                    if (request == null) {
                        uploader.setState(13);
                        return;
                    }
                    uploader.setUploadBeginAndEnd(request.low, request.high + 1);
                } else if (!ifd.isRangeSatisfiable(upStart, upEnd)) {
                    uploader.setState(13);
                    return;
                }
            }
        }
    }

    private int processNewRequest(HTTPUploader uploader, Socket socket, boolean forceAllow) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(uploader + " processing new request.");
        }
        int queued = -1;
        if (!this.shouldBypassQueue(uploader)) {
            queued = forceAllow ? 2 : this.checkAndQueue(uploader, socket);
        } else {
            queued = -1;
            this.unsetQueue(socket);
        }
        switch (queued) {
            case 0: {
                uploader.setState(2);
                break;
            }
            case 3: {
                uploader.setState(14);
                break;
            }
            case 1: {
                uploader.setState(9);
                break;
            }
            case 2: {
                this.assertAsConnecting(uploader.getState());
                this.addAcceptedUploader(uploader);
                break;
            }
            case -1: {
                break;
            }
            default: {
                Assert.that(false, "Invalid queued state: " + queued);
            }
        }
        return queued;
    }

    protected synchronized void addAcceptedUploader(HTTPUploader uploader) {
        if (uploader.isForcedShare()) {
            ++this._forcedUploads;
        }
        this._activeUploadList.add(uploader);
    }

    private void addToGUI(HTTPUploader uploader) {
        UploadStat.ATTEMPTED.incrementStat();
        if (this.shouldShowInGUI(uploader)) {
            RouterService.getCallback().addUpload(uploader);
            FileDesc fd = uploader.getFileDesc();
            if (fd != null) {
                fd.incrementAttemptedUploads();
                RouterService.getCallback().handleSharedFileUpdate(fd.getFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSingleUpload(HTTPUploader uploader) throws IOException {
        switch (uploader.getState()) {
            case 13: {
                UploadStat.UNAVAILABLE_RANGE.incrementStat();
                break;
            }
            case 7: {
                UploadStat.FILE_NOT_FOUND.incrementStat();
                break;
            }
            case 1: {
                UploadStat.FREELOADER.incrementStat();
                break;
            }
            case 2: {
                UploadStat.LIMIT_REACHED.incrementStat();
                break;
            }
            case 9: {
                UploadStat.QUEUED.incrementStat();
                break;
            }
            case 14: {
                UploadStat.BANNED.incrementStat();
                break;
            }
            case 0: {
                uploader.setState(3);
                UploadStat.UPLOADING.incrementStat();
                break;
            }
            case 15: {
                UploadStat.THEX.incrementStat();
                break;
            }
            case 4: 
            case 5: {
                Assert.that(false, "invalid state in doSingleUpload");
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(uploader + " doing single upload");
        }
        boolean closeConnection = false;
        try {
            uploader.initializeStreams();
            uploader.writeResponse();
            closeConnection = uploader.getCloseConnection();
            uploader.setState(4);
        }
        finally {
            uploader.closeFileStreams();
        }
        if (closeConnection) {
            throw new IOException("close connection");
        }
    }

    public synchronized boolean isServiceable() {
        return this.hasFreeSlot(this.uploadsInProgress() + this.getNumQueuedUploads());
    }

    public synchronized int uploadsInProgress() {
        return this._activeUploadList.size() - this._forcedUploads;
    }

    public synchronized int getNumQueuedUploads() {
        return this._queuedUploads.size();
    }

    public boolean hadSuccesfulUpload() {
        return this._hadSuccesfulUpload;
    }

    public synchronized boolean isConnectedTo(InetAddress addr) {
        Object next;
        Iterator i = this._queuedUploads.iterator();
        while (i.hasNext()) {
            next = (KeyValue)i.next();
            Socket socket = (Socket)((KeyValue)next).getKey();
            if (socket == null || !socket.getInetAddress().equals(addr)) continue;
            return true;
        }
        i = this._activeUploadList.iterator();
        while (i.hasNext()) {
            next = (HTTPUploader)i.next();
            InetAddress host = ((HTTPUploader)next).getConnectedHost();
            if (host == null || !host.equals(addr)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean killUploadsForFileDesc(FileDesc fd) {
        boolean ret = false;
        Iterator i = this._activeUploadList.iterator();
        while (i.hasNext()) {
            HTTPUploader uploader = (HTTPUploader)i.next();
            FileDesc upFD = uploader.getFileDesc();
            if (upFD == null || !upFD.equals(fd)) continue;
            ret = true;
            uploader.stop();
        }
        return ret;
    }

    private synchronized void unsetQueue(Socket socket) {
        int posInQueue = this.positionInQueue(socket);
        if (posInQueue != -1) {
            KeyValue kv = (KeyValue)this._queuedUploads.get(posInQueue);
            kv.setValue(new Long(0L));
        }
    }

    private synchronized int checkAndQueue(Uploader uploader, Socket socket) throws IOException {
        RequestCache rqc = (RequestCache)this.REQUESTS.get(uploader.getHost());
        if (rqc == null) {
            rqc = new RequestCache();
        }
        this.REQUESTS.put(uploader.getHost(), rqc);
        rqc.countRequest();
        if (rqc.isHammering()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(uploader + " banned.");
            }
            return 3;
        }
        FileDesc fd = uploader.getFileDesc();
        if (!fd.isVerified()) {
            RouterService.getFileManager().validate(fd);
        }
        URN sha1 = fd.getSHA1Urn();
        boolean isGreedy = rqc.isGreedy(sha1);
        int size = this._queuedUploads.size();
        int posInQueue = this.positionInQueue(socket);
        int maxQueueSize = UploadSettings.UPLOAD_QUEUE_SIZE.getValue();
        boolean wontAccept = size >= maxQueueSize || rqc.isDupe(sha1);
        int ret = -1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Greedy: " + isGreedy + ", size: " + size + ", pos: " + posInQueue + ", maxS: " + maxQueueSize + ", dupe: " + rqc.isDupe(sha1));
        }
        boolean limitReached = false;
        if (isGreedy && size >= 1) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(uploader + " greedy -- limit reached.");
            }
            UploadStat.LIMIT_REACHED_GREEDY.incrementStat();
            limitReached = true;
        } else if (posInQueue < 0 && (limitReached = this.hostLimitReached(uploader.getHost()))) {
            rqc.limitReached(sha1);
        }
        boolean queue = uploader.supportsQueueing();
        Assert.that(maxQueueSize > 0, "queue size 0, cannot use");
        Assert.that(uploader.getState() == 0, "Bad state: " + uploader.getState());
        Assert.that(uploader.getMethod() == HTTPRequestMethod.GET);
        if (posInQueue == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(uploader + "Uploader not in que(capacity:" + maxQueueSize + ")");
            }
            if (limitReached || wontAccept) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(uploader + " limited? " + limitReached + " wontAccept? " + wontAccept);
                }
                return 0;
            }
            this.addToQueue(socket);
            posInQueue = size;
            ret = 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug(uploader + " new uploader added to queue");
            }
        } else {
            KeyValue kv = (KeyValue)this._queuedUploads.get(posInQueue);
            Long prev = (Long)kv.getValue();
            if (prev + 45000L > System.currentTimeMillis()) {
                this._queuedUploads.remove(posInQueue);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(uploader + " queued uploader flooding-throwing exception");
                }
                throw new IOException();
            }
            if (rqc.isDupe(sha1)) {
                return 0;
            }
            kv.setValue(new Long(System.currentTimeMillis()));
            if (LOG.isDebugEnabled()) {
                LOG.debug(uploader + " updated queued uploader");
            }
            ret = 1;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(uploader + " checking if given uploader can be accomodated ");
        }
        if (this.hasFreeSlot(posInQueue + this.uploadsInProgress())) {
            ret = 2;
            if (LOG.isDebugEnabled()) {
                LOG.debug(uploader + " accepting upload");
            }
            this._queuedUploads.remove(posInQueue);
        } else if (!queue) {
            this._queuedUploads.remove(posInQueue);
            ret = 0;
        }
        if (ret == 2) {
            rqc.startedUpload(sha1);
        }
        return ret;
    }

    private synchronized void addToQueue(Socket socket) {
        Long t = new Long(System.currentTimeMillis());
        this._queuedUploads.add(new KeyValue(socket, t));
    }

    public synchronized int positionInQueue(Socket socket) {
        int i = 0;
        Iterator iter = this._queuedUploads.iterator();
        while (iter.hasNext()) {
            Object curr = ((KeyValue)iter.next()).getKey();
            if (curr == socket) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private synchronized void removeFromList(Uploader uploader) {
        if (this._activeUploadList.remove(uploader)) {
            RequestCache rcq;
            if (((HTTPUploader)uploader).isForcedShare()) {
                --this._forcedUploads;
            }
            if ((rcq = (RequestCache)this.REQUESTS.get(uploader.getHost())) != null && uploader != null && uploader.getFileDesc() != null) {
                rcq.uploadDone(uploader.getFileDesc().getSHA1Urn());
            }
        }
        if (this._activeUploadList.size() == 0) {
            RouterService.getCallback().uploadsComplete();
        }
    }

    private synchronized boolean hostLimitReached(String host) {
        int max = UploadSettings.UPLOADS_PER_PERSON.getValue();
        int i = 0;
        Iterator iter = this._activeUploadList.iterator();
        while (iter.hasNext()) {
            Uploader u = (Uploader)iter.next();
            if (!u.getHost().equals(host)) continue;
            ++i;
        }
        iter = this._queuedUploads.iterator();
        while (iter.hasNext()) {
            Socket s = (Socket)((KeyValue)iter.next()).getKey();
            if (!s.getInetAddress().getHostAddress().equals(host)) continue;
            ++i;
        }
        return i >= max;
    }

    private boolean hasFreeSlot(int current) {
        if (current >= UploadSettings.HARD_MAX_UPLOADS.getValue()) {
            return false;
        }
        if (current < UploadSettings.SOFT_MAX_UPLOADS.getValue()) {
            return true;
        }
        float fastest = 0.0f;
        Iterator iter = this._activeUploadList.iterator();
        while (iter.hasNext()) {
            BandwidthTracker upload = (BandwidthTracker)iter.next();
            float speed = 0.0f;
            try {
                speed = upload.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                speed = 0.0f;
            }
            fastest = Math.max(fastest, speed);
        }
        return fastest > 3.0f;
    }

    public int calculateBandwidth() {
        float totalBandwith = this.getTotalBandwith();
        float burstSize = totalBandwith / (float)this.uploadsInProgress();
        return (int)burstSize;
    }

    private float getTotalBandwith() {
        float connectionSpeed = (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f;
        float speed = UploadSettings.UPLOAD_SPEED.getValue();
        float totalBandwith = connectionSpeed * speed / 100.0f;
        return totalBandwith;
    }

    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    private void reportUploadSpeed(long milliseconds, long bytes) {
        if (bytes < 200000L) {
            return;
        }
        int bandwidth = 8 * (int)((float)bytes / (float)milliseconds);
        this.speeds.add(new Integer(bandwidth));
        if (this.speeds.size() >= 5) {
            int max = 0;
            for (int i = 0; i < this.speeds.size(); ++i) {
                max = Math.max(max, (Integer)this.speeds.get(i));
            }
            this.highestSpeed = max;
        }
    }

    private HttpRequestLine parseHttpRequest(Socket socket, InputStream iStream) throws IOException {
        socket.setSoTimeout(8000);
        ByteReader br = new ByteReader(iStream);
        LOG.trace("trying to read request.");
        String str = br.readLine();
        if (LOG.isTraceEnabled()) {
            LOG.trace("request is: " + str);
        }
        try {
            if (str == null) {
                throw new IOException();
            }
            str.trim();
            if (this.isURNGet(str)) {
                return this.parseURNGet(str);
            }
            return UploadManager.parseTraditionalGet(str);
        }
        catch (IOException ioe) {
            LOG.debug("http request failed", ioe);
            UploadStat.MALFORMED_REQUEST.incrementStat();
            if (str == null) {
                return new HttpRequestLine(-4, "Malformed Request", false);
            }
            return new HttpRequestLine(-4, "Malformed Request", UploadManager.isHTTP11Request(str));
        }
    }

    private boolean isURNGet(String requestLine) {
        int slash1Index = requestLine.indexOf("/");
        int slash2Index = requestLine.indexOf("/", slash1Index + 1);
        if (slash1Index == -1 || slash2Index == -1) {
            return false;
        }
        String idString = requestLine.substring(slash1Index + 1, slash2Index);
        return idString.equalsIgnoreCase("uri-res");
    }

    private static HttpRequestLine parseTraditionalGet(String requestLine) throws IOException {
        try {
            int index = -1;
            StringTokenizer st = new StringTokenizer(requestLine);
            if (st.countTokens() < 2) {
                throw new IOException("invalid request: " + requestLine);
            }
            String fileInfoPart = st.nextToken().trim();
            String fileName = null;
            HashMap<String, Integer> parameters = null;
            boolean hadPassword = false;
            if (fileInfoPart.equals("/")) {
                index = -1;
                fileName = "Browse-Host Request";
                UploadStat.BROWSE_HOST.incrementStat();
            } else if (fileInfoPart.startsWith(BROWSER_CONTROL_STR)) {
                index = -8;
                fileName = fileInfoPart;
            } else if (fileInfoPart.startsWith(FV_REQ_BEGIN)) {
                index = -6;
                fileName = fileInfoPart;
            } else if (fileInfoPart.startsWith(RESOURCE_GET)) {
                index = -7;
                fileName = fileInfoPart.substring(RESOURCE_GET.length());
            } else if (fileInfoPart.equals("/update.xml")) {
                index = -2;
                fileName = "Update-File Request";
                UploadStat.UPDATE_FILE.incrementStat();
            } else if (fileInfoPart.startsWith("/gnutella/push-proxy") || fileInfoPart.startsWith("/gnet/push-proxy")) {
                int question = fileInfoPart.indexOf(63);
                if (question == -1) {
                    throw new IOException("Malformed PushProxy Req");
                }
                fileInfoPart = fileInfoPart.substring(question + 1);
                index = -5;
                StringTokenizer stLocal = new StringTokenizer(fileInfoPart, "=&");
                if (stLocal.countTokens() < 2 || stLocal.countTokens() % 2 != 0) {
                    throw new IOException("Malformed PushProxy HTTP Request");
                }
                Integer fileIndex = null;
                while (stLocal.hasMoreTokens()) {
                    String k = stLocal.nextToken();
                    String val = stLocal.nextToken();
                    if (k.equalsIgnoreCase("ServerId")) {
                        if (fileName != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        byte[] base16 = Base32.decode(val);
                        if (base16.length != 16) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        fileName = new GUID(base16).toHexString();
                        continue;
                    }
                    if (k.equalsIgnoreCase("guid")) {
                        if (fileName != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        if (val.length() != 32) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        fileName = val;
                        continue;
                    }
                    if (!k.equalsIgnoreCase("file")) continue;
                    if (fileIndex != null) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    fileIndex = Integer.valueOf(val);
                    if (fileIndex < 0) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    if (parameters == null) {
                        parameters = new HashMap<String, Integer>();
                    }
                    parameters.put("file", fileIndex);
                }
                UploadStat.PUSH_PROXY.incrementStat();
            } else {
                int g = requestLine.indexOf("/get/");
                int d = requestLine.indexOf("/", g + 5);
                String str_index = requestLine.substring(g + 5, d);
                index = Integer.parseInt(str_index);
                int f = requestLine.indexOf(" HTTP/", d);
                try {
                    fileName = URLDecoder.decode(requestLine.substring(d + 1, f));
                }
                catch (IllegalArgumentException e) {
                    fileName = requestLine.substring(d + 1, f);
                }
                UploadStat.TRADITIONAL_GET.incrementStat();
            }
            boolean http11 = UploadManager.isHTTP11Request(requestLine);
            return new HttpRequestLine(index, fileName, http11, parameters, hadPassword);
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
    }

    private HttpRequestLine parseURNGet(String requestLine) throws IOException {
        URN urn = URN.createSHA1UrnFromHttpRequest(requestLine);
        HashMap<String, String> params = new HashMap<String, String>();
        String requestUpper = requestLine.toUpperCase(Locale.US);
        if (requestUpper.indexOf("N2X?") > 0) {
            params.put(SERVICE_ID, "N2X?");
        } else if (requestUpper.indexOf("N2R?") > 0) {
            params.put(SERVICE_ID, "N2R?");
        } else {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid URN query: " + requestLine);
            }
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(requestLine));
        }
        FileDesc desc = RouterService.getFileManager().getFileDescForUrn(urn);
        if (desc == null) {
            UploadStat.UNKNOWN_URN_GET.incrementStat();
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(requestLine));
        }
        UploadStat.URN_GET.incrementStat();
        return new HttpRequestLine(desc.getIndex(), desc.getFileName(), UploadManager.isHTTP11Request(requestLine), params, false);
    }

    private static boolean isHTTP11Request(String requestLine) {
        return requestLine.endsWith("1.1");
    }

    private void assertAsConnecting(int state) {
        Assert.that(state == 0, "invalid state: " + state);
    }

    private void assertAsComplete(int state) {
        Assert.that(state == 4, "invalid state: " + state);
    }

    private void assertAsFinished(int state) {
        Assert.that(state == 5 || state == 4, "invalid state: " + state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        ArrayList activeCopy;
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            activeCopy = new ArrayList(this._activeUploadList);
        }
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = activeCopy.iterator();
        while (iter.hasNext()) {
            HTTPUploader up = (HTTPUploader)iter.next();
            if (up.isForcedShare()) continue;
            c = true;
            up.measureBandwidth();
            currentTotal += up.getAverageBandwidth();
        }
        if (c) {
            UploadManager uploadManager2 = this;
            synchronized (uploadManager2) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMeasuredBandwidth() {
        ArrayList activeCopy;
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            activeCopy = new ArrayList(this._activeUploadList);
        }
        float sum = 0.0f;
        Iterator iter = activeCopy.iterator();
        while (iter.hasNext()) {
            HTTPUploader up = (HTTPUploader)iter.next();
            if (up.isForcedShare()) continue;
            sum += up.getMeasuredBandwidth();
        }
        this.lastMeasuredBandwidth = sum;
        return sum;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    public float getLastMeasuredBandwidth() {
        return this.lastMeasuredBandwidth;
    }

    static void tBandwidthTracker(UploadManager upman) {
        upman.reportUploadSpeed(100000L, 1000000L);
        Assert.that(upman.measuredUploadSpeed() == -1);
        upman.reportUploadSpeed(100000L, 2000000L);
        Assert.that(upman.measuredUploadSpeed() == -1);
        upman.reportUploadSpeed(100000L, 3000000L);
        Assert.that(upman.measuredUploadSpeed() == -1);
        upman.reportUploadSpeed(100000L, 4000000L);
        Assert.that(upman.measuredUploadSpeed() == -1);
        upman.reportUploadSpeed(100000L, 5000000L);
        Assert.that(upman.measuredUploadSpeed() == 400);
        upman.reportUploadSpeed(100000L, 6000000L);
        Assert.that(upman.measuredUploadSpeed() == 480);
        upman.reportUploadSpeed(1L, 1000L);
        Assert.that(upman.measuredUploadSpeed() == 480);
        upman.reportUploadSpeed(100000L, 1000000L);
        upman.reportUploadSpeed(100000L, 1000000L);
        upman.reportUploadSpeed(100000L, 1000000L);
        upman.reportUploadSpeed(100000L, 1000000L);
        upman.reportUploadSpeed(100000L, 1000000L);
        Assert.that(upman.measuredUploadSpeed() == 80);
    }

    private static class RequestCache {
        private static final double MAX_REQUESTS = 5000.0;
        private static final int MAX_ENTRIES = 10;
        static long WAIT_TIME = 900000L;
        static long FIRST_CHECK_TIME = 30000L;
        private final Set REQUESTS = new FixedSizeExpiringSet(10, WAIT_TIME);
        private final Set ACTIVE_UPLOADS = new HashSet();
        private double _numRequests = 0.0;
        private long _lastRequest = this._firstRequest = System.currentTimeMillis();
        private long _firstRequest;

        RequestCache() {
        }

        boolean isGreedy(URN sha1) {
            return this.REQUESTS.contains(sha1);
        }

        void startedUpload(URN sha1) {
            this.ACTIVE_UPLOADS.add(sha1);
        }

        boolean isHammering() {
            if (this._lastRequest - this._firstRequest <= FIRST_CHECK_TIME) {
                return false;
            }
            return (double)(this._lastRequest - this._firstRequest) / this._numRequests < 5000.0;
        }

        void limitReached(URN sha1) {
            this.REQUESTS.add(sha1);
        }

        void countRequest() {
            this._numRequests += 1.0;
            this._lastRequest = System.currentTimeMillis();
        }

        boolean isDupe(URN sha1) {
            return this.ACTIVE_UPLOADS.contains(sha1);
        }

        void uploadDone(URN sha1) {
            this.ACTIVE_UPLOADS.remove(sha1);
        }
    }

    private static final class HttpRequestLine {
        final int _index;
        final String _fileName;
        final boolean _http11;
        final Map _params;
        final boolean _hadPass;

        public String toString() {
            return "Index = " + this._index + ", FileName = " + this._fileName + ", is HTTP1.1? " + this._http11 + ", Parameters = " + this._params;
        }

        HttpRequestLine(int index, String fileName, boolean http11) {
            this(index, fileName, http11, Collections.EMPTY_MAP, false);
        }

        HttpRequestLine(int index, String fName, boolean http11, Map params, boolean hadPass) {
            this._index = index;
            this._fileName = fName;
            this._http11 = http11;
            this._params = params == null ? Collections.EMPTY_MAP : params;
            this._hadPass = hadPass;
        }

        boolean isHTTP11() {
            return this._http11;
        }

        Map getParameters() {
            return this._params;
        }

        boolean hadPassword() {
            return this._hadPass;
        }
    }
}

