/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UrnCache {
    private static final Log LOG = LogFactory.getLog(UrnCache.class);
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static final File URN_CACHE_BACKUP_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.bak");
    private static UrnCache instance = null;
    private static final Map URN_MAP = UrnCache.createMap();
    private final ProcessingQueue QUEUE = new ProcessingQueue("Hasher");
    private Map pendingHashing = new HashMap();
    private boolean dirty = UrnCache.removeOldEntries(URN_MAP);

    public static synchronized UrnCache instance() {
        if (instance == null) {
            instance = new UrnCache();
        }
        return instance;
    }

    private UrnCache() {
    }

    public synchronized void calculateAndCacheUrns(File file, UrnCallback callback) {
        Set urns = this.getUrns(file);
        if (!urns.isEmpty()) {
            callback.urnsCalculated(file, urns);
        } else {
            ArrayList<UrnCallback> list;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding: " + file + " to be hashed.");
            }
            if ((list = (ArrayList<UrnCallback>)this.pendingHashing.get(file)) == null) {
                list = new ArrayList<UrnCallback>(1);
                this.pendingHashing.put(file, list);
            }
            list.add(callback);
            this.QUEUE.add(new Processor(file));
        }
    }

    public synchronized void clearPendingHashes(Object owner) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing all pending hashes owned by: " + owner);
        }
        Iterator i = this.pendingHashing.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry next = i.next();
            File f = (File)next.getKey();
            List callbacks = (List)next.getValue();
            for (int j = callbacks.size() - 1; j >= 0; --j) {
                UrnCallback c = (UrnCallback)callbacks.get(j);
                if (!c.isOwner(owner)) continue;
                callbacks.remove(j);
            }
            if (!callbacks.isEmpty()) continue;
            i.remove();
        }
    }

    public synchronized void clearPendingHashesFor(File file, Object owner) {
        List callbacks;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing all pending hashes for: " + file + ", owned by: " + owner);
        }
        if ((callbacks = (List)this.pendingHashing.get(file)) != null) {
            for (int j = callbacks.size() - 1; j >= 0; --j) {
                UrnCallback c = (UrnCallback)callbacks.get(j);
                if (!c.isOwner(owner)) continue;
                callbacks.remove(j);
            }
            if (callbacks.isEmpty()) {
                this.pendingHashing.remove(file);
            }
        }
    }

    public Set calculateUrns(File file) throws IOException, InterruptedException {
        HashSet<URN> set = new HashSet<URN>(1);
        set.add(URN.createSHA1Urn(file));
        return set;
    }

    public synchronized Set getUrns(File file) {
        if (file.lastModified() == 0L) {
            return Collections.EMPTY_SET;
        }
        UrnSetKey key = new UrnSetKey(file);
        Set cachedUrns = (Set)URN_MAP.get(key);
        if (cachedUrns == null) {
            return Collections.EMPTY_SET;
        }
        return cachedUrns;
    }

    public synchronized void removeUrns(File f) {
        UrnSetKey k = new UrnSetKey(f);
        URN_MAP.remove(k);
        this.dirty = true;
    }

    public synchronized void addUrns(File file, Set urns) {
        UrnSetKey key = new UrnSetKey(file);
        URN_MAP.put(key, Collections.unmodifiableSet(urns));
        this.dirty = true;
    }

    private static Map createMap() {
        HashMap result = UrnCache.readMap(URN_CACHE_FILE);
        if (result == null) {
            result = UrnCache.readMap(URN_CACHE_BACKUP_FILE);
        }
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map readMap(File file) {
        void var1_2;
        ObjectInputStream ois = null;
        ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        Map result = (Map)ois.readObject();
        Object var5_3 = null;
        if (ois == null) return var1_2;
        try {
            ois.close();
            return var1_2;
        }
        catch (IOException e) {}
        return var1_2;
        {
            catch (Throwable t) {
                LOG.error("Unable to read UrnCache", t);
                result = null;
                Object var5_4 = null;
                if (ois == null) return var1_2;
                try {
                    ois.close();
                    return var1_2;
                }
                catch (IOException e) {}
                return var1_2;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static boolean removeOldEntries(Map map) {
        boolean dirty = false;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof UrnSetKey) {
                File f;
                UrnSetKey key = (UrnSetKey)next;
                if (key == null || (f = new File(key._path)).exists() && f.lastModified() == key._modTime) continue;
                dirty = true;
                iter.remove();
                continue;
            }
            dirty = true;
            iter.remove();
        }
        return dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        if (!this.dirty) {
            return;
        }
        URN_CACHE_FILE.renameTo(URN_CACHE_BACKUP_FILE);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(URN_CACHE_FILE)));
            oos.writeObject(URN_MAP);
            oos.flush();
            IOUtils.close(oos);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
        finally {
            IOUtils.close(oos);
        }
        this.dirty = false;
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int result = 17;
            result = result * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            result = result * 37 + this._path.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey key = (UrnSetKey)o;
            return this._modTime == key._modTime && this._path.equals(key._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeLong(this._modTime);
            s.writeObject(this._path);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this._modTime = s.readLong();
            this._path = (String)s.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }

    private class Processor
    implements Runnable {
        private final File file;

        Processor(File f) {
            this.file = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set urns;
            List callbacks;
            UrnCache urnCache = UrnCache.this;
            synchronized (urnCache) {
                callbacks = (List)UrnCache.this.pendingHashing.remove(this.file);
                urns = UrnCache.this.getUrns(this.file);
            }
            if (callbacks != null && !callbacks.isEmpty()) {
                if (urns.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Hashing file: " + this.file);
                    }
                    try {
                        urns = UrnCache.this.calculateUrns(this.file);
                        UrnCache.this.addUrns(this.file, urns);
                    }
                    catch (IOException ignored) {
                        LOG.warn("Unable to calculate URNs", ignored);
                    }
                    catch (InterruptedException ignored) {
                        LOG.warn("Unable to calculate URNs", ignored);
                    }
                }
                for (int i = 0; i < callbacks.size(); ++i) {
                    ((UrnCallback)callbacks.get(i)).urnsCalculated(this.file, urns);
                }
            }
        }
    }
}

