/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.archive;

import com.limegroup.gnutella.archive.ArchiveContribution;
import com.limegroup.gnutella.archive.ArchiveRequest;
import com.limegroup.gnutella.archive.ArchiveResponse;
import com.limegroup.gnutella.archive.Archives;
import com.limegroup.gnutella.archive.BadResponseException;
import com.limegroup.gnutella.archive.DescriptionTooShortException;
import com.limegroup.gnutella.archive.IdentifierUnavailableException;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;

class AdvancedContribution
extends ArchiveContribution {
    private String _identifier;
    private String _ftpServer;
    private String _ftpPath;
    private String _verificationUrl;
    private Object _requestLock = new Object();
    private ArchiveRequest _request = null;
    private static final int DESCRIPTION_MIN_WORDS = 5;
    private static final String MIN_WORDS_REGEX = "\\W*(\\w+\\W+){" + Integer.toString(4) + "}\\w+.*";
    private static final Pattern MIN_WORDS_PATTERN = Pattern.compile(MIN_WORDS_REGEX);

    private void initFtpServer() {
        this._ftpServer = Archives.getMediaString(this.getMedia()) + "-uploads.archive.org";
    }

    public AdvancedContribution(String username, String password, String title, String description, int media) throws DescriptionTooShortException {
        super(username, password, title, description, media);
        this.initFtpServer();
    }

    public AdvancedContribution(String username, String password, String title, String description, int media, int collection, int type) throws DescriptionTooShortException {
        super(username, password, title, description, media, collection, type);
        this.initFtpServer();
    }

    static void checkDescription(String description) throws DescriptionTooShortException {
        if (!MIN_WORDS_PATTERN.matcher(description).matches()) {
            throw new DescriptionTooShortException(description, 5);
        }
    }

    public void setDescription(String description) throws DescriptionTooShortException {
        AdvancedContribution.checkDescription(description);
        super.setDescription(description);
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public String getVerificationUrl() {
        return this._verificationUrl;
    }

    protected String getFtpServer() {
        return this._ftpServer;
    }

    protected String getFtpPath() {
        return this._ftpPath;
    }

    protected boolean isFtpDirPreMade() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        super.cancel();
        Object object = this._requestLock;
        synchronized (object) {
            if (this._request != null) {
                this._request.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestIdentifier(String identifier) throws IdentifierUnavailableException, BadResponseException, HttpException, IOException {
        String CREATE_ID_URL = "http://www.archive.org/services/check_identifier.php";
        this._identifier = null;
        String nId = Archives.normalizeName(identifier);
        Object object = this._requestLock;
        synchronized (object) {
            this._request = new ArchiveRequest("http://www.archive.org/services/check_identifier.php", new NameValuePair[]{new NameValuePair("identifier", nId)});
        }
        this._request.execute();
        ArchiveResponse response = this._request.getResponse();
        Object object2 = this._requestLock;
        synchronized (object2) {
            this._request = null;
        }
        String resultType = response.getResultType();
        if (resultType == "success") {
            this._ftpPath = this._identifier = nId;
            this._verificationUrl = "http://www.archive.org/" + Archives.getMediaString(this.getMedia()) + "/" + Archives.getMediaString(this.getMedia()) + "-details-db.php?collection=" + Archives.getCollectionString(this.getCollection()) + "&collectionid=" + this._identifier;
            return this._identifier;
        }
        if (resultType == "error") {
            throw new IdentifierUnavailableException(response.getMessage(), nId);
        }
        throw new BadResponseException("unidentified result type:" + resultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkin() throws HttpException, BadResponseException, IOException {
        String CHECKIN_URL = "http://www.archive.org/services/contrib-submit.php";
        String username = this.getUsername();
        if (username == null) {
            throw new IllegalStateException("username not set");
        }
        if (this._identifier == null) {
            throw new IllegalStateException("identifier not set");
        }
        Object object = this._requestLock;
        synchronized (object) {
            this._request = new ArchiveRequest("http://www.archive.org/services/contrib-submit.php", new NameValuePair[]{new NameValuePair("user_email", username), new NameValuePair("server", this.getFtpServer()), new NameValuePair("dir", this._identifier)});
        }
        this._request.execute();
        ArchiveResponse response = this._request.getResponse();
        Object object2 = this._requestLock;
        synchronized (object2) {
            this._request = null;
        }
        String resultType = response.getResultType();
        if (resultType == "success") {
            return;
        }
        if (resultType == "error") {
            throw new BadResponseException("checkin failed: " + response.getMessage());
        }
        throw new BadResponseException("unidentified result type:" + resultType);
    }
}

