/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.archive;

import com.limegroup.gnutella.archive.AdvancedContribution;
import com.limegroup.gnutella.archive.Contribution;
import com.limegroup.gnutella.archive.DescriptionTooShortException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Archives {
    public static final int MEDIA_MOVIES = 1;
    private static final Integer _mediaMovies = new Integer(1);
    public static final int MEDIA_AUDIO = 3;
    private static final Integer _mediaAudio = new Integer(3);
    private static final Map _mediaStrings;
    public static final int TYPE_MOVING_IMAGE = 1;
    private static final Integer _typeMovingImage;
    public static final int TYPE_SOUND = 2;
    private static final Integer _typeSound;
    private static final Map _typeStrings;
    public static final int COLLECTION_OPENSOURCE_MOVIES = 1;
    private static final Integer _collectionOpensourceMovies;
    public static final int COLLECTION_OPENSOURCE_AUDIO = 2;
    private static final Integer _collectionOpensourceAudio;
    private static final Map _collectionStrings;
    private static final Map _defaultCollectionsForMedia;
    private static final Map _defaultTypesForMedia;
    private static final Pattern BAD_BEGINNING_CHARS;
    private static final Pattern BAD_CHARS;
    private static final String REPLACE_STR = "_";

    static String getMediaString(int media) {
        return (String)_mediaStrings.get(new Integer(media));
    }

    static String getCollectionString(int collection) {
        return (String)_collectionStrings.get(new Integer(collection));
    }

    static String getTypeString(int type) {
        return (String)_typeStrings.get(new Integer(type));
    }

    static int defaultCollectionForMedia(int media) {
        Integer c = (Integer)_defaultCollectionsForMedia.get(new Integer(media));
        if (c == null) {
            throw new IllegalArgumentException("Invalid media type: " + media);
        }
        return c;
    }

    static int defaultTypesForMedia(int media) {
        Integer c = (Integer)_defaultTypesForMedia.get(new Integer(media));
        if (c == null) {
            throw new IllegalArgumentException("Invalid media type: " + media);
        }
        return c;
    }

    public static String normalizeName(String name) {
        int MIN_LENGTH = 5;
        int MAX_LENGTH = 100;
        if (name == null) {
            return null;
        }
        name = BAD_BEGINNING_CHARS.matcher(name).replaceFirst("");
        name = BAD_CHARS.matcher(name).replaceAll(REPLACE_STR);
        StringBuffer nameBuf = new StringBuffer(name);
        while (nameBuf.length() < 5) {
            nameBuf.append(REPLACE_STR);
        }
        if (nameBuf.length() > 100) {
            nameBuf.setLength(100);
        }
        return nameBuf.toString();
    }

    public static Contribution createContribution(String username, String password, String title, String description, int media) throws DescriptionTooShortException {
        return new AdvancedContribution(username, password, title, description, media);
    }

    public static Contribution createContribution(String username, String password, String title, String description, int media, int collection, int type) throws DescriptionTooShortException {
        return new AdvancedContribution(username, password, title, description, media, collection, type);
    }

    public static void checkDescription(String description) throws DescriptionTooShortException {
        AdvancedContribution.checkDescription(description);
    }

    static {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(_mediaMovies, "movies");
        m.put(_mediaAudio, "audio");
        _mediaStrings = Collections.unmodifiableMap(m);
        _typeMovingImage = new Integer(1);
        _typeSound = new Integer(2);
        m = new HashMap();
        m.put(_typeMovingImage, "MovingImage");
        m.put(_typeSound, "Sound");
        _typeStrings = Collections.unmodifiableMap(m);
        _collectionOpensourceMovies = new Integer(1);
        _collectionOpensourceAudio = new Integer(2);
        HashMap<Integer, String> mCS = new HashMap<Integer, String>();
        HashMap<Integer, Integer> mDCFM = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mDTFM = new HashMap<Integer, Integer>();
        mCS.put(_collectionOpensourceMovies, "opensource_movies");
        mCS.put(_collectionOpensourceAudio, "opensource_audio");
        _collectionStrings = Collections.unmodifiableMap(mCS);
        mDCFM.put(_mediaMovies, _collectionOpensourceMovies);
        mDTFM.put(_mediaMovies, _typeMovingImage);
        mDCFM.put(_mediaAudio, _collectionOpensourceMovies);
        mDTFM.put(_mediaAudio, _typeSound);
        _defaultCollectionsForMedia = Collections.unmodifiableMap(mDCFM);
        _defaultTypesForMedia = Collections.unmodifiableMap(mDTFM);
        BAD_BEGINNING_CHARS = Pattern.compile("^[^\\p{Alnum}]+");
        BAD_CHARS = Pattern.compile("[^\\p{Alnum}\\.\\-_]");
    }
}

