/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.archive;

import com.limegroup.gnutella.archive.ArchiveContribution;
import com.limegroup.gnutella.archive.ArchiveRequest;
import com.limegroup.gnutella.archive.ArchiveResponse;
import com.limegroup.gnutella.archive.Archives;
import com.limegroup.gnutella.archive.BadResponseException;
import com.limegroup.gnutella.archive.DescriptionTooShortException;
import com.limegroup.gnutella.archive.IdentifierUnavailableException;
import java.io.IOException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;

class DirectContribution
extends ArchiveContribution {
    private String _identifier;
    private String _ftpServer;
    private String _ftpPath;
    private String _verificationUrl;
    private Object _requestLock = new Object();
    private ArchiveRequest _request = null;

    public DirectContribution(String username, String password, String title, String description, int media) throws DescriptionTooShortException {
        super(username, password, title, description, media);
    }

    public DirectContribution(String username, String password, String title, String description, int media, int collection, int type) throws DescriptionTooShortException {
        super(username, password, title, description, media, collection, type);
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public String getVerificationUrl() {
        return this._verificationUrl;
    }

    protected String getFtpServer() {
        return this._ftpServer;
    }

    protected String getFtpPath() {
        return this._ftpPath;
    }

    protected boolean isFtpDirPreMade() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        super.cancel();
        Object object = this._requestLock;
        synchronized (object) {
            if (this._request != null) {
                this._request.cancel();
                this._request = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestIdentifier(String identifier) throws IdentifierUnavailableException, BadResponseException, HttpException, IOException {
        Object object;
        ArchiveResponse response;
        String CREATE_ID_URL = "http://www.archive.org:80/create.php";
        this._identifier = null;
        String nId = Archives.normalizeName(identifier);
        ArchiveRequest request = new ArchiveRequest("http://www.archive.org:80/create.php", new NameValuePair[]{new NameValuePair("xml", "1"), new NameValuePair("user", this.getUsername()), new NameValuePair("identifier", nId)});
        Object object2 = this._requestLock;
        synchronized (object2) {
            this._request = request;
        }
        try {
            request.execute();
            response = request.getResponse();
            Object var8_8 = null;
            object = this._requestLock;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Object object3 = this._requestLock;
            synchronized (object3) {
                this._request = null;
            }
            throw throwable;
        }
        synchronized (object) {
            this._request = null;
        }
        String resultType = response.getResultType();
        if (resultType == "success") {
            String url = response.getUrl();
            if (url.equals("")) {
                throw new BadResponseException("successful result, but no url given");
            }
            String[] urlSplit = url.split("/", 2);
            if (urlSplit.length < 2) {
                throw new BadResponseException("No slash (/) present to separate server from path: " + url);
            }
            this._ftpServer = urlSplit[0];
            this._ftpPath = "/" + urlSplit[1];
            this._identifier = nId;
            this._verificationUrl = "http://www.archive.org/details/" + this._identifier;
            return this._identifier;
        }
        if (resultType == "error") {
            throw new IdentifierUnavailableException(response.getMessage(), nId);
        }
        throw new BadResponseException("unidentified result type:" + resultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkin() throws HttpException, BadResponseException, IOException {
        Object object;
        ArchiveResponse response;
        String CHECKIN_URL = "http://www.archive.org/checkin.php";
        String username = this.getUsername();
        if (username == null) {
            throw new IllegalStateException("username not set");
        }
        if (this._identifier == null) {
            throw new IllegalStateException("identifier not set");
        }
        ArchiveRequest request = new ArchiveRequest("http://www.archive.org/checkin.php", new NameValuePair[]{new NameValuePair("xml", "1"), new NameValuePair("user", username), new NameValuePair("identifier", this._identifier)});
        Object object2 = this._requestLock;
        synchronized (object2) {
            this._request = request;
        }
        try {
            request.execute();
            response = request.getResponse();
            Object var7_7 = null;
            object = this._requestLock;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Object object3 = this._requestLock;
            synchronized (object3) {
                this._request = null;
            }
            throw throwable;
        }
        synchronized (object) {
            this._request = null;
        }
        String resultType = response.getResultType();
        if (resultType == "success") {
            return;
        }
        if (resultType == "error") {
            throw new BadResponseException("checkin failed: " + response.getMessage());
        }
        throw new BadResponseException("unidentified result type:" + resultType);
    }
}

