/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.archive;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.archive.Archives;
import com.limegroup.gnutella.archive.UnsupportedFormatException;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class File {
    private static final HashMap _mp3Formats = new HashMap();
    private static final String MP3_VBR = "VBR MP3";
    private static final String OGG_VORBIS = "Ogg Vorbis";
    private final FileDesc _fd;
    private String _format;
    private String _runtime;
    private String _licenseUrl;
    private String _licenseDeclaration;
    private Element _element;
    private final String _remoteFileName;

    File(FileDesc fd) {
        License license;
        this._fd = fd;
        LimeXMLDocument xmlDoc = this._fd.getXMLDocument();
        String fileName = this._fd.getFileName();
        this._remoteFileName = Archives.normalizeName(fileName);
        if (LimeXMLUtils.isMP3File(fileName)) {
            try {
                Integer bitRate;
                String bitRateStr = xmlDoc.getValue("audios__audio__bitrate__");
                if (bitRateStr != null && _mp3Formats.get(bitRate = Integer.valueOf(bitRateStr)) != null) {
                    this._format = (String)_mp3Formats.get(bitRate);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (this._format == null) {
                this._format = MP3_VBR;
            }
        } else if (LimeXMLUtils.isOGGFile(fileName)) {
            this._format = OGG_VORBIS;
        } else {
            throw new UnsupportedFormatException();
        }
        try {
            String secondsStr = xmlDoc.getValue("audios__audio__seconds__");
            if (secondsStr != null) {
                int seconds = Integer.parseInt(secondsStr);
                this._runtime = CommonUtils.seconds2time(seconds);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (xmlDoc.isLicenseAvailable() && (license = xmlDoc.getLicense()).getLicenseName() == "Creative Commons License") {
            this._licenseUrl = license.getLicenseDeed(null).toString();
            this._licenseDeclaration = xmlDoc.getLicenseString();
        }
    }

    String getLicenseUrl() {
        return this._licenseUrl;
    }

    String getLicenseDeclaration() {
        return this._licenseDeclaration;
    }

    String getLocalFileName() {
        return this._fd.getFileName();
    }

    String getRemoteFileName() {
        return this._remoteFileName;
    }

    FileDetails getFileDetails() {
        return this._fd;
    }

    long getFileSize() {
        return this._fd.getFileSize();
    }

    java.io.File getIOFile() {
        return this._fd.getFile();
    }

    Element getElement(Document document) {
        String FILE_ELEMENT = "file";
        String NAME_ATTR = "name";
        String SOURCE_ATTR = "source";
        String SOURCE_ATTR_DEFAULT_VALUE = "original";
        String RUNTIME_ELEMENT = "runtime";
        String FORMAT_ELEMENT = "format";
        String LICENSE_ELEMENT = "license";
        if (this._element == null) {
            Element fileElement = document.createElement("file");
            fileElement.setAttribute("name", this.getRemoteFileName());
            fileElement.setAttribute("source", "original");
            if (this._runtime != null) {
                Element runtimeElement = document.createElement("runtime");
                runtimeElement.appendChild(document.createTextNode(this._runtime));
                fileElement.appendChild(runtimeElement);
            }
            Element formatElement = document.createElement("format");
            formatElement.appendChild(document.createTextNode(this._format));
            fileElement.appendChild(formatElement);
            String licenseDeclaration = this.getLicenseDeclaration();
            if (licenseDeclaration != null) {
                Element licenseElement = document.createElement("license");
                licenseElement.appendChild(document.createTextNode(licenseDeclaration));
                fileElement.appendChild(licenseElement);
            }
            this._element = fileElement;
        }
        return this._element;
    }

    static {
        int[] bitRates = new int[]{64, 96, 128, 160, 192, 256};
        for (int i = 0; i < bitRates.length; ++i) {
            Integer bitRate = new Integer(bitRates[i]);
            _mp3Formats.put(bitRate, bitRate.toString() + "Kbps MP3");
        }
    }
}

