/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.auth.ContentCache;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.auth.SettingsBasedContentAuthority;
import com.limegroup.gnutella.messages.vendor.ContentRequest;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.settings.ContentSettings;
import com.limegroup.gnutella.util.ManagedThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentManager {
    private static final Log LOG = LogFactory.getLog(ContentManager.class);
    private final Map OBSERVERS = Collections.synchronizedMap(new HashMap());
    private final List RESPONDERS = new ArrayList();
    private final Set REQUESTED = Collections.synchronizedSet(new HashSet());
    private final Set TIMEOUTS = Collections.synchronizedSet(new HashSet());
    private final ContentCache CACHE = new ContentCache();
    private volatile ContentAuthority authority = null;
    private volatile boolean shutdown = false;

    public void initialize() {
        this.CACHE.initialize();
        this.startProcessingThread();
    }

    public void shutdown() {
        this.shutdown = true;
        this.CACHE.writeToDisk();
    }

    public int getCacheSize() {
        return this.CACHE.getSize();
    }

    public void setContentAuthority(ContentAuthority authority) {
        this.authority = authority;
    }

    public boolean isVerified(URN urn) {
        return !ContentSettings.isManagementActive() || this.CACHE.hasResponseFor(urn) || this.TIMEOUTS.contains(urn);
    }

    public void request(URN urn, ContentResponseObserver observer, long timeout) {
        ContentResponseData response = this.CACHE.getResponse(urn);
        if (response != null || !ContentSettings.isManagementActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Immediate response for URN: " + urn);
            }
            observer.handleResponse(urn, response);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling request for URN: " + urn);
            }
            this.scheduleRequest(urn, observer, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentResponseData request(URN urn, long timeout) {
        Validator validator;
        Validator validator2 = validator = new Validator();
        synchronized (validator2) {
            this.request(urn, validator, timeout);
            if (validator.hasResponse()) {
                return validator.getResponse();
            }
            try {
                validator.wait();
            }
            catch (InterruptedException ix) {
                LOG.warn("Interrupted while waiting for response", ix);
            }
            return validator.getResponse();
        }
    }

    public ContentResponseData getResponse(URN urn) {
        return this.CACHE.getResponse(urn);
    }

    protected void scheduleRequest(URN urn, ContentResponseObserver observer, long timeout) {
        long now = System.currentTimeMillis();
        this.addResponder(new Responder(now, timeout, observer, urn));
        if (this.REQUESTED.add(urn) && this.authority != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending request for URN: " + urn + " to authority: " + this.authority);
            }
            this.authority.send(new ContentRequest(urn));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not sending request.  No authority or already requested.");
        }
    }

    public void handleContentResponse(ContentResponse responseMsg) {
        URN urn = responseMsg.getURN();
        if (urn != null && this.REQUESTED.remove(urn)) {
            Collection responders;
            ContentResponseData response = new ContentResponseData(responseMsg);
            this.CACHE.addResponse(urn, response);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding response (" + response + ") for URN: " + urn);
            }
            if ((responders = (Collection)this.OBSERVERS.remove(urn)) != null) {
                this.removeResponders(responders);
                Iterator i = responders.iterator();
                while (i.hasNext()) {
                    Responder next = (Responder)i.next();
                    next.observer.handleResponse(next.urn, response);
                }
            }
        } else if (LOG.isWarnEnabled()) {
            if (urn == null) {
                LOG.debug("No URN in response: " + responseMsg);
            } else {
                LOG.debug("Didn't request URN: " + urn + ", msg: " + responseMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeResponders(Collection responders) {
        int size = responders.size();
        int removed = 0;
        List list = this.RESPONDERS;
        synchronized (list) {
            for (int i = this.RESPONDERS.size() - 1; i >= 0; --i) {
                Responder next = (Responder)this.RESPONDERS.get(i);
                if (responders.contains(next)) {
                    this.RESPONDERS.remove(i);
                    ++removed;
                }
                if (removed == size) break;
            }
        }
        if (removed != size) {
            LOG.warn("unable to remove all responders");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResponder(Responder responder) {
        Map map = this.OBSERVERS;
        synchronized (map) {
            HashSet<Responder> observers = (HashSet<Responder>)this.OBSERVERS.get(responder.urn);
            if (observers == null) {
                observers = new HashSet<Responder>();
            }
            observers.add(responder);
            this.OBSERVERS.put(responder.urn, observers);
            if (responder.dead != 0L) {
                this.addForTimeout(responder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addForTimeout(Responder responder) {
        List list = this.RESPONDERS;
        synchronized (list) {
            if (this.RESPONDERS.isEmpty()) {
                this.RESPONDERS.add(responder);
            } else if (responder.dead <= ((Responder)this.RESPONDERS.get(this.RESPONDERS.size() - 1)).dead) {
                this.RESPONDERS.add(responder);
            } else {
                int insertion = Collections.binarySearch(this.RESPONDERS, responder);
                if (insertion < 0) {
                    insertion = (insertion + 1) * -1;
                }
                this.RESPONDERS.add(insertion, responder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeout(long now) {
        Responder next;
        ArrayList<Responder> responders = null;
        List list = this.RESPONDERS;
        synchronized (list) {
            next = null;
            for (int i = this.RESPONDERS.size() - 1; i >= 0 && (next = (Responder)this.RESPONDERS.get(i)).dead <= now; --i) {
                this.REQUESTED.remove(next.urn);
                this.TIMEOUTS.add(next.urn);
                if (responders == null) {
                    responders = new ArrayList<Responder>(2);
                }
                responders.add(next);
                this.RESPONDERS.remove(i);
                next = null;
            }
        }
        if (responders != null) {
            for (int i = 0; i < responders.size(); ++i) {
                next = (Responder)responders.get(i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Timing out responder: " + next + " for URN: " + next.urn);
                }
                try {
                    next.observer.handleResponse(next.urn, null);
                    continue;
                }
                catch (Throwable t) {
                    ErrorService.error(t, "Content ContentResponseData Error");
                }
            }
        }
    }

    protected void startProcessingThread() {
        ManagedThread timeouter = new ManagedThread(new Runnable(){

            public void run() {
                if (ContentManager.this.authority == null) {
                    ContentManager.this.setDefaultContentAuthority();
                }
                while (!ContentManager.this.shutdown) {
                    try {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ix) {
                            // empty catch block
                        }
                        if (ContentManager.this.shutdown) continue;
                        ContentManager.this.timeout(System.currentTimeMillis());
                        continue;
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                        continue;
                    }
                    break;
                }
                return;
            }
        }, "ContentProcessor");
        timeouter.setDaemon(true);
        timeouter.start();
    }

    protected ContentAuthority getDefaultContentAuthority() {
        return new SettingsBasedContentAuthority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultContentAuthority() {
        ContentAuthority auth = this.getDefaultContentAuthority();
        if (auth.initialize() && auth != null) {
            HashSet alreadyReq = new HashSet();
            Set set = this.REQUESTED;
            synchronized (set) {
                alreadyReq.addAll(this.REQUESTED);
                this.setContentAuthority(auth);
            }
            Iterator i = alreadyReq.iterator();
            while (i.hasNext()) {
                URN urn = (URN)i.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending delayed request for URN: " + urn + " to: " + auth);
                }
                auth.send(new ContentRequest(urn));
            }
        }
    }

    private static class Validator
    implements ContentResponseObserver {
        private boolean gotResponse = false;
        private ContentResponseData response = null;

        private Validator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResponse(URN urn, ContentResponseData response) {
            Validator validator = this;
            synchronized (validator) {
                this.gotResponse = true;
                this.response = response;
                this.notify();
            }
        }

        public boolean hasResponse() {
            return this.gotResponse;
        }

        public ContentResponseData getResponse() {
            return this.response;
        }
    }

    private static class Responder
    implements Comparable {
        private final long dead;
        private final ContentResponseObserver observer;
        private final URN urn;

        Responder(long now, long timeout, ContentResponseObserver observer, URN urn) {
            this.dead = timeout != 0L ? now + timeout : 0L;
            this.observer = observer;
            this.urn = urn;
        }

        public int compareTo(Object a) {
            Responder o = (Responder)a;
            return this.dead < o.dead ? 1 : (this.dead > o.dead ? -1 : 0);
        }
    }
}

