/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import java.net.UnknownHostException;

public class IpPortContentAuthority
implements ContentAuthority {
    private IpPort authority;
    private String host;
    private int port;

    public IpPortContentAuthority(IpPort host) {
        this.authority = host;
        this.host = host.getAddress();
        this.port = host.getPort();
    }

    public IpPortContentAuthority(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void send(Message m) {
        UDPService.instance().send(m, this.authority);
    }

    public boolean initialize() {
        if (this.authority == null) {
            try {
                this.authority = new IpPortImpl(this.host, this.port);
            }
            catch (UnknownHostException uhe) {
                return false;
            }
        }
        return true;
    }

    public IpPort getIpPort() {
        return this.authority;
    }
}

