/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPHostCache {
    private static final Log LOG = LogFactory.getLog(UDPHostCache.class);
    private static final int MAXIMUM_FAILURES = 5;
    public static final int PERMANENT_SIZE = 100;
    public static final int FETCH_AMOUNT = 5;
    private final List udpHosts = new ArrayList(100);
    private final Set udpHostsSet = new HashSet();
    private final UDPPinger pinger;
    private final Set attemptedHosts;
    private boolean dirty = false;
    private boolean writeDirty = false;
    private static final Comparator FAILURE_COMPARATOR = new FailureComparator();

    public UDPHostCache(UDPPinger pinger) {
        this(600000L, pinger);
    }

    public UDPHostCache(long expiryTime, UDPPinger pinger) {
        this.attemptedHosts = new FixedSizeExpiringSet(100, expiryTime);
        this.pinger = pinger;
    }

    public synchronized void write(Writer out) throws IOException {
        Iterator iter = this.udpHosts.iterator();
        while (iter.hasNext()) {
            ExtendedEndpoint e = (ExtendedEndpoint)iter.next();
            e.write(out);
        }
        this.writeDirty = false;
    }

    public synchronized boolean isWriteDirty() {
        return this.writeDirty;
    }

    public synchronized int getSize() {
        return this.udpHostsSet.size();
    }

    public synchronized void resetData() {
        LOG.debug("Clearing attempted udp host caches");
        this.decrementFailures();
        this.attemptedHosts.clear();
    }

    protected synchronized void decrementFailures() {
        Iterator i = this.attemptedHosts.iterator();
        while (i.hasNext()) {
            ExtendedEndpoint ep = (ExtendedEndpoint)i.next();
            ep.decrementUDPHostCacheFailure();
            if (ep.getUDPHostCacheFailures() == 5 && this.udpHosts.size() < 100) {
                this.add(ep);
            }
            this.dirty = true;
            this.writeDirty = true;
        }
    }

    public synchronized boolean fetchHosts() {
        if (this.dirty) {
            Collections.shuffle(this.udpHosts);
            Collections.sort(this.udpHosts, FAILURE_COMPARATOR);
            this.dirty = false;
        }
        ArrayList validHosts = new ArrayList(Math.min(5, this.udpHosts.size()));
        LinkedList invalidHosts = new LinkedList();
        Iterator i = this.udpHosts.iterator();
        while (i.hasNext() && validHosts.size() < 5) {
            Object next = i.next();
            if (this.attemptedHosts.contains(next)) continue;
            if (NetworkUtils.isPrivateAddress(((ExtendedEndpoint)next).getAddress())) {
                invalidHosts.add(next);
                continue;
            }
            validHosts.add(next);
        }
        i = invalidHosts.iterator();
        while (i.hasNext()) {
            this.remove((ExtendedEndpoint)i.next());
        }
        this.attemptedHosts.addAll(validHosts);
        return this.fetch(validHosts);
    }

    protected synchronized boolean fetch(Collection hosts) {
        if (hosts.isEmpty()) {
            LOG.debug("No hosts to fetch");
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching endpoints from " + hosts + " host caches");
        }
        this.pinger.rank(hosts, new HostExpirer(hosts), new Cancellable(){

            public boolean isCancelled() {
                return RouterService.isConnected();
            }
        }, this.getPing());
        return true;
    }

    protected PingRequest getPing() {
        return PingRequest.createUHCPing();
    }

    public synchronized boolean remove(ExtendedEndpoint e) {
        boolean removed2;
        boolean removed1;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removing endpoint: " + e);
        }
        Assert.that((removed1 = this.udpHosts.remove(e)) == (removed2 = this.udpHostsSet.remove(e)), "Set " + removed1 + " but queue " + removed2);
        if (removed1) {
            this.writeDirty = true;
        }
        return removed1;
    }

    public synchronized boolean add(ExtendedEndpoint e) {
        Assert.that(e.isUDPHostCache());
        if (this.udpHostsSet.contains(e)) {
            return false;
        }
        if (this.udpHosts.size() >= 100) {
            Object removed = this.udpHosts.remove(this.udpHosts.size() - 1);
            this.udpHostsSet.remove(removed);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ejected: " + removed);
            }
        }
        this.udpHosts.add(e);
        this.udpHostsSet.add(e);
        this.dirty = true;
        this.writeDirty = true;
        return true;
    }

    public synchronized void hostCachesAdded() {
        if (this.udpHostsSet.isEmpty()) {
            this.loadDefaults();
        }
    }

    protected void loadDefaults() {
        this.createAndAdd("uhc2.limewire.com", 20181);
        this.createAndAdd("uhc3.limewire.com", 51180);
        this.createAndAdd("cache.kicks-ass.net", 8000);
        this.createAndAdd("gwc.jooz.net", 8010);
        this.createAndAdd("kisama.ath.cx", 8080);
        this.createAndAdd("krill.shacknet.nu", 20095);
        this.createAndAdd("uhc.udp-host-cache.com", 9999);
        this.createAndAdd("gwc2.908middle.us", 3559);
    }

    private void createAndAdd(String host, int port) {
        try {
            ExtendedEndpoint ep = new ExtendedEndpoint(host, port).setUDPHostCache(true);
            this.add(ep);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class FailureComparator
    implements Comparator {
        private FailureComparator() {
        }

        public int compare(Object a, Object b) {
            ExtendedEndpoint e1 = (ExtendedEndpoint)a;
            ExtendedEndpoint e2 = (ExtendedEndpoint)b;
            return e1.getUDPHostCacheFailures() - e2.getUDPHostCacheFailures();
        }
    }

    private class HostExpirer
    implements MessageListener {
        private final Set hosts = new IpPortSet();
        private final Set allHosts;
        private byte[] guid;

        public HostExpirer(Collection hostsToAdd) {
            this.hosts.addAll(hostsToAdd);
            this.allHosts = new HashSet(hostsToAdd);
            this.removeDuplicates(hostsToAdd, this.hosts);
        }

        private void removeDuplicates(Collection all, Collection some) {
            HashSet duplicates = new HashSet(all);
            duplicates.removeAll(some);
            Iterator i = duplicates.iterator();
            while (i.hasNext()) {
                ExtendedEndpoint ep = (ExtendedEndpoint)i.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing duplicate entry: " + ep);
                }
                UDPHostCache.this.remove(ep);
            }
        }

        public void processMessage(Message m, ReplyHandler handler) {
            if (handler instanceof UDPReplyHandler) {
                if (this.hosts.remove(handler) && LOG.isTraceEnabled()) {
                    LOG.trace("Recieved: " + m);
                }
                if (this.hosts.isEmpty()) {
                    RouterService.getMessageRouter().unregisterMessageListener(this.guid, this);
                }
            }
        }

        public void registered(byte[] g) {
            this.guid = g;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregistered(byte[] g) {
            UDPHostCache uDPHostCache = UDPHostCache.this;
            synchronized (uDPHostCache) {
                ExtendedEndpoint ep;
                Iterator i = this.hosts.iterator();
                while (i.hasNext()) {
                    ep = (ExtendedEndpoint)i.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No response from cache: " + ep);
                    }
                    ep.recordUDPHostCacheFailure();
                    UDPHostCache.this.dirty = true;
                    UDPHostCache.this.writeDirty = true;
                    if (ep.getUDPHostCacheFailures() <= 5) continue;
                    UDPHostCache.this.remove(ep);
                }
                this.allHosts.removeAll(this.hosts);
                i = this.allHosts.iterator();
                while (i.hasNext()) {
                    ep = (ExtendedEndpoint)i.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Valid response from cache: " + ep);
                    }
                    ep.recordUDPHostCacheSuccess();
                    UDPHostCache.this.dirty = true;
                    UDPHostCache.this.writeDirty = true;
                }
            }
        }
    }
}

