/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.bugs.RemoteClientInfo;
import com.limegroup.gnutella.bugs.ServletAccessor;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.version.Version;
import com.limegroup.gnutella.version.VersionFormatException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class BugManager {
    private static final BugManager INSTANCE = new BugManager();
    private static final String TITLE = GUIMediator.getStringResource("ERROR_INTERNAL_TITLE");
    private final ProcessingQueue BUGS_QUEUE = new ProcessingQueue("BugProcessor", false);
    private final Map BUG_TIMES = Collections.synchronizedMap(new HashMap());
    private final Object WRITE_LOCK = new Object();
    private static final byte[] SEPARATOR = "-----------------\n".getBytes();
    private volatile long _nextAllowedTime = 0L;
    private volatile int _dialogsShowing = 0;
    private static final int MAX_DIALOGS = 3;
    private boolean dirty = false;

    public static BugManager instance() {
        return INSTANCE;
    }

    private BugManager() {
        this.loadOldBugs();
    }

    public void shutdown() {
        this.writeBugsToDisk();
    }

    public void handleBug(Throwable bug, String threadName, String detail) {
        if (bug instanceof ThreadDeath) {
            throw (ThreadDeath)bug;
        }
        if (bug instanceof IOException && IOUtils.handleException((IOException)bug, null)) {
            return;
        }
        bug.printStackTrace();
        LocalClientInfo info = new LocalClientInfo(bug, threadName, detail, false);
        if (BugSettings.LOG_BUGS_LOCALLY.getValue()) {
            this.logBugLocally(info);
        }
        boolean sent = false;
        if (!CommonUtils.isTestingVersion()) {
            if (BugSettings.IGNORE_ALL_BUGS.getValue()) {
                return;
            }
            if (!this.shouldInform(info)) {
                return;
            }
            if (BugSettings.USE_BUG_SERVLET.getValue() && this.isSendableVersion()) {
                sent = true;
                this.sendToServlet(info);
            }
        }
        if (!sent && this._dialogsShowing < 3) {
            this.reviewBug(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logBugLocally(LocalClientInfo info) {
        File f = BugSettings.BUG_LOG_FILE.getValue();
        FileUtils.setWriteable(f);
        OutputStream os = null;
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            if (f.length() > (long)BugSettings.MAX_BUGFILE_SIZE.getValue()) {
                f.delete();
            }
            os = new BufferedOutputStream(new FileOutputStream(f.getPath(), true));
            os.write((new Date().toString() + "\n").getBytes());
            os.write(info.toBugReport().getBytes());
            os.write(SEPARATOR);
            os.flush();
        }
        Object var7_7 = null;
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException ignored2) {}
        return;
        {
            catch (IOException ignored) {
                Object var7_8 = null;
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException ignored2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException ignored2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadOldBugs() {
        ObjectInputStream in;
        block10: {
            in = null;
            File f = BugSettings.BUG_INFO_FILE.getValue();
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
            String version = (String)in.readObject();
            long nextTime = in.readLong();
            Map bugs = (Map)in.readObject();
            if (version.equals(CommonUtils.getLimeWireVersion())) {
                this._nextAllowedTime = nextTime;
                long now = System.currentTimeMillis();
                Iterator i = bugs.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Long allowed = (Long)entry.getValue();
                    if (allowed == null || now >= allowed) continue;
                    this.BUG_TIMES.put(entry.getKey(), allowed);
                }
                break block10;
            }
            if (!BugSettings.IGNORE_ALL_BUGS.getValue()) break block10;
            BugSettings.IGNORE_ALL_BUGS.setValue(false);
            BugSettings.USE_BUG_SERVLET.setValue(false);
        }
        Object var13_11 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (Throwable t) {}
        return;
        {
            catch (Throwable throwable) {
                Object var13_12 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (Throwable t) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeBugsToDisk() {
        var1_1 = this.WRITE_LOCK;
        synchronized (var1_1) {
            block15: {
                if (!this.dirty) {
                    return;
                }
                out = null;
                try {
                    f = BugSettings.BUG_INFO_FILE.getValue();
                    out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
                    version = CommonUtils.getLimeWireVersion();
                    out.writeObject(version);
                    out.writeLong(this._nextAllowedTime);
                    out.writeObject(this.BUG_TIMES);
                    out.flush();
                    var6_6 = null;
                    ** if (out == null) goto lbl-1000
                }
                catch (Throwable var5_12) {
                    var6_8 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw var5_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (Exception var3_4) {
                        var6_7 = null;
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
            this.dirty = false;
        }
    }

    private boolean shouldInform(LocalClientInfo info) {
        long now = System.currentTimeMillis();
        if (now < this._nextAllowedTime) {
            return false;
        }
        Long allowed = (Long)this.BUG_TIMES.get(info.getParsedBug());
        return allowed == null || now >= allowed;
    }

    private boolean isSendableVersion() {
        Version lastVersion;
        Version myVersion;
        try {
            myVersion = new Version(CommonUtils.getLimeWireVersion());
            lastVersion = new Version(BugSettings.LAST_ACCEPTABLE_VERSION.getValue());
        }
        catch (VersionFormatException vfe) {
            return false;
        }
        return myVersion.compareTo(lastVersion) >= 0;
    }

    private static String warning() {
        String msg = "Uijt!jt!MjnfXjsf/!Uif!pggjdjbm!xfctjuf!jt!xxx/mjnfxjsf/dpn/";
        StringBuffer ret = new StringBuffer(msg.length());
        for (int i = 0; i < msg.length(); ++i) {
            ret.append((char)(msg.charAt(i) - '\u0001'));
        }
        return ret.toString();
    }

    private void reviewBug(final LocalClientInfo info) {
        ++this._dialogsShowing;
        final JDialog DIALOG = new JDialog(GUIMediator.getAppFrame(), TITLE, true);
        Dimension DIALOG_DIMENSION = new Dimension(100, 300);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        boolean sendable = this.isSendableVersion();
        String msg = sendable ? GUIMediator.getStringResource("ERROR_INTERNAL_SERVLET") : GUIMediator.getStringResource("ERROR_INTERNAL_OLD");
        msg = BugManager.warning() + "\n\n" + msg;
        MultiLineLabel label = new MultiLineLabel(msg, 400);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(label);
        JPanel buttonPanel = new JPanel();
        JButton sendButton = new JButton(GUIMediator.getStringResource("ERROR_INTERNAL_SEND"));
        sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BugManager.this.sendToServlet(info);
                DIALOG.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        JButton reviewButton = new JButton(GUIMediator.getStringResource("ERROR_INTERNAL_REVIEW"));
        reviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextArea textArea = new JTextArea(info.toBugReport());
                textArea.setColumns(50);
                textArea.setEditable(false);
                textArea.setCaretPosition(0);
                JScrollPane scroller = new JScrollPane(textArea);
                scroller.setBorder(BorderFactory.createEtchedBorder());
                scroller.setPreferredSize(new Dimension(500, 200));
                MessageService.instance().showMessage(scroller);
            }
        });
        JButton discardButton = new JButton(GUIMediator.getStringResource("ERROR_INTERNAL_DISCARD"));
        discardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        if (sendable) {
            buttonPanel.add(sendButton);
        }
        buttonPanel.add(reviewButton);
        buttonPanel.add(discardButton);
        JPanel optionsPanel = new JPanel();
        JPanel innerPanel = new JPanel();
        ButtonGroup bg = new ButtonGroup();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        optionsPanel.setLayout(new BorderLayout());
        final JRadioButton alwaysSend = new JRadioButton(GUIMediator.getStringResource("ERROR_INTERNAL_ALWAYS_SEND"));
        final JRadioButton alwaysReview = new JRadioButton(GUIMediator.getStringResource("ERROR_INTERNAL_ALWAYS_REVIEW"));
        final JRadioButton alwaysDiscard = new JRadioButton(GUIMediator.getStringResource("ERROR_INTERNAL_ALWAYS_DISCARD"));
        innerPanel.add(Box.createVerticalStrut(6));
        if (!CommonUtils.isTestingVersion()) {
            if (sendable) {
                innerPanel.add(alwaysSend);
            }
            innerPanel.add(alwaysReview);
            innerPanel.add(alwaysDiscard);
        }
        innerPanel.add(Box.createVerticalStrut(6));
        optionsPanel.add((Component)innerPanel, "West");
        bg.add(alwaysSend);
        bg.add(alwaysReview);
        bg.add(alwaysDiscard);
        bg.setSelected(alwaysReview.getModel(), true);
        ActionListener alwaysListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == alwaysSend) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(false);
                    BugSettings.USE_BUG_SERVLET.setValue(true);
                } else if (e.getSource() == alwaysReview) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(false);
                    BugSettings.USE_BUG_SERVLET.setValue(false);
                } else if (e.getSource() == alwaysDiscard) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(true);
                }
            }
        };
        alwaysSend.addActionListener(alwaysListener);
        alwaysReview.addActionListener(alwaysListener);
        alwaysDiscard.addActionListener(alwaysListener);
        mainPanel.add(labelPanel);
        mainPanel.add(optionsPanel);
        mainPanel.add(buttonPanel);
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        if (GUIMediator.isAppVisible()) {
            DIALOG.setLocationRelativeTo(MessageService.getParentComponent());
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = DIALOG.getSize();
            DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        }
        try {
            DIALOG.setVisible(true);
        }
        catch (InternalError ie) {
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            // empty catch block
        }
    }

    private void servletSendFailed(LocalClientInfo info) {
        ++this._dialogsShowing;
        final JDialog DIALOG = new JDialog(GUIMediator.getAppFrame(), TITLE, true);
        Dimension DIALOG_DIMENSION = new Dimension(350, 300);
        Dimension ERROR_DIMENSION = new Dimension(300, 200);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        MultiLineLabel label = new MultiLineLabel(GUIMediator.getStringResource("ERROR_INTERNAL_SERVLET_FAILED"), 400);
        JPanel labelPanel = new JPanel();
        JPanel innerPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.add(label);
        innerPanel.add(Box.createVerticalStrut(6));
        labelPanel.add(innerPanel);
        labelPanel.add(Box.createHorizontalGlue());
        String bugInfo = info.toBugReport().trim() + "\n\n" + "FILES IN CURRENT DIRECTORY NOT LISTED.\n" + "SIZE: 0";
        final JTextArea textArea = new JTextArea(bugInfo);
        textArea.selectAll();
        textArea.copy();
        textArea.setColumns(50);
        textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setBorder(BorderFactory.createEtchedBorder());
        scroller.setPreferredSize(ERROR_DIMENSION);
        JPanel buttonPanel = new JPanel();
        JButton copyButton = new JButton(GUIMediator.getStringResource("ERROR_INTERNAL_COPY"));
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textArea.selectAll();
                textArea.copy();
                textArea.setCaretPosition(0);
            }
        });
        JButton quitButton = new JButton(GUIMediator.getStringResource("ERROR_INTERNAL_OK"));
        quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        buttonPanel.add(copyButton);
        buttonPanel.add(quitButton);
        mainPanel.add(labelPanel);
        mainPanel.add(scroller);
        mainPanel.add(buttonPanel);
        DIALOG.getContentPane().add(mainPanel);
        try {
            DIALOG.pack();
        }
        catch (OutOfMemoryError oome) {
            return;
        }
        if (GUIMediator.isAppVisible()) {
            DIALOG.setLocationRelativeTo(MessageService.getParentComponent());
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = DIALOG.getSize();
            DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        }
        DIALOG.show();
    }

    private void sendToServlet(LocalClientInfo info) {
        this.BUGS_QUEUE.add(new ServletSender(info));
    }

    static /* synthetic */ void access$300(BugManager x0, LocalClientInfo x1) {
        x0.servletSendFailed(x1);
    }

    private class ServletSender
    implements Runnable {
        final LocalClientInfo INFO;

        ServletSender(LocalClientInfo info) {
            this.INFO = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RemoteClientInfo remoteInfo = new ServletAccessor().getRemoteBugInfo(this.INFO);
            if (remoteInfo == null) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ServletSender this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        BugManager.access$300(ServletSender.access$200(this.this$1), this.this$1.INFO);
                    }
                });
                return;
            }
            long now = System.currentTimeMillis();
            long thisNextTime = remoteInfo.getNextThisBugTime();
            long anyNextTime = remoteInfo.getNextAnyBugTime();
            Object object = BugManager.this.WRITE_LOCK;
            synchronized (object) {
                if (anyNextTime != 0L) {
                    BugManager.this._nextAllowedTime = now + thisNextTime;
                    BugManager.this.dirty = true;
                }
                if (thisNextTime != 0L) {
                    BugManager.this.BUG_TIMES.put(this.INFO.getParsedBug(), new Long(now + thisNextTime));
                    BugManager.this.dirty = true;
                }
                BugManager.this.writeBugsToDisk();
            }
        }

        static /* synthetic */ BugManager access$200(ServletSender x0) {
            return x0.BugManager.this;
        }
    }
}

