/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionChecker
implements Runnable {
    private volatile boolean _connected;
    private int _unsuccessfulAttempts;
    private boolean _triedSP2Workaround;
    private static final Log LOG = LogFactory.getLog(ConnectionChecker.class);
    private static String[] STANDARD_HOSTS = new String[]{"www.wanadoo.fr", "www.tiscali.com", "www.ntt.com", "www.tonline.com", "www.download.com", "www.ibm.com", "www.sun.com", "www.apple.com", "www.ebay.com", "www.sun.com", "www.monster.com", "www.uunet.com", "www.real.com", "www.microsoft.com", "www.sco.com", "www.google.com", "www.cnn.com", "www.amazon.com", "www.espn.com", "www.yahoo.com", "www.oracle.com", "www.dell.com", "www.ge.com", "www.sprint.com", "www.att.com", "www.mci.com", "www.cisco.com", "www.intel.com", "www.motorola.com", "www.hp.com", "www.gateway.com", "www.sony.com", "www.ford.com", "www.gm.com", "www.aol.com", "www.verizon.com", "www.passport.com", "www.go.com", "www.overture.com", "www.earthlink.net", "www.bellsouth.net", "www.excite.com", "www.paypal.com", "www.altavista.com", "www.weather.com", "www.mapquest.com", "www.geocities.com", "www.juno.com", "www.msnbc.com", "www.lycos.com", "www.comcast.com"};
    private static ConnectionChecker current;

    private ConnectionChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionChecker checkForLiveConnection() {
        ConnectionChecker checker;
        LOG.trace("checking for live connection");
        boolean startThread = false;
        Class clazz = ConnectionChecker.class;
        synchronized (clazz) {
            if (current == null) {
                startThread = true;
                current = new ConnectionChecker();
            }
            checker = current;
        }
        if (startThread) {
            LOG.debug("Starting a new connection-checker thread");
            ThreadFactory.startThread(checker, "check for live connection");
        }
        return checker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        block14: {
            block13: {
                Class clazz;
                block15: {
                    block11: {
                        block12: {
                            try {
                                List<String> hostList = Arrays.asList(STANDARD_HOSTS);
                                Collections.shuffle(hostList);
                                Iterator<String> iter = hostList.iterator();
                                while (iter.hasNext()) {
                                    String curHost = iter.next();
                                    this.connectToHost(curHost);
                                    if (this._connected) {
                                        LOG.debug("Connection exists.");
                                        if (this._triedSP2Workaround && !RouterService.isConnected() && !RouterService.isConnecting()) {
                                            LOG.debug("Reconnecting RouterService");
                                            RouterService.connect();
                                        }
                                        Object var5_4 = null;
                                        if (class$com$limegroup$gnutella$connection$ConnectionChecker != null) break block11;
                                        break block12;
                                    }
                                    if (this._unsuccessfulAttempts <= 2) continue;
                                    LOG.debug("Failed connection check more than twice.");
                                    if (this._triedSP2Workaround || !CommonUtils.isWindowsXP()) {
                                        RouterService.getConnectionManager().noInternetConnection();
                                        break block13;
                                    }
                                    this._triedSP2Workaround = true;
                                    this.trySP2Workaround();
                                }
                                break block14;
                            }
                            catch (Throwable throwable) {
                                Object var5_7 = null;
                                Class clazz2 = ConnectionChecker.class;
                                synchronized (clazz2) {
                                    current = null;
                                    throw throwable;
                                }
                            }
                        }
                        clazz = class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker");
                        break block15;
                    }
                    clazz = class$com$limegroup$gnutella$connection$ConnectionChecker;
                }
                Class clazz3 = clazz;
                synchronized (clazz) {
                    current = null;
                    // ** MonitorExit[var6_8] (shouldn't be in output)
                    return;
                }
            }
            Object var5_5 = null;
            Class clazz = ConnectionChecker.class;
            synchronized (clazz) {
                current = null;
                return;
            }
        }
        Object var5_6 = null;
        Class clazz = ConnectionChecker.class;
        synchronized (clazz) {
            current = null;
            return;
        }
    }

    private void trySP2Workaround() {
        if (this.hasNoTransfers() && this.udpIsDead()) {
            return;
        }
        this.killAndSleep();
    }

    private boolean hasNoTransfers() {
        RouterService.getDownloadManager().measureBandwidth();
        float down = RouterService.getDownloadManager().getMeasuredBandwidth();
        if (down != 0.0f) {
            return false;
        }
        RouterService.getUploadManager().measureBandwidth();
        float up = RouterService.getUploadManager().getMeasuredBandwidth();
        return up == 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean udpIsDead() {
        PingRequest ping = PingRequest.createUDPPing();
        Collection hosts = RouterService.getPreferencedHosts(false, "en", 50);
        UDPPinger myPinger = RouterService.getHostCatcher().getPinger();
        UDPChecker checker = new UDPChecker();
        myPinger.rank(hosts, checker, checker, ping);
        long now = System.currentTimeMillis();
        UDPChecker uDPChecker = checker;
        synchronized (uDPChecker) {
            try {
                for (int i = 0; i < 5; ++i) {
                    checker.wait(1000L);
                    if (UDPService.instance().getLastReceivedTime() <= now) continue;
                    checker.received = true;
                    return false;
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        return !checker.received;
    }

    private void killAndSleep() {
        RouterService.disconnect();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._unsuccessfulAttempts = 0;
    }

    public boolean hasConnected() {
        return this._connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToHost(String host) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking for connection with host: " + host);
        }
        try {
            Observer observer;
            InetAddress.getByName(host);
            Observer observer2 = observer = new Observer();
            synchronized (observer2) {
                Socket s = Sockets.connect(host, 80, 6000, observer);
                LOG.debug("Waiting for callback...");
                try {
                    observer.wait(12000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!observer.hasResponse()) {
                    LOG.debug("No response!");
                    if (Sockets.removeConnectObserver(observer)) {
                        LOG.debug("Removed observer");
                        ++this._unsuccessfulAttempts;
                        IOUtils.close(s);
                    }
                }
            }
        }
        catch (IOException bad) {
            LOG.debug("failed to resolve name", bad);
            ++this._unsuccessfulAttempts;
        }
    }

    private class UDPChecker
    implements MessageListener,
    Cancellable {
        volatile boolean received;

        private UDPChecker() {
        }

        public boolean isCancelled() {
            return this.received;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMessage(Message m, ReplyHandler handler) {
            this.received = true;
            UDPChecker uDPChecker = this;
            synchronized (uDPChecker) {
                this.notify();
            }
        }

        public void registered(byte[] guid) {
        }

        public void unregistered(byte[] guid) {
        }
    }

    private class Observer
    implements ConnectObserver {
        boolean response = false;

        private Observer() {
        }

        public void handleIOException(IOException iox) {
        }

        public synchronized void handleConnect(Socket socket) throws IOException {
            if (!this.response) {
                LOG.debug("Socket connected OK");
                this.response = true;
                ConnectionChecker.this._connected = true;
                this.notify();
                IOUtils.close(socket);
            }
        }

        public synchronized void shutdown() {
            if (!this.response) {
                LOG.debug("Socket failed to connect");
                this.response = true;
                ConnectionChecker.this._unsuccessfulAttempts++;
                this.notify();
            }
        }

        public boolean hasResponse() {
            return this.response;
        }
    }
}

