/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.AssertFailure;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DownloadState;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.statistics.NumericalDownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadWorker {
    private static final Log LOG = LogFactory.getLog(DownloadWorker.class);
    private static final int MIN_SPLIT_SIZE = 16384;
    private static final float MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    private static final int UNKNOWN_SPEED = -1;
    private static final int NORMAL_CONNECT_TIME = 10000;
    private static final int PUSH_CONNECT_TIME = 20000;
    private static final int UDP_PUSH_CONNECT_TIME = 6000;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    public static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    private final ManagedDownloader _manager;
    private final RemoteFileDesc _rfd;
    private final VerifyingFile _commonOutFile;
    private volatile boolean _interrupted;
    private volatile HTTPDownloader _downloader;
    private volatile boolean _shouldRelease;
    private final String _workerName;
    private DirectConnector _connectObserver;
    private DownloadState _currentState;
    private volatile boolean _stealing;

    DownloadWorker(ManagedDownloader manager, RemoteFileDesc rfd, VerifyingFile vf) {
        this._manager = manager;
        this._rfd = rfd;
        this._commonOutFile = vf;
        this._currentState = new DownloadState();
        this._workerName = LOG.isDebugEnabled() ? "DownloadWorker for " + this._manager.getSaveFile().getName() + " #" + System.identityHashCode(this) : "DownloaderWorker";
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting worker: " + this._workerName);
        }
        this.establishConnection();
    }

    private void initializeAlternateLocations() {
        AlternateLocation current;
        int count;
        Iterator iter = this._manager.getValidAlts().iterator();
        for (count = 0; iter.hasNext() && count < 10; ++count) {
            current = (AlternateLocation)iter.next();
            this._downloader.addSuccessfulAltLoc(current);
        }
        iter = this._manager.getInvalidAlts().iterator();
        for (count = 0; iter.hasNext() && count < 10; ++count) {
            current = (AlternateLocation)iter.next();
            this._downloader.addFailedAltLoc(current);
        }
    }

    private void httpLoop() {
        LOG.debug("Starting HTTP Loop");
        this.incrementState(null);
    }

    public void incrementState(ConnectionStatus status) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("WORKER: " + this + ", State Changed, Current: " + this._currentState + ", status: " + status);
        }
        if (this._interrupted) {
            this.finishHttpLoop();
            return;
        }
        switch (this._currentState.getCurrentState()) {
            case 6: {
                this.releaseRanges();
            }
            case 0: 
            case 5: {
                this._currentState.setHttp11(this._rfd.isHTTP11());
                this._currentState.setState(1);
                if (this.requestTHEXIfNeeded()) break;
            }
            case 1: {
                this._currentState.setState(2);
                if (this.downloadThexIfNeeded()) break;
            }
            case 2: {
                this._currentState.setState(3);
                if (this.consumeBodyIfNeeded()) break;
            }
            case 3: {
                this._downloader.forgetRanges();
                if (status == null || !status.isQueued()) {
                    this._currentState.setState(4);
                    if (this.assignAndRequest()) break;
                    this.finishHttpLoop();
                    break;
                }
            }
            case 4: {
                this.httpRequestFinished(status);
                break;
            }
            default: {
                throw new IllegalStateException("bad state: " + this._currentState);
            }
        }
    }

    private boolean consumeBodyIfNeeded() {
        if (this._downloader.isBodyConsumed()) {
            LOG.debug("Not consuming body.");
            return false;
        }
        this._downloader.consumeBody(new State(){

            protected void handleState(boolean success) {
                if (!success) {
                    DownloadWorker.this.handleRFDFailure(DownloadWorker.this._rfd);
                }
            }
        });
        return true;
    }

    private void handleRFDFailure(RemoteFileDesc rfd) {
        this._rfd.incrementFailedCount();
        if (this._rfd.getFailedCount() < 2) {
            this._rfd.setRetryAfter(60);
            this._manager.addRFD(this._rfd);
        } else {
            this._manager.informMesh(this._rfd, false);
        }
    }

    private void httpRequestFinished(ConnectionStatus status) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP req finished, status: " + status);
        }
        this._manager.addPossibleSources(this._downloader.getLocationsReceived());
        if (status.isNoData() || status.isNoFile()) {
            this.finishHttpLoop();
        } else {
            if (!status.isConnected()) {
                this.releaseRanges();
            }
            if (!status.isQueued()) {
                this._manager.removeQueuedWorker(this);
            }
            if (status.isPartialData()) {
                this._currentState.setState(0);
                this.incrementState(null);
            } else {
                Assert.that(status.isQueued() || status.isConnected());
                boolean queued = this._manager.killQueuedIfNecessary(this, !status.isQueued() ? -1 : status.getQueuePosition());
                if (status.isConnected()) {
                    this._currentState.setState(6);
                    this.beginDownload();
                } else if (!queued) {
                    this.finishHttpLoop();
                } else {
                    this.handleQueued(status);
                }
            }
        }
    }

    private void beginDownload() {
        try {
            this._downloader.doDownload(new State(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleState(boolean success) {
                    if (success) {
                        DownloadWorker.this._rfd.resetFailedCount();
                        if (DownloadWorker.this._currentState.isHttp11()) {
                            DownloadStat.SUCCESSFUL_HTTP11.incrementStat();
                        } else {
                            DownloadStat.SUCCESSFUL_HTTP10.incrementStat();
                        }
                    } else {
                        if (DownloadWorker.this._currentState.isHttp11()) {
                            DownloadStat.FAILED_HTTP11.incrementStat();
                        } else {
                            DownloadStat.FAILED_HTTP10.incrementStat();
                        }
                        DownloadWorker.this._manager.workerFailed(DownloadWorker.this);
                    }
                    if (DownloadWorker.this._commonOutFile.isHopeless()) {
                        DownloadWorker.this._manager.promptAboutCorruptDownload();
                    }
                    int stop = DownloadWorker.this._downloader.getInitialReadingPoint() + DownloadWorker.this._downloader.getAmountRead();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WORKER: terminating from " + DownloadWorker.this._downloader + " at " + stop + " error? " + !success);
                    }
                    ManagedDownloader managedDownloader = DownloadWorker.this._manager;
                    synchronized (managedDownloader) {
                        if (!success) {
                            DownloadWorker.this._downloader.stop();
                            DownloadWorker.this.handleRFDFailure(DownloadWorker.this._rfd);
                        } else {
                            DownloadWorker.this._manager.informMesh(DownloadWorker.this._rfd, true);
                            if (!DownloadWorker.this._currentState.isHttp11()) {
                                DownloadWorker.this._manager.addRFD(DownloadWorker.this._rfd);
                            }
                        }
                    }
                }
            });
        }
        catch (SocketException se) {
            this.finishHttpLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestTHEXIfNeeded() {
        boolean shouldRequest = false;
        VerifyingFile verifyingFile = this._commonOutFile;
        synchronized (verifyingFile) {
            if (!this._commonOutFile.isHashTreeRequested()) {
                HashTree ourTree = this._commonOutFile.getHashTree();
                boolean bl = shouldRequest = this._downloader.hasHashTree() && this._manager.getSHA1Urn() != null && (ourTree == null || !ourTree.isDepthGoodEnough());
                if (shouldRequest) {
                    this._commonOutFile.setHashTreeRequested(true);
                }
            }
        }
        if (shouldRequest) {
            this._downloader.requestHashTree(this._manager.getSHA1Urn(), new State(){

                protected void handleState(boolean success) {
                }
            });
        }
        return shouldRequest;
    }

    private boolean downloadThexIfNeeded() {
        if (!this._downloader.isRequestingThex()) {
            return false;
        }
        ConnectionStatus status = this._downloader.parseThexResponseHeaders();
        if (!status.isConnected()) {
            this._rfd.setTHEXFailed();
            this.incrementState(status);
        } else {
            this._manager.removeQueuedWorker(this);
            this._downloader.downloadThexBody(this._manager.getSHA1Urn(), new State(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleState(boolean success) {
                    VerifyingFile verifyingFile = DownloadWorker.this._commonOutFile;
                    synchronized (verifyingFile) {
                        HashTree oldTree;
                        DownloadWorker.this._commonOutFile.setHashTreeRequested(false);
                        HashTree newTree = DownloadWorker.this._downloader.getHashTree();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Downloaded tree: " + newTree);
                        }
                        if (newTree != null && newTree.isBetterTree(oldTree = DownloadWorker.this._commonOutFile.getHashTree())) {
                            DownloadWorker.this._commonOutFile.setHashTree(newTree);
                        }
                    }
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRanges() {
        int high;
        int low;
        HTTPDownloader downloader;
        if (!this._shouldRelease) {
            return;
        }
        this._shouldRelease = false;
        if (this._commonOutFile.isComplete()) {
            return;
        }
        HTTPDownloader hTTPDownloader = downloader = this._downloader;
        synchronized (hTTPDownloader) {
            low = downloader.getInitialReadingPoint() + downloader.getAmountRead();
            low = Math.max(low, downloader.getInitialWritingPoint());
            high = downloader.getInitialReadingPoint() + downloader.getAmountToRead() - 1;
        }
        if (high - low >= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("releasing ranges " + new Interval(low, high));
            }
            try {
                this._commonOutFile.releaseBlock(new Interval(low, high));
            }
            catch (AssertFailure bad) {
                downloader.createAssertionReport(bad);
            }
            downloader.forgetRanges();
        } else {
            LOG.debug("nothing to release!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueued(ConnectionStatus status) {
        this._manager.removeActiveWorker(this);
        DownloadState downloadState = this._currentState;
        synchronized (downloadState) {
            if (this._interrupted) {
                LOG.debug("Exiting from queueing");
                return;
            }
            LOG.debug("Queueing");
            this._currentState.setState(5);
        }
        RouterService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOG.debug("Queue time up");
                DownloadState downloadState = DownloadWorker.this._currentState;
                synchronized (downloadState) {
                    if (DownloadWorker.this._interrupted) {
                        LOG.warn("WORKER: interrupted while waiting in queue " + DownloadWorker.this._downloader);
                        return;
                    }
                }
                NIODispatcher.instance().invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        5.access$900(this.this$1).incrementState(null);
                    }
                });
            }

            static /* synthetic */ DownloadWorker access$900(5 x0) {
                return x0.DownloadWorker.this;
            }
        }, status.getQueuePollTime(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("establishConnection(" + this._rfd + ")");
        }
        if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted) {
            this._manager.addRFD(this._rfd);
            this.finishWorker();
            return;
        }
        boolean needsPush = this._rfd.needsPush();
        ManagedDownloader managedDownloader = this._manager;
        synchronized (managedDownloader) {
            int state = this._manager.getState();
            if (this._manager.getNumDownloaders() == 0 && state != 4 && state != 5 && state != 6 && state != 7 && state != 9 && state != 11 && state != 12) {
                if (this._interrupted) {
                    return;
                }
                this._manager.setState(1);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WORKER: attempting connect to " + this._rfd.getHost() + ":" + this._rfd.getPort());
        }
        DownloadStat.CONNECTION_ATTEMPTS.incrementStat();
        if (this._rfd.isReplyToMulticast()) {
            this.connectWithPush(new PushConnector(false, true));
        } else if (!needsPush) {
            this.connectDirectly(new DirectConnector(true));
        } else {
            this.connectWithPush(new PushConnector(true, false));
        }
    }

    private boolean finishConnect() {
        if (this._downloader == null) {
            this._manager.informMesh(this._rfd, false);
            return false;
        }
        if (this._interrupted) {
            this._downloader.stop();
            this._downloader = null;
            return false;
        }
        return true;
    }

    private void connectDirectly(DirectConnector observer) {
        if (!this._interrupted) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("WORKER: attempt asynchronous direct connection to: " + this._rfd);
            }
            this._connectObserver = observer;
            try {
                Socket socket = Sockets.connect(this._rfd.getHost(), this._rfd.getPort(), 10000, observer);
                if (!observer.isShutdown()) {
                    observer.setSocket(socket);
                }
            }
            catch (IOException iox) {
                observer.shutdown();
            }
        } else {
            this.finishWorker();
        }
    }

    private void connectWithPush(PushConnector observer) {
        if (!this._interrupted) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("WORKER: attempt push connection to: " + this._rfd);
            }
            this._connectObserver = null;
            final PushDetails details = new PushDetails(this._rfd.getClientGUID(), this._rfd.getHost());
            observer.setPushDetails(details);
            this._manager.registerPushObserver(observer, details);
            RouterService.getDownloadManager().sendPush(this._rfd, observer);
            RouterService.schedule(new Runnable(){

                public void run() {
                    DownloadWorker.this._manager.unregisterPushObserver(details, true);
                }
            }, this._rfd.isFromAlternateLocation() ? 6000L : 20000L, 0L);
        } else {
            this.finishWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInfo() {
        if (this._downloader != null) {
            HTTPDownloader hTTPDownloader = this._downloader;
            synchronized (hTTPDownloader) {
                return this + "hashcode " + System.identityHashCode(this._downloader) + " will release? " + this._shouldRelease + " interrupted? " + this._interrupted + " active? " + this._downloader.isActive() + " victim? " + this._downloader.isVictim() + " initial reading " + this._downloader.getInitialReadingPoint() + " initial writing " + this._downloader.getInitialWritingPoint() + " amount to read " + this._downloader.getAmountToRead() + " amount read " + this._downloader.getAmountRead() + " is in stealing " + this.isStealing() + "\n";
            }
        }
        return "worker not started";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assignAndRequest() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("assignAndRequest for: " + this._rfd);
        }
        Interval interval = null;
        try {
            VerifyingFile verifyingFile = this._commonOutFile;
            synchronized (verifyingFile) {
                if (this._commonOutFile.hasFreeBlocksToAssign() > 0) {
                    interval = this.pickAvailableInterval();
                }
            }
        }
        catch (NoSuchRangeException nsre) {
            this.handleNoRanges();
            return false;
        }
        if (interval == null) {
            if (!this.assignGrey()) {
                return false;
            }
        } else {
            this.assignWhite(interval);
        }
        return true;
    }

    private void completeAssignAndRequest(IOException x, Interval range, DownloadWorker victim) {
        ConnectionStatus status = this.completeAssignAndRequestImpl(x, range, victim);
        if (victim != null) {
            victim.setStealing(false);
            this.setStealing(false);
        }
        this.incrementState(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus completeAssignAndRequestImpl(IOException x, Interval range, DownloadWorker victim) {
        try {
            try {
                this._downloader.parseHeaders();
            }
            finally {
                if (x != null) {
                    throw x;
                }
            }
            if (victim == null) {
                this.completeAssignWhite(range);
            } else {
                this.completeAssignGrey(victim, range);
            }
        }
        catch (NoSuchElementException nsex) {
            DownloadStat.NSE_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, nsex);
            return this.handleNoMoreDownloaders();
        }
        catch (NoSuchRangeException nsrx) {
            LOG.debug(this._downloader, nsrx);
            return this.handleNoRanges();
        }
        catch (TryAgainLaterException talx) {
            DownloadStat.TAL_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, talx);
            return this.handleTryAgainLater();
        }
        catch (RangeNotAvailableException rnae) {
            DownloadStat.RNA_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, rnae);
            return this.handleRangeNotAvailable();
        }
        catch (FileNotFoundException fnfx) {
            DownloadStat.FNF_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, fnfx);
            return this.handleFileNotFound();
        }
        catch (NotSharingException nsx) {
            DownloadStat.NS_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, nsx);
            return this.handleNotSharing();
        }
        catch (QueuedException qx) {
            DownloadStat.Q_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, qx);
            return this.handleQueued(qx.getQueuePosition(), qx.getMinPollTime());
        }
        catch (ProblemReadingHeaderException prhe) {
            DownloadStat.PRH_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, prhe);
            return this.handleProblemReadingHeader();
        }
        catch (UnknownCodeException uce) {
            DownloadStat.UNKNOWN_CODE_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, uce);
            return this.handleUnknownCode();
        }
        catch (ContentUrnMismatchException cume) {
            DownloadStat.CONTENT_URN_MISMATCH_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, cume);
            return ConnectionStatus.getNoFile();
        }
        catch (IOException iox) {
            DownloadStat.IO_EXCEPTION.incrementStat();
            LOG.debug(this._downloader, iox);
            return this.handleIO();
        }
        DownloadStat.RESPONSE_OK.incrementStat();
        if (this._rfd.getFailedCount() > 0) {
            DownloadStat.RETRIED_SUCCESS.incrementStat();
        }
        this._rfd.resetFailedCount();
        ManagedDownloader managedDownloader = this._manager;
        synchronized (managedDownloader) {
            if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted) {
                LOG.trace("Stopped in assignAndRequest");
                this._manager.addRFD(this._rfd);
                return ConnectionStatus.getNoData();
            }
            this._manager.workerStarted(this);
        }
        return ConnectionStatus.getConnected();
    }

    private void assignWhite(Interval interval) {
        final int low = interval.low;
        final int high = interval.high;
        this._shouldRelease = true;
        this._downloader.connectHTTP(low, high + 1, true, this._commonOutFile.getBlockSize(), new IOStateObserver(){

            public void handleStatesFinished() {
                DownloadWorker.this.completeAssignAndRequest(null, new Interval(low, high), null);
            }

            public void handleIOException(IOException iox) {
                DownloadWorker.this.completeAssignAndRequest(iox, null, null);
            }

            public void shutdown() {
                DownloadWorker.this.completeAssignAndRequest(new IOException("shutdown"), null, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAssignWhite(Interval expectedRange) {
        HTTPDownloader hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader) {
            int low = expectedRange.low;
            int high = expectedRange.high;
            int newLow = this._downloader.getInitialReadingPoint();
            int newHigh = this._downloader.getAmountToRead() - 1 + newLow;
            if (newHigh - newLow >= 0) {
                if (newLow > low) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WORKER: Host gave subrange, different low.  Was: " + low + ", is now: " + newLow);
                    }
                    this._commonOutFile.releaseBlock(new Interval(low, newLow - 1));
                }
                if (newHigh < high) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WORKER: Host gave subrange, different high.  Was: " + high + ", is now: " + newHigh);
                    }
                    this._commonOutFile.releaseBlock(new Interval(newHigh + 1, high));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WORKER: assigning white " + newLow + "-" + newHigh + " to " + this._downloader);
                }
            } else {
                LOG.debug("debouched at birth");
            }
        }
    }

    private Interval pickAvailableInterval() throws NoSuchRangeException {
        Interval interval = null;
        if (!this._downloader.getRemoteFileDesc().isPartialSource()) {
            interval = this._currentState.isHttp11() ? this._commonOutFile.leaseWhite(this.findChunkSize()) : this._commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet availableRanges = this._downloader.getRemoteFileDesc().getAvailableRanges();
                interval = this._currentState.isHttp11() ? this._commonOutFile.leaseWhite(availableRanges, this.findChunkSize()) : this._commonOutFile.leaseWhite(availableRanges);
            }
            catch (NoSuchElementException nsee) {
                throw new NoSuchRangeException();
            }
        }
        return interval;
    }

    private int findChunkSize() {
        int chunkSize = this._commonOutFile.getChunkSize();
        int free = this._commonOutFile.hasFreeBlocksToAssign();
        if (free <= chunkSize && this._manager.getActiveWorkers().size() > 1) {
            chunkSize = Math.max(16384, free / 2);
        }
        return chunkSize;
    }

    private boolean assignGrey() {
        if (this.isStealing()) {
            return false;
        }
        if (this._downloader.getRemoteFileDesc().isPartialSource()) {
            this.handleNoRanges();
            return false;
        }
        final DownloadWorker slowest = this.findSlowestDownloader();
        if (slowest == null) {
            LOG.debug("didn't find anybody to steal from");
            this.handleNoMoreDownloaders();
            return false;
        }
        final Interval slowestRange = slowest.getDownloadInterval();
        if (slowestRange.low == slowestRange.high) {
            this.handleNoMoreDownloaders();
            return false;
        }
        slowest.setStealing(true);
        this.setStealing(true);
        this._downloader.connectHTTP(slowestRange.low, slowestRange.high, false, this._commonOutFile.getBlockSize(), new IOStateObserver(){

            public void handleStatesFinished() {
                DownloadWorker.this.completeAssignAndRequest(null, slowestRange, slowest);
            }

            public void handleIOException(IOException iox) {
                DownloadWorker.this.completeAssignAndRequest(iox, null, slowest);
            }

            public void shutdown() {
                DownloadWorker.this.completeAssignAndRequest(new IOException("shutdown"), null, slowest);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAssignGrey(DownloadWorker victim, Interval slowestRange) throws IOException {
        int newStart;
        HTTPDownloader hTTPDownloader = victim.getDownloader();
        synchronized (hTTPDownloader) {
            if (!victim.getDownloader().isActive()) {
                LOG.debug("victim is no longer active");
                throw new NoSuchElementException();
            }
            Interval newSlowestRange = victim.getDownloadInterval();
            if (newSlowestRange.high != slowestRange.high) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("victim is now downloading something else " + newSlowestRange + " vs. " + slowestRange);
                }
                throw new NoSuchElementException();
            }
            if (newSlowestRange.low > slowestRange.low && LOG.isDebugEnabled()) {
                LOG.debug("victim managed to download " + (newSlowestRange.low - slowestRange.low) + " bytes while stealer was connecting");
            }
            int myLow = this._downloader.getInitialReadingPoint();
            int myHigh = this._downloader.getAmountToRead() + myLow;
            if (myHigh < slowestRange.high) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WORKER: not stealing because stealer gave a subrange.  Expected low: " + slowestRange.low + ", high: " + slowestRange.high + ".  Was low: " + myLow + ", high: " + myHigh);
                }
                throw new IOException();
            }
            newStart = Math.max(newSlowestRange.low, myLow);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER: picking stolen grey " + newStart + "-" + slowestRange.high + " from [" + victim + "] to [" + this + "]");
            }
            victim.getDownloader().stopAt(newStart);
        }
        this._downloader.startAt(newStart);
        this._shouldRelease = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Interval getDownloadInterval() {
        HTTPDownloader downloader;
        HTTPDownloader hTTPDownloader = downloader = this._downloader;
        synchronized (hTTPDownloader) {
            int start = Math.max(downloader.getInitialReadingPoint() + downloader.getAmountRead(), downloader.getInitialWritingPoint());
            int stop = downloader.getInitialReadingPoint() + downloader.getAmountToRead();
            return new Interval(start, stop);
        }
    }

    private void setStealing(boolean stealing) {
        this._stealing = stealing;
    }

    boolean isStealing() {
        return this._stealing;
    }

    private DownloadWorker findSlowestDownloader() {
        float ourSpeed;
        DownloadWorker slowest = null;
        float slowestSpeed = ourSpeed = this.getOurSpeed();
        Set queuedWorkers = this._manager.getQueuedWorkers().keySet();
        Iterator iter = this._manager.getAllWorkers().iterator();
        while (iter.hasNext()) {
            HTTPDownloader h;
            DownloadWorker worker = (DownloadWorker)iter.next();
            if (worker.isStealing() || queuedWorkers.contains(worker) || (h = worker.getDownloader()) == null || h == this._downloader || h.isVictim()) continue;
            if (ourSpeed == -1.0f) {
                if (!worker.isSlow()) continue;
                return worker;
            }
            float hisSpeed = 0.0f;
            try {
                h.getMeasuredBandwidth();
                hisSpeed = h.getAverageBandwidth();
            }
            catch (InsufficientDataException ide) {
                hisSpeed = Math.max(0.0f, ourSpeed - 0.1f);
            }
            if (!(hisSpeed < slowestSpeed)) continue;
            slowestSpeed = hisSpeed;
            slowest = worker;
        }
        return slowest;
    }

    private float getOurSpeed() {
        if (this._downloader == null) {
            return -1.0f;
        }
        try {
            this._downloader.getMeasuredBandwidth();
            return this._downloader.getAverageBandwidth();
        }
        catch (InsufficientDataException bad) {
            return -1.0f;
        }
    }

    boolean isSlow() {
        float ourSpeed = this.getOurSpeed();
        return ourSpeed < MIN_ACCEPTABLE_SPEED && ourSpeed != -1.0f;
    }

    private ConnectionStatus handleNoMoreDownloaders() {
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoData();
    }

    private ConnectionStatus handleNoRanges() {
        this._rfd.setAvailableRanges(null);
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(300);
        }
        this._rfd.resetFailedCount();
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleTryAgainLater() {
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(60);
        }
        if (!this._manager.getActiveWorkers().isEmpty() && this._rfd.getWaitTime(System.currentTimeMillis()) < 600) {
            this._rfd.setRetryAfter(600);
        }
        this._manager.addRFD(this._rfd);
        this._rfd.resetFailedCount();
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleRangeNotAvailable() {
        this._rfd.resetFailedCount();
        this._manager.informMesh(this._rfd, true);
        return ConnectionStatus.getPartialData();
    }

    private ConnectionStatus handleFileNotFound() {
        this._manager.informMesh(this._rfd, false);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleNotSharing() {
        return this.handleFileNotFound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus handleQueued(int position, int pollTime) {
        ManagedDownloader managedDownloader = this._manager;
        synchronized (managedDownloader) {
            if (this._manager.getActiveWorkers().isEmpty()) {
                if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted) {
                    return ConnectionStatus.getNoData();
                }
                this._manager.setState(10);
            }
            this._rfd.resetFailedCount();
            return ConnectionStatus.getQueued(position, pollTime);
        }
    }

    private ConnectionStatus handleProblemReadingHeader() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleUnknownCode() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleIO() {
        this.handleRFDFailure(this._rfd);
        return ConnectionStatus.getNoFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt() {
        this._interrupted = true;
        DownloadState downloadState = this._currentState;
        synchronized (downloadState) {
            if (this._currentState.getCurrentState() == 5) {
                this.finishHttpLoop();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping while state is: " + this._currentState + ", this: " + this.toString());
        }
        if (this._downloader != null) {
            this._downloader.stop();
        } else {
            Socket socket;
            DirectConnector observer = this._connectObserver;
            if (observer != null && (socket = observer.getSocket()) != null) {
                IOUtils.close(socket);
            }
        }
    }

    public RemoteFileDesc getRFD() {
        return this._rfd;
    }

    HTTPDownloader getDownloader() {
        return this._downloader;
    }

    public String toString() {
        return this._workerName + "[" + this._currentState + "] -> " + this._rfd;
    }

    private void finishWorker() {
        this._interrupted = true;
        this._manager.workerFinished(this);
    }

    private void startDownload(HTTPDownloader dl) {
        this._downloader = dl;
        if (this.finishConnect()) {
            LOG.trace("Starting download");
            this.initializeAlternateLocations();
            this.httpLoop();
        } else {
            this.finishWorker();
        }
    }

    private void finishHttpLoop() {
        this.releaseRanges();
        this._manager.removeQueuedWorker(this);
        this._downloader.stop();
        this.finishWorker();
    }

    private class DirectConnector
    extends HTTPConnectObserver {
        private long createTime = System.currentTimeMillis();
        private boolean pushConnectOnFailure;
        private Socket connectingSocket;
        private boolean shutdown;

        DirectConnector(boolean pushConnectOnFailure) {
            this.pushConnectOnFailure = pushConnectOnFailure;
        }

        public void handleConnect(Socket socket) {
            this.connectingSocket = null;
            NumericalDownloadStat.TCP_CONNECT_TIME.addData((int)(System.currentTimeMillis() - this.createTime));
            DownloadStat.CONNECT_DIRECT_SUCCESS.incrementStat();
            HTTPDownloader dl = new HTTPDownloader(socket, DownloadWorker.this._rfd, DownloadWorker.this._commonOutFile, DownloadWorker.this._manager instanceof InNetworkDownloader);
            try {
                dl.connectTCP(0);
            }
            catch (IOException iox) {
                this.shutdown();
                return;
            }
            DownloadWorker.this.startDownload(dl);
        }

        public void shutdown() {
            this.shutdown = true;
            this.connectingSocket = null;
            DownloadStat.CONNECT_DIRECT_FAILURES.incrementStat();
            if (this.pushConnectOnFailure) {
                DownloadWorker.this.connectWithPush(new PushConnector(false, false));
            } else {
                DownloadWorker.this.finishConnect();
                DownloadWorker.this.finishWorker();
            }
        }

        void setSocket(Socket socket) {
            this.connectingSocket = socket;
        }

        Socket getSocket() {
            return this.connectingSocket;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }
    }

    private class PushConnector
    extends HTTPConnectObserver {
        private boolean forgetOnFailure;
        private boolean directConnectOnFailure;
        private PushDetails pushDetails;

        PushConnector(boolean forgetOnFailure, boolean directConnectOnFailure) {
            this.forgetOnFailure = forgetOnFailure;
            this.directConnectOnFailure = directConnectOnFailure;
        }

        public void handleConnect(Socket socket) {
            HTTPDownloader dl = new HTTPDownloader(socket, DownloadWorker.this._rfd, DownloadWorker.this._commonOutFile, DownloadWorker.this._manager instanceof InNetworkDownloader);
            try {
                dl.connectTCP(0);
                DownloadStat.CONNECT_PUSH_SUCCESS.incrementStat();
            }
            catch (IOException iox) {
                DownloadStat.PUSH_FAILURE_LOST.incrementStat();
                this.failed();
                return;
            }
            DownloadWorker.this.startDownload(dl);
        }

        public void shutdown() {
            DownloadStat.PUSH_FAILURE_NO_RESPONSE.incrementStat();
            this.failed();
        }

        void setPushDetails(PushDetails details) {
            this.pushDetails = details;
        }

        private void failed() {
            DownloadWorker.this._manager.unregisterPushObserver(this.pushDetails, false);
            if (!this.directConnectOnFailure) {
                if (this.forgetOnFailure) {
                    DownloadWorker.this._manager.forgetRFD(DownloadWorker.this._rfd);
                }
                DownloadWorker.this.finishConnect();
                DownloadWorker.this.finishWorker();
            } else {
                DownloadWorker.this.connectDirectly(new DirectConnector(false));
            }
        }
    }

    private abstract class State
    implements IOStateObserver {
        private State() {
        }

        public final void handleIOException(IOException iox) {
            this.handleState(false);
            DownloadWorker.this.finishHttpLoop();
        }

        public final void handleStatesFinished() {
            this.handleState(true);
            DownloadWorker.this.incrementState(null);
        }

        public final void shutdown() {
            this.handleState(false);
            DownloadWorker.this.finishHttpLoop();
        }

        protected abstract void handleState(boolean var1);
    }
}

