/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ByteOrder;
import java.io.Serializable;

public class Interval
implements Serializable {
    static final long serialVersionUID = -2562093104400487554L;
    public final int low;
    public final int high;

    public Interval(long low, long high) {
        if (high < low) {
            throw new IllegalArgumentException("low: " + low + ", high: " + high);
        }
        if (low < 0L) {
            throw new IllegalArgumentException("low < min int:" + low);
        }
        if (high > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("high > max int:" + high);
        }
        this.low = (int)low;
        this.high = (int)high;
    }

    public Interval(long singleton) {
        if (singleton < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("singleton < min:" + singleton);
        }
        if (singleton > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("singleton > max int:" + singleton);
        }
        this.low = (int)singleton;
        this.high = (int)singleton;
    }

    public boolean isSubrange(Interval other) {
        return this.low >= other.low && this.high <= other.high;
    }

    public String toString() {
        if (this.low == this.high) {
            return String.valueOf(this.low);
        }
        return String.valueOf(this.low) + "-" + String.valueOf(this.high);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)o;
        return this.low == other.low && this.high == other.high;
    }

    public byte[] toBytes() {
        byte[] res = new byte[8];
        this.toBytes(res, 0);
        return res;
    }

    public void toBytes(byte[] dest, int offset) {
        ByteOrder.int2beb(this.low, dest, offset);
        ByteOrder.int2beb(this.high, dest, offset + 4);
    }
}

