/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.SourceRanker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LegacyRanker
extends SourceRanker {
    private static final Log LOG = LogFactory.getLog(LegacyRanker.class);
    private final Set rfds = new HashSet();

    public synchronized boolean addToPool(RemoteFileDesc host) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding host " + host + " to be ranked");
        }
        return this.rfds.add(host);
    }

    public synchronized RemoteFileDesc getBest() {
        if (!this.hasMore()) {
            return null;
        }
        RemoteFileDesc ret = LegacyRanker.getBest(this.rfds.iterator());
        boolean removed = this.rfds.remove(ret);
        Assert.that(removed, "unable to remove RFD.");
        if (LOG.isDebugEnabled()) {
            LOG.debug("the best we came with is " + ret);
        }
        return ret;
    }

    static RemoteFileDesc getBest(Iterator iter) {
        RemoteFileDesc ret = (RemoteFileDesc)iter.next();
        long now = System.currentTimeMillis();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (rfd.isBusy(now)) continue;
            if (ret.isBusy(now)) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() != null && ret.getSHA1Urn() == null) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() == null != (ret.getSHA1Urn() == null)) continue;
            if (rfd.getQuality() > ret.getQuality()) {
                ret = rfd;
                continue;
            }
            if (rfd.getQuality() != ret.getQuality() || rfd.getSpeed() <= ret.getSpeed()) continue;
            ret = rfd;
        }
        return ret;
    }

    public boolean hasMore() {
        return !this.rfds.isEmpty();
    }

    protected Collection getShareableHosts() {
        return this.rfds;
    }

    protected Collection getPotentiallyBusyHosts() {
        return this.rfds;
    }

    public int getNumKnownHosts() {
        return this.rfds.size();
    }
}

