/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MagnetDownloader
extends ManagedDownloader
implements Serializable {
    private static final Log LOG = LogFactory.getLog(MagnetDownloader.class);
    static final long serialVersionUID = 9092913030585214105L;
    private static final transient String MAGNET = "MAGNET";

    public MagnetDownloader(IncompleteFileManager ifm, MagnetOptions magnet, boolean overwrite, File saveDir, String fileName) throws SaveLocationException {
        super(new RemoteFileDesc[0], ifm, null, saveDir, MagnetDownloader.checkMagnetAndExtractFileName(magnet, fileName), overwrite);
        this.propertiesMap.put(MAGNET, magnet);
    }

    public void initialize(DownloadManager manager, FileManager fileManager, DownloadCallback callback) {
        Assert.that(this.getMagnet() != null);
        this.downloadSHA1 = this.getMagnet().getSHA1Urn();
        super.initialize(manager, fileManager, callback);
    }

    private MagnetOptions getMagnet() {
        return (MagnetOptions)this.propertiesMap.get(MAGNET);
    }

    protected int initializeDownload() {
        if (!this.hasRFD()) {
            MagnetOptions magnet = this.getMagnet();
            String[] defaultURLs = magnet.getDefaultURLs();
            if (defaultURLs.length == 0) {
                return 6;
            }
            RemoteFileDesc firstDesc = null;
            for (int i = 0; i < defaultURLs.length && firstDesc == null; ++i) {
                try {
                    firstDesc = MagnetDownloader.createRemoteFileDesc(defaultURLs[i], this.getSaveFile().getName(), magnet.getSHA1Urn());
                    this.initPropertiesMap(firstDesc);
                    this.addDownloadForced(firstDesc, true);
                    continue;
                }
                catch (IOException badRFD) {
                    // empty catch block
                }
            }
            if (firstDesc == null) {
                return 6;
            }
        }
        return super.initializeDownload();
    }

    private static RemoteFileDesc createRemoteFileDesc(String defaultURL, String filename, URN urn) throws IOException {
        if (defaultURL == null) {
            LOG.debug("createRemoteFileDesc called with null URL");
            return null;
        }
        URL url = null;
        url = new URL(defaultURL);
        int port = url.getPort();
        if (port < 0) {
            port = 80;
        }
        HashSet<URN> urns = new HashSet<URN>(1);
        if (urn != null) {
            urns.add(urn);
        }
        URI uri = new URI(url);
        return new URLRemoteFileDesc(url.getHost(), port, 0L, filename != null ? filename : MagnetOptions.extractFileName(uri), MagnetDownloader.contentLength(url), new byte[16], 3000, false, 3, false, null, urns, false, false, "", 0L, url, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int contentLength(URL url) throws IOException {
        try {
            new URI(url.toExternalForm().toCharArray());
        }
        catch (URIException e) {
            throw new IOException("invalid url: " + url);
        }
        HttpClient client = HttpClientManager.getNewClient();
        HeadMethod head = new HeadMethod(url.toExternalForm());
        head.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        try {
            client.executeMethod(head);
            if (head.getStatusCode() != 200) {
                throw new IOException("Got " + head.getStatusCode() + " instead of 200");
            }
            int length = head.getResponseContentLength();
            if (length < 0) {
                throw new IOException("No content length");
            }
            int n = length;
            return n;
        }
        finally {
            if (head != null) {
                head.releaseConnection();
            }
        }
    }

    protected QueryRequest newRequery(int numRequeries) throws CantResumeException {
        MagnetOptions magnet = this.getMagnet();
        String textQuery = magnet.getQueryString();
        if (textQuery != null) {
            String q = StringUtils.createQueryString(textQuery);
            return QueryRequest.createQuery(q);
        }
        String q = StringUtils.createQueryString(this.getSaveFile().getName());
        return QueryRequest.createQuery(q);
    }

    protected boolean allowAddition(RemoteFileDesc other) {
        URN otherSHA1 = other.getSHA1Urn();
        if (this.downloadSHA1 != null && otherSHA1 != null) {
            return this.downloadSHA1.equals(otherSHA1);
        }
        return false;
    }

    protected synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        if (!this.hasRFD()) {
            this.initPropertiesMap(rfd);
        }
        return super.addDownloadForced(rfd, cache);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        MagnetOptions magnet = this.getMagnet();
        if (magnet == null) {
            String[] defaultURLs;
            ObjectInputStream.GetField fields = stream.readFields();
            String textQuery = (String)fields.get("_textQuery", null);
            URN urn = (URN)fields.get("_urn", null);
            String fileName = (String)fields.get("_filename", null);
            magnet = MagnetOptions.createMagnet(textQuery, fileName, urn, defaultURLs = (String[])fields.get("_defaultURLs", null));
            if (!magnet.isDownloadable()) {
                throw new IOException("Old undownloadable magnet");
            }
            this.propertiesMap.put(MAGNET, magnet);
        }
        if (this.propertiesMap.get("defaultFileName") == null) {
            this.propertiesMap.put("defaultFileName", magnet.getFileNameForSaving());
        }
    }

    protected boolean shouldSendRequeryImmediately(int numRequeries) {
        return this.downloadSHA1 != null ? super.shouldSendRequeryImmediately(numRequeries) : false;
    }

    private static String checkMagnetAndExtractFileName(MagnetOptions magnet, String fileName) {
        if (!magnet.isDownloadable()) {
            throw new IllegalArgumentException("magnet not downloadable");
        }
        if (fileName != null) {
            return fileName;
        }
        return magnet.getFileNameForSaving();
    }

    protected void initializeIncompleteFile() throws IOException {
        if (this.getContentLength() != -1) {
            super.initializeIncompleteFile();
        }
    }
}

