/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.DualIterator;
import com.limegroup.gnutella.util.IpPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingRanker
extends SourceRanker
implements MessageListener,
Cancellable {
    private static final Log LOG = LogFactory.getLog(PingRanker.class);
    private UDPPinger pinger = new UDPPinger();
    private Set newHosts;
    private TreeMap pingedHosts = new TreeMap(IpPort.COMPARATOR);
    private Set testedLocations = new HashSet();
    private TreeSet verifiedHosts;
    private URN sha1;
    private GUID myGUID;
    private boolean running;
    private long lastPingTime;
    private static final Comparator RFD_COMPARATOR = new RFDComparator();
    private static final Comparator ALT_DEPRIORITIZER = new RFDAltDeprioritizer();

    protected PingRanker() {
        this.newHosts = new HashSet();
        this.verifiedHosts = new TreeSet(RFD_COMPARATOR);
    }

    public synchronized boolean addToPool(Collection c) {
        ArrayList l = c instanceof List ? (ArrayList)c : new ArrayList(c);
        Collections.sort(l, ALT_DEPRIORITIZER);
        return this.addInternal(l);
    }

    private boolean addInternal(Collection c) {
        boolean ret = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.addInternal((RemoteFileDesc)iter.next())) continue;
            ret = true;
        }
        this.pingNewHosts();
        return ret;
    }

    public synchronized boolean addToPool(RemoteFileDesc host) {
        boolean ret = this.addInternal(host);
        this.pingNewHosts();
        return ret;
    }

    private boolean addInternal(RemoteFileDesc host) {
        if (this.sha1 == null) {
            if (host.getSHA1Urn() != null) {
                this.sha1 = host.getSHA1Urn();
            } else {
                return this.testedLocations.add(host);
            }
        }
        if (this.running && this.knowsAboutHost(host)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding new host " + host + " " + host.getPushAddr());
        }
        boolean ret = false;
        ret = host.isReplyToMulticast() ? this.verifiedHosts.add(host) : this.newHosts.add(host);
        ret |= !this.running;
        if (this.myGUID == null && this.meshHandler != null) {
            this.myGUID = new GUID(GUID.makeGuid());
            RouterService.getMessageRouter().registerMessageListener(this.myGUID.bytes(), this);
        }
        return ret;
    }

    private boolean knowsAboutHost(RemoteFileDesc host) {
        return this.newHosts.contains(host) || this.verifiedHosts.contains(host) || this.testedLocations.contains(host);
    }

    public synchronized RemoteFileDesc getBest() throws NoSuchElementException {
        RemoteFileDesc ret;
        if (!this.hasMore()) {
            return null;
        }
        if (!this.verifiedHosts.isEmpty()) {
            LOG.debug("getting a verified host");
            ret = (RemoteFileDesc)this.verifiedHosts.first();
            this.verifiedHosts.remove(ret);
        } else {
            LOG.debug("getting a non-verified host");
            DualIterator dual = new DualIterator(this.testedLocations.iterator(), this.newHosts.iterator());
            ret = LegacyRanker.getBest(dual);
            this.newHosts.remove(ret);
            this.testedLocations.remove(ret);
            if (ret.needsPush()) {
                Iterator iter = ret.getPushProxies().iterator();
                while (iter.hasNext()) {
                    this.pingedHosts.remove(iter.next());
                }
            } else {
                this.pingedHosts.remove(ret);
            }
        }
        this.pingNewHosts();
        if (LOG.isDebugEnabled()) {
            LOG.debug("the best host we came up with is " + ret + " " + ret.getPushAddr());
        }
        return ret;
    }

    private void pingNewHosts() {
        if (this.isCancelled()) {
            return;
        }
        if (!this.hasNonBusy()) {
            return;
        }
        if (this.sha1 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastPingTime < (long)DownloadSettings.WORKER_INTERVAL.getValue()) {
            return;
        }
        HeadPing ping = new HeadPing(this.myGUID, this.sha1, PingRanker.getPingFlags());
        int batch = DownloadSettings.PING_BATCH.getValue();
        ArrayList<RemoteFileDesc> toSend = new ArrayList<RemoteFileDesc>(batch);
        int sent = 0;
        Iterator iter = this.newHosts.iterator();
        while (iter.hasNext() && sent < batch) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (rfd.isBusy(now)) continue;
            iter.remove();
            if (rfd.needsPush()) {
                if (rfd.getPushProxies().size() > 0 && rfd.getSHA1Urn() != null) {
                    this.pingProxies(rfd);
                }
            } else {
                this.pingedHosts.put(rfd, rfd);
                toSend.add(rfd);
            }
            this.testedLocations.add(rfd);
            ++sent;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nverified hosts " + this.verifiedHosts.size() + "\npingedHosts " + this.pingedHosts.values().size() + "\nnewHosts " + this.newHosts.size() + "\npinging hosts: " + sent);
        }
        this.pinger.rank(toSend, null, this, ping);
        this.lastPingTime = now;
    }

    protected Collection getPotentiallyBusyHosts() {
        return this.newHosts;
    }

    private void pingProxies(RemoteFileDesc rfd) {
        if (RouterService.acceptedIncomingConnection() || RouterService.getUdpService().canDoFWT() && rfd.supportsFWTransfer()) {
            HeadPing pushPing = new HeadPing(this.myGUID, rfd.getSHA1Urn(), new GUID(rfd.getPushAddr().getClientGUID()), PingRanker.getPingFlags());
            Iterator iter = rfd.getPushProxies().iterator();
            while (iter.hasNext()) {
                this.pingedHosts.put(iter.next(), rfd);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("pinging push location " + rfd.getPushAddr());
            }
            this.pinger.rank(rfd.getPushProxies(), null, this, pushPing);
        }
    }

    private static int getPingFlags() {
        int flags = 3;
        if (RouterService.acceptedIncomingConnection() || RouterService.getUdpService().canDoFWT()) {
            flags |= 4;
        }
        return flags;
    }

    public synchronized boolean hasMore() {
        return !this.verifiedHosts.isEmpty() || !this.newHosts.isEmpty() || !this.testedLocations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(Message m, ReplyHandler handler) {
        MeshHandler mesh;
        RemoteFileDesc rfd;
        Set alts = null;
        PingRanker pingRanker = this;
        synchronized (pingRanker) {
            if (!this.running) {
                return;
            }
            if (!(m instanceof HeadPong)) {
                return;
            }
            HeadPong pong = (HeadPong)m;
            if (!this.pingedHosts.containsKey(handler)) {
                return;
            }
            rfd = (RemoteFileDesc)this.pingedHosts.remove(handler);
            this.testedLocations.remove(rfd);
            if (LOG.isDebugEnabled()) {
                LOG.debug("received a pong " + pong + " from " + handler + " for rfd " + rfd + " with PE " + rfd.getPushAddr());
            }
            if (!pong.hasFile() && !pong.isGGEPPong() && rfd.needsPush()) {
                return;
            }
            if (pong.isFirewalled()) {
                Iterator iter = rfd.getPushProxies().iterator();
                while (iter.hasNext()) {
                    this.pingedHosts.remove(iter.next());
                }
            }
            mesh = this.meshHandler;
            if (pong.hasFile()) {
                pong.updateRFD(rfd);
                if (rfd.isBusy()) {
                    this.newHosts.add(rfd);
                } else {
                    this.verifiedHosts.add(rfd);
                }
                alts = pong.getAllLocsRFD(rfd);
            }
        }
        if (alts == null) {
            mesh.informMesh(rfd, false);
        } else {
            mesh.addPossibleSources(alts);
        }
    }

    public synchronized void registered(byte[] guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ranker registered with guid " + new GUID(guid).toHexString());
        }
        this.running = true;
    }

    public synchronized void unregistered(byte[] guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ranker unregistered with guid " + new GUID(guid).toHexString());
        }
        this.running = false;
        this.newHosts.addAll(this.verifiedHosts);
        this.newHosts.addAll(this.testedLocations);
        this.verifiedHosts.clear();
        this.pingedHosts.clear();
        this.testedLocations.clear();
        this.lastPingTime = 0L;
    }

    public synchronized boolean isCancelled() {
        return !this.running || this.verifiedHosts.size() >= DownloadSettings.MAX_VERIFIED_HOSTS.getValue();
    }

    protected synchronized void clearState() {
        if (this.myGUID != null) {
            RouterService.getMessageRouter().unregisterMessageListener(this.myGUID.bytes(), this);
            this.myGUID = null;
        }
    }

    protected synchronized Collection getShareableHosts() {
        ArrayList ret = new ArrayList(this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size());
        ret.addAll(this.verifiedHosts);
        ret.addAll(this.newHosts);
        ret.addAll(this.testedLocations);
        return ret;
    }

    public synchronized int getNumKnownHosts() {
        return this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size();
    }

    private static final class RFDAltDeprioritizer
    implements Comparator {
        private RFDAltDeprioritizer() {
        }

        public int compare(Object a, Object b) {
            RemoteFileDesc rfd1 = (RemoteFileDesc)a;
            RemoteFileDesc rfd2 = (RemoteFileDesc)b;
            if (rfd1.isFromAlternateLocation() != rfd2.isFromAlternateLocation()) {
                if (rfd1.isFromAlternateLocation()) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    private static final class RFDComparator
    implements Comparator {
        private RFDComparator() {
        }

        public int compare(Object a, Object b) {
            RemoteFileDesc pongA = (RemoteFileDesc)a;
            RemoteFileDesc pongB = (RemoteFileDesc)b;
            if (pongA.isReplyToMulticast() != pongB.isReplyToMulticast()) {
                if (pongA.isReplyToMulticast()) {
                    return -1;
                }
                return 1;
            }
            if (pongA.getQueueStatus() > pongB.getQueueStatus()) {
                return 1;
            }
            if (pongA.getQueueStatus() < pongB.getQueueStatus()) {
                return -1;
            }
            if (pongA.needsPush() != pongB.needsPush()) {
                if (pongA.needsPush()) {
                    return -1;
                }
                return 1;
            }
            if (pongA.isPartialSource() != pongB.isPartialSource()) {
                if (pongA.isPartialSource()) {
                    return -1;
                }
                return 1;
            }
            return pongA.hashCode() - pongB.hashCode();
        }
    }
}

