/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.util.NetworkUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PushList {
    private static final Log LOG = LogFactory.getLog(PushList.class);
    private final TreeMap pushers = new TreeMap(GUID.GUID_BYTE_COMPARATOR);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPushHost(PushDetails details, HTTPConnectObserver observer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding observer for details: " + details);
        }
        TreeMap treeMap = this.pushers;
        synchronized (treeMap) {
            byte[] clientGUID = details.getClientGUID();
            LinkedList<Push> perGUID = (LinkedList<Push>)this.pushers.get(clientGUID);
            if (perGUID == null) {
                perGUID = new LinkedList<Push>();
                this.pushers.put(clientGUID, perGUID);
            }
            perGUID.add(new Push(details, observer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectObserver getExactHostFor(PushDetails details) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving exact match for details: " + details);
        }
        TreeMap treeMap = this.pushers;
        synchronized (treeMap) {
            byte[] clientGUID = details.getClientGUID();
            List perGUID = (List)this.pushers.get(clientGUID);
            if (perGUID == null) {
                LOG.debug("No pushes waiting on those exact details.");
                return null;
            }
            Push best = this.getExactHost(perGUID, details);
            if (perGUID.isEmpty()) {
                this.pushers.remove(clientGUID);
            }
            if (best != null) {
                return best.observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectObserver getHostFor(byte[] clientGUID, String address) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving best match for address: " + address + ", guid: " + new GUID(clientGUID));
        }
        TreeMap treeMap = this.pushers;
        synchronized (treeMap) {
            List perGUID = (List)this.pushers.get(clientGUID);
            if (perGUID == null) {
                LOG.debug("No pushes waiting on that GUID.");
                return null;
            }
            Push best = this.getBestHost(perGUID, address);
            if (perGUID.isEmpty()) {
                this.pushers.remove(clientGUID);
            }
            if (best != null) {
                return best.observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllAndClear() {
        LinkedList<HTTPConnectObserver> allConnectors = new LinkedList<HTTPConnectObserver>();
        TreeMap treeMap = this.pushers;
        synchronized (treeMap) {
            Iterator i = this.pushers.values().iterator();
            while (i.hasNext()) {
                List list = (List)i.next();
                if (list == null) continue;
                Iterator j = list.iterator();
                while (j.hasNext()) {
                    Push next = (Push)j.next();
                    allConnectors.add(next.observer);
                }
            }
            this.pushers.clear();
        }
        return allConnectors;
    }

    private Push getBestHost(List hosts, String address) {
        Push next;
        if (hosts.isEmpty()) {
            return null;
        }
        Iterator i = hosts.iterator();
        while (i.hasNext()) {
            next = (Push)i.next();
            if (!next.details.getAddress().equals(address)) continue;
            LOG.debug("Found an exact match!");
            i.remove();
            return next;
        }
        LOG.debug("No exact match, using first private|bogus address.");
        i = hosts.iterator();
        while (i.hasNext()) {
            next = (Push)i.next();
            if (!NetworkUtils.isPrivateAddress(next.details.getAddress()) && !next.details.getAddress().equals("1.1.1.1")) continue;
            i.remove();
            return next;
        }
        LOG.debug("No private address to use!");
        return null;
    }

    private Push getExactHost(List hosts, PushDetails details) {
        if (hosts.isEmpty()) {
            return null;
        }
        Iterator i = hosts.iterator();
        while (i.hasNext()) {
            Push next = (Push)i.next();
            if (!next.details.equals(details)) continue;
            i.remove();
            return next;
        }
        LOG.debug("No exact match!");
        return null;
    }

    private static class Push {
        private final PushDetails details;
        private final HTTPConnectObserver observer;

        Push(PushDetails details, HTTPConnectObserver observer) {
            this.details = details;
            this.observer = observer;
        }
    }
}

