/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.SelectionStrategy;
import com.limegroup.gnutella.util.IntervalSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RandomDownloadStrategy
implements SelectionStrategy {
    private static final Log LOG = LogFactory.getLog(RandomDownloadStrategy.class);
    private static final int MAX_FRAGMENTS = 16;
    protected static Random pseudoRandom = new Random();
    protected final long completedSize;

    public RandomDownloadStrategy(long completedSize) {
        this.completedSize = completedSize;
    }

    public Interval pickAssignment(IntervalSet candidateBytes, IntervalSet neededBytes, long blockSize) throws NoSuchElementException {
        long lowerBound = neededBytes.getFirst().low;
        long upperBound = neededBytes.getLast().high;
        if (blockSize < 1L) {
            throw new IllegalArgumentException("Block size cannot be " + blockSize);
        }
        if (lowerBound < 0L) {
            throw new IllegalArgumentException("lowerBound must be >= 0, " + lowerBound + "<0");
        }
        if (upperBound >= this.completedSize) {
            throw new IllegalArgumentException("Greatest needed byte must be less than completedSize " + upperBound + " >= " + this.completedSize);
        }
        if (candidateBytes.isEmpty()) {
            throw new NoSuchElementException();
        }
        long idealLocation = this.getIdealLocation(neededBytes, blockSize);
        Object lastSuitableInterval = null;
        Iterator intervalIterator = candidateBytes.getAllIntervals();
        Interval intervalAbove = null;
        Interval intervalBelow = null;
        while (intervalIterator.hasNext()) {
            Interval candidateInterval = (Interval)intervalIterator.next();
            if ((long)candidateInterval.low < idealLocation) {
                intervalBelow = this.optimizeIntervalBelow(candidateInterval, idealLocation, blockSize);
            }
            if ((long)candidateInterval.high < idealLocation) continue;
            intervalAbove = this.optimizeIntervalAbove(candidateInterval, idealLocation, blockSize);
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("idealLocation=" + idealLocation + " intervalAbove=" + intervalAbove + " intervalBelow=" + intervalBelow + " out of possibilites:" + candidateBytes);
        }
        if (intervalAbove == null) {
            return intervalBelow;
        }
        if (intervalBelow == null) {
            return intervalAbove;
        }
        return (pseudoRandom.nextInt() & 1) == 1 ? intervalAbove : intervalBelow;
    }

    protected long alignHigh(long location, long blockSize) {
        location += blockSize;
        location -= location % blockSize;
        return location - 1L;
    }

    protected long alignLow(long location, long blockSize) {
        location -= location % blockSize;
        return location;
    }

    private long getIdealLocation(IntervalSet neededBytes, long blockSize) {
        int fragmentCount = neededBytes.getNumberOfIntervals();
        if (fragmentCount >= 16) {
            int randomFragmentNumber = pseudoRandom.nextInt(fragmentCount + 1);
            if (randomFragmentNumber == fragmentCount) {
                return neededBytes.getLast().high + 1;
            }
            return ((Interval)neededBytes.getAllIntervalsAsList().get((int)randomFragmentNumber)).low;
        }
        return this.getRandomLocation(neededBytes.getFirst().low, neededBytes.getLast().high, blockSize);
    }

    private Interval optimizeIntervalAbove(Interval candidate, long location, long blockSize) {
        long bestHigh;
        long bestLow = candidate.low;
        if (bestLow < location) {
            bestLow = location;
        }
        if ((bestHigh = this.alignHigh(bestLow, blockSize)) > (long)candidate.high) {
            bestHigh = candidate.high;
        }
        if ((long)candidate.high == bestHigh && (long)candidate.low == bestLow) {
            return candidate;
        }
        return new Interval(bestLow, bestHigh);
    }

    private Interval optimizeIntervalBelow(Interval candidate, long location, long blockSize) {
        long bestLow;
        long bestHigh = candidate.high;
        if (bestHigh >= location) {
            bestHigh = location - 1L;
        }
        if ((bestLow = this.alignLow(bestHigh, blockSize)) < (long)candidate.low) {
            bestLow = candidate.low;
        }
        if ((long)candidate.high == bestHigh && (long)candidate.low == bestLow) {
            return candidate;
        }
        return new Interval(bestLow, bestHigh);
    }

    private long getRandomLocation(long minIndex, long maxIndex, long blockSize) {
        long minBlock = minIndex / blockSize;
        long maxBlock = maxIndex / blockSize;
        if (minBlock >= maxBlock) {
            return minIndex;
        }
        return blockSize * (minBlock + Math.abs(pseudoRandom.nextLong() % (maxBlock - minBlock + 1L)));
    }
}

