/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.DiskException;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.SelectionStrategy;
import com.limegroup.gnutella.downloader.SelectionStrategyFactory;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.ByteArrayCache;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.PowerOf2ByteArrayCache;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VerifyingFile {
    private static final Log LOG = LogFactory.getLog(VerifyingFile.class);
    private static final ProcessingQueue QUEUE = new ProcessingQueue("BlockingVF", true, 6);
    static final float MAX_CORRUPTION = 0.9f;
    static final int DEFAULT_CHUNK_SIZE = 131072;
    private static final List DELAYED = new LinkedList();
    private static final ByteArrayCache CACHE = new ByteArrayCache(512, 2048);
    private static final PowerOf2ByteArrayCache CHUNK_CACHE;
    private volatile RandomAccessFile fos;
    private volatile boolean isOpen;
    private final int completedSize;
    private int lostSize;
    private final IntervalSet verifiedBlocks;
    private IntervalSet leasedBlocks;
    private IntervalSet partialBlocks;
    private IntervalSet savedCorruptBlocks;
    private IntervalSet pendingBlocks;
    private SelectionStrategy blockChooser = null;
    private HashTree hashTree;
    private String expectedHashRoot;
    private boolean hashTreeRequested;
    private boolean discardBad = true;
    private IOException storedException;
    private long existingFileSize = -1L;

    public VerifyingFile() {
        this(-1);
    }

    public VerifyingFile(int completedSize) {
        this.completedSize = completedSize;
        this.verifiedBlocks = new IntervalSet();
        this.leasedBlocks = new IntervalSet();
        this.pendingBlocks = new IntervalSet();
        this.partialBlocks = new IntervalSet();
        this.savedCorruptBlocks = new IntervalSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file) throws IOException {
        if (this.completedSize == -1) {
            throw new IllegalStateException("cannot open for unknown size.");
        }
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
            if (!parentFile.exists()) {
                throw new IOException("permission denied");
            }
            FileUtils.setWriteable(parentFile);
        }
        FileUtils.setWriteable(file);
        this.fos = new RandomAccessFile(file, "rw");
        SelectionStrategy myStrategy = SelectionStrategyFactory.getStrategyFor(FileUtils.getFileExtension(file), this.completedSize);
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            this.storedException = null;
            this.blockChooser = myStrategy;
            this.isOpen = true;
        }
    }

    public synchronized void addInterval(Interval interval) {
        this.partialBlocks.add(interval);
    }

    public boolean writeBlock(long pos, byte[] data) throws InterruptedException {
        return this.writeBlock(pos, 0, data.length, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlockWithCallback(long currPos, int start, int length, byte[] buf, WriteCallback callback) {
        if (this.writeBlock(currPos, start, length, buf)) {
            callback.writeScheduled();
        } else {
            ByteArrayCache byteArrayCache = CACHE;
            synchronized (byteArrayCache) {
                DELAYED.add(new DelayedWrite(currPos, start, length, buf, callback, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeBlock(long currPos, int start, int length, byte[] buf) {
        boolean canWrite;
        ByteArrayCache byteArrayCache = CACHE;
        synchronized (byteArrayCache) {
            canWrite = DELAYED.isEmpty();
        }
        if (canWrite) {
            return this.writeBlockImpl(currPos, start, length, buf, true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeBlockImpl(long currPos, int start, int length, byte[] buf, boolean runDelayed) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("trying to write block at offset " + currPos + " with size " + length);
        }
        if (length == 0) {
            return true;
        }
        if (this.fos == null) {
            throw new IllegalStateException("no fos!");
        }
        if (!this.isOpen()) {
            return true;
        }
        byte[] temp = CACHE.getQuick();
        if (temp == null) {
            return false;
        }
        if (temp.length < length) {
            Assert.that(false, "bad length: " + length + ", needed <= " + temp.length);
        }
        System.arraycopy(buf, start, temp, 0, length);
        Interval intvl = new Interval(currPos, currPos + (long)length - 1L);
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            if (!this.leasedBlocks.contains(intvl)) {
                VerifyingFile.releaseChunk(temp, runDelayed);
                Assert.that(false, "trying to write an interval " + intvl + " that wasn't leased.\n" + this.dumpState());
            }
            if (this.partialBlocks.contains(intvl) || this.savedCorruptBlocks.contains(intvl) || this.pendingBlocks.contains(intvl)) {
                VerifyingFile.releaseChunk(temp, runDelayed);
                Assert.that(false, "trying to write an interval " + intvl + " that was already written" + this.dumpState());
            }
            this.leasedBlocks.delete(intvl);
            if (this.verifiedBlocks.containsAny(intvl)) {
                IntervalSet remaining = new IntervalSet();
                remaining.add(intvl);
                remaining.delete(this.verifiedBlocks);
                this.pendingBlocks.add(remaining);
            } else {
                this.pendingBlocks.add(intvl);
            }
        }
        QUEUE.add(new ChunkHandler(temp, intvl));
        return true;
    }

    public void setScanForExistingBlocks(boolean scan, long length) throws IOException {
        if (scan && length != 0L) {
            if (length > (long)this.completedSize) {
                throw new IOException("invalid completed size or length");
            }
            this.existingFileSize = length;
        } else {
            this.existingFileSize = -1L;
        }
    }

    public String dumpState() {
        return "verified:" + this.verifiedBlocks + "\npartial:" + this.partialBlocks + "\ndiscarded:" + this.savedCorruptBlocks + "\npending:" + this.pendingBlocks + "\nleased:" + this.leasedBlocks;
    }

    public Interval leaseWhite() throws NoSuchElementException {
        return this.leaseWhiteHelper(null, this.completedSize);
    }

    public Interval leaseWhite(int chunkSize) throws NoSuchElementException {
        return this.leaseWhiteHelper(null, chunkSize);
    }

    public Interval leaseWhite(IntervalSet ranges) throws NoSuchElementException {
        return this.leaseWhiteHelper(ranges, 131072L);
    }

    public Interval leaseWhite(IntervalSet ranges, int chunkSize) throws NoSuchElementException {
        return this.leaseWhiteHelper(ranges, chunkSize);
    }

    public synchronized void releaseBlock(Interval in) {
        if (!this.leasedBlocks.contains(in)) {
            Assert.that(false, "trying to release an interval " + in + " that wasn't leased " + this.dumpState());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Releasing interval: " + in + " state " + this.dumpState());
        }
        this.leasedBlocks.delete(in);
    }

    public synchronized Iterator getBlocks() {
        return this.getBlocksAsList().iterator();
    }

    public synchronized Iterator getVerifiedBlocks() {
        return this.verifiedBlocks.getAllIntervals();
    }

    public synchronized byte[] toBytes() {
        return this.verifiedBlocks.toBytes();
    }

    public String toString() {
        return this.dumpState();
    }

    public synchronized List getSerializableBlocks() {
        IntervalSet ret = new IntervalSet();
        Iterator iter = this.verifiedBlocks.getAllIntervals();
        while (iter.hasNext()) {
            ret.add((Interval)iter.next());
        }
        iter = this.partialBlocks.getAllIntervals();
        while (iter.hasNext()) {
            ret.add((Interval)iter.next());
        }
        iter = this.savedCorruptBlocks.getAllIntervals();
        while (iter.hasNext()) {
            ret.add((Interval)iter.next());
        }
        return ret.getAllIntervalsAsList();
    }

    public synchronized List getBlocksAsList() {
        ArrayList l = new ArrayList();
        l.addAll(this.verifiedBlocks.getAllIntervalsAsList());
        l.addAll(this.partialBlocks.getAllIntervalsAsList());
        l.addAll(this.savedCorruptBlocks.getAllIntervalsAsList());
        l.addAll(this.pendingBlocks.getAllIntervalsAsList());
        IntervalSet ret = new IntervalSet();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            ret.add((Interval)iter.next());
        }
        return ret.getAllIntervalsAsList();
    }

    public synchronized List getVerifiedBlocksAsList() {
        return this.verifiedBlocks.getAllIntervalsAsList();
    }

    public synchronized int getBlockSize() {
        return this.verifiedBlocks.getSize() + this.partialBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.pendingBlocks.getSize();
    }

    public synchronized int getPendingSize() {
        return this.pendingBlocks.getSize();
    }

    public static int getNumPendingItems() {
        return QUEUE.size();
    }

    public synchronized int getVerifiedBlockSize() {
        return this.verifiedBlocks.getSize();
    }

    public synchronized int getAmountLost() {
        return this.lostSize;
    }

    public synchronized boolean isComplete() {
        if (this.hashTree != null) {
            return this.verifiedBlocks.getSize() + this.savedCorruptBlocks.getSize() == this.completedSize;
        }
        return this.verifiedBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.partialBlocks.getSize() == this.completedSize;
    }

    public synchronized String listMissingPieces() {
        IntervalSet all = new IntervalSet();
        all.add(new Interval(0L, this.completedSize - 1));
        all.delete(this.verifiedBlocks);
        all.delete(this.savedCorruptBlocks);
        if (this.hashTree == null) {
            all.delete(this.partialBlocks);
        }
        return all.toString() + ", pending: " + this.pendingBlocks.toString() + ", has tree? " + (this.hashTree != null) + ", verified: " + this.verifiedBlocks + ", savedCorrupt: " + this.savedCorruptBlocks + ", partial: " + this.partialBlocks;
    }

    public synchronized void waitForPendingIfNeeded() throws InterruptedException, DiskException {
        if (this.storedException != null) {
            throw new DiskException(this.storedException);
        }
        while (!this.isComplete() && this.getBlockSize() == this.completedSize) {
            if (this.storedException != null) {
                throw new DiskException(this.storedException);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("waiting for a pending chunk to verify or write..");
            }
            this.wait();
        }
    }

    public synchronized boolean isHopeless() {
        return (float)this.lostSize >= 0.9f * (float)this.completedSize;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public synchronized int hasFreeBlocksToAssign() {
        return this.completedSize - (this.verifiedBlocks.getSize() + this.leasedBlocks.getSize() + this.partialBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.pendingBlocks.getSize());
    }

    public void close() {
        this.isOpen = false;
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized Interval leaseWhiteHelper(IntervalSet availableBytes, long chunkSize) throws NoSuchElementException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("leasing white, state:\n" + this.dumpState());
        }
        if (availableBytes == null) {
            availableBytes = IntervalSet.createSingletonSet(0L, this.completedSize - 1);
        }
        IntervalSet neededBytes = IntervalSet.createSingletonSet(0L, this.completedSize - 1);
        neededBytes.delete(this.verifiedBlocks);
        neededBytes.delete(this.leasedBlocks);
        neededBytes.delete(this.partialBlocks);
        neededBytes.delete(this.savedCorruptBlocks);
        neededBytes.delete(this.pendingBlocks);
        if (LOG.isDebugEnabled()) {
            LOG.debug("needed bytes: " + neededBytes);
        }
        availableBytes.delete(neededBytes.invert(this.completedSize));
        Interval ret = this.blockChooser.pickAssignment(availableBytes, neededBytes, chunkSize);
        this.leaseBlock(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("leasing white interval " + ret + "\nof available intervals " + neededBytes);
        }
        return ret;
    }

    private synchronized void leaseBlock(Interval in) {
        this.leasedBlocks.add(in);
    }

    public synchronized void setExpectedHashTreeRoot(String root) {
        this.expectedHashRoot = root;
    }

    public synchronized HashTree getHashTree() {
        return this.hashTree;
    }

    public synchronized void setHashTree(HashTree tree) {
        if (this.expectedHashRoot != null && tree != null && !tree.getRootHash().equalsIgnoreCase(this.expectedHashRoot)) {
            return;
        }
        if (tree != null && tree.getFileSize() != (long)this.completedSize) {
            return;
        }
        HashTree previous = this.hashTree;
        this.hashTree = tree;
        if (previous == null && tree != null && (this.existingFileSize != -1L || this.pendingBlocks.getSize() == 0 && this.partialBlocks.getSize() > 0)) {
            QUEUE.add(new EmptyVerifier(this.existingFileSize));
            this.existingFileSize = -1L;
        }
    }

    public synchronized void setHashTreeRequested(boolean yes) {
        this.hashTreeRequested = yes;
    }

    public synchronized boolean isHashTreeRequested() {
        return this.hashTreeRequested;
    }

    public synchronized void setDiscardUnverified(boolean yes) {
        this.discardBad = yes;
    }

    public synchronized int getChunkSize() {
        return this.hashTree == null ? 131072 : this.hashTree.getNodeSize();
    }

    public static int getSizeOfVerifyingCache() {
        return CHUNK_CACHE.getCacheSize();
    }

    public static int getSizeOfByteCache() {
        return CACHE.getCacheSize();
    }

    public static void clearCaches() {
        CacheCleaner runner = new CacheCleaner();
        runner.run();
    }

    private void verifyChunks() {
        this.verifyChunks(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyChunks(long existingFileSize) {
        boolean fullScan = existingFileSize != -1L;
        HashTree tree = this.getHashTree();
        if (tree != null) {
            Iterator iter = this.findVerifyableBlocks(existingFileSize).iterator();
            while (iter.hasNext()) {
                Interval i = (Interval)iter.next();
                boolean good = this.verifyChunk(i, tree);
                VerifyingFile verifyingFile = this;
                synchronized (verifyingFile) {
                    this.partialBlocks.delete(i);
                    if (good) {
                        this.verifiedBlocks.add(i);
                    } else if (!fullScan) {
                        if (!this.discardBad) {
                            this.savedCorruptBlocks.add(i);
                        }
                        this.lostSize += i.high - i.low + 1;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyChunk(Interval i, HashTree tree) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("verifying interval " + i);
        }
        int length = i.high - i.low + 1;
        byte[] b = CHUNK_CACHE.get(length);
        try {
            RandomAccessFile randomAccessFile = this.fos;
            synchronized (randomAccessFile) {
                this.fos.seek(i.low);
                this.fos.readFully(b, 0, length);
            }
        }
        catch (IOException bad) {
            return false;
        }
        catch (OutOfMemoryError oom) {
            return false;
        }
        boolean corrupt = tree.isCorrupt(i, b, length);
        if (LOG.isDebugEnabled() && corrupt) {
            LOG.debug("block corrupt!");
        }
        return !corrupt;
    }

    private synchronized List findVerifyableBlocks(long existingFileSize) {
        List partial;
        if (LOG.isTraceEnabled()) {
            LOG.trace("trying to find verifyable blocks out of " + this.partialBlocks);
        }
        boolean fullScan = existingFileSize != -1L;
        ArrayList<Interval> verifyable = new ArrayList<Interval>(2);
        int chunkSize = this.getChunkSize();
        if (fullScan) {
            IntervalSet temp = (IntervalSet)this.partialBlocks.clone();
            temp.add(new Interval(0L, existingFileSize));
            partial = temp.getAllIntervalsAsList();
        } else {
            partial = this.partialBlocks.getAllIntervalsAsList();
        }
        for (int i = 0; i < partial.size(); ++i) {
            Interval current = (Interval)partial.get(i);
            int lowChunkOffset = current.low - current.low % chunkSize;
            if (current.low % chunkSize != 0) {
                lowChunkOffset += chunkSize;
            }
            while (current.high >= lowChunkOffset + chunkSize - 1) {
                Interval complete = new Interval(lowChunkOffset, lowChunkOffset + chunkSize - 1);
                verifyable.add(complete);
                lowChunkOffset += chunkSize;
            }
        }
        if (!partial.isEmpty()) {
            int lastChunkOffset = this.completedSize - this.completedSize % chunkSize;
            if (lastChunkOffset == this.completedSize) {
                lastChunkOffset -= chunkSize;
            }
            Interval last = (Interval)partial.get(partial.size() - 1);
            if (last.high == this.completedSize - 1 && last.low <= lastChunkOffset) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("adding the last chunk for verification");
                }
                verifyable.add(new Interval(lastChunkOffset, last.high));
            }
        }
        return verifyable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runDelayedWrites() {
        while (CACHE.isBufferAvailable()) {
            DelayedWrite dw;
            ByteArrayCache byteArrayCache = CACHE;
            synchronized (byteArrayCache) {
                if (DELAYED.isEmpty()) {
                    LOG.debug("Nothing delayed to run.");
                    return;
                }
                dw = (DelayedWrite)DELAYED.get(0);
            }
            if (dw.write()) {
                byteArrayCache = CACHE;
                synchronized (byteArrayCache) {
                    DELAYED.remove(0);
                    continue;
                }
            }
            QUEUE.invokeLater(new Runnable(){

                public void run() {
                    VerifyingFile.runDelayedWrites();
                }
            });
        }
    }

    private static void releaseChunk(byte[] buf, boolean runDelayed) {
        CACHE.release(buf);
        if (runDelayed) {
            VerifyingFile.runDelayedWrites();
        }
    }

    static {
        RouterService.schedule(new CacheCleaner(), 600000L, 600000L);
        CHUNK_CACHE = new PowerOf2ByteArrayCache();
    }

    private static class DelayedWrite {
        private final long currPos;
        private final int start;
        private final int length;
        private final byte[] buf;
        private final WriteCallback callback;
        private final VerifyingFile vf;

        DelayedWrite(long currPos, int start, int length, byte[] buf, WriteCallback callback, VerifyingFile vf) {
            this.currPos = currPos;
            this.start = start;
            this.length = length;
            this.buf = buf;
            this.callback = callback;
            this.vf = vf;
        }

        private boolean write() {
            if (this.vf.writeBlockImpl(this.currPos, this.start, this.length, this.buf, false)) {
                this.callback.writeScheduled();
                return true;
            }
            return false;
        }
    }

    static interface WriteCallback {
        public void writeScheduled();
    }

    private static class ChunkCacheCleaner
    implements Runnable {
        private ChunkCacheCleaner() {
        }

        public void run() {
            CHUNK_CACHE.clear();
        }
    }

    private static class CacheCleaner
    implements Runnable {
        private CacheCleaner() {
        }

        public void run() {
            LOG.info("clearing cache");
            CACHE.clear();
            QUEUE.add(new ChunkCacheCleaner());
        }
    }

    private class EmptyVerifier
    implements Runnable {
        private final long existingFileSize;

        EmptyVerifier(long existingFileSize) {
            this.existingFileSize = existingFileSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            VerifyingFile.this.verifyChunks(this.existingFileSize);
            VerifyingFile verifyingFile = VerifyingFile.this;
            synchronized (verifyingFile) {
                VerifyingFile.this.notify();
            }
        }
    }

    private class ChunkHandler
    implements Runnable {
        private final byte[] buf;
        private final Interval intvl;

        public ChunkHandler(byte[] buf, Interval intvl) {
            this.buf = buf;
            this.intvl = intvl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean freedPending = false;
            try {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Writing intvl: " + this.intvl);
                    }
                    Object object = VerifyingFile.this.fos;
                    synchronized (object) {
                        VerifyingFile.this.fos.seek(this.intvl.low);
                        VerifyingFile.this.fos.write(this.buf, 0, this.intvl.high - this.intvl.low + 1);
                    }
                    object = VerifyingFile.this;
                    synchronized (object) {
                        VerifyingFile.this.pendingBlocks.delete(this.intvl);
                        VerifyingFile.this.partialBlocks.add(this.intvl);
                        freedPending = true;
                    }
                    VerifyingFile.this.verifyChunks();
                }
                catch (IOException diskIO) {
                    VerifyingFile verifyingFile = VerifyingFile.this;
                    synchronized (verifyingFile) {
                        VerifyingFile.this.pendingBlocks.delete(this.intvl);
                        VerifyingFile.this.storedException = diskIO;
                    }
                    Object var7_5 = null;
                    try {
                        VerifyingFile.releaseChunk(this.buf, true);
                    }
                    catch (IllegalStateException bad) {
                        throw new IllegalStateException(bad.getMessage() + "\n" + VerifyingFile.this.dumpState());
                    }
                    VerifyingFile verifyingFile2 = VerifyingFile.this;
                    synchronized (verifyingFile2) {
                        if (!freedPending) {
                            VerifyingFile.this.pendingBlocks.delete(this.intvl);
                        }
                        VerifyingFile.this.notify();
                        return;
                    }
                }
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {}
                catch (IllegalStateException bad) {
                    throw new IllegalStateException(bad.getMessage() + "\n" + VerifyingFile.this.dumpState());
                }
                VerifyingFile.releaseChunk(this.buf, true);
                VerifyingFile verifyingFile = VerifyingFile.this;
                synchronized (verifyingFile) {
                    if (!freedPending) {
                        VerifyingFile.this.pendingBlocks.delete(this.intvl);
                    }
                    VerifyingFile.this.notify();
                    throw throwable;
                }
            }
            try {}
            catch (IllegalStateException bad) {
                throw new IllegalStateException(bad.getMessage() + "\n" + VerifyingFile.this.dumpState());
            }
            VerifyingFile.releaseChunk(this.buf, true);
            VerifyingFile verifyingFile = VerifyingFile.this;
            synchronized (verifyingFile) {
                if (!freedPending) {
                    VerifyingFile.this.pendingBlocks.delete(this.intvl);
                }
                VerifyingFile.this.notify();
                return;
            }
        }
    }
}

