/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.guess.QueryKeyGenerator;
import com.limegroup.gnutella.security.SecurityUtils;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Arrays;

class TEAQueryKeyGenerator
implements QueryKeyGenerator {
    protected final int QK_LENGTH = 4;
    protected final int PRE_ROTATE;
    protected final int POST_ROTATE;
    protected final int LK0;
    protected final int LK1;
    protected final int RK0;
    protected final int RK1;
    protected final long PRE_WHITEN_KEY;
    protected final long POST_WHITEN_KEY;

    TEAQueryKeyGenerator() {
        SecureRandom rand = SecurityUtils.createSecureRandomNoBlock();
        this.PRE_WHITEN_KEY = rand.nextLong();
        this.POST_WHITEN_KEY = rand.nextLong();
        this.LK0 = rand.nextInt();
        this.LK1 = rand.nextInt();
        this.RK0 = rand.nextInt();
        this.RK1 = rand.nextInt();
        int rotations = rand.nextInt();
        this.PRE_ROTATE = rotations & 0x3F;
        this.POST_ROTATE = rotations >>> 26;
    }

    TEAQueryKeyGenerator(int k0, int k1, int k2, int k3, int preRotate, int postRotate) {
        this.PRE_ROTATE = preRotate & 0x3F;
        this.POST_ROTATE = postRotate & 0x3F;
        this.POST_WHITEN_KEY = 0L;
        this.PRE_WHITEN_KEY = 0L;
        this.LK0 = k0;
        this.LK1 = k1;
        this.RK0 = k2;
        this.RK1 = k3;
    }

    public boolean checkKeyBytes(byte[] keyBytes, InetAddress ip, int port) {
        return Arrays.equals(keyBytes, this.getKeyBytes(ip, port));
    }

    public byte[] getKeyBytes(InetAddress ip, int port) {
        byte[] ipBytes = ip.getAddress();
        int ipInt = 0;
        for (int i = 3; i >= 0; --i) {
            ipInt ^= ipBytes[i] << (i << 3);
        }
        long key64 = this.encrypt((long)port << 32 | (long)ipInt & 0xFFFFFFFFL);
        byte[] qkBytes = new byte[4];
        int outIndex = 3;
        int left = (int)(key64 >> 32);
        int right = (int)key64;
        while (outIndex >= 0) {
            int lowByte;
            if (left == 0) {
                left = right;
                right ^= 0xFFFFFFFF;
            }
            if ((lowByte = left & 0xFF) != 0 && lowByte != 28) {
                qkBytes[outIndex] = (byte)lowByte;
                --outIndex;
            }
            left >>>= 8;
        }
        return qkBytes;
    }

    private final long encrypt(long block) {
        block = block << this.PRE_ROTATE | block >>> 64 - this.PRE_ROTATE;
        int left = (int)((block ^= this.PRE_WHITEN_KEY) >> 32);
        int right = (int)block;
        int roundKey = 0;
        for (int cycleCount = 32; cycleCount > 0; --cycleCount) {
            right += ((left += (right << 4) + this.LK0 ^ right + (roundKey += -1640531527) ^ (right >>> 5) + this.LK1) << 4) + this.RK0 ^ left + roundKey ^ (left >>> 5) + this.RK1;
        }
        block = (long)left << 32 | (long)right & 0xFFFFFFFFL;
        return (block ^= this.POST_WHITEN_KEY) << this.POST_ROTATE | block >>> 64 - this.POST_ROTATE;
    }
}

