/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.util.Buffer;
import javax.swing.AbstractListModel;

public class BufferListModel
extends AbstractListModel {
    private Buffer buffer;

    public BufferListModel(int size) {
        this.buffer = new Buffer(size);
    }

    public Object getElementAt(int idx) {
        return this.buffer.get(idx);
    }

    public int getSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getSize();
    }

    public void changeSize(int size) {
        if (size == 0) {
            int oldSize = 0;
            if (this.buffer != null) {
                oldSize = this.buffer.getSize();
            }
            this.buffer = null;
            this.fireContentsChanged(this, 0, oldSize);
            return;
        }
        Buffer nbuffer = new Buffer(size);
        for (int i = 0; this.buffer != null && i < Math.min(this.buffer.getSize(), size); ++i) {
            nbuffer.addFirst(this.buffer.get(i));
        }
        this.buffer = nbuffer;
    }

    public void removeAllElements() {
        if (this.buffer == null) {
            return;
        }
        this.buffer.clear();
        this.fireContentsChanged(this, 0, this.buffer.getCapacity());
    }

    public void addFirst(Object val) {
        if (this.buffer == null) {
            return;
        }
        this.buffer.addFirst(val);
        this.fireContentsChanged(this, 0, this.buffer.getSize());
    }
}

