/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorCallback;
import com.limegroup.gnutella.gui.GUIMediator;
import javax.swing.SwingUtilities;

public final class ErrorHandler
implements ErrorCallback {
    public void error(Throwable problem) {
        if (problem instanceof ThreadDeath) {
            throw (ThreadDeath)problem;
        }
        Error doWorkRunnable = new Error(problem, null);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void error(Throwable problem, String msg) {
        if (problem instanceof ThreadDeath) {
            throw (ThreadDeath)problem;
        }
        Error doWorkRunnable = new Error(problem, msg);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    private static class Error
    implements Runnable {
        private final Throwable PROBLEM;
        private final String MESSAGE;
        private final String CURRENT_THREAD_NAME;

        private Error(Throwable problem, String msg) {
            this.PROBLEM = problem;
            this.MESSAGE = msg;
            this.CURRENT_THREAD_NAME = Thread.currentThread().getName();
        }

        public void run() {
            if (this.MESSAGE == null) {
                GUIMediator.showInternalError(this.PROBLEM, this.CURRENT_THREAD_NAME);
            } else {
                GUIMediator.showInternalError(this.PROBLEM, this.MESSAGE, this.CURRENT_THREAD_NAME);
            }
        }
    }
}

