/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MacUtils;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class FileChooserHandler {
    public static File getInputDirectory() {
        return FileChooserHandler.getInputDirectory(GUIMediator.getAppFrame());
    }

    public static File getInputDirectory(Component parent) {
        return FileChooserHandler.getInputDirectory(parent, "FILE_CHOOSER_DIRECTORY_TITLE", CommonUtils.getCurrentDirectory());
    }

    public static File getInputDirectory(Component parent, File directory) {
        return FileChooserHandler.getInputDirectory(parent, "FILE_CHOOSER_DIRECTORY_TITLE", "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory);
    }

    public static File getInputDirectory(Component parent, File directory, FileFilter filter) {
        return FileChooserHandler.getInputDirectory(parent, "FILE_CHOOSER_DIRECTORY_TITLE", "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory, filter);
    }

    public static File getInputDirectory(Component parent, String titleKey, File directory) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory);
    }

    public static File getInputDirectory(Component parent, String titleKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory, filter);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, approveKey, directory, null);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 1, 0, filter);
    }

    public static File getInputFile() {
        return FileChooserHandler.getInputFile(GUIMediator.getAppFrame());
    }

    public static File getInputFile(Component parent) {
        return FileChooserHandler.getInputFile(parent, "FILE_CHOOSER_DIRECTORY_TITLE", "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", CommonUtils.getCurrentDirectory());
    }

    public static File getInputFile(Component parent, FileFilter filter) {
        return FileChooserHandler.getInputFile(parent, "FILE_CHOOSER_DIRECTORY_TITLE", "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", CommonUtils.getCurrentDirectory(), filter);
    }

    public static File getInputFile(Component parent, String titleKey, File directory) {
        return FileChooserHandler.getInputFile(parent, titleKey, "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory);
    }

    public static File getInputFile(Component parent, String titleKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInputFile(parent, titleKey, "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory, filter);
    }

    public static File getInputFile(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 0, 0);
    }

    public static File getInputFile(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 0, 0, filter);
    }

    public static File getInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, mode, option, null);
    }

    public static File getSaveAsFile(Component parent, String titleKey, File suggestedFile) {
        return FileChooserHandler.getSaveAsFile(parent, titleKey, suggestedFile, null);
    }

    public static File getSaveAsFile(Component parent, String titleKey, File suggestedFile, final FileFilter filter) {
        if (CommonUtils.isAnyMac()) {
            FileDialog dialog = new FileDialog((Frame)GUIMediator.getAppFrame(), GUIMediator.getStringResource(titleKey), 1);
            dialog.setDirectory(suggestedFile.getParent());
            dialog.setFile(suggestedFile.getName());
            if (filter != null) {
                FilenameFilter f = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return filter.accept(new File(dir, name));
                    }
                };
                dialog.setFilenameFilter(f);
            }
            dialog.setVisible(true);
            String dir = dialog.getDirectory();
            String file = dialog.getFile();
            if (dir != null && file != null) {
                File f = new File(dir, file);
                if (filter != null && !filter.accept(f)) {
                    return null;
                }
                return f;
            }
            return null;
        }
        JFileChooser chooser = FileChooserHandler.getDirectoryChooser(titleKey, null, null, 0, filter);
        chooser.setSelectedFile(suggestedFile);
        return chooser.showSaveDialog(parent) != 0 ? null : chooser.getSelectedFile();
    }

    public static File getInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option, final FileFilter filter) {
        if (!CommonUtils.isAnyMac()) {
            JFileChooser fileChooser = FileChooserHandler.getDirectoryChooser(titleKey, approveKey, directory, mode, filter);
            try {
                if (fileChooser.showOpenDialog(parent) != option) {
                    return null;
                }
            }
            catch (NullPointerException npe) {
                return null;
            }
            return fileChooser.getSelectedFile();
        }
        FileDialog dialog = mode == 1 ? MacUtils.getFolderDialog() : new FileDialog((Frame)GUIMediator.getAppFrame(), "");
        dialog.setTitle(GUIMediator.getStringResource(titleKey));
        if (filter != null) {
            FilenameFilter f = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return filter.accept(new File(dir, name));
                }
            };
            dialog.setFilenameFilter(f);
        }
        dialog.setVisible(true);
        String dirStr = dialog.getDirectory();
        String fileStr = dialog.getFile();
        if (dirStr == null || fileStr == null) {
            return null;
        }
        File f = new File(dirStr, fileStr);
        if (filter != null && !filter.accept(f)) {
            return null;
        }
        return f;
    }

    private static JFileChooser getDirectoryChooser(String titleKey, String approveKey, File directory, int mode, FileFilter filter) {
        JFileChooser chooser = null;
        if (directory == null) {
            chooser = new JFileChooser();
        } else {
            try {
                chooser = new JFileChooser(directory);
            }
            catch (NullPointerException e) {
                chooser = new JFileChooser(directory);
            }
        }
        if (filter != null) {
            chooser.setFileFilter(filter);
        } else if (mode == 1) {
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return true;
                }

                public String getDescription() {
                    return GUIMediator.getStringResource("DIRECTORY_CHOOSER_FILE_DESCRIPTION");
                }
            });
        }
        chooser.setFileSelectionMode(mode);
        String title = GUIMediator.getStringResource(titleKey);
        chooser.setDialogTitle(title);
        if (approveKey != null) {
            String approveButtonText = GUIMediator.getStringResource(approveKey);
            chooser.setApproveButtonText(approveButtonText);
        }
        return chooser;
    }
}

