/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.gui.GUIMediator;
import javax.swing.SwingUtilities;

public final class GURLHandler {
    private static final GURLHandler INSTANCE;
    private boolean registered = false;
    private boolean enabled = false;
    private String url;

    private GURLHandler() {
    }

    public static GURLHandler getInstance() {
        return INSTANCE;
    }

    private void callback(final String url) {
        if (this.enabled && ExternalControl.isInitialized()) {
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        ExternalControl.handleMagnetRequest(url);
                    }
                    catch (Throwable t) {
                        GUIMediator.showInternalError(t);
                    }
                }
            };
            SwingUtilities.invokeLater(runner);
        } else {
            this.url = url;
        }
    }

    public void enable() {
        ExternalControl.enqueueMagnetRequest(this.url);
        this.url = null;
        this.enabled = true;
    }

    public void register() {
        if (!this.registered && this.InstallEventHandler() == 0) {
            this.registered = true;
        }
    }

    protected void finalize() throws Throwable {
        if (this.registered) {
            this.RemoveEventHandler();
        }
    }

    private final synchronized native int InstallEventHandler();

    private final synchronized native int RemoveEventHandler();

    static {
        System.loadLibrary("GURL");
        INSTANCE = new GURLHandler();
    }
}

